

RMDIR			PB-Lib C/C++ Library Programmer's Manual		RMDIR


NAME
	rmdir - remove specified directory
	rmDirTree - remove a whole directory tree

SYNOPSIS
	#include <fsys.h>

	int rmdir(const char *path);
	int rmDirTree(char *path);

DESCRIPTION
	rmdir() removes the directory specified in path.  For this call to
	succeed, the directory 'path' should be empty of any files or other
	subdirectories. You cannot remove the current directory either.

	If you have files or other directories, use rmDirTree() which will
	recurse in all subdirectories and will delete all the files on the
	way, even if they have the hidden, system or read-only attributes set.
	Be very careful with this function and do not run it on your root
	directory as it works quite fast and may damage your files before you
	can react. This is potentially a very dangerous function.

RETURN VALUE
	On success, zero is returned. On error, -1 is returned.

EXAMPLE
	#include <stdio.h>
	#include <fsys.h>

	void
	main(void)
	{
		char buf[80];

		/* if you feel daring, try rmDirTree() on the same */
		printf( "Dir to remove: " );
		gets(buf);
		if( -1 == rmdir(buf) ) puts( "Oops" );
	}

