
MKDIR			PB-Lib C/C++ Library Programmer's Manual		MKDIR


NAME
	mkdir - create a directory
	mkDirTree - create a directory tree

SYNOPSIS
	#include <fsys.h>

	int mkdir(const char *path);
	int mkDirTree(char *path);

DESCRIPTION
	mkdir() creates a directory with name specified in path.  This
	functions can fail if the directory already exists or if there's a
	file with the exact same name in which case MS-DOS will not let use
	create a directory.  Note that this function cannot create
	intermediate directories, i.e. if you want to create "C:\FIRST\SECOND"
	and "C:\FIRST" does not exist, the call will fail.  You can use
	mkDirTree() instead, it will handle this situation.

	mkDirTree() creates the whole directory tree specified in path.  This
	function will create all intermediate directories if they don't exist.
	It, too, may fail for the same reasons as mkdir().

RETURN VALUE
	On success, zero is returned. On error, -1 is returned.

EXAMPLE
	#include <stdio.h>
	#include <fsys.h>

	void
	main(void)
	{
		char buf[80];

		printf( "Dir to create: " );
		gets(buf);
		if( -1 == mkdir(buf) ) puts( "Ooops" );
		printf( "Directory tree to create: " );
		get(buf);
		if( -1 == mkDirTree(buf) ) puts( "Ooops" );
	}
