GETCWD			PB-Lib C/C++ Library Programmer's Manual		GETCWD

NAME
	getcwd - get the current working directory

SYNOPSIS
	#include <fsys.h>

	char *getcwd(char *buffer, int buflen);

DESCRIPTION
	getcwd() places the current working directory path into 'buffer'.  The
	maximum size of the resulting string will not exceed 'buflen'.
	However, if it does, getcwd() returns NULL.  The resulting path will
	contain the complete path (including the drive letter) of the default
	directory on the current drive in the form "C:\DIR\PATH" and will not
	be terminated with a backslash.

RETURN VALUE
	'buffer' on success or NULL otherwise.

EXAMPLE
	#include <stdio.h>
	#include <fsys.h>

	void main(void)
	{
		char buf[81];

		/* mimic the behavior of 'cd' without arguments */
		puts( getcwd(buf, sizeof(buf)) );
	}

