
CPFILE			PB-Lib C/C++ Library Programmer's Manual		CPFILE

NAME
	cpfile - copies one file to another

SYNOPSIS
	#include <fsys.h>

	int cpfile(const char *dest, const char *src);

DESCRIPTION
	cpfile() copies the file given in the 'src' path to a new location,
	specified by 'dest'.  It uses a large IO buffer to speed up the
	process and generally, it works reasonably fast.  If the destination
	file already exists, it will be overwritten.

RETURN VALUE
	On error, cpfile() returns -1
	0 if the copying completed successfully.

EXAMPLE
	#include <fsys.h>

	void main(int argc, char *argv[])
	{
		char bak[81];

		/* create a backup copy of the executable */
		chext(bak, *argv, ".BAK");
		cpfile(bak, *argv);
	}

