
CHDIR			PB-Lib C/C++ Library Programmer's Manual		CHDIR


NAME
	chdir - change working directory

SYNOPSIS
	#include <fsys.h>

	int chdir(const char *path);

DESCRIPTION
	chdir() changes the current directory to that specified in path.  Note
	that it does change across drives, but will not set a new drive.  That
	means that is you specify a directory on a drive, other than the
	default, it will be set (for that drive), but the current drive (and
	directory) will stay the same.  This is exactly how the library
	chdir() behaves.

RETURN VALUE
	On success, zero is returned. On error, -1 is returned.

EXAMPLE
	#include <stdio.h>

	void
	main(void)
	{
		char buf[80];

		printf( "Change to which dir: " );
		get( buf );
		if( -1 == chdir(buf) ) puts( "Oops!" );
	}

SEE ALSO
	mkdir, rmdir
