
BASEDIR			PB-Lib C/C++ Library Programmer's Manual		BASEDIR

NAME
	basedir  - extract subdirectory specification from path

SYNOPSIS
	#include <fsys.h>

	char *basedir(char *name);

DESCRIPTION
	basedir extracts the subdirectory portion from a path specification
	(the return buffer will be terminated with a backslash). It does
	recognize UNIX-style paths which use a forward slash instead of a
	backslash.  If no subdirectory is available in the filespec name, then
	a ".\" is returned.

RETURN VALUE
	A pointer to a static buffer which is overwritten with each call.  It
	contains the subdirectory path specification from 'name'.

EXAMPLE
	#include <stdio.h>
	#include <fsys.h>

	int main(void)
	{
		printf( "Program dir: %s\n", basedir(*argv) );
		return 0;
	}

