
SCANF				PB-Lib C/C++ Library Programmer's Manual			SCANF

NAME
	scanf - scans and formats input from stdin (local and remote)
	sscanf - scans and formats input from a string
	fscanf - scans and formats input from a stream (file)
	vscanf - scanf() alternate entry point
	vsscanf - sscanf() alternate entry point
	vfscanf - fscanf() alternate entry point

SYNOPSIS
	int scanf(const char *format[, address, ...]);
	int sscanf(char *buffer, const char *format[, address, ...]);
	int fscanf(FILE *stream, const char *format[, address, ...]);
	int vscanf(const char *format, va_list arglist);
	int vsscanf(char *buffer, const char *format, va_list arglist);
	int vfscanf(FILE *stream, const char *format, va_list arglist);

DESCRIPTION
	For a complete description of scanf(), see your compiler's manual.
	This version is provided to make up for the missing interface in the
	ProBoard SDK.  It supports most of the standard ANSI features with one
	notable exception, floating point numbers.  This is not particularly
	important because the SDK itself does not lead very well to that
	direction.  As for the MS-DOS compilers, this scanf() family does not
	support pointer modifiers (N and P) because the SDK requires the large
	memory model where all those are 'far' anyway.  A big difference
	between this version and the one that comes with most compilers is
	support for binary numbers (see the format notes).

	scanf() scans a series of input fields one character at a time.  Each
	field is formatted according to the the specifiers (see below) in the
	'format' string.  Finally, scanf() stores the converted value in the
	address passed to it as an argument after 'format'.  The number of
	specifiers should match the number of passed addresses (with one
	exception, see the '*' character) or the results are undefined (but
	possibly disastrous because scanf() will trash an unknown memory
	area.)  Also, the number of specifiers should match the number of
	input fields.  Excess addresses are harmless as scanf() will simply
	ignore them.

FORMAT STRING
	This string controls how the scanf() functions scan, convert, and
	store their input fields.  Generally, it is quite difficult the teach
	scanf() to synchronize with the input if it diverges from the expected
	pattern.  Therefore, a gets() or fgets() followed by sscanf() is
	prefferred over scanf().

	The format string is a character string that contains three types of
	objects:  whitespace characters, non-whitespace characters and format
	specifiers.

		The whitespace characters are blank (' '), tab ('\t') or newline
		('\n').  If one of these is encountered, all consecutive
		whitespace characters up to the next non-whitespace character in
		the input will be scanned but not stored.  Note that when it comes
		to the input, a whitespace character is defined via a call to the
		function isspace(), which generally includes vertical tabs, form
		feeds and possibly more.

		The non-whitespace characters are all other ASCII characters
		except the percent sign ('%').  If scanf() encounters one of
		these, it will read, but not store, a matching character from the
		input. It is an error if the input does not match it exactly.

		The format specifier direct the scanf() functions to read and
		convert characters from the input field into specific type of
		values, and then store the result in the locations given by the
		address arguments.

FORMAT SPECIFIERS
	The general form of the 'format' specifier is as follows:

		% [*] [width] [h|l] type_character

	Each format specifier must begin with the percent ('%') character.
	After it come the following, in that order:

		- an optional assignment-suppression specifier ('*')
		- an optional width specifier ('width')
		- an optional argument type modifier (h | l)
		- the type character (required)

	*
		Suppresses the assignment of the next input field.  It is scanned
		as per the spcification following the star ('*') character, but
		the result is not assigned to the next available address passed to
		the scanf() function.

	width
		Maximum number of characters to read.  Fewer might be read if the
		field terminates before the number is exhausted or if scanf()
		encounters a character which cannot be converted with the current
		specification.  This should be given in decimal.  If omitted, the
		maximum matching number of input characters will be scanned.

	'h' or 'l'
		Overrides the default type of address argument.  'h' is a short
		int, 'l' is a long int.  Note that this is a lower-case 'L'
		letter, not the digit one ('1').

	type characters
		The following table lists all type characters recognized by
		scanf(), what type of input is expected by each of them and in
		what format the input will be stored.  Note that this table is
		based on the assumption that none of the optional format
		specifiers (as '*', 'width', 'h' or 'l') are present in the format
		string.

			Type	Expected input			Type of argument
		-----------------------------------------------------------
			b		binary integer			pointer to int
			B		binary integer			pointer to long
			d		decimal integer			pointer to int
			D		decimal integer			pointer to long
			o		octal integer			pointer to int
			O		octal integer			pointer to long
			i		decimal, octal, hex,	pointer to int
					or binary integer
			u		unsigned decimal		pointer to unsigned int
			U		unsigned decimal		pointer to unsigned long
			x		hexadecimal integer		pointer to int
			X		hexadecimal integer		pointer to long
			s		character string		pointer to a character array
			c		character				pointer to a character or
											if 'width' is give, pointer
											to an array of 'width' number
											of characters
			%		% character				no conversion is stored
			n								pointer to int
			[		character string		see 'SEARCH SET' below
		-----------------------------------------------------------

		For an explanation of the differences between this scanf() family
		and the one that might come with your compiler, see the
		COMPATIBILITY section below.

INPUT FIELDS
	Any one of the following is considered an input field:

		- all characters up to but not including the next whitespace
		character (defined by isspace());
		- all characters up to the first one that cannot be converted
		under the current format specifier;
		- up to the number of character specified in 'width'

CONVERSIONS
	These are the conventions that govern some of the possible conversions
	together with the format specifiers.

		%c	character conversion.  Reads the next character, including
			a whitespace.

		%Wc	where W is the 'width'.  This will scan and store W number of
			characters into an array.  The array's size should be at least
			W characters.  Note that the NUL character is not appended to
			the end of the array.

		%s	string conversion.  The array size should be at least one
			character longer than the expected input string (so scanf will
			store the terminating NUL character at the end).  A space, tab
			or a new line terminates the input field.

		%[search set]
			See SEARCH SET for complete details.  The argument is an array
			of characters, similar to the '%s' type character.  A NUL is
			automatically appended to the end of the resulting string.
			The input terminates when a character not matching the 'search
			set' is encountered in the input.

		%d, %i, %o, %x, %b, %D, %O, %X, %B
			A pointer to an unsigned int or long can be used in place of
			the signed (default) one where applicable.  The uppercase
			letters scan the long version of the lowercase.  Note that you
			can also force same behavior with the 'l' modifier.  Also, you
			can force short integers with the uppercase letters with the
			'h' format modifier.

		%n
			This will store the number of input fields successfully
			scanned, converted and stored up until (but not including) the
			'%n' specifier itself.

SEARCH SET
	A search set is surrounded by square brackets from both sides and
	defines the characters making up the string input field.  If the first
	character is a carret ('^'), the set is inverted to include all ASCII
	characters except those between the brackets.

	The input field is not delimited by whitespace.  Instead, the search
	set determines which characters to match and when to stop.  For
	example, if you specify the set like this:  "%[abcd]", then only the
	characters 'a', 'b', 'c' or 'd' will be allowed in the input string
	to match, i.e. any other character will terminate the current
	conversion.  If you specify the set like this:  "%[^abcd]", then all
	characters except 'a', 'b', 'c' and 'd' will be allowed in the input
	field and any one of these will terminate it.

	There's also a shortcut you can use to define a range of characters in
	the search set.  For example, to match all decimal digits you could
	define a set tlike this:  "%[0123456789]", or you could use ths
	shortcut to achieve the same effect with "%[0-9]".  To match all
	alphanumerics, you could use "%[0-9A-Za-z]".  There are certain rules
	and limitations involved with search sets:

		- the character prior to the hyphen must be lexically less than
		the one following it;

		- the hyphen must not be the first or last character in the set.
		If it is, it will be treated as a normal character ('-');

		- the characters to the right of the hyphen must be the end of the
		range, and not the beginning of some other range.

END OF SCAN
	The scanf() family of functions can stop scanning an input field
	before reaching the normal end-of-field character, or might terminate
	entirely for a number of reasons.

	The scanf() stops scanning and storing the current field and proceeds
	to the next one if any one of the following occurs:

		- an assignment-suppression character appears after the percent
		character in the specification; the current field is scanned but
		not stored.

		- 'width' characters have been read; scanf() stops scanning the
		input field and proceeds to the next format character.

		- the next character read cannot be converted under the current
		specification ('9' when the format is octal).

		- the next character in the input does not appear in the search
		set or does appear in the inverted (exclusion) search set.

	When scanf() stops scanning the current field, the next character is
	assumed to be unread and is pushed back onto the input stream to
	become the first character for the next input field.

	scanf() will terminate entirely under the following circumstances:

		- the next character of the input field conflicts with the next
		corresonding non-whitespace character in the format string.

		- the next character in the input field is EOF.

		- the format string has been exhausted.

OTHER SCANF FUNCTIONS
	sscanf()'s EOF character for the input is the NUL string terminator.

	The vscanf() functions behave exactly as their scanf() counterparts,
	except the accept a pointer to a list of arguments instead of an
	argument list.

RETURN VALUE
	The scanf() family of functions return the number of input fields
	successfully scanned, converted and stored.  The return value does not
	include the fields that were not stored.

EXAMPLE
	See the provided example in EX_SCANF.C

COMPATIBILITY
	This scanf() family does some things slightly differently than the
	ones supplied with your compiler.  The main difference is the lack of
	support for %e, %Em %f, %g and %G - the floating point conversions.
	Also, the 'L' format modifier is not supported (since it only works on
	floats to make them doubles).

	Also, the pointer modifiers 'N' and 'F' are not supported.  All
	addresses are assumed to be 'far' (or so the library is compiled).

	The '%p' type character is not supported.

	Additional type characters that might not be supported by your
	compiler's scanf() are the '%b' and '%B' characters for binary
	integers in the input stream.

	The '%X' type character will match a long integer by default (unless
	modified with 'h').  This is different from Borland's version which is
	just an alias for '%x', but it is consistent with the other integer
	matching characters.

	The '%I' is not supported. Use '%li' instead.

	You can get an assertion failure if you pass unrecognized conversion
	type characters.  This is different from the original scanf(), but
	since it's a programming error to do, you may want to fix this in your
	source code.

BUGS
	Most of this manpage is redundant.
