
CONIO			PB-Lib C/C++ Library Programmer's Manual		CONIO

NAME
	clreol - clear to the endo of line in current window
	clrscr - clear current widnow screen
	cprintf - printf to the current window
	cputs - puts to current window
	getch - get character from BIOS
	getche - get and echo character
	gettext - save portion of absolute screen
	gotoxy - positions cursor within current screen
	putch - echo character to window screen
	puttext - put saved buffer back to screen
	textattr - change foreground and background screen colors
	textbackground - change background color
	textcolor - change foreground color
	wherex - return current window column the cursor is on
	wherey - return current window row the cursor is on
	window - define a new window
	MK_COLOR - create a color attribute.

SYNOPSIS
	#include <sys/__conio.h>

	void clreol(void);
	void clrscr(void);
	int cprintf(const char *format[, argument, ...]);
	int cputs(const char *s);
	int getch(void);
	int getche(void);
	int gettext(int left, int top, int right, int bottom, void *dest);
	void gotoxy(int col, int row);
	int putch(int ch);
	int puttext(int left, int top, int right, int bottom, void *src);
	void textattr(int newattr);
	void textbackground(int color);
	void textcolor(int color);
	int wherex(void);
	int wherey(void);
	void window(int left, int top, int right, int bottom);
	int MK_COLOR(int background, int foreground);

DESCRIPTION
	This package duplicates most of the Borland's CONIO functionality and
	is provided because no other compiler has it.  __CONIO supports
	writing to user-defined windows on the display, different colors (with
	no ANSI.SYS driver required), keyboard input and various text
	manipulations.  Unlike Borland's routines, these do not have the
	option of doing direct video writes to the video RAM.  Instead, all
	requests are handled by the BIOS.  This is slower, but far more
	compatible with most existing systems.  Also, speed was not a
	consideration during the writing of the functions, portability was.
	Well-behaved programs are generally a lot more flexible and easily
	integrated into existing systems.

	When the __CONIO package initializes (this is done when you simply
	call any of its functions), the default window size is 80x25 color (if
	the monitor supports it, or monochrome otherwise).  Note that all
	cursor addressing is relative to the current window, with the
	upper-left corner being at (1,1).

	clreol() clears from the current cursor position to the end of the
	line in a text window. The cursor does not change position.

	clrscr() clears the current window using the current color attribute.
	The cursor is positioned at (1,1) - the top-left corner.

	cprintf() writes formatted output to the screen.  This function is
	very similar the the printf() family.  The syntax is the same with the
	following exceptions:

		- cprintf() does not translate newlines ('\n') into line-feed and
		newline pairs ('\r\n'), which are required to force a new line.

		- tabs will not translate into spaces, instead, the 0x09 ASCII
		character will be shown.

		- the return value is the number of characters output.

	cputs() writes a string to the screen.  The newline characters will
	not be translated into newline/linefeed pairs.  Newline is not
	appended at the end of the string.

	getch() gets a character from the keyboard and does not echo it to the
	screen.  Since the keyboard is read directly, not Ctrl+Break or Ctrl+C
	combinations will work.  When processing extended keys (F1-F12, for
	example), getch() will first return 0 and next, the character code on
	the subsequent call.

	getche() is the same as getch() except it echoes the character to the
	text screen window.

	gettext() copies text from text mode screen to memory buffer.  The
	contents of the rectangle defined by 'left', 'top', 'right' and
	'bottom' are copied to the user-supplied buffer 'dest'.  Note that
	these coordinates are not window-relative, but are absolute to the
	global screen, starting at (1,1) for the top-left corner.  The
	function reads the contents of the screen row by row, from left to
	right, top to bottom.  Note that each character read takes two bytes
	of memory in the buffer, the first being the character itself, and the
	second - the video attribute.  Therefore, for a rectangle of width 'w'
	and height 'h', the buffer space required is defined as ('w' * 'h' *
	'2') bytes.  If the buffer is not big enough, gettext() will overwrite
	(and trash) memory contents as there's no way to verify 'dest' size.

	gotoxy() positions the cursor in the current text window.  The
	coordinates are relative to the current window and start at (1,1) -
	the top-left corner.  If the coordinates are invalid, the results are
	undefined.  This is different from Borland's version where they will
	simply be ignored.

	putch() outputs a character to the screen window.  It will not
	translate newline characters to newline/linefeed pairs.  This function
	will automatically advance to the next line and will cause a scroll up
	if the last line was the bottom of the current window.

	puttext() copies text from a memory buffer to text mode screen.  You
	will usually want to use a buffer obtained with a call to gettext() as
	'src'.  The coordinates are absolute to the screen, not the current
	text window.  The buffer consists of alterating pairs of characters
	and attributes.

	textattr() sets the text attribute (both background and foreground
	colors) in a single call.  The function does not affect any characters
	currently displayed, only subsequent output with putch(), cprintf() or
	cputs().  Use the COLORS constants to defined the colors byte.  This
	byte has the following encoding:

						7  6  5  4  3  2  1  0
						B  b  b  b  f  f  f  f

	where 'B' stands for blink and can be turned on by adding the constant
	BLINK the attribute.  'ffff' is the foreground color and 'bbb' is the
	background color (see COLORS section for available constants).  You
	can use the MK_COLOR() macro to obtain the color you want.  The macro
	is defined like this:  int MK_COLOR(background, foreground); It
	returns an integer ready to be passed as argument to textattr().

	textbackground() selects new text mode background color.  The current
	characters will not be affected, only subsequent output will be.  You
	can use the COLORS constants for the 'color' argument.  Note that only
	the first 8 values can be selected.  The others will cause the blink
	bit to enable.

	textcolor() selects new text mode foreground color.  The current
	characters will not be affected, only subsequent output via calls to
	cputch(), cprintf() and cputs() will be.  You can use the COLORS
	constants as an argument to this function.

	wherex() gives the horizontal (column) cursor position within the
	current text window.  The coordinate starts with 1 for the first
	column and is window-relative.

	wherey() gives the vertical (row) cursor position within the current
	text window.  The coordinate starts with 1 for the first row and is
	window-relative.

	window() defines a text-mode window.  All subsequent operations will
	occur within this window (clrscr, clreol, cputch, cprintf, cputs,
	wherex, wherey, etc. will operate within this window).

	MK_COLOR() creates a BIOS-compatible color attribute for the
	textattr() function.  You can use the constants defined in COLORS for
	arguments.  Note that you can only use the first eigth values as
	background colors.  If you need the character to blink, add the BLINK
	constant to the value obtained from this call. Note: this is a macro.

COLORS
			Color			Value	Background	Foreground
			----------------------------------------------
			BLACK			0			yes			yes
			BLUE			1			yes			yes
			GREEN			2			yes			yes
			CYAN			3			yes			yes
			RED				4			yes			yes
			MAGENTA			5			yes			yes
			BROWN			6			yes			yes
			LIGHTGRAY		7			yes			yes
			DARKGRAY		8			no			yes
			LIGHTBLUE		9			no			yes
			LIGHTGREEN		10			no			yes
			LIGHTCYAN		11			no			yes
			LIGHTRED		12			no			yes
			LIGHTMAGENTA	13			no			yes
			YELLOW			14			no			yes
			WHITE			15			no			yes

			BLINK 			128			n/a			n/a

	To obtain blinking characters, add BLINK to the attribute.  You can
	use the MK_COLOR() macro to create color attibutes for the textattr()
	function.  You can use the constants above directly for the
	textcolor() andtextbackground() functions.

RETURN VALUE
	clreol(): none.
	clrscr(): none.
	cprintf(): number of characters output.
	cputs(): last character printed.
	getch(): character read from keyboard.
	getche(): character read from keyboard.
	gettext(): returns 1 on success and 0 otherwise.
	gotoxy(): none.
	putch(): returns the character printed.
	puttext(): returns 1 on success, 0 otherwise.
	textattr(): none.
	textbackground(): none.
	textcolor(): none.
	wherex(): integer from 1 to 80.
	wherey(): integer from 1 to 25.
	window(): none.
	MK_COLOR(): textattr()-compatible color attribute.

EXAMPLE
	#include <stdio.h>
	#include <sys/__conio.h>

	void main(void)
	{
		int i;

		window( 10, 4, 60, 20 );
		textattr( MK_COLOR(BLUE, YELLOW) );
		clrscr();
		for( i = 1; i < 5; ++i ){
			gotoxy( i * 2, i );
			cprintf( "We're at (%d,%d)", wherex(), wherey() );
		}
		getch();
		window( 1, 1, 80, 25 );
		textcolor( LIGHTGRAY );
		textbackground( BLACK );
		clrscr();
	}
