ASSERT			PB-Lib C/C++ Library Programmer's Manual		ASSERT

NAME
	assert - test a condition and possibly abort

SYNOPSIS
	void assert(int test);

DESCRIPTION
	assert() is a macro that expands to an if statement; if 'test'
	evaluates to 0, it prints an error message and aborts the program by
	calling exit();

	The message printed out looks like this:

	"Assertion failed: 'test', file 'filename', line 'linenum'"

	'test' is the test that evaluated to 0, 'filename' is the name of the
	source file and 'linenum' is the number of the line that the macro
	appears on.

	If you place the #define NDEBUG directive in the source code, the
	effect is to comment out the assert() statement.  Use this for
	shipping code after you're sure the assertion is always true.

RETURN VALUE
	None.

EXAMPLE
	#include <stdio.h>
	#include <stdlib.h>
	#include <assert.h>

	int main(void)
	{
		char *ptr;

		p = malloc( 65535L );  /* really contrived */
		assert( NULL != p );
		free(p);
		return 0;
	}

	The program output will be something like that (assuming that the call
	to malloc() fails):

	Assertion failed: NULL != p, file ASSERT.C, line 10

