PROGRAM Append_nodelists_to_panther_PHN_files;
USES DOS;
TYPE
  STRING30 = STRING [30];
  STRING35 = STRING [35];

PROCEDURE Help (Problem: byte);
(* If any *foreseen* errors arise, we are sent here to
   give a little Help and exit (relatively) peacefully *)
CONST
  NL = #13#10;
  progdesc = 'PANDA v1.00 - Free DOS utility: Add nodelists to Panther dialling directories.';
  author   = 'September 27, 1995.  Copyright (c) 1995 by David Daniel Anderson - Reign Ware.' + NL;
  usage    = 'Usage:  PANDA <nodelist> <.PHN directory>' + NL;
  example  = 'Example:  PANDA newnodes panther.phn' + NL;
  see      = 'See PANDA.DOC for instructions for creating nodelists.' + NL;
VAR
  message : STRING [50];
BEGIN
  WriteLn (progdesc);
  WriteLn (author);
  WriteLn (usage);
  WriteLn (example);
  WriteLn (see);
  IF (problem IN [1..254]) THEN BEGIN
    CASE problem OF
      1 : message := 'Invalid file name(s) specified.';
      7 : message := 'File handling error.';
      ELSE  message := 'Unanticipated error of unknown type.';
    END;
    WriteLn (#7, message);
  END;
  Halt (problem)
END;

PROCEDURE CheckIO;
BEGIN
  IF IOResult <> 0 THEN Help (7);
END;

FUNCTION RTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [Length (InStr) ] IN [#0, #9, #32]) DO
    Dec (InStr [0]);
  RTrim := InStr;
END;

FUNCTION LTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [1] IN [#0, #9, #32]) DO
    Delete (InStr, 1, 1);
  LTrim := InStr;
END;

FUNCTION Trim (ss: STRING): STRING;
BEGIN
  Trim := RTrim (LTrim (ss));
END;

FUNCTION RPad (bstr: STRING; len: BYTE; pChar: CHAR): STRING;
BEGIN
  WHILE (Length (bstr) < len) DO
    bstr := bstr + pChar;
  RPad := bstr;
END;

FUNCTION IsDir (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) = Directory)
    THEN IsDir := TRUE
    ELSE IsDir := FALSE;
END;

FUNCTION IsFile (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) <> Directory)
    THEN IsFile := TRUE
    ELSE IsFile := FALSE;
END;

FUNCTION GetFilePath (CONST PSTR: STRING; VAR sDir: DIRSTR): PATHSTR;
VAR
  dirinfo   : SEARCHREC;
  jPath     : PATHSTR;  { file path,       }
  jDir      : DIRSTR;   {      directory,  }
  jName     : NAMESTR;  {      name,       }
  jExt      : EXTSTR;   {      extension.  }
BEGIN
  jPath := PSTR;
  IF jPath = '' THEN jPath := '*.*';
  IF (NOT (jPath [Length (jPath) ] IN [':', '\'])) AND IsDir (jPath) THEN
    jPath := jPath + '\';
  IF (jPath [Length (jPath) ] IN [':', '\']) THEN
    jPath := jPath + '*.*';

  FSplit (FExpand (jPath), jDir, jName, jExt);
  jPath := jDir + jName+ jExt;

  sDir := jDir;
  GetFilePath := jPath;
END;

PROCEDURE GetTokens (TokenStr : STRING; VAR Token1: STRING30; VAR Token2 : STRING35);
VAR
  count: BYTE;

BEGIN
  Token1 := '-';
  Token2 := '-';

  count := 0;
  WHILE (count <= 6) DO BEGIN
    Inc (count);
    IF count=3 THEN
      Token1 := Copy (TokenStr, 1, Pos(',', TokenStr)-1);
    IF count=6 THEN
      Token2 := Copy (TokenStr, 1, Pos(',', TokenStr)-1);
    TokenStr := Copy (TokenStr, Pos(',', TokenStr)+1, Length (TokenStr));
  END;

END;

PROCEDURE Appendbbsnumbers (fon_bbsname, phn_bbsname: string);
VAR
  phn: FILE;
  fon: TEXT;

  bbsnam: STRING30;
  bbsnum: STRING35;
  entry: STRING [111];
  fonstr: STRING [73];
  defaults: ARRAY [1..38] OF CHAR;
  entry_array: ARRAY [1..111] OF CHAR;

BEGIN
  Assign (fon, fon_bbsname);
  Reset (fon); CheckIO;

  Assign (phn, phn_bbsname);
  Reset (phn, 1); CheckIO;
  Seek (phn, FileSize (phn) - SizeOf (defaults));
  BlockRead (phn, defaults, SizeOf (defaults));

  Seek (phn, FileSize (phn));

  WHILE NOT EoF (fon) DO BEGIN
    ReadLn (fon, fonstr);
    IF (Length (fonstr) > 1) THEN
    BEGIN
      GetTokens (fonstr, bbsnam, bbsnum);
      IF Length (bbsnam) > SizeOf (bbsnam) THEN
        bbsnam := Trim (Copy (bbsnam, 1, SizeOf (bbsnam)));
      IF Length (bbsnum) > SizeOf (bbsnum) THEN
        bbsnum := Trim (Copy (bbsnum, 1, SizeOf (bbsnum)));

      WriteLn ('Adding BBS: ', bbsnam, '; ', bbsnum);

      bbsnam := rpad (bbsnam, SizeOf (bbsnam), #0);
      bbsnum := rpad (bbsnum, SizeOf (bbsnum), #0);

      entry := bbsnam + bbsnum + #0#0#0#0#0#0#0#0 + defaults;

      Move (entry [1], entry_array, SizeOf (entry));

      BlockWrite (phn, entry_array, SizeOf (entry_array));
      CheckIO;

    END;
  END;

  Close (fon);
  Close (phn);
END;

VAR
  phn_bbsname,
  fon_bbsname: string;

  PhnPath, FonPath: PATHSTR;
  PhnDir, FonDir: DIRSTR;

BEGIN
  IF ParamCount <> 2 THEN Help (255);
  fon_bbsname := GetFilePath (ParamStr(1), FonDir);
  phn_bbsname := GetFilePath (ParamStr(2), PhnDir);

  IF IsFile (phn_bbsname) AND IsFile (fon_bbsname)
    THEN Appendbbsnumbers (fon_bbsname, phn_bbsname)
    ELSE Help (1)
END.
