#define MAX_STRINGS 12

class CMyApp : public CWinApp
{
public:
    BOOL InitInstance ();
};

class CMainWindow : public CWnd
{
private:
    int m_cxChar;                       // Average character width
    int m_cyChar;                       // Character height
    int m_cyLine;                       // Line height
    int m_nTextPos;                     // Current text position
    int m_nTabStops[7];                 // Tab stops
    int m_nTextLimit;                   // Rightmost text extent
    int m_nMsgPos;                      // Position in m_messages array
    
    HCURSOR m_hCursorArrow;             // Handle of arrow cursor
    HCURSOR m_hCursorIBeam;             // Handle of I-beam cursor

    CPoint m_pointTextOrigin;           // Text origin
    CPoint m_pointHeaderOrigin;         // Header origin
    CPoint m_pointUpperMsgOrigin;       // Origin of top message string
    CPoint m_pointLowerMsgOrigin;       // Origin of bottom message string
    CPoint m_pointCaretPos;             // Saved caret position

    CRect m_rectTextBox;                // Text-entry rectangle
    CRect m_rectMsgBox;                 // Message-string rectangle
    CRect m_rectScroll;                 // Scroll rectangle

    CString m_text;                     // The input text
    CString m_messages[MAX_STRINGS];    // Message text strings

    int GetNearestPos (CPoint);
    void PositionCaret (CDC* = NULL);
    void DrawInputText (CDC*);
    void Draw3DRectangle (CDC*, CRect&);
    void ShowMessage (CString&, UINT, UINT, UINT);
    void DrawMessages (CDC*);

public:
    CMainWindow ();

protected:
    void PostNcDestroy ();

    afx_msg int OnCreate (LPCREATESTRUCT);
    afx_msg void OnPaint ();
    afx_msg void OnSetFocus (CWnd*);
    afx_msg void OnKillFocus (CWnd*);
    afx_msg void OnLButtonDown (UINT, CPoint);
    afx_msg void OnMouseMove (UINT, CPoint);
    afx_msg void OnKeyDown (UINT, UINT, UINT);
    afx_msg void OnKeyUp (UINT, UINT, UINT);
    afx_msg void OnSysKeyDown (UINT, UINT, UINT);
    afx_msg void OnSysKeyUp (UINT, UINT, UINT);
    afx_msg void OnChar (UINT, UINT, UINT);
    afx_msg void OnSysChar (UINT, UINT, UINT);

    DECLARE_MESSAGE_MAP ()
};
