//
//
//
// MakEngine.cc
//
//

#define INCL_DOSSEMAPHORES
#define INCL_DOSDATETIME
#define INCL_DOSERRORS

#include "PmMain.hh"
#include "PmVars.hh"
#include "PmHelp.hh"
#include "PmIDs.hh"

#include <PmBitmap.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "debug.h"

#include "makengine.hh"
#include "videoengine.hh"
#include "sndengine.hh"

#include "tile.hh"
#include "playfield.hh"
#include "sprite.hh"
#include "ghost.hh"
#include "makman.hh"

#include "joyos2.h"

//
// Variables used for communication with the other thread.
//
int fieldRedraw; // playfield needs to be redrawn
int useJoystick;
GAME_2DPOS_STRUCT joyCal[3] = // let pos 0 empty, pos 1 and 2 for joystick A and B respectively
    { {0,0},{0,0},{0,0} };

char  defaultTilePath[100] = "3dtiles";

char* tilePaths[] = {
    "tiles",
    "3dtiles"
    };

const int numFldDsgns = 5;


int fldDsgns[numFldDsgns][fieldSizeX * fieldSizeY] =
{
  // Design used for level 1..
  {  spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc,
     dr , hor, hor, hor, hor, hor, hor, hor, hor, hor, ldr, hor, hor, hor, hor, hor, hor, hor, hor, hor, ld ,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     ver, bdt, le , hor, re , dot, le , ldr, re , dot, ver, dot, le , hor, re , dot, le , hor, re , bdt, ver,
     ver, dot, dot, dot, dot, dot, dot, ver, dot, dot, ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     dru, hor, re , dot, le , ld , dot, de , dot, le , rul, re , dot, le , re , dot, ue , dot, ue , dot, ver,
     ver, dot, dot, dot, dot, ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver, dot, ver, dot, ver,
     ver, dot, dr , ld , dot, ver, dot, dr , hor, hor, dor, hor, hor, ld , dot, le , ul , dot, de , dot, ver,
     ver, dot, ver, ver, dot, de , dot, ver, spc, spc, spc, spc, spc, ver, dot, dot, dot, dot, dot, dot, ver,
     ver, dot, ver, ver, dot, dot, dot, ver, spc, spc, spc, spc, spc, ver, dot, dr , hor, hor, ld , dot, ver,
     ver, dot, ru , ul , dot, ue , dot, ru , hor, hor, hor, hor, hor, ul , dot, ru , hor, hor, ul , dot, ver,
     ver, dot, dot, dot, dot, ver, dot, dot, dot, dot, spc, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     dru, hor, re , dot, le , ul , dot, le , hor, hor, ldr, hor, hor, re , dot, ue , dot, lre, dot, le , uld,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver, dot, dot, dot, dot, ver, dot, dot, dot, dot, ver,
     ver, bdt, le , hor, hor, hor, hor, hor, re , dot, de , dot, le , hor, hor, rul, hor, hor, re , bdt, ver,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     ru , hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, ul  },

  // Design used for level 2...
  {  spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc,
     dr , hor, hor, hor, hor, hor, hor, hor, hor, hor, ldr, hor, hor, hor, hor, hor, hor, hor, hor, hor, ld ,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     ver, bdt, le,  hor, ld , dot, le , hor, re , dot, ver, dot, le , hor, re , dot, dr , hor, re,  bdt, ver,
     ver, dot, dot, dot, ver, dot, dot, dot, dot, dot, ver, dot, dot, dot, dot, dot, ver, dot, dot, dot, ver,
     ver, dot, ue , dot, ru,  hor, hor, hor, re,  dot, de , dot, le , hor, hor, hor, ul , dot, ue , dot, ver,
     ver, dot, ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver, dot, ver,
     ver, dot, ru , hor, hor, re,  dot, dr , hor, hor, dor, hor, hor, ld , dot, le , hor, hor, ul , dot, ver,
     ver, dot, dot, dot, dot, dot, dot, ver, spc, spc, spc, spc, spc, ver, dot, dot, dot, dot, dot, dot, ver,
     ver, dot, dr , ld , dot, ue , dot, ver, spc, spc, spc, spc, spc, ver, dot, ue , dot, dr , ld , dot, ver,
     ver, dot, ru , ul , dot, ver, dot, ru , hor, hor, hor, hor, hor, ul , dot, ver, dot, ru , ul , dot, ver,
     ver, dot, dot, dot, dot, ver, dot, dot, dot, dot, spc, dot, dot, dot, dot, ver, dot, dot, dot, dot, ver,
     dru, hor, re , dot, le,  ul , dot, le , hor, ld , dot, dr , hor, re , dot, ru , re , dot, le , hor, uld,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, ver, dot, ver, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     ver, bdt, le,  hor, hor, re , dot, ue , dot, de , dot, de , dot, ue , dot, le , hor, hor, re , bdt, ver,
     ver, dot, dot, dot, dot, dot, dot, ver, dot, dot, dot, dot, dot, ver, dot, dot, dot, dot, dot, dot, ver,
     ru , hor, hor, hor, hor, hor, hor, rul, hor, hor, hor, hor, hor, rul, hor, hor, hor, hor, hor, hor, ul  },
   // 3
  {  spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc,
     dr , hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, ld ,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     ver, bdt, dr , hor, re , dot, dr , hor, hor, hor, hor, hor, hor, hor, ld , dot, le , hor, ld , bdt, ver,
     ver, dot, de , dot, dot, dot, ver, dot, dot, dot, dot, dot, dot, dot, ver, dot, dot, dot, de , dot, ver,
     ver, dot, dot, dot, ue , dot, de , dot, le , hor, hor, hor, re , dot, de , dot, ue , dot, dot, dot, ver,
     dru, hor, re , dot, de , dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, de , dot, le , hor, uld,
     ver, dot, dot, dot, dot, ue,  dot, dr , hor, hor, dor, hor, hor, ld , dot, ue , dot, dot, dot, dot, ver,
     ver, dot, le , re , dot, ver, dot, ver, spc, spc, spc, spc, spc, ver, dot, ver, dot, le , re , dot, ver,
     ver, dot, dot, dot, dot, ver, dot, ver, spc, spc, spc, spc, spc, ver, dot, ver, dot, dot, dot, dot, ver,
     ver, dot, dr , re , dot, de , dot, ru , hor, hor, hor, hor, hor, ul , dot, de , dot, le , ld , dot, ver,
     ver, dot, de , dot, dot, dot, dot, dot, dot, dot, spc, dot, dot, dot, dot, dot, dot, dot, de , dot, ver,
     ver, dot, dot, dot, dr,  re , dot, le , ld , dot, ue , dot, dr , re , dot, le , ld , dot, dot, dot, ver,
     ver, dot, ue , dot, ver, dot, dot, dot, ver, dot, ver, dot, ver, dot, dot, dot, ver, dot, ue , dot, ver,
     ver, bdt, de,  dot, de , dot, ue , dot, de , dot, ver, dot, de , dot, ue , dot, de , dot, de , bdt, ver,
     ver, dot, dot, dot, dot, dot, ver, dot, dot, dot, ver, dot, dot, dot, ver, dot, dot, dot, dot, dot, ver,
     ru , hor, hor, hor, hor, hor, rul, hor, hor, hor, rul, hor, hor, hor, rul, hor, hor, hor, hor, hor, ul  },
   // 4
  {  spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc,
     dr , hor, hor, hor, hor, hor, ldr, hor, hor, hor, ldr, hor, hor, hor, ldr, hor, hor, hor, hor, hor, ld ,
     ver, dot, dot, dot, dot, dot, ver, dot, dot, dot, ver, dot, dot, dot, ver, dot, dot, dot, dot, dot, ver,
     ver, bdt, lre, dot, ue , dot, de , dot, ue , dot, de , dot, ue , dot, de , dot, ue , dot, lre, bdt, ver,
     ver, dot, dot, dot, ver, dot, dot, dot, ver, dot, dot, dot, ver, dot, dot, dot, ver, dot, dot, dot, ver,
     dru, re , dot, le , rul, re , dot, le , rul, re , dot, le , rul, re , dot, le , rul, re , dot, le , uld,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     ver, dot, dr , re , dot, lre, dot, dr , hor, hor, dor, hor, hor, ld , dot, lre, dot, le , ld , dot, ver,
     ver, dot, de , dot, dot, dot, dot, ver, spc, spc, spc, spc, spc, ver, dot, dot, dot, dot, de , dot, ver,
     ver, dot, dot, dot, dr , ld , dot, ver, spc, spc, spc, spc, spc, ver, dot, dr , ld , dot, dot, dot, ver,
     ver, dot, lre, dot, ru , ul , dot, ru , hor, hor, hor, hor, hor, ul , dot, ru , ul , dot, lre, dot, ver,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, spc, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     dru, re , dot, le , ldr, re , dot, le , ldr, re , dot, le , ldr, re , dot, le , ldr, re , dot, le , dru,
     ver, dot, dot, dot, ver, dot, dot, dot, ver, dot, dot, dot, ver, dot, dot, dot, ver, dot, dot, dot, ver,
     ver, bdt, lre, dot, de , dot, ue , dot, de , dot, ue , dot, de , dot, ue , dot, de , dot, lre, bdt, ver,
     ver, dot, dot, dot, dot, dot, ver, dot, dot, dot, ver, dot, dot, dot, ver, dot, dot, dot, dot, dot, ver,
     ru , hor, hor, hor, hor, hor, rul, hor, hor, hor, rul, hor, hor, hor, rul, hor, hor, hor, hor, hor, ul  },
   // 5
  {  spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc, spc,
     dr , hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, ld ,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     ver, bdt, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, bdt, ver,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     ver, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, ver,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     ver, dot, lre, dot, le , re , dot, dr , hor, hor, dor, hor, hor, ld , dot, le , re , dot, lre, dot, ver,
     ver, dot, dot, dot, dot, dot, dot, ver, spc, spc, spc, spc, spc, ver, dot, dot, dot, dot, dot, dot, ver,
     ver, dot, ue , dot, dr , ld , dot, ver, spc, spc, spc, spc, spc, ver, dot, dr , ld , dot, ue , dot, ver,
     ver, dot, de , dot, ru , ul , dot, ru , hor, hor, hor, hor, hor, ul , dot, ru , ul , dot, de , dot, ver,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, spc, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     ver, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, ver,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     ver, bdt, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, dot, lre, bdt, ver,
     ver, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, dot, ver,
     ru , hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, hor, ul  }

};


const int numLevels = 5;

int levelData[numLevels][10] = {
{      
    0,      // Field Design
    10*32,   // Pill duration, in ticks
    4.7*32,  // Ghost hatch time, in ticks
    0,       // Ghost Path Time (unused)
    8,       // Ghost IQ
    60*32,   // time between fruits
    15*32,   // fruit duration
    200,     // fruit value
    0,       // fruit value icon from makman
    cherry   // fruit icon
    },
{
    1,       // Field Design
    8*32,    // Pill duration, in ticks
    4*32,    // Ghost hatch time, in ticks
    0,       // Ghost Path Time (unused)
    10,      // Ghost IQ
    60*32,   // time between fruits
    14*32,   // fruit duration
    400,     // fruit value
    1,       // fruit value icon from makman
    strawberry // fruit icon
    },
{
    2,       // Field Design
    5*32,    // Pill duration, in ticks
    4*32,    // Ghost hatch time, in ticks
    0,       // Ghost Path Time (unused)
    10,      // Ghost IQ
    60*32,   // time between fruits
    14*32,   // fruit duration
    400,     // fruit value
    1,       // fruit value icon from makman
    strawberry // fruit icon
    },
{
    3,       // Field Design
    5*32,    // Pill duration, in ticks
    4*32,    // Ghost hatch time, in ticks
    0,       // Ghost Path Time (unused)
    10,      // Ghost IQ
    60*32,   // time between fruits
    14*32,   // fruit duration
    400,     // fruit value
    1,       // fruit value icon from makman
    strawberry // fruit icon
    },
{
    4,      // Field Design
    5*32,    // Pill duration, in ticks
    4*32,    // Ghost hatch time, in ticks
    0,       // Ghost Path Time (unused)
    10,      // Ghost IQ
    60*32,   // time between fruits
    14*32,   // fruit duration
    400,     // fruit value
    1,       // fruit value icon from makman
    strawberry // fruit icon
    }
};



char *pillBitmaps[] =
{
  "power dot.bmp",
  "power dot 1.bmp",
  "power dot 2.bmp",
  "power dot 3.bmp"
  };

char *doorBitmaps[] =
{
  "ghost door 001.bmp",
  "ghost door 002.bmp",
  "ghost door 003.bmp",
  "ghost door 004.bmp"
  };

// How often the pill icon changes ( in ticks )
#define pillFrequency 5
#define doorFrequency 7

movement usrMove;

gfx    *GfxEng;
snd    *SndEng;
//
// Sprites
makman *myman;
ghost  *andrej,
       *blinky,
       *inky,
       *stinky;

game   myGame;

//
// Instantiate playfield
playfield *myfld;

//
// Housekeeping stuff
int lostEvents;
int engineFailure;


int Eng_Abort( char* pszErrMsg)
{
  char szErrTitle[] = "GFX Engine Error";

  WinMessageBox(HWND_DESKTOP,
		hwndFrame,
		(PSZ)(pszErrMsg),
		(PSZ)szErrTitle,
		0,
	        MB_MOVEABLE | MB_CUACRITICAL | MB_CANCEL );

  engineFailure = 1;

  return engineFailure;
}

int Eng_Close ( VOID )
{
  
  delete myfld;    
  delete myman;
  delete andrej;
  delete blinky;
  delete inky;
  delete stinky;

  SndEng->unload(snd_start);
  SndEng->unload(snd_mak);
  SndEng->unload(snd_ghost);
  SndEng->unload(snd_dot);
  SndEng->unload(snd_empty);

  return 0;
}

int Eng_Init ( VOID )
{
   
  engineFailure = 0;

  myfld = new playfield  ( fieldSizeX, fieldSizeY, 0, 0);

  myfld->load_backtile ( "blank.bmp" );
  myfld->load_backtile ( "horizontal.bmp" );
  myfld->load_backtile ( "vertical.bmp" );
  myfld->load_backtile ( "left to down.bmp" );
  myfld->load_backtile ( "right to up.bmp" );
  myfld->load_backtile ( "up to left.bmp" );
  myfld->load_backtile ( "down to right.bmp" );
  myfld->load_backtile ( "down right up.bmp" );
  myfld->load_backtile ( "left down right.bmp" );
  myfld->load_backtile ( "right up left.bmp" );
  myfld->load_backtile ( "up left down.bmp" );
  myfld->load_backtile ( "down end.bmp" );
  myfld->load_backtile ( "left end.bmp" );
  myfld->load_backtile ( "right end.bmp" );
  myfld->load_backtile ( "up end.bmp" );
  myfld->load_backtile ( "dot.bmp");
  myfld->load_backtile ( sizeof(doorBitmaps)/sizeof(char*), doorBitmaps, doorFrequency, FALSE);
  myfld->load_backtile ( "left end right end.bmp");
  myfld->load_backtile ( sizeof(pillBitmaps)/sizeof(char*), pillBitmaps, pillFrequency, TRUE);
  myfld->load_backtile ( "middle mouth right.bmp");
  myfld->load_backtile ( "score 0.bmp");
  myfld->load_backtile ( "score 1.bmp");
  myfld->load_backtile ( "score 2.bmp");
  myfld->load_backtile ( "score 3.bmp");
  myfld->load_backtile ( "score 4.bmp");
  myfld->load_backtile ( "score 5.bmp");
  myfld->load_backtile ( "score 6.bmp");
  myfld->load_backtile ( "score 7.bmp");
  myfld->load_backtile ( "score 8.bmp");
  myfld->load_backtile ( "score 9.bmp");
  myfld->load_backtile ( "Cherry.bmp");
  myfld->load_backtile ( "Strawberry.bmp");

  // Instantiate sprites
  myman  = new makman;
  andrej = new ghost;
  blinky = new ghost;
  inky   = new ghost;
  stinky = new ghost;

  myfld->register_sprite (myman);
  myfld->register_sprite (inky);
  myfld->register_sprite (blinky);
  myfld->register_sprite (stinky);
  myfld->register_sprite (andrej);

  lostEvents = 0;

  snd_empty = SndEng->load("sounds\\empty.wav");
  snd_dot   = SndEng->load("sounds\\dot.wav");
  snd_ghost = SndEng->load("sounds\\eating.wav");
  snd_mak   = SndEng->load("sounds\\eaten.wav");
  snd_start = SndEng->load("sounds\\ready.wav");


  if (engineFailure)
    return FALSE; // an error has occurred

  return TRUE; // init ok
}

int Eng_InitLevel ( int crntLevel )
{

  int* lD;

  crntLevel = crntLevel % numLevels;

  lD = &levelData[crntLevel][0];

  myfld->set_field (fldDsgns[lD[0]], fieldSizeX * fieldSizeY * sizeof(int) );
  myfld->set_field_data ( lD[1], lD[2], lD[3], lD[4], lD[5], lD[6], lD[7], lD[8], lD[9]);


  usrMove = move_left;

  return TRUE;

}

int Eng_NewGame ( VOID )
{
    myfld->new_game();

    return TRUE;
}

int Eng_StartGame ( VOID )
{
  APIRET rc;
  myfld->show();
  
  rc = DosStartTimer ( 26, (HSEM)hevTick, &hTimer);
  if (rc)
    {
      char buf[80];
      sprintf(buf, "Couldn't start game timer, code : %u",rc);
      Eng_Abort (buf);
    }

  return rc;
}

int Eng_SetOfs ( int x, int y )
{
  myfld->setScreenOfs( x, y );
  return 0;
}


int  Eng_ShowPlayfield( VOID )
{
  myfld->show();

  return TRUE;
}



int  Eng_ProcessInput ( SHORT key )
{

  switch (key)  {
  case VK_LEFT:
    usrMove = move_left;
    break;
  case VK_RIGHT:
    usrMove = move_right;
    break;
  case VK_UP:
    usrMove = move_up;
    break;
 case VK_DOWN:
    usrMove = move_down;
    break;
default:
    break;
  }

  return key;
}

VOID Eng_ThreadProc (VOID)
{
  // APIRET rc;
  ULONG  ulPostCt;
  GAME_STATUS_STRUCT joyStatus;
  ULONG  dataLen = sizeof(joyStatus);
  GAME_2DPOS_STRUCT *joyData = &joyStatus.curdata.A;

  // do for all eternity
  while(TRUE)
  {
      // wait for a timer tick
      DosWaitEventSem ((ULONG)hevTick, SEM_INDEFINITE_WAIT);
      DosResetEventSem((ULONG)hevTick, &ulPostCt);
      // did I miss any events?
      if (ulPostCt > 1)
	  lostEvents += ulPostCt - 1;

      // If i'm using a joystick, read joystick input
      if (useJoystick)
      {
	  DosDevIOCtl( hGame, IOCTL_CAT_USER, GAME_GET_STATUS,
		      NULL, 0, NULL,
		      &joyStatus, dataLen, &dataLen);
	  int joyX, joyY;
	  joyX = joyData[useJoystick-1].x - joyCal[useJoystick].x;
	  joyY = joyData[useJoystick-1].y - joyCal[useJoystick].y;

	  // a small tolerance to compensate for joystick drifting
	  int tolX = joyCal[useJoystick].x/10;
	  int tolY = joyCal[useJoystick].y/10;
	  
	  // we're moving on the X axis or on the Y axis?
	  if ( abs(joyX) > abs(joyY) )
	  { // X axis
	      if (joyX > tolX)
		  usrMove = move_right;
	      if (joyX < -tolX)
		  usrMove = move_left;
	  }
	  else
	  { // Y axis
	      if (joyY > tolY)
		  usrMove = move_down;
	      if (joyY < -tolY)
		  usrMove = move_up;
	  }

      } // joystick input

      // keep the game going
      myGame = myfld->tick( usrMove );
      myfld->update( fieldRedraw );
      fieldRedraw = 0;
      
      // any change of status?
      if ( (DosWaitEventSem ((ULONG)hevTerminate, SEM_IMMEDIATE_RETURN) == NO_ERROR) ||
	  (myGame!=level_running) )
      {
	  // suspend this thread and notify main thread
	  DosStopTimer (hTimer);          
	  WinPostMsg ( hwndClient, WM_COMMAND, (VOID *)IDM_ENGINE, (VOID *)myGame); 
	  DosSuspendThread(tidAsync);
      }
  }
}
