/* UDP-related user commands
 * Copyright 1991 Phil Karn, KA9Q
 */
#ifdef MSDOS
#include <dos.h>
#endif
#include "global.h"
#include "mbuf.h"
#include "netuser.h"
#include "socket.h"
#include "udp.h"
#include "internet.h"
#include "cmdparse.h"
#include "commands.h"
  
static int doudpstat __ARGS((int argc,char *argv[],void *p));
  
static struct cmds DFAR Udpcmds[] = {
    "status",   doudpstat,  0, 0,   NULLCHAR,
    NULLCHAR,
};
int
doudp(argc,argv,p)
int argc;
char *argv[];
void *p;
{
    return subcmd(Udpcmds,argc,argv,p);
}
int
st_udp(udp,n)
struct udp_cb *udp;
int n;
{
    if(n == 0)
#ifdef UNIX
        tprintf("&UCB Rcv-Q  Local socket\n");
  
    return tprintf("%8.8x%6u  %s\n",FP_SEG(udp),udp->rcvcnt,pinet(&udp->socket));
#else
    tputs("&UCB Rcv-Q  Local socket\n");
  
    return tprintf("%4.4x%6u  %s\n",FP_SEG(udp),udp->rcvcnt,pinet(&udp->socket));
#endif
}
  
/* Dump UDP statistics and control blocks */
static int
doudpstat(argc,argv,p)
int argc;
char *argv[];
void *p;
{
    register struct udp_cb *udp;
    register int i;
  
    for(i=1;i<=NUMUDPMIB;i++){
        tprintf("(%2u)%-20s%10lu",i,
        Udp_mib[i].name,Udp_mib[i].value.integer);
        if(i % 2)
            tputs("     ");
        else
            tputc('\n');
    }
    if((i % 2) == 0)
        tputc('\n');
  
    tputs("&UCB Rcv-Q  Local socket\n");
    for(udp = Udps;udp != NULLUDP; udp = udp->next){
        if(st_udp(udp,1) == EOF)
            return 0;
    }
    return 0;
}
