unit Heaptst;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls,
  HeapChk,  {--- Variable HeapCheckActive   ---}
  HeapTest; {--- Function HeapTestCheckPtrs ---}

type
  TForm1 = class(TForm)
    ButtonMakeError: TButton;
    ButtonShowError: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    ButtonMakeInv: TButton;
    procedure ButtonMakeErrorClick(Sender: TObject);
    procedure ButtonShowErrorClick(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure ButtonMakeInvClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


{--- Make an Overflow --}
procedure TForm1.ButtonMakeErrorClick(Sender: TObject);
var
  p : PChar;
begin
  GetMem(p,16);
  strcopy(p,'1234567890123456'); { one Byte Overflow }
end;


{--- Make an Overflow, that ButtonShowErrorClick can't show ---}
procedure TForm1.ButtonMakeInvClick(Sender: TObject);
var
  p : PChar;
begin
  {-- this is a Overflow like ButtonMakeErrorClick.
      The block is dealloceted before ButtonShowErrorClick can occur.
      Click on ShowError can't show this error, because the block
      is deallocated.
      This Error will be listed in the DUMP.TXT
      (!!! only in the registered version !!!)
   -- }
  GetMem(p,16);
  strcopy(p,'1234567890123456'); { one Byte Overflow }
  FreeMem(p,16);
end;

{--- Show Errors ---}
procedure TForm1.ButtonShowErrorClick(Sender: TObject);
begin
  {-- lock for Overflows --}
  HeapTestCheckPtrs;
end;


{--- Set Name of Dumpfile ---}
procedure TForm1.Edit1Change(Sender: TObject);
begin
  HeapTestDumpFile := Edit1.Text;
end;


{--- Set Searchpath for Sourcefiles ---}
procedure TForm1.Edit2Change(Sender: TObject);
begin
  HeapTestSearchPath := Edit2.Text;
end;



procedure TForm1.FormShow(Sender: TObject);
begin
  {-- test if HeapChk is installed --}
  if not HeapCheckActive then
    {-- maybe a new version of delphi-librarys --}
    ShowMessage('Can''t install HeapChk');

  {-- make a none-deallocated block. Lock in DUMP.TXT --}
  TStringList.Create;
end;


end.
