/*  REXX ͻ */
/*                                                                  */
/*   Name: CEMTUTIL.CMD                                             */
/*                                                                  */
/*   Type: OS/2 command procedure                                   */
/*                                                                  */
/*   Desc: REXX procedure to test the features of the CEMTUTIL.DLL  */
/*                                                                  */
/*   Creation date: 5 Aug 1995, creation time: 14:18:34             */
/*                                                                  */
/*   Author: (c) Volker Bandke                                      */
/*                                                                  */
/* ͼ */

SIGNAL ON HALT
SIGNAL ON ERROR
SIGNAL ON FAILURE
SIGNAL ON SYNTAX

/*Ŀ*/
/* Load all additional functions that we need                      */
/**/
Call RxFuncAdd "SysLoadFuncs",  "rexxutil",  "SysLoadFuncs"
call SysLoadFuncs
call RxFuncAdd "Rx_CEMT_LoadFuncs", "CEMTUTIL", "Rx_CEMT_LoadFuncs"
call Rx_CEMT_LoadFuncs
/*Ŀ*/
/* Test of Rx_CEMT_ListSystems call                                */
/**/
call SysCls;
say
say "Ŀ"
say " Testing the Rx_CEMT_ListSystems call                            "
say ""
say
RC=Rx_CEMT_ListSystems("CICSSYS")
say "Returncode from Rx_CEMT_ListSystems is" RC
if (rc=0) then
 do
  select
   when CICSSYS.0=0 then X= "There is no system"
   when CICSSYS.0=1 then X= "There is one system"
   otherwise             X= "There are" CICSSYS.0 "systems"
  end
  say X "that can be connected to"
  if CICSSYS.0 > 0 then
   do i = 1 to CICSSYS.0
    parse value CICSSYS.i with sysid description
    if description="" then description="(none)"
    say "SYSID:" sysid ", Description:" description
   end
 end
else
 do
  say "Rx_CEMT_ListSystems ended with RC=" RC
  say "The ECI Error code was" CICSSYS.ECI_RC
  say "This error code actually means" CICSSYS.ECI_RC$
 end
/* endif */
/*Ŀ*/
/* Test of Rx_CEMT_Inq_System call                                 */
/**/
say "Press the <ENTER> key to continue"
pull dummy
call SysCls;
say
say "Ŀ"
say " Testing the Rx_CEMT_Inq_System call                             "
say ""
say
parse value Rx_CEMT_Inq_System() with eci_code sysid applid opsys cicsrel oprel cwalen
if (eci_code=0) then
 do
  say "Sysid ....................." sysid
  say "Applid ...................." applid
  select
   when opsys='P' then opsys='OS/2'
   when opsys='X' then opsys='MVS/ESA'
   otherwise opsys="Unknown"
  end
  say "Operating system .........." opsys
  say "Operating system release .." oprel%10 ||'.'|| oprel//10
  say "CICS release .............." substr(cicsrel,1,2)||'.'||substr(cicsrel,3,2)
  say "Length of CWA ............." cwalen
 end
else
 do
  say "The Rx_CEMT_INQ_System failed with ECI_RC =" eci_code
 end
/*endif (RC=0) then */
/*Ŀ*/
/* Test of Rx_CEMT_Inq_Tasks call                                  */
/**/
say "Press the <ENTER> key to continue"
pull dummy
test:
call SysCls;
say
say "Ŀ"
say " Testing the Rx_CEMT_Inq_Tasks call                              "
say ""
say
RC=Rx_CEMT_Inq_Tasks("CICSTSK");
say "Returncode from Rx_CEMT_Inq_Tasks was" RC
if (RC = 0) then
 do
  x = CICSTSK.0
  say "There are" x "Tasks currently running"
  if x > 0 then
   say "Ŀ"
   say " tasknum  trans  Type  fac.  prty "
   say "Ĵ"
   do i = 1 to CICSTSK.0
    parse value CICSTSK.i with tasknum transid fac factype prty
    tasknum=tasknum+0
    prty=prty+0
    tasknum=" " || right(tasknum,7) || " "
    transid=" " || right(transid,5) || " "
    factype=" " || right(factype,4) || " "
    fac    =" " || right(fac    ,4) || " "
    prty   =" " || right(prty   ,3) || "  "
    say tasknum||transid||factype||fac||prty
   end
   say ""
 end
/* endif */
say "ECI Return code was " CICSTSK.ECI_RC
say "This has the following meaning: " CICSTSK.ECI_RC$
if CICSTSK.ABCODE\= " " then say "The transaction has abended with abendcode" CICSCON.ABCODE
/*Ŀ*/
/* Test of Rx_CEMT_Inq_Connections call                            */
/**/
say "Press the <ENTER> key to continue"
pull dummy
call SysCls;
say
say "Ŀ"
say " Testing the Rx_CEMT_Inq_Connections call                        "
say ""
say
RC=Rx_CEMT_Inq_Connections("CICSCON");
say "Returncode from Rx_CEMT_Inq_Connections was" RC
if (RC = 0) then
 do
  x = CICSCON.0
  say "There are" x "connections defined to other systems"
  if x > 0 then
   do i = 1 to CICSCON.0
     parse value CICSCON.i with sysid netname servstat acqstat
     select
      when servstat='I' then servstat = "In Service    "
      when servstat="O" then servstat = "Out of service"
      when servstat="G" then servstat = "Going Out     "
      otherwise servstat="Unknown"
     end
     select
      when acqstat='A' then acqstat = "Acquired"
      when acqstat='R' then acqstat = "Released"
      otherwise acqstat             = "Unknown "
     end
     say "Sysid:" sysid ", netname:" netname "is" servstat "and" acqstat
   end
 end
/* endif */
say "ECI Return code was " CICSCON.ECI_RC
say "This has the following meaning: " CICSCON.ECI_RC$
if CICSCON.ABCODE\= " " then say "The transaction has abended with abendcode" CICSCON.ABCODE
/*Ŀ*/
/* Test of Rx_CEMT_Inq_Transactions call                           */
/**/
say "Press the <ENTER> key to continue"
pull dummy
test:
call SysCls;
say
say "Ŀ"
say " Testing the Rx_CEMT_Inq_Transactions call                       "
say ""
say
RC=Rx_CEMT_Inq_Transactions("CICSTRN");
say "Returncode from Rx_CEMT_Inq_Transactions was" RC
if (RC=0) then
 do
  x = CICSTRN.0
  say "There are" x "transactions defined in this CICS system"
  if x > 0 then
   do i = 1 to CICSTRN.0
    parse value CICSTRN.I with transid program enastat purgstat rsysid rtranid
    select
     when enastat="E" then enastat="enabled"
     when enastat="D" then enastat="disabled"
     otherwise enastat="unknown"
    end
    select
     when purgstat="P" then purgstat="purgeable"
     when purgstat="N" then purgstat="nonpurgeable"
     otherwise purgstat="unknown"
    end
    if program="(remote)" then
     say "Transaction:" transid "is" enastat "and" purgstat "and remote in" rsysid "as" rtranid
     else say "Transaction:" transid ", program: " program "is" enastat "and" purgstat
   end
  /* endif */
 end
/* endif RC=0 */
say "Returncode from ECI was " CICSTRN.ECI_RC
say "This returncode actually means" CICSTRN.ECI_RC$
if CICSTRN.ABCODE\=" " then say "The CICS transaction abended with abcode" CICSTRN.ABCODE
/*Ŀ*/
/* Test of Rx_CEMT_Inq_File call                                   */
/**/
say "Press the <ENTER> key to continue"
pull dummy
call SysCls;
say
say "Ŀ"
say " Testing the Rx_CEMT_Inq_Files call                              "
say ""
say
RC=Rx_CEMT_Inq_Files("CICSFIL");
say "Returncode from Rx_CEMT_Inq_Files was" RC
if (RC=0) then
 do
  x = CICSFIL.0
  say "There are" x "datasets defined in this CICS system"
  if x > 0 then
   do i = 1 to CICSFIL.0
     parse value CICSFIL.I with filename enastat openstat
     select
      when enastat="E" then enastat="is enabled"
      when enastat="D" then enastat="is disabled"
      when enastat="U" then enastat="is unenabled"
      otherwise enastat="has unknown enablestatus"
     end
     select
      when openstat="O" then openstat="is open"
      when openstat="C" then openstat="is closed"
      otherwise openstat="has unknown openstatus"
     end
     say "The file" filename enastat "and" openstat
   end
  /* endif */
 end
/* endif */
say "Returncode from ECI was " CICSFIL.ECI_RC
say "This returncode actually means" CICSFIL.ECI_RC$
if CICSFIL.ABCODE\=" " then say "The CICS transaction abended with abcode" CICSFIL.ABCODE
/*Ŀ*/
/* Test of Rx_CEMT_Inq_Programs call                               */
/**/
say "Press the <ENTER> key to continue"
pull dummy
call SysCls;
say
say "Ŀ"
say " Testing the Rx_CEMT_Inq_Programs call                           "
say ""
say
RC=Rx_CEMT_Inq_Programs("CICSPRG");
say "Returncode from Rx_CEMT_Inq_Programs was" RC
if (rc=0) then,
 do
  x = CICSPRG.0
  say "There are" x "programs defined in this CICS system"
  if x > 0 then
   do i = 1 to CICSPRG.0
     parse value CICSPRG.i with program enastatus
     select
      when enastatus="E" then enastatus="is enabled"
      when enastatus="D" then enastatus="is disabled"
      otherwise enastatus="has unknown enabledstatus"
     end
     say program enastatus
   end
  /* endif */
 end
/* endif */
say "Returncode from ECI was " CICSPRG.ECI_RC
say "This returncode actually means" CICSPRG.ECI_RC$
if CICSPRG.ABCODE\=" " then say "The CICS transaction abended with abcode" CICSPRG.ABCODE
/*Ŀ*/
/* Test of Rx_CEMT_Inq_TDQueues call                               */
/**/
say "Press the <ENTER> key to continue"
pull dummy
call SysCls;
say
say "Ŀ"
say " Testing the Rx_CEMT_Inq_TDQueues call                           "
say ""
say
RC=Rx_CEMT_Inq_TDQueues("CICSTDQ");
say "Returncode from Rx_CEMT_Inq_TDQueues is" RC
if (RC=0) then
 do
  x = CICSTDQ.0
  say "There are" x "transient data queues defined in this CICS system"
  if x > 0 then
   do i = 1 to CICSTDQ.0
     parse value CICSTDQ.i with qname qtype enastat openstat term tran trigger req
     select
      when qtype="I" then qtype="Intra"
      when qtype="E" then qtype="Extra"
      when qtype="N" then qtype="Indirect"
      when qtype="R" then qtype="Remote"
      otherwise qtype="Unknown"
     end
     select
      when enastat="E" then enastat="Ena"
      when enastat="D" then enastat="Dis"
      otherwise enastat="n/a"
     end
     select
      when openstat="O" then openstat="Ope"
      when openstat="C" then openstat="Clo"
      otherwise openstat="n/a"
     end
     x = qname qtype enastat openstat
     if qtype="Intra" then x = X || " " || term  || " " || tran || " " || trigger
     say x
   end
  /* endif */
 end
/* endif */
say "Returncode from ECI was " CICSTDQ.ECI_RC
say "This returncode actually means" CICSTDQ.ECI_RC$
if CICSTDQ.ABCODE\=" " then say "The CICS transaction abended with abcode" CICSTDQ.ABCODE
/*Ŀ*/
/* Test of Rx_CEMT_Inq_Terminals call                              */
/**/
say "Press the <ENTER> key to continue"
pull dummy
call SysCls;
say
say "Ŀ"
say " Testing the Rx_CEMT_Inq_Terminals call                          "
say ""
say
RC=Rx_CEMT_Inq_Terminals("CICSTRM");
say "Returncode from Rx_CEMT_Inq_Terminals was" RC
if (RC=0) then
 do
  x = CICSTRM.0
  say "There are" x "terminals defined in this CICS system"
  if x > 0 then
   do i = 1 to CICSTRM.0
     parse value CICSTRM.I with termid netname  acqstatus servstatus atistatus
     select
      when  acqstatus="A" then acqstatus = "is acquired"
      when  acqstatus="R" then acqstatus = "is released"
      otherwise nop
     end
     select
      when  servstatus="I" then servstatus="and in service."
      when  servstatus="O" then servstatus="and out of service."
      when  servstatus="G" then servstatus="and going out of service."
      otherwise nop
     end
     select
      when atistatus="A" then atistatus=" ATI is allowed"
      when atistatus="N" then atistatus=" ATI is not allowed"
      otherwise nop
     end
     say "The terminal" termid "("||netname||")" acqstatus servstatus atistatus
   end
  /* endif */
 end
/* endif */
say "Returncode from ECI was " CICSTRM.ECI_RC
say "This returncode actually means" CICSTRM.ECI_RC$
if CICSTRM.ABCODE\=" " then say "The CICS transaction abended with abcode" CICSTRM.ABCODE
say "Press the <ENTER> key to continue"
pull dummy
exit

SYNTAX:
ERROR:
FAILURE:
 say "A Syntax error occurred in line " SIGL
 say "The offending statement was:"
 say Sourceline(SIGL)
 call vardump
HALT:
exit
