/*********************************************************************/
/*     REXX Function to determine partition file type                */
/*********************************************************************/
Parse Upper Arg partition .

/*********************************************************************/
/* Validate partition is two characters, the second must be a colon  */
/* and the first must be an alphabetic character from A-Z.           */
/*********************************************************************/
If Length(partition) <> 2 | Pos(':',partition) <> 2 | \Datatype(Substr(partition,1,1),'U') Then
   filetype = 'ERROR'
Else
   Do

/*********************************************************************/
/*           Initialize REXXUtil environment (if not present)        */
/*********************************************************************/
      rxload = RxFuncQuery('SysLoadFuncs')
      If rxload Then
         Do
            Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
            Call sysloadfuncs
         End

/*********************************************************************/
/*    Drives A: and B: can only be "FAT".                            */
/*********************************************************************/
      If partition = 'A:' | partition = 'B:' Then
         filetype = 'FAT'
      Else
         Do

/*********************************************************************/
/*   Get a list of all available local drives and validate the one   */
/*   we were passed.                                                 */
/*********************************************************************/
            drives = SysDriveMap('C:', 'LOCAL')
            If Wordpos(partition,drives) > 0 Then
               Select

/*********************************************************************/
/*   Check if the specified drive letter refers to a DCF/2 Virtual   */
/*   Disk Unit (VDU).  If so, flag it as such before proceeding.     */
/*********************************************************************/
                  When Value('DCF2_VDU_'||Substr(partition,1,1),,'OS2ENVIRONMENT') <> '' Then
                     filetype = 'VDU'

/*********************************************************************/
/*   If it is not a VDU, make sure the device is actually available  */
/*   and ready, otherwise return 'NOT READY' to the caller.          */
/*********************************************************************/
                  When SysDriveInfo(partition) = '' Then
                     filetype = 'NOT READY'

/*********************************************************************/
/*   If it is not a VDU, then check to see what kind of file system  */
/*   was used.                                                       */
/*********************************************************************/
                  Otherwise
                     Do

/*********************************************************************/
/*   Attempt to create a subdirectory that won't work on a FAT vol   */
/*********************************************************************/
                        result = SysMkDir(partition'\willonlyworkonHPFS')
                        Select

/*********************************************************************/
/*   If the function was successful, it must be HPFS.  Remove the    */
/*   directory we created.                                           */
/*********************************************************************/
                           When result = 0 Then
                              Do
                                 filetype = 'HPFS'
                                 rc = SysRmDir(partition'\willonlyworkonHPFS')
                              End

/*********************************************************************/
/*   If the function indicates an illegal name, it must be FAT       */
/*********************************************************************/
                           When result = 206 Then
                              filetype = 'FAT'

/*********************************************************************/
/*    Otherwise it must be a CD-ROM.                                 */
/*********************************************************************/
                           Otherwise
                              filetype = 'CD-ROM'
                        End
                     End
               End

/*********************************************************************/
/*  If we take this condition, the specified partition doesn't exist */
/*********************************************************************/
            Else
               filetype = 'ERROR'
         End

/*********************************************************************/
/*      If we loaded REXXUtil, unload it, then exit, passing back    */
/*      the filetype to the calling routine.                         */
/*********************************************************************/
      If rxload Then
         Call SysDropFuncs
   End
Return filetype
