; +---------------------------------------------------------+ ;
; | Sample program SHD for use with the Magic Assembler | ;
; +---------------------------------------------------------+ ;
        
        mov     ah,09
        mov     dx,offset(headtxt)
        int     21
        mov     ax,3d00
        mov     dx,offset(pname)
        int     21
        jnc     @15
        xor     al,al
        mov     dx,offset(palerr)
        jmp     error
@15     mov     bx,ax
        mov     ah,3f
        mov     cx,0300
        mov     dx,offset(palette)
        int     21
        mov     ah,3e
        int     21
        cmp     byte [0081],0d
        jne     @1
        xor     al,al
        mov     dx,offset(syntax)
        jmp     error
@1:     mov     si,0082
@2:     lodsb
        cmp     al,0d
        je      @16
        cmp     al,'/'
        je      @16
        jmp     @2
@16:    ds:
        mov     byte [si-01],00
        cmp     al,'/'
        jne     @17
        lodsb
        cmp     al,'I'
        je      @18
        cmp     al,'i'
        je      @18
        jmp     @17
@18:    mov     showit,ff
        pop     ds
        jmp     @19
@17:    push    ds
        push    es
        pop     ds
        mov     showit,00
        pop     ds
@19:    mov     ax,3d00
        mov     dx,0082
        int     21
        jnc     @3
        xor     al,al
        mov     dx,offset(openerr)
        jmp     error
@3:     mov     handle,ax
        mov     bx,ax
        mov     ah,3f
        mov     cx,0003
        mov     dx,offset(header)
        int     21
        mov     si,dx
        mov     di,offset(mheader)
        mov     cx,0003
@4:     cmpsb
        jne     @5
        loop    @4
        jmp     @6
@5:     mov     dx,offset(notdvm)
        mov     al,ff
        jmp     error
@6:     mov     ah,3f
        mov     cx,01
        mov     dx,offset(fullqrt)
        int     21
        cmp     fullqrt,'Q'
        je      @8
        cmp     fullqrt,'F'
        je      @9
        mov     ah,3f
        mov     cx,1
        mov     dx,offset(vs)
        int     21
        cmp     vs,40
        jna     @10
        xor     al,al
        mov     dx,offset(vererr)
        jmp     error
@10:    mov     ah,3f
        mov     cx,0001
        mov     dx,offset(infobyt)
        int     21
        jmp     @11
@8:     mov     infobyt,20
        jmp     @11
@9:     mov     infobyt,a0
@11:    mov     ah,3f
        mov     cx,0002
        mov     dx,offset(dtime)
        int     21
        test    infobyt,08
        jz      @20
        mov     ah,3f
        mov     cx,2
        mov     dx,offset(txtsize)
        int     21
        mov     cx,txtsize
@13:    push    cx
        mov     ah,3f
        mov     cx,1
        mov     dx,offset(cha)
        int     21
        cmp     showit,00
        je      @14
        push    bx
        mov     dl,cha
        mov     ah,02
        int     21
        pop     bx
@14:    pop     cx
        loop    @13
        cmp     showit,00
        je      @20
        xor     ah,ah
        int     16
@20:    mov     ax,0013
        int     10
        mov     ax,0a000
        mov     es,ax
        mov     al,infobyt
        and     al,14
        cmp     al,14
        jne     @22
        mov     stepsiz,08
        mov     palsiz3,06
        mov     linesiz,14
        jmp     @23
@22:    cmp     al,04
        jne     @24
        mov     stepsiz,4
        mov     palsiz3,0c
        mov     linesiz,28
        jmp     @23
@24:    cmp     al,00
        jne     @25
        mov     stepsiz,2
        mov     palsiz3,30
        mov     linesiz,50
        jmp     @23
@25:    mov     stepsiz,1
        mov     palsiz3,0300
        mov     linesiz,00a0
@23:    test    infobyt,40
        jnz     @40
        mov     linesiz,00a0
        mov     to_x,00a0
        mov     stepsiz,01
@40:    test    infobyt,80
        jz      @29
        mov     ax,linesiz
        add     linesiz,ax
        mov     ax,to_x
        add     to_x,ax
        mov     ax,to_y
        add     to_y,ax
@29:    mov     al,infobyt
        and     al,22
        cmp     al,22
        jne     @21
        mov     ah,3f
        mov     cx,palsiz3
        mov     dx,offset(palette)
        int     21
@21:    push    bx
        mov     ax,1012
        xor     bx,bx
        mov     cx,0100
        mov     dx,offset(palette)
        push    es
        push    ds
        pop     es
        int     10
        pop     es
        pop     bx
@26:    mov     al,infobyt
        and     al,22
        cmp     al,20
        jne     @27
        mov     ah,3f
        mov     cx,palsiz3
        mov     dx,offset(palette)
        int     21
        cmp     ax,cx
        je      @37
        jmp     @12
@37:    push    bx
        mov     ax,1012
        xor     bx,bx
        mov     cx,0100
        mov     dx,offset(palette)
        push    es
        push    ds
        pop     es
        int     10
        pop     es
        pop     bx
@27:    xor     di,di
        mov     cx,to_y
@28:    push    cx
        mov     ah,3f
        mov     cx,linesiz
        mov     dx,offset(line)
        int     21
        cmp     cx,ax
        je      @39
        jmp     @12
@39:    mov     cx,to_x
        mov     si,offset(line)
@30:    push    cx
        cmp     stepsiz,01
        jne     @31
        lodsb
        stosb
        jmp     @33
@31:    cmp     stepsiz,02
        jne     @32
        lodsb
        push    ax
        and     al,f0
        mov     cl,04
        shr     al,cl
        stosb
        pop     ax
        and     al,0f
        stosb
        jmp     @33
@32:    cmp     stepsiz,04
        jne     @34
        lodsb
        push    ax
        and     al,c0
        mov     cl,6
        shr     al,cl
        stosb
        pop     ax
        push    ax
        and     al,30
        mov     cl,04
        shr     al,cl
        stosb
        pop     ax
        push    ax
        and     al,0c
        mov     cl,02
        shr     al,cl
        stosb
        pop     ax
        and     al,03
        stosb
        jmp     @33
@34:    mov     cx,08
        lodsb
@35:    push    ax
        dec     cl
        shr     al,cl
        inc     cl
        and     al,1
        stosb
        pop     ax
        loop    @35
@33:    pop     cx
        sub     cx,stepsiz
        cmp     cx,0
        jne     @30
        cmp     to_x,00a0
        jne     @36
        add     di,00a0
@36:    pop     cx
        loop    @38
        jmp     @26
@38:    jmp     @28
@12:    mov     ah,3e
        int     21
        xor     ah,ah
        int     16
        mov     ax,0003
        int     10
        mov     ax,4c00
        int     21

error:  xor     al,al
        je      @7
        mov     ah,3e
        int     21
@7:     mov     ah,09
        int     21
        mov     ah,4c
        int     21

headtxt db      'Show DVM - Written by Bert Greevenbosch for Magic Software' 0a 0d 'Public Domain Version' 0a 0d 'Last possible DVM version: 4.0' 0a 0d '$'
openerr db      'Error opening file' 0a 0d '$'
vererr  db      'Cannot display this version' 0a 0d '$'
mheader db      'DVM'
notdvm  db      'Not a DVM' 0a 0d '$'
palerr  db      'Cannot open DVMPAL.BIN' 0a 0d '$'
pname   db      'DVMPAL.BIN' 00
syntax  db      'Syntax: SDA [Filename.DVM][/I]' 0a 0d '$'
to_x    dw      00a0
to_y    dw      0064
-
cha     db      ?
dtime   dw      ?
header  ds      3
fullqrt db      ?
handle  dw      ?
infobyt db      ?
line    ds      140
linesiz dw      ?
stepsiz dw      ?
palette ds      300
parseg  dw      ?
palsiz3 dw      ?
showit  db      ?
txtsize dw      ?
vs      db      ?
