/* AFE 2.6 Installation Process */

'@echo off'

call rxfuncadd sysloadfuncs,rexxutil,sysloadfuncs
call sysloadfuncs
 
call SysCls
Say '';Say ''
 
Say '  AFE INSTALLATION !';Say '';say ''

/* check for presence of required files */

exe=Stream('afe.exe','c','query exists')<>''
ico=Stream('afe.ico','c','query exists')<>''
cfg=Stream('afe-cfg.exe','c','query exists')<>''
dll=Stream('vrobj.dll','c','query exists')<>''

if exe=0 then do
say '  Can not find AFE.EXE !';exit
end

if ico=0 then do
say '  Can not find AFE.ICO !';exit
end

if cfg=0 then do
say '  Can not find AFE-CFG.EXE !';exit
end

if dll=0 then do
say '  Can not find VROBJ.DLL !';exit
end

Say '  Will copy program to correct drive/directory and create a'
say '  desktop object...';say '';say ''

/* get the path to install AFE files */

Say '  Give me the full pathname where you want AFE installed,'
Say '  including the drive.';say '';say '        Example: d:\bin\afe'
say ''

pull pathname

if pathname='' then do
say '';say '  No path specified !'
exit
end

/* if the user appended a "\" at the end of his path we don't want it */

if right(pathname,1)=="\" then do
pathlength=length(pathname)
pathlength=pathlength-1
newafepath=substr(pathname,1,pathlength)
pathname=newafepath
end

/* however, if it's the root directory we do want the "\" */

if right(pathname,1)==":" then do
pathname=''pathname'\'
end

/* make sure it's a real path */

call SysFileTree pathname,'file','d'
if file.0=0 then do
rc=SysMkDir(''pathname'')
  if rc>0 then do
  say '';say '  Path does not exist and can not be created !'
  exit
  end
end

call SysCls
say '';say '  Copying files...'

/* if we appended a "\" we now need to remove it */

if right(pathname,1)=="\" then do
pathlength=length(pathname)
pathlength=pathlength-1
newafepath=substr(pathname,1,pathlength)
pathname=newafepath
end

/* if there are already AFE files there let's make sure that they
   can be overwritten */

over=Stream(''pathname'\afe*','c','query exists')<>''
if over>0 then do
call SysFileTree ''pathname'\afe*','files','f','*-*+*','-----'

/* if there is an old AFE.CFG or AFE.INI get rid of them */

if Stream(''pathname'\afe.cfg','c','query exists')<>'' then do
call SysFileDelete ''pathname'\afe.cfg';end

if Stream(''pathname'\afe.ini','c','query exists')<>'' then do
call SysFileDelete ''pathname'\afe.ini';end

end

/* if this is the root we need that trailing "\" */

if right(pathname,1)==":" then do
pathname=''pathname'\'
end

/* copy the files */

'copy afe.exe 'pathname''
'copy afe.ico 'pathname''
'copy afe-cfg.exe 'pathname''

/* need to get rid of that trailing "\" again */

if right(pathname,1)=="\" then do
pathlength=length(pathname)
pathlength=pathlength-1
newafepath=substr(pathname,1,pathlength)
pathname=newafepath
end

call SysCls;say '';say '  Done!';SAY '';say '  Now I need a place to put the DLL';say ''
say '  Give me a full pathname (must be in your CONFIG.SYS LIBPATH statement)';say ''
say '       Example: c:\os2\dll'
say ''

/* now get the path to put the DLL file */

pull DLLpath

if dllpath='' then do
say '';say '  No path specified !'
exit
end

if right(DLLpath,1)=="\" then do
pathlength=length(DLLpath)
pathlength=pathlength-1
newDLLpath=substr(DLLpath,1,pathlength)
DLLpath=newDLLpath
end

if right(DLLpath,1)==":" then do
DLLpath=''DLLpath'\'
end

call SysFileTree dllpath,'file','d'
if file.0=0 then do
say ' Path does not exist !';exit;end

call SysCls
say '';say '  Copying files...'

if right(DLLpath,1)=="\" then do
pathlength=length(DLLpath)
pathlength=pathlength-1
newDLLpath=substr(DLLpath,1,pathlength)
DLLpath=newDLLpath
end

over=Stream(''DLLpath'\vrobj.dll','c','query exists')<>''
if over>0 then do
   call SysFileTree ''DLLpath'\vrobj.dll','files','f','*-*+*','-----'
 end

if right(DLLpath,1)==":" then do
DLLpath=''DLLpath'\'
end

'copy vrobj.dll 'dllpath''

call SysCls;say '';say '  Done!';say ''

Say '  Now creating Desktop object...'

/* create a desktop object for AFE */

classname='WPProgram'
title='AFE 2.6'
location='<WP_DESKTOP>'
setup='MINIMIZED=YES;PROGTYPE=PM;EXENAME='pathname'\AFE.EXE;OBJECTID=<WP_DESKTOP_AFE>;ASSOCFILTER=*.zip,*.lzh,*.zoo,*.arj;ICONFILE='pathname'\AFE.ICO;STARTUPDIR='pathname';'

BldObj:

result=SysCreateObject(classname,title,location,setup,'r')
 
If result=1 Then do

call SysCls
say '';say '  Object created!';Say '';Say '  All done!';SAY ''
say '  The AFE program object is installed on your desktop.'
say '';say '';say '  Ready to start AFE Configuration...'
say '';say ''

'pause'

/* start the program */

call SysCls
call syssetobjectdata '<WP_DESKTOP_AFE>','open=default'
'exit'
end

Else do
call SysCls
say '';say '  Not created! Return code='result
exit
end

