/*
==============================================================================================================
   Name:             AWE_API.H

   Description:      API message function header file for accessing AWEMAN.DLL.
                     This header file contains the possible messages to access the AWEMAN.DLL. 
                     The messages will be process by AWEMAN.DLL and respective operations will be 
                     performed.

   Purpose:          Header file meant for accessing APIs of AWEMAN.DLL.

   Author:           E.W. Khor
                     Copyright 1993,94 Creative Technology Ltd.

   Date:             version 1.0    -     27th Jan 1994

   Revision:         Version 1.1    -     29th March 1994
                        AWE_SEND_MIDI added.
                                    -     12th April 1994
                        New API for AWE_GET_UBANK_PARENT added.
                        New API for AWE_GET_DRUM_BANK added.
                                    -     15th April 1994
                        New API for AWE_ISHANDLE added.
                        
==============================================================================================================
*/

#ifndef  _AWE_API_H
#define     _AWE_API_H

/*
--------------------------------
      Function Category
--------------------------------
*/
#define     BASE_INIT                        100
#define     BASE_CONFIG                      200
#define     BASE_QUERY                       300
#define     BASE_MIDI                        400

/*
--------------------------------
      Function Messages
--------------------------------
*/
#define     AWE_OPEN                         (BASE_INIT+1)
#define     AWE_CLOSE                        (BASE_INIT+2)
/* BEGIN VERSION 1.1 ADD */
#define     AWE_ISHANDLE                     (BASE_INIT+3)
/* END VERSION 1.1 */

#define     AWE_REFRESH                      (BASE_CONFIG+1)
#define     AWE_SELECT_EFX                   (BASE_CONFIG+2)
#define     AWE_SELECT_SYN_BANK              (BASE_CONFIG+3)
#define     AWE_LOAD_USER_BANK               (BASE_CONFIG+4)
#define     AWE_CLEAR_USER_BANK              (BASE_CONFIG+5)
#define     AWE_LOAD_USER_INSTR              (BASE_CONFIG+6)
#define     AWE_CLEAR_USER_INSTR             (BASE_CONFIG+7)

#define     AWE_QUERY_EFXT_SUPPORT           (BASE_QUERY+1)
#define     AWE_QUERY_EFXV_SUPPORT           (BASE_QUERY+2)
#define     AWE_QUERY_SYN_SUPPORT            (BASE_QUERY+3)
#define     AWE_GET_EFX                      (BASE_QUERY+4)
#define     AWE_GET_SYN_BANK                 (BASE_QUERY+5)
#define     AWE_GET_USER_BANK                (BASE_QUERY+6)
#define     AWE_GET_USER_INSTR               (BASE_QUERY+7)
#define     AWE_QUERY_DRAM_SIZE              (BASE_QUERY+8)
#define     AWE_GET_VERSION                  (BASE_QUERY+9)
/* BEGIN VERSION 1.1 ADD */
#define     AWE_GET_UBANK_PARENT             (BASE_QUERY+10)
#define     AWE_GET_DRUM_BANK                (BASE_QUERY+11)
/* END VERSION 1.1 */

/* BEGIN VERSION 1.1 ADD */
#define     AWE_SEND_MIDI                    (BASE_MIDI+1)
/* END VERSION 1.1 */

#endif      /* _AWE_API_H */
