{
 * Describes user privilege/class information API
 *
 }

Const CLS_ID  =$8f7c9321;

  { File header structure (internal) }

type clshdr=Record
     ulclhid:dword;                                        { ID signature }
     usclfirst:Word;                             { Offset of first record }
     usn:Word;                     { Number of user class records present }
     ussize:Word;                      { Size of individual class records }
     usstr:Word;                                    { Size of all strings }
     end;

  { This structure describes the priv file
   * structure and is subject to change
   }

type clsrec=Record
     usLevel :Word;                              { Numeric security level }
     usKey   :Word;           { Keyletter for MECCA [?below] [?above] etc }

     zAbbrev :ZStr;                         { Abbreviation for this class }
     zDesc   :ZStr;                                     { Long class name }
     zAlias  :ZStr;                          { Alias for the abbreviation }

     usTimeDay,                         { Daily time allowance in minutes }
     usTimeCall,                         { Call time allowance in minutes }
     usCallsDay,                                  { Max calls/day -1=none }
     usMinBaud,                                { Minimum logon baud / 100 }
     usFileBaud,                            { Minimum download baud / 100 }
     usFileRatio,                            { File upload:download ratio }
     usFreeRatio:Word;     { Download allowance before ratio takes effect }
     ulFileLimit:DWord;         { Maximum download allowance in kilobytes }
     usUploadReward:Word;                               { % upload reward }

     zLoginFile:ZStr;       { Show this file (in misc directory) on login }

     ulAccFlags:dword;                       { Access related class flags }
     ulMailFlags:dword;                        { Mail related class flags }
     ulUsrFlags:dword;                         { User-defined class flags }

     usOldPriv:Word;      { 'old' user priv equivalent, for compatibility }
     End;


  { Mail-related class access flags }

Const CFLAGM_PVT      =$01000000;             { Show private messages }
      CFLAGM_EDITOR   =$02000000;            { External editor access }
      CFLAGM_LEDITOR  =$04000000;      { Local external editor access }
      CFLAGM_NETFREE  =$08000000;                 { Netmail is 'free' }
      CFLAGM_ATTRANY  =$10000000; { Allow 'sysop' attribute overrides }
      CFLAGM_RDONLYOK =$40000000; { Allow write priv in readonly area }
      CFLAGM_NOREALNM =$80000000;      { Don't add ^aREALNAME to msgs }

  { General purpose access flags }

      CFLAGA_ULBBSOK  =$00000001;        { Uploading .?bs files is ok }
      CFLAGA_FLIST    =$00000002; { Allow file dloads not in filelist }
      CFLAGA_FHIDDEN  =$00000004;       { See/download 'hidden' files }
      CFLAGA_UHIDDEN  =$00000008; { Allow 'not in userlist' user view }
      CFLAGA_HIDDEN   =$00000010;          { Always hide in user list }
      CFLAGA_HANGUP   =$00000020;                { Hangup immediately }
      CFLAGA_NOLIMIT  =$00000040;          { Don't check dload limits }
      CFLAGA_NOTIME   =$00000080;           { Don't check time limits }


 { The following determine the type of information
  * returned by ClassGetInfo()
  }

      CIT_NUMCLASSES    =-1;
      CIT_DAY_TIME      =0;
      CIT_CALL_TIME     =1;
      CIT_DL_LIMIT      =2;
      CIT_RATIO         =3;
      CIT_MIN_BAUD      =4;
      CIT_MIN_XFER_BAUD =5;
      CIT_MAX_CALLS     =6;
      CIT_FREE_RATIO    =7;
      CIT_UPLOAD_REWARD =8;
      CIT_ACCESSFLAGS   =9;
      CIT_MAILFLAGS     =10;
      CIT_USERFLAGS     =11;
      CIT_LEVEL         =12;
      CIT_KEY           =13;
      CIT_INDEX         =14;
      CIT_OLDPRIV       =15;

  { This structure is used in memory to
   * manage the API interface
   }

type PCLH=^CLH;
     CLH=Record
         usn    :Word;                        { Number of classes available }
         ussize :Word;                                        { Record size }
         pcInfo :CLSREC;               { Pointer to class information array }
         pHeap  :PChar;                     { Pointer to class strings heap }
         End;

  { Privilege comparison operators }

Type _privcmp=(privGE,   { >=   (0)}
               privLE,   { <=   (1)}
               privGT,   { >    (2)}
               privLT,   { <    (3)}
               privEQ,   { ==   (4)}
               privNE    { !=   (5)}
              );

{end}
