{# name=Maximus USER.BBS structure definition
}

Const MAX_ALEN     =64;     { Max length of usr.msg[] and usr.files[]  }


{ Masks for usr.bits1, below }

Const BITS_HOTKEYS     =$0001; { Hotkeys, independent of HOTFLASH level   }
      BITS_NOTAVAIL    =$0002; { If set, user is NOT normally available
                                 for chat.                                }
      BITS_FSR         =$0004; { Full-screen reading in msg areas         }
      BITS_NERD        =$0008; { Yelling makes no noise on sysop console  }
      BITS_NOULIST     =$0010; { Don't display name in userlist           }
      BITS_TABS        =$0020; { User can handle being sent raw tabs      }
      BITS_ENCRYPT     =$0040; { pwd is a MD5 digest, not plaintext       }
      BITS_RIP         =$0080; { Remote Imaging Prototocol support        }


{ Masks for usr.bits2, below }

      BITS2_BADLOGON   =$0001; { MAX: if user's last logon attempt was bad}
      BITS2_IBMCHARS   =$0002; { MAX: if user can receive high-bit chars  }
      BITS2_RSVD1      =$0004; { MAX: *obsolete* 1.02 avatar flag         }
      BITS2_BORED      =$0008; { Use the line-oriented editor             }
      BITS2_MORE       =$0010; { Wants the "MORE?" prompt                 }
      BITS2_RSVD2      =$0020; { OPUS: set=wants Ansi                     }
      BITS2_CONFIGURED =$0040; { OPUS: set=used Maximus before            }
      BITS2_CLS        =$0080; { OPUS: set=transmit ^L, clear=ignore ^L   }
      BITS2_BIT8       =$0100; { used to be 'usr.keys'                    }
      BITS2_BIT9       =$0200; { used to be 'usr.keys'                    }
      BITS2_BITA       =$0400; { used to be 'usr.keys'                    }
      BITS2_BITB       =$0800; { used to be 'usr.keys'                    }
      BITS2_BITC       =$1000; { used to be 'usr.keys'                    }
      BITS2_BITD       =$2000; { used to be 'usr.keys'                    }
      BITS2_BITE       =$4000; { used to be 'usr.keys'                    }
      BITS2_BITF       =$8000; { used to be 'usr.keys'                    }

      SEX_UNKNOWN       =$0000;
      SEX_MALE          =$0001;
      SEX_FEMALE        =$0002;

{ Masks for usr.delflag, below.  WARNING!  Only the first eight bits       *
  of this flag should be used for compatibility with df_save!              }

      UFLAG_DEL   =$01;
      UFLAG_PERM  =$02;

{ Masks for usr.xp_flag, below }

      XFLAG_EXPDATE    =$0001; { Use the xp_date to control access        }
      XFLAG_EXPMINS    =$0002; { Use the xp_mins number to control access }
      XFLAG_DEMOTE     =$0004; { Demote user to priv level in usr.xp_priv }
      XFLAG_AXE        =$0008; { Just hang up on user                     }

{ Constants for usr.video, below }

      GRAPH_TTY         =$00; { The current user's graphics setting...    }
      GRAPH_ANSI        =$01;
      GRAPH_AVATAR      =$02;
      GRAPH_RIP         =$03;

type usrndx=Record
     hash_name :dword;
     hash_alias:dword;
     End;

Type _usr=Record
      name:Array[0..35] of char;        { Caller's name                               0}
      city:Array[0..35] of Char;        { Caller's location                          36}

      alias:Array[0..20] of Char; { MAX: user's alias (handle)                 72}
      phone:Array[0..14] of Char; { MAX: user's phone number                   93}

      lastread_ptr:Word;    { MAX: a num which points to offset in      108}
                            { file -- Offset of lastread pointer will be   }
                            { lastread_ptr*sizeof(int).                    }

      timeremaining:Word;   { MAX: time left for current call (xtern pro110}

      pwd:Array[0..15] of Char; { Password                              112}
      times:Word;           { Number of previous calls to this system   128}
      help:Byte;            { Help level                                130}
      group:Word;           { Group number (not implemented)            131}
      video:Byte;           { user's video mode (see GRAPH_XXXX)        133}
      nulls:Byte;           { Number of Nulls (delays) after <cr>       134}

      bits:Byte;            { Bit flags for user (number 1)             135}

      dob_year:Word;        { Date of birth: year (1900-)               136}

      bits2:Word;           { Bit flags for user (number 2)             138}

      max2priv:Word;        { Max 2.x priv level (NOT USED)             140}
      dataphone:Array[0..18] of Char; { Data/business phone number      142}
      struct_len:Byte;      { len of struct, divided by 20. SEE ABOVE!  161}
      time:Word;            { Time on-line so far today                 162}

      delflag:Word;         { Used to hold baud rate for O)utside comman164}
                            { In USER.BBS, usr.flag uses the constants     }
                            { UFLAG_xxx, defined earlier in this file.     }

      msgs_posted:DWord;    { Total number of messages posted           166}
      msgs_read:DWord;      { Total number of messages read             170}

      width:Byte;           { Width of the caller's screen              174}
      len:Byte;             { Height of the caller's screen             175}
      credit:Word;          { Matrix credit, in cents                   176}
      debit:Word;           { Current matrix debit, in cents            178}

      xp_priv:Word;         { Priv to demote to, when time or minutes ru180}
                            { out.                                         }

      xp_date:stamp_combo;  { Bit-mapped date of when user expires      182}
                            { If zero, then no expiry date.                }

      xp_mins:dword;        { How many minutes the user has left before 186*
                             * expiring.                                    }

      xp_flag:byte;         { Flags for expiry.  See above XFLAG_XXX def190}
      sex:byte;             { Sex: SEX_MALE or SEX_FEMALE)              191}

      ludate:stamp_combo;   { Bit-mapped date of user's last call       192}

      xkeys:dword;          { User's keys (all 32 of 'em)               196}
      lang :byte;           { The user's current language #             200}
      def_proto:sbyte;      { Default file-transfer protocol            201}

      up:dword;             { K-bytes uploaded, all calls               202}
      down:dword;           { K-bytes downloaded, all calls             206}
      downtoday:sdword;     { K-bytes downloaded, today                 210}

      rsvd45:Array[1..18] of byte; { Reserved by Maximus for future use 214}

      call:Word;            { Number of previous calls today            232}

      compress:Byte;        { Default compression program to use        234}

      df_save:Byte;         { Used for storing real usr.delflag in      235*
                             * LASTUSxx.BBS while in a door.                }

      extra:Dword;                                                     {236}
      date_1stcall:SCOMBO;  { Date of first call to system              240}
      date_pwd_chg:SCOMBO;  { Date of last password change              244}

      nup:dword;            { Number of files uploaded                  248}
      ndown:dword;          { Number of files downloaded                252}
      ndowntoday:sdword;    { Number of files downloaded today          256}

      time_added:word;      { Time credited to the user for today       260}
      msg:Array[0..MAX_ALEN-1] of Char;   { Current message area        262}
      files:Array[0..MAX_ALEN-1] of Char; { Current file area           326}

      dob_day:Byte;         { Date of birth: day (1-31)                 390}
      dob_month:Byte;       { Date of birth: month (1-12)               391}
      point_credit:dword;   { Total points allocated                    392}
      point_debit:dword;    { Total points used                         396}
      date_newfile:SCOMBO;  { Date of last new-files check              400}
      priv:Word;            { Privilege level                           404}
      rsvd6:Array[1..54] of Byte; { Reserved for future use             406}
                                                                       {460}
      End;

{End}

