{*
 * Structure of Callers.Bbs
 * Maximus (optional) caller information & activity log
 *}

Const  CALL_LOGON      =$8000;                 {* Caller was logged on! *}
       CALL_CARRIER    =$0001;                   {* Caller lost carrier *}
       CALL_EJECTED    =$0002;   {* Caller was ejected by sysop or priv *}
       CALL_PAGED_AH   =$0004;              {* Caller paged after hours *}
       CALL_DLEXCEED   =$0008;        {* Caller attempted to exceed d/l *}
       CALL_EXPIRED    =$0010;         {* Caller's subscription expired *}
       CALL_TIMELIMIT  =$0020;            {* Caller exceeded time limit *}
       CALL_NERD       =$0040;                    {* Caller was nerd'ed *}
       CALL_BARRPWD    =$0080;            {* Barricade password failure *}

Type callinfo=Record
     Name     :Array[0..35] of Char; {* User's name/alias                 0*}
     City     :Array[0..35] of Char; {* User's city                      36*}
     login             :stamp_combo; {* Time logged on                   72*}
     logoff            :stamp_combo; {* Time logged off                  76*}
     task              :Word;        {* Which node                       80*}
     Flags             :Word;        {* Call flags                       82*}
     logon_priv        :Word;        {* Priv level on login              84*}
     logoff_priv       :Word;        {* Priv level on logoff             86*}
     logon_xkeys       :dword;       {* Keys on login                    88*}
     logoff_xkeys      :dword;       {* Keys on logoff                   92*}
     filesup           :Word;        {* Number of files uploaded         96*}
     filesdn           :Word;        {* Number of files dnloaded         98*}
     kbup              :Word;        {* kb uploaded                     100*}
     kbdn              :Word;        {* kb dnloaded                     102*}
     calls             :Word;        {* Number of previous calls + 1    104*}
     read              :Word;        {* Number of messages read         106*}
     posted            :Word;        {* Number of messages posted       108*}
     paged             :Word;        {* Number of times user paged      110*}
     added             :sword;       {* Time added during call          112*}
     reserved          :Array[0..13] of Byte;                        {* 114*}
     End;                                                            {* 128*}

{End}
