#include <stdio.h>
#include <dos.h>
#include <conio.h>

/*
al:     0 get rx status    returned in al: crt c is carrier detect,
                                           r is char received, t is
                                           transmit buffer empty

al:     1 get char         returned in al
al:     2 put char in ah
al:     3 set CD
al:     4 clear CD
*/

#define BUFSIZE 1024
struct {
        char buffer[BUFSIZE];
        int  bufptr_put;
        int  bufptr_take;
        int  chars_in_buffer;
        char cd;
       } status[2];



unsigned common(int half,unsigned ax)
{
int other,i=0,c;
other=half^1;
switch(ax&255){
case 0: /*return status  CD Rx Tx */
        if (status[half].cd) i |=4;
        if (status[half].chars_in_buffer) i |=2;
        if (!status[other].chars_in_buffer<BUFSIZE) i |=1;
        return i;
case 1: /* get char */
        if (!status[half].chars_in_buffer) return 0;
        status[half].chars_in_buffer--;
        c=status[half].buffer[status[half].bufptr_take++];
        if (status[half].bufptr_take>=BUFSIZE) status[half].bufptr_take=0;
        return c;

case 2: /* Put char */
        if (status[other].chars_in_buffer>= BUFSIZE) break;
        status[other].buffer[status[other].bufptr_put++]= ax>>8;
        if (status[other].bufptr_put>=BUFSIZE) status[other].bufptr_put=0;
        status[other].chars_in_buffer++;
        break;
case 3: /* set other cd */
        status[other].cd=1;
        break;
case 4: /* Clear other cd */
        status[other].cd=0;
        break;
default: cprintf("Bad operation(%d)\r\n",ax&255);
        }
return 0;
}

#pragma argsused
void interrupt part0(unsigned bp, unsigned di, unsigned si, unsigned ds,
                        unsigned es, unsigned dx, unsigned cx, unsigned bx,
                        unsigned ax, unsigned ip,unsigned cs, unsigned flags)
{
ax=common(0,ax);
}

#pragma argsused
void interrupt part1(unsigned bp, unsigned di, unsigned si, unsigned ds,
                        unsigned es, unsigned dx, unsigned cx, unsigned bx,
                        unsigned ax, unsigned ip,unsigned cs, unsigned flags)
{
ax=common(1,ax);
}



#pragma argsused
void main(int argc, char *argv[])
{
status[0].cd=0;
status[0].bufptr_put=0;
status[0].bufptr_take=0;
status[0].chars_in_buffer=0;
status[1].cd=0;
status[1].bufptr_put=0;
status[1].bufptr_take=0;
status[1].chars_in_buffer=0;;
setvect(0xD6,part0);
setvect(0xD7,part1);
keep(0,(_SS+(_SP/16)-_psp));
}
