// MoveLo/2 1.0.9

#define TEST_CRLF

#if defined(__OS2__)
#define VERSION "1.0.9k/OS2"
#elif defined(__NT__)
#define VERSION "1.0.9k/NT"
#elif defined(__WINDOWS_386__)
#define VERSION "1.0.9k/WIN32"
#else
#define VERSION "1.0.9k/DOS"
#endif

#include <stdlib.h>
#include <iostream.h>
#include <stdio.h>
#include <dos.h>
#include <direct.h>
#include <ctype.h>
#include <io.h>
#include <share.h>
#include <time.h>
#include <errno.h>
#include <stdarg.h>
#include <sys\stat.h>
#include <setjmp.h>
#include <afix431.h>

#if defined(__OS2__)
#define INCL_DOSFILEMGR
#include <os2.h>
#else
#include <fcntl.h>
#define	TRUE 1
#define	FALSE 0
typedef char BOOL;
#endif

//#if defined(__OS2__) || defined(__NT__)
#define FAR
#define _ffree(x) free(x)
#define _fmalloc(x) malloc(x)
//#else
//#define FAR far
//#endif

#define BoxesMaxLen _MAX_PATH
#define SaveTicMaxLen _MAX_PATH
#define ctlfileMaxLen _MAX_PATH2
#define OutboundMaxLen _MAX_PATH
#define QueueMaxLen _MAX_PATH
#define LogFNameMaxLen _MAX_PATH2
#define FlagsMaxLen _MAX_PATH
#define PacketsMaxLen _MAX_PATH
#define tempfileMaxLen _MAX_PATH2
#define flofileMaxLen _MAX_PATH2
#define targetMaxLen _MAX_PATH2
#define TagMaxLen 40

const char Title[] =
	"MoveLo2 "VERSION" - Move Bink outbound to t-mail fileboxes\n";

//-----------------------------------------------------------------------------
typedef unsigned short UWORD;
typedef struct
{	UWORD	zone;
	UWORD	net;
	UWORD	node;
	UWORD	point;
} Address;

//  p⪨ ⨪
// ⨬ p: 0, 2, 3
enum{ MoveAnyTics=0, DontMoveOtherTics=1, DontMovePTTics=2, DontMoveTics=3 };
unsigned char	bMoveTic = DontMoveTics;
unsigned char	bMailFirst = TRUE;	// p tobesent (᭠砫 宬)
unsigned char	bSetQueFlag;
char	Queue[QueueMaxLen];	// pp  passthrough 䠩
char	szLogFName[LogFNameMaxLen];
char	line[512];
char	newname[_MAX_PATH2];
char	target[targetMaxLen];
char	flofile[flofileMaxLen];
char	tempfile[tempfileMaxLen];
char	Flags[FlagsMaxLen];	// pp 䫠
char	Outbound[OutboundMaxLen];
char	Packets[PacketsMaxLen];	// pp Packets
char	Boxes[BoxesMaxLen];
char	ctlfile[ctlfileMaxLen];
char	SaveTic[SaveTicMaxLen];
static char LogTypes[] = "\xfe=?!+-*>\0";
static char LogPlus[80];	// p  ᮮ饭 '+'
BOOL	bLogOpened;
FILE	*fpLog;
static jmp_buf	JmpOnError;

enum{ ParameterTooLong=1, SinglePerCent, ErrMissParm, ErrInvParm, ErrMissAddress };


const unsigned long Crc32Table[256] = {
0x00000000,0x77073096,0xee0e612c,0x990951ba,0x076dc419,0x706af48f,0xe963a535,0x9e6495a3,
0x0edb8832,0x79dcb8a4,0xe0d5e91e,0x97d2d988,0x09b64c2b,0x7eb17cbd,0xe7b82d07,0x90bf1d91,
0x1db71064,0x6ab020f2,0xf3b97148,0x84be41de,0x1adad47d,0x6ddde4eb,0xf4d4b551,0x83d385c7,
0x136c9856,0x646ba8c0,0xfd62f97a,0x8a65c9ec,0x14015c4f,0x63066cd9,0xfa0f3d63,0x8d080df5,
0x3b6e20c8,0x4c69105e,0xd56041e4,0xa2677172,0x3c03e4d1,0x4b04d447,0xd20d85fd,0xa50ab56b,
0x35b5a8fa,0x42b2986c,0xdbbbc9d6,0xacbcf940,0x32d86ce3,0x45df5c75,0xdcd60dcf,0xabd13d59,
0x26d930ac,0x51de003a,0xc8d75180,0xbfd06116,0x21b4f4b5,0x56b3c423,0xcfba9599,0xb8bda50f,
0x2802b89e,0x5f058808,0xc60cd9b2,0xb10be924,0x2f6f7c87,0x58684c11,0xc1611dab,0xb6662d3d,
0x76dc4190,0x01db7106,0x98d220bc,0xefd5102a,0x71b18589,0x06b6b51f,0x9fbfe4a5,0xe8b8d433,
0x7807c9a2,0x0f00f934,0x9609a88e,0xe10e9818,0x7f6a0dbb,0x086d3d2d,0x91646c97,0xe6635c01,
0x6b6b51f4,0x1c6c6162,0x856530d8,0xf262004e,0x6c0695ed,0x1b01a57b,0x8208f4c1,0xf50fc457,
0x65b0d9c6,0x12b7e950,0x8bbeb8ea,0xfcb9887c,0x62dd1ddf,0x15da2d49,0x8cd37cf3,0xfbd44c65,
0x4db26158,0x3ab551ce,0xa3bc0074,0xd4bb30e2,0x4adfa541,0x3dd895d7,0xa4d1c46d,0xd3d6f4fb,
0x4369e96a,0x346ed9fc,0xad678846,0xda60b8d0,0x44042d73,0x33031de5,0xaa0a4c5f,0xdd0d7cc9,
0x5005713c,0x270241aa,0xbe0b1010,0xc90c2086,0x5768b525,0x206f85b3,0xb966d409,0xce61e49f,
0x5edef90e,0x29d9c998,0xb0d09822,0xc7d7a8b4,0x59b33d17,0x2eb40d81,0xb7bd5c3b,0xc0ba6cad,
0xedb88320,0x9abfb3b6,0x03b6e20c,0x74b1d29a,0xead54739,0x9dd277af,0x04db2615,0x73dc1683,
0xe3630b12,0x94643b84,0x0d6d6a3e,0x7a6a5aa8,0xe40ecf0b,0x9309ff9d,0x0a00ae27,0x7d079eb1,
0xf00f9344,0x8708a3d2,0x1e01f268,0x6906c2fe,0xf762575d,0x806567cb,0x196c3671,0x6e6b06e7,
0xfed41b76,0x89d32be0,0x10da7a5a,0x67dd4acc,0xf9b9df6f,0x8ebeeff9,0x17b7be43,0x60b08ed5,
0xd6d6a3e8,0xa1d1937e,0x38d8c2c4,0x4fdff252,0xd1bb67f1,0xa6bc5767,0x3fb506dd,0x48b2364b,
0xd80d2bda,0xaf0a1b4c,0x36034af6,0x41047a60,0xdf60efc3,0xa867df55,0x316e8eef,0x4669be79,
0xcb61b38c,0xbc66831a,0x256fd2a0,0x5268e236,0xcc0c7795,0xbb0b4703,0x220216b9,0x5505262f,
0xc5ba3bbe,0xb2bd0b28,0x2bb45a92,0x5cb36a04,0xc2d7ffa7,0xb5d0cf31,0x2cd99e8b,0x5bdeae1d,
0x9b64c2b0,0xec63f226,0x756aa39c,0x026d930a,0x9c0906a9,0xeb0e363f,0x72076785,0x05005713,
0x95bf4a82,0xe2b87a14,0x7bb12bae,0x0cb61b38,0x92d28e9b,0xe5d5be0d,0x7cdcefb7,0x0bdbdf21,
0x86d3d2d4,0xf1d4e242,0x68ddb3f8,0x1fda836e,0x81be16cd,0xf6b9265b,0x6fb077e1,0x18b74777,
0x88085ae6,0xff0f6a70,0x66063bca,0x11010b5c,0x8f659eff,0xf862ae69,0x616bffd3,0x166ccf45,
0xa00ae278,0xd70dd2ee,0x4e048354,0x3903b3c2,0xa7672661,0xd06016f7,0x4969474d,0x3e6e77db,
0xaed16a4a,0xd9d65adc,0x40df0b66,0x37d83bf0,0xa9bcae53,0xdebb9ec5,0x47b2cf7f,0x30b5ffe9,
0xbdbdf21c,0xcabac28a,0x53b39330,0x24b4a3a6,0xbad03605,0xcdd70693,0x54de5729,0x23d967bf,
0xb3667a2e,0xc4614ab8,0x5d681b02,0x2a6f2b94,0xb40bbe37,0xc30c8ea1,0x5a05df1b,0x2d02ef8d};

unsigned long UpdateCrc32(unsigned char Octet, unsigned long CRC)
{
 return Crc32Table[(unsigned char)(CRC^(unsigned long)(Octet))] ^ (CRC>>8);
}

#if defined(__OS2__)	|| defined(__NT__)
BOOL bLongNames = 0;
#endif

//-----------------------------------------------------------------------------
const char DuoTrTbl[] = "0123456789ABCDEFGHIJKLMNOPQRSTUV";

char* DuoTr( char* buf, unsigned val, short int len )
{
	do{
		buf[--len] = DuoTrTbl[ val&31 ];
		val>>=5;
	}while( len );
	return buf;
}

//-----------------------------------------------------------------------------
char* HexTr( char* buf, unsigned long val, short int len )
{
	do{
		buf[--len] = DuoTrTbl[ val&15 ];
		val>>=4;
	}while( len );
	return buf;
}

//-----------------------------------------------------------------------------
unsigned long bink2tmail( Address& Ads, const char* binkname,
	char* tmailname, char* address )
{
	char	buffer[33];
	char* ptr;
	Ads.point = 0;
	Ads.node = (UWORD)strtol( binkname+4, NULL, 16 );
	memcpy( buffer, binkname, 4 );
	buffer[4] = '\0';
	Ads.net = (UWORD)strtol( buffer, NULL, 16 );

#if defined(__OS2__)||defined(__NT__)
	if( bLongNames )
		sprintf( tmailname, "%u.%u.%u", Ads.zone, Ads.net, Ads.node );
	else{
#endif
		tmailname[1] = DuoTrTbl[ Ads.zone&31 ];
		*tmailname = DuoTrTbl[ (Ads.zone>>5)&31 ];
		DuoTr( tmailname+2, Ads.net, 3 );
		DuoTr( tmailname+5, Ads.node, 3 );
		tmailname[8] = '\0';
#if defined(__OS2__)||defined(__NT__)
	}
#endif
	sprintf( address, "%u:%u/%u", Ads.zone, Ads.net, Ads.node );
	unsigned long CRC = 0xffffffff;
	ptr = address;
	while ( *ptr )
		CRC = UpdateCrc32( *ptr++, CRC );
	return CRC;
}

//-----------------------------------------------------------------------------
/* 饭  LOG-䠩 */
void LogMsg( const char cType, const char *Msg )
{	if( !strchr( LogTypes, cType ) )	return;
	if( !*szLogFName )
	{	cout << Msg <<'\n';
		return;
	}
	if( !bLogOpened )
	{	if( fpLog=_fsopen( szLogFName, "at", SH_DENYWR ), !fpLog )
		{ cout << "Error on open log file "<< szLogFName <<'\n';
			cout << Msg <<'\n';
			szLogFName[0] = '\0';
			return;
		}
		bLogOpened = TRUE;
	}

	time_t DosTime;
	struct tm	CurTm;
	char	buf[20];
	DosTime = time( NULL );
	_localtime( &DosTime, &CurTm );

	strftime( buf, 256, "%T ", &CurTm );
	if( cType == '+' )
	{	sprintf( LogPlus, "%s%c %s\n", buf, cType, Msg );
		return;
	}
	if( *LogPlus && cType != 0xfe && cType != '=' )
	{	fputs( LogPlus, fpLog );
		*LogPlus = '\0';
	}
	fputs( buf, fpLog );
	putc( cType, fpLog );
	putc( ' ', fpLog );
	fputs( Msg, fpLog );
	putc( '\n', fpLog );
	fflush( fpLog );
}

//-----------------------------------------------------------------------------
void FlushLog( void )
{
	if( !*LogPlus ) return;

	if( !bLogOpened )
	{	if( fpLog=_fsopen( szLogFName, "at", SH_DENYWR ), !fpLog )
		{ cout << "Error on open log file "<< szLogFName <<'\n';
			cout << LogPlus;
			szLogFName[0] = '\0';
			return;
		}
		bLogOpened = TRUE;
	}
	fputs( LogPlus, fpLog );
	*LogPlus = '\0';
	fflush( fpLog );
}

//-----------------------------------------------------------------------------
void LogMsgP( const char cType, const char* Msg, ... )
{ va_list	arglist;
	char buf[1024];

	if( !strchr( LogTypes, cType ) )	return;

	va_start( arglist, Msg );
	vsprintf( buf, Msg, arglist );
	va_end( arglist );
	LogMsg( cType, buf );
}

//-----------------------------------------------------------------------------
char* skip_blanks( char* pstr )
{	if( !pstr )	return NULL;
	while( *pstr==' ' || *pstr=='\t' )	pstr++;
	char c = *pstr;
	if ( !c || c=='\n' || c==';' )	return NULL;
	return pstr;
}

//-----------------------------------------------------------------------------
char* toend( char* pstr )
{
	while( *pstr>' ' )	pstr++;
	return pstr;
}

//-----------------------------------------------------------------------------
typedef struct VAR
{	struct VAR*	next;
	unsigned char	len;
	unsigned char	type;
	char	name[2];
}	Var;
enum{ tSet, tDefault };
static Var*	Vars	= NULL;

//-----------------------------------------------------------------------------
char* GetVarValue( char* var )
{	Var*	pVar;
	for( pVar = Vars; pVar && strcmp(pVar->name,var); pVar = pVar->next );
	if( pVar )
	{	if ( pVar->type==tSet )	return pVar->name+pVar->len+1;
		char*	val;
		if( val = getenv( var ), val )	return val;
		return pVar->name+pVar->len+1;
	}
	return NULL;
}

#define ExpLineLen 1024
char ExpLine[ExpLineLen];

//-----------------------------------------------------------------------------
char* VarExpand( char* ptr )
{	char* val;
	short	len;
	char*	var;

	if( !ptr )	goto EmptyString;
	val = skip_blanks( ptr );
	if( !val )	goto EmptyString;
	if( var = (char*)strchr( val, ';' ), var )
		len = (short)(var-val);
	else
		len = (short)strlen(val);
	for (--len; len; len--)
		if( val[len]>' ' )	goto NonEmpty;
	goto EmptyString;
NonEmpty:
	val[++len] = '\0';
	if( var = (char*)strchr( val, '%' ), var )
		goto SubstVariable;
	return val;

SubstVariable:
	char	*to;
	char	*from;
	short	l;
	short rest;
	rest = ExpLineLen-1;
	to = ExpLine;
	from = val;
	do{
		if( l = (short)(var-from), l )
		{	if( (rest-=l)<0 )	goto TooLong;
			memcpy( to, from, l );
			to+=l;
		}
		if( !*(++var) )	longjmp( JmpOnError, SinglePerCent );
		if( from = strchr( var, '%' ), from )	*from++ = '\0';

		if( val = GetVarValue( var ), val )
		{ l = (short)strlen( val );
			{	if( (rest-=l)<0 )	goto TooLong;
				memcpy( to, val, l );
				to+=l;
			}
		}else
			LogMsgP( '!', "Environment variable %s has no value", var );
		if( !from )	goto NoTail;
	}while( var = strchr( from, '%' ), var );
	l = (short)strlen( from );
	if( rest<l )	goto TooLong;
	strcpy( to, from );
NoTail:
	return ExpLine;

TooLong:
	longjmp( JmpOnError, ParameterTooLong );

EmptyString:
	*ExpLine	= '\0';
	return NULL;
}

//-----------------------------------------------------------------------------
char* GetValue( char* ptr, char* szTo, const short Size )
{	char* val;
	short	len;

	if( !ptr )	goto EmptyString;
	val = skip_blanks( ptr );
	if( !val )	goto EmptyString;
	ptr = toend(val);
	len = (short)(ptr-val);
	if( len>=Size )	goto TooLong;
	memcpy( szTo, val, len );
	szTo[len] = '\0';
	return ptr;

TooLong:
	longjmp( JmpOnError, ParameterTooLong );

EmptyString:
	szTo[0]	= '\0';
	return NULL;
}

//-----------------------------------------------------------------------------
void SetVarValue( unsigned char type, char* ptr )
{	short l1, l2;
	char	Name[64];

	ptr = GetValue( ptr, (char*)Name, 64 );
	l1 = (short)strlen(Name);
	ptr = skip_blanks( ptr );
	if(!ptr)	ptr = "";
	l2 = (short)strlen(ptr);
	Var* pVar;
	pVar = (Var*)malloc( sizeof(Var)+l1+l2 );
	pVar->next = Vars;
	pVar->len = (unsigned char)l1;
	pVar->type = type;
	Vars = pVar;
	strcpy( pVar->name, Name );
	strcpy( pVar->name+l1+1, ptr );
}

//-----------------------------------------------------------------------------
int parse_address( char*& parm, Address& res /*, const int Mode=0*/ )
{ char* pstr;
	pstr = skip_blanks( parm );
	if( !pstr ) goto MissParm;

	res.zone = (UWORD)strtol( pstr, &pstr, 10 );
	if( *pstr != ':' )	goto	InvalidFormat;
	res.net = (UWORD)strtol( pstr+1, &pstr, 10 );
	if( *pstr != '/' )	goto	InvalidFormat;
	res.node = (UWORD)strtol( pstr+1, &pstr, 10 );
	if( *pstr == '.' )
		res.point = (UWORD)strtol( pstr+1, &pstr, 10 );
	else
		res.point = 0;
	if( *pstr > ' ' && *pstr != ';' )	goto	InvalidFormat;
	parm = pstr;
	return TRUE;

InvalidFormat:
	if( *pstr<=' ' )
		LogMsgP( '?',"Invalid format of address parameter '%s'", parm );
	else	LogMsgP( '?',"Invalid character '%c' in address '%s'", *pstr, parm );
	return FALSE;

MissParm:
	LogMsg( '?', "Missing <address> parameter" );
	return FALSE;
}


//-----------------------------------------------------------------------------
char* uniqname( char* buffer )
{	HexTr( buffer, rand(), 4 );
	HexTr( buffer+4, rand(), 4 );
	buffer[8] = '\0';
	return buffer;
}

#if !defined(__OS2__)
//=======  p cp 㭪樨 DosCopy   OS/2 p  =====================
#define DCPY_EXISTING	1

//-----------------------------------------------------------------------------
// rc = dosexterr
unsigned	DosCopy( const char* src, const char* dest, long Mode )
{
	int hIn, hOut;
	unsigned	rc;
	unsigned	count;
	char FAR*	pBuffer;
#define BUFFSIZE	16384

	if( rc = _dos_open( src, O_RDONLY|SH_DENYWR, &hIn ), rc ) 	return rc;
	rc = Mode & DCPY_EXISTING ?
		_dos_creat( dest, _A_NORMAL, &hOut ) :
		_dos_creatnew( dest, _A_NORMAL, &hOut );
	if( rc )	goto Abend;
	pBuffer = (char*)malloc( BUFFSIZE );
	while( rc = _dos_read( hIn, pBuffer, BUFFSIZE, &count ), !rc )
	{	if( count )
		{	rc = _dos_write( hOut, pBuffer, count, &count );
			if( rc || count<BUFFSIZE )	break;
		}else	break;
	}
	if( !rc )
	{	UWORD  date, time;
		_dos_getftime( hIn, &date, &time );
		_dos_setftime( hOut, date, time );
	}
	_dos_close( hOut );
	_ffree( pBuffer );
Abend:
	_dos_close( hIn );
	return rc;
}

//inline int DosForceDelete( const char* name )	{ return remove( name ); }
#define DosForceDelete( name ) remove( name )
//inline int DosMove(const char*oldname,const char*newname)
//{return rename( oldname, newname );}
#define DosMove( oldname, newname ) rename( oldname, newname )
//=============================================================================
#endif


//-----------------------------------------------------------------------------
// p 䠩
//  Mode:
#define KILLSENT	1
#define TRUNCSENT	2
#define TARGETDIR	4
//   ⢨ p ⢮ 䠩 祭:
#define ACTION		24
#define RENAMENEW	8
#define RENAMEOLD	16
#define OVERWRITE	24
//  return code:
// 0 - ᯥ譮 믮
// 1 - p    䠩
// 2 - 䠩  pᥭ, 㦭  ⠢  
// 3 - 䠩  pᥭ,   㦭 pp (pp,  p )
int	MoveFile( const char* source, const char* dest, unsigned Mode = 0 )
{
#if defined(__OS2__)
	APIRET rc;
#else
	int	rc;
#endif
	char	bRenamed = 0;
	char tmp[ _MAX_PATH2 ];
	char tmp2[ _MAX_PATH2 ];
	char* drive;
	char* drive2;
	char* dir;
	char* dir2;
	char*	fname;
	char*	ext;
	char*	cmd;
	unsigned long	DosCopyFlags = 0l;

	if( Mode&TARGETDIR )
	{	_makepath( tmp, NULL, dest, "fake", NULL );
		_splitpath2( tmp, tmp2, &drive2, &dir2, &fname, &ext );
		_splitpath2( source, tmp, &drive, &dir, &fname, &ext );
		_makepath( newname, drive2, dir2, fname, ext );
	}else{
		strcpy( newname, dest );
		_splitpath2( source, tmp, &drive, &dir, &fname, &ext );
		_splitpath2( dest, tmp2, &drive2, &dir2, &fname, &ext );
	}

	if( access( source, F_OK ) )
	{	LogMsgP( '?',"File %s not found", source );
		return 2;
	}

	struct stat filestat;
	if( !stat( newname, &filestat) )
	{ //  㦥 
		if( !filestat.st_size )
			remove( newname );
		else
			switch( Mode & ACTION )
			{
			case RENAMENEW:
				bRenamed = 1;
				{	char uid[9];
					do{
						_makepath( newname, drive2, dir2, uniqname(uid), ext );
					}while( !access( newname, F_OK ) );
					LogMsgP( '-',"New file %s%s is renamed to %s%s",
						fname, ext, uid, ext );
				}
				break;
			case RENAMEOLD:
            bRenamed = 1;
				{	char uid[9];
					char tmpname[_MAX_PATH2];
					do	_makepath( tmpname, drive2, dir2, uniqname(uid), ext );
					while( !access( tmpname, F_OK ) );
					if( DosMove( newname, tmpname ) )
					{	LogMsgP( '?',"File %s already exists. Rename is failed", newname );
						return 2;
					}
					LogMsgP( '-',"Old file %s%s is renamed to %s%s",
						fname, ext, uid, ext );
				}
				break;
			case OVERWRITE:
//				DosForceDelete( newname );
				DosCopyFlags = DCPY_EXISTING;
				break;
			default:
				LogMsgP( '?',"File %s already exists", newname );
				return 2;
			}
	}
	if( !(Mode&(KILLSENT|TRUNCSENT)) || strcmp( drive, drive2 ) )
	{	// p  p㣮 
		if( rc = DosCopy( source, newname, DosCopyFlags ), !rc)
		{	if( Mode & (KILLSENT|TRUNCSENT) )
				if( (Mode&(KILLSENT|TRUNCSENT)) == KILLSENT )
					DosForceDelete( source );
				else{	// p⨬ 䠩
					int hTmp;
					_dos_creat( source, _A_NORMAL, &hTmp );
					_dos_close( hTmp );
				}
			return bRenamed;
		}else
			cmd = "DosCopy";
	}else{  // p  p  ᪠
		if( DosCopyFlags & DCPY_EXISTING )
			if( DosForceDelete( newname ) )
			{	LogMsgP( '?', "Can't remove old file %s", newname );
				return 2;
			}
		if( rc = DosMove( source, newname ), !rc ) //   rc 㤥  NT ?
		{	if( Mode & (TRUNCSENT) )
			{	int hTmp;
				_dos_creat( source, _A_NORMAL, &hTmp );
				_dos_close( hTmp );
			}
			return bRenamed;
		}else
			cmd = "DosMove";
	}
//#if !defined(__OS2__)
//	{	struct _DOSERROR dos_err;
//		rc = dosexterr( &dos_err );
//	}
//#endif
	char* msg;
	switch( rc )
	{
	case 2:
		LogMsgP( '?',"File %s not found", source );
		return 3;
	case 3:
		LogMsgP( '?',"%s(\"%s\",\"%s\"): Path not found", cmd, source, newname );
		return 2;
	case 5:
		msg = "Access denied";
		break;
	case 15:
		LogMsgP( '?',"Can't copy %s to drive %s",
			source, drive2 );
		return 2;
	case 17:
		msg = "Not same device";
		break;
	case 26:
		msg = "Not DOS disk, unnkown media type";
		break;
	case 32:
		msg = "Sharing violation";
		break;
	case 36:
		msg = "Sharing buffer overflow";
		break;
	case 87:
		msg = "Invalid parameter";
		break;
#if defined(__OS2__)
	case 108:
		msg = "Drive locked";
		break;
	case 112:
		msg = "Disk %s full";
		break;
	case 123:
		msg = "Invalid file-system name";
		break;
	default:
		LogMsgP( '?',"Error code %u on %s(\"%s\",\"%s\")",
				(unsigned)rc, cmd, source, newname );
		return 2;
#else
	default:
		LogMsgP( '?',"DOS error code %u on %s(\"%s\",\"%s\")",
				(unsigned)rc, cmd, source, newname );
		return 2;
#endif
	}
	LogMsgP( '?',"%s(\"%s\",\"%s\"): %s", cmd, source, newname, msg );
	return 2;
}

unsigned tempflo_opened = 0;

typedef FILE* pFILE;

//-----------------------------------------------------------------------------
// ᯮ⥫쭠 㭪:  p  _movelo_.tmp -  䠩, p
//  p뢠 flo.
unsigned put_toflo( const char FAR* line, pFILE& tempflo, const char* pFloDir )
{
	if( !tempflo_opened )
	{ _makepath( tempfile, NULL, pFloDir, "_MOVELO_.TMP", NULL );
		tempflo = _fsopen( tempfile, "wt", SH_DENYRW );
		if ( !tempflo )
		{	LogMsg( '?',"Can't open/create temp .flo file" );
			return 2;
		}
		tempflo_opened = 1;
	}
	fputs( line, tempflo );
	return 0;
}


//-----------------------------------------------------------------------------
// pp  ᯨ᪠ ⥣ passthrough 䠩
// H㦭 ⮫쪮  p 2=DontMovePTTics
typedef struct PASSTHROUGHLIST
{	struct PASSTHROUGHLIST*	Next;
	byte	Len;
	char	Tag[TagMaxLen+1];
}	PassTT;

PassTT*	PTThead = NULL;	//  ᯨ᪠
// " PassThrough 䠩", 쪮  p 2,  ⠫ ᥣ = FALSE
BOOL bPTExists	= FALSE;

//-----------------------------------------------------------------------------
void AddPassThrough( char* Tag )
{	PassTT*	newptt;
	newptt = (PassTT*)malloc( sizeof(PassTT) );
	newptt->Next = PTThead;
	newptt->Len = (char)strlen(Tag);
	strcpy( newptt->Tag, Tag );
	bPTExists = TRUE;
//	LogMsgP( '>', "AddPassThrough %s", Tag );
}

//-----------------------------------------------------------------------------
void ClearPassThroughTable( void )
{	PassTT* ptt;
	while( PTThead )
	{	ptt = PTThead;
		PTThead = ptt->Next;
		_ffree( ptt );
	}
	bPTExists = FALSE;
}

//-----------------------------------------------------------------------------
typedef struct CACHE
{	struct CACHE FAR* Next;
//unsigned	Size;
	char	Line[1];
}	cache;
typedef cache FAR* pcache;
static pcache Head;
static pcache *Last;
static pcache HeadTFS;
static pcache *LastTFS;

// TOBESENT_NOTEMPTY => tobesent    
enum{ TOBESENT_EMPTY=0, TOBESENT_NOTEMPTY=1, TOBESENT_CHANGED=2, TOBESENT_FILES=4 };
unsigned tobesent_status = 0;

//-----------------------------------------------------------------------------
void	read_tobesent( const char* pBox )
{	FILE*	tobesent;
	Head = NULL;
	Last = &Head;
	HeadTFS = NULL;
	LastTFS = &HeadTFS;

	tobesent_status = TOBESENT_EMPTY;
	unsigned	atr;
	if( _dos_getfileattr( pBox, &atr ) )	return;	// 䠩  
	if( !(atr&_A_SUBDIR) )
	{	LogMsgP( '?',"Strange: file %s is not SUBDIR", pBox );
		return;
	}
	_makepath( target, NULL, pBox, "TOBESENT.$$$", NULL );
	if( access( target, 0 ) )	return;
	if ( tobesent = _fsopen( target, "rt", SH_DENYWR ) ,!tobesent )
	{	LogMsgP( '?',"Can't open file %s", target );
		return;
	}
	char	buf[512];
	short	len;
	while( fgets( buf, 512, tobesent ) )
	{	if( *buf=='~' )
		{	tobesent_status |= TOBESENT_CHANGED|TOBESENT_NOTEMPTY;
			continue;
		}
		len = (short)strlen( buf );
#ifdef TEST_CRLF
		if( buf[len-1]!='\n' )
		{	buf[len] = '\n';
			buf[++len]='\0';
		}
#endif
		pcache pNew = (pcache)_fmalloc( len + sizeof(cache) );
		strcpy( pNew->Line, buf );
		pNew->Next = NULL;
		if( bMailFirst && *buf=='#' )
		{	if( tobesent_status & TOBESENT_FILES )	tobesent_status |= TOBESENT_CHANGED;
			*LastTFS = pNew;
			LastTFS = &(pNew->Next);
		}else
		{	tobesent_status |= TOBESENT_FILES;
			*Last = pNew;
			Last = &(pNew->Next);
		}
		tobesent_status |= TOBESENT_NOTEMPTY;
	}
	fclose( tobesent );
}

//-----------------------------------------------------------------------------
//  p  tobesent.$$$
void put_tobesent( const char* line, unsigned char Mode = 0 )
{	pcache	pNew;
	short	len,l;

	FlushLog();
	l = len = (short)strlen( line );
	if( line[len-1]!='\n' )	len++;
	if( (Mode&KILLSENT) && *line!='^' )
	{	pNew = (pcache)_fmalloc( (++len) + sizeof(cache) );
		strcpy( pNew->Line+1, line );
		*(pNew->Line) = '^';
	}else
	{	pNew = (pcache)_fmalloc( len + sizeof(cache) );
		strcpy( pNew->Line, line );
	}
	if( line[l-1]!='\n' )
	{	(pNew->Line)[len-2] = '\n';
		(pNew->Line)[len-1] = '\0';
	}
	pNew->Next = NULL;
	if( bMailFirst && *line=='#' )
	{	*LastTFS = pNew;
		LastTFS = &(pNew->Next);
	}else
	{	*Last = pNew;
		Last = &(pNew->Next);
	}
	tobesent_status |= TOBESENT_CHANGED;
}


//-----------------------------------------------------------------------------
// 襬  䠩 tobesent  ⭮ ⤠  - ᯨ᪠
void	write_tobesent( const char* pBox )
{	_makepath( target, NULL, pBox, "TOBESENT.$$$", NULL );
	if( !(tobesent_status&TOBESENT_CHANGED) )	return;	// 祣  
	// tobesent 
	if( !Head && !HeadTFS )
	{	if( !(tobesent_status&TOBESENT_NOTEMPTY) )	remove( target );
		return;	//  ⮩, ⠪  ⠫
	}

	pcache	pLine;
	FILE*	tobesent = NULL;
	unsigned	atr;
	// pp塞 ⢮/ᮧ filebox
	if( _dos_getfileattr( pBox, &atr ) ? mkdir( pBox ) : !(atr&_A_SUBDIR) )
		LogMsgP( '?',"Can't create FileBox %s", pBox );
	else
		if( tobesent = _fsopen( target, "wt", SH_DENYWR ), !tobesent )
			LogMsgP( '?',"Can't open/create file %s", target );

	pLine = HeadTFS;
	while( pLine )
	{	HeadTFS = pLine->Next;
		if(tobesent)	fputs( pLine->Line, tobesent );
		_ffree( pLine );
		pLine = HeadTFS;
	}
	LastTFS = &HeadTFS;
	pLine = Head;
	while( pLine )
	{	Head = pLine->Next;
		if(tobesent)	fputs( pLine->Line, tobesent );
		_ffree( pLine );
		pLine = Head;
	}
	Last = &Head;
	fclose( tobesent );
	return;
}


//-----------------------------------------------------------------------------
// ᯮ⥫쭠 㭪: 饬  tobesent.$$$ 㪠 p
// , ᫨  諨, 뢠  㤠
// p頥  p 뫪   p
pcache* scan_tobesent( char* line, const char bTestOnly = FALSE )
{	char*	pline;
	pcache	pCache;
	pcache*	pplink;

	if( bMailFirst && *line=='#' )	pplink = &HeadTFS;
	else	pplink = &Head;

	//  p 3  ᠬ 㤥   㤠 ⨪
	pline = ( bMoveTic==DontMoveTics && *line=='^' ? line+1 : line );
	while( pCache = *pplink, pCache )
	{	if( !strcmp( pCache->Line, pline ) )	return pplink;
		pplink = &(pCache->Next);
	}
	if( !bTestOnly )
		put_tobesent( pline );	// 뢠 p  tobesent.$$$
	return NULL;
}

//-----------------------------------------------------------------------------
typedef struct ROUTE
{	struct ROUTE*	Next;
	char	OutName[8];	//  ?lo-䠩  㧫   pp  ⮢
	UWORD	point;
	UWORD	zone;
	char	Mode;		//  ppp, = 0
	unsigned char	DirLen;	//  p   pp 祭
	char	Dir[2];	// sz-p - pp 祭 
						// p⢥ ᫥ - 䫠  ⠢ /䠩
} route;

route*	RouteTbl;	//  ᯨ᪠ 㠫쭮 ⠢
route** pLastRoute;

//-----------------------------------------------------------------------------
// ᮪ passthrough 䠩
typedef struct PTFILE
{	struct PTFILE*	Next;
	char	File[1];
} PTFile;

PTFile*	ptfHead;
PTFile** ptfTail;

//-----------------------------------------------------------------------------
static PTFile**	ScanPTFList( const char* str )
{	PTFile** res = &ptfHead;
	PTFile*	ptf;
	while( ptf = *res, ptf )
	{	if( !strcmp( ptf->File, str ) )	return res;
		res = &ptf->Next;
	}
	return NULL;
}

//-----------------------------------------------------------------------------
typedef struct
{	UWORD	zone;
	UWORD	region;
	UWORD	net;
	UWORD	node;
	UWORD	point;
}	AdsMask;

typedef struct MAXARCSIZE
{	struct MAXARCSIZE*	Next;
	AdsMask	Mask;
	unsigned long	limit;
} MaxArcSize;

MaxArcSize*	pMASTbl;	//  ᯨ᪠ p祭  pp ⮢
MaxArcSize** ppLastMAS;

Address	Main = {0,0,0,0};	//  p
#define	ANY	0xffff

//-----------------------------------------------------------------------------
// p pp - ᪨ pᮢ
// p ᨭ⠪᪮ 訡 室  JmpOnError
char* GetAdsMask( char* parm, AdsMask& M )
{	char*	pstr;
	M.zone = ANY;
	M.region = ANY;
	M.net = ANY;
	M.node = ANY;
	M.point = ANY;
	if( !parm )	return parm;
//		longjmp( JmpOnError, ErrMissParm );
	pstr = skip_blanks( parm );
	if( !pstr )	return pstr;
//		longjmp( JmpOnError, ErrMissParm );
	UWORD	n;
	char	c;
	{	char*	pend;
		pend = toend(pstr);
		c = *pend;
		*pend = '\0';
	}
	switch(*pstr)
	{
	case '.':
		M.node = Main.node;
		M.region = (UWORD)(Main.net/100);
		M.net = Main.net;
		M.zone = Main.zone;
		goto	GetPoint;
	case '/':
		M.region = (UWORD)(Main.net/100);
		M.net = Main.net;
		M.zone = Main.zone;
		goto	GetNode;
	case ':':
		M.zone = Main.zone;
		goto	GetNet;
	case '*':
		n = -1;
		++pstr;
		break;
	default:
//		if( !memcmp(pstr,"ALL") )
		if( *pstr>'9'||*pstr<'0' )	goto InvalidParameter;
		n = (UWORD)strtol( pstr, &pstr, 10 );
	}
	switch(*pstr)
	{
	case '.':
		M.node = n;
//		M.region = (UWORD)(Main.net/100);
		M.net = Main.net;
		M.zone = Main.zone;
		goto	GetPoint;
	case '/':
//		M.region = (UWORD)(n/100);
		M.net = n;
		M.zone = Main.zone;
		goto	GetNode;
	case '*':
		M.region = n;
		M.zone = Main.zone;
		pstr++;
		goto	GetNode_;
	case ':':
		M.zone = n;
		goto	GetNet;
	case '\0':
		goto Done;
	default:
      goto InvalidParameter;
	}
GetNet:
	if( !*(++pstr) )	goto InvalidParameter;
	if( *pstr!='*' )
	{	n = (UWORD)strtol( pstr, &pstr, 10 );
		if( *pstr=='*' )
		{	M.region = n;
			pstr++;
		}else{
			M.region = (UWORD)(n/100);
			M.net = n;
		}
	}else	pstr++;
GetNode_:
	if( *pstr!='/' )	goto InvalidParameter;
GetNode:
	if( !*(++pstr) )	goto Done;
	if( *pstr=='*' )	pstr++;
	else	M.node = (UWORD)strtol( pstr, &pstr, 10 );
	if( !*pstr )	goto Point0;
	if( *pstr!='.' )	goto InvalidParameter;
GetPoint:
	if( !*(++pstr) )	goto Point0;
	if( *pstr!='*' )	M.point = (UWORD)strtol( pstr, &pstr, 10 );
	else pstr++;
	if( *pstr )	goto InvalidParameter;
Done:
	if( !M.zone )	longjmp( JmpOnError, ErrMissAddress );
//	LogMsgP( '>', "%s => %u:%u/%u.%u reg=%u",
//		parm, M.zone, M.net, M.node, M.point, M.region );
	*pstr = c;
	return pstr;

Point0:
	M.point = 0;
	goto Done;

InvalidParameter:
	longjmp( JmpOnError, ErrInvParm );
}

//-----------------------------------------------------------------------------
int CmpAdsWithMask( AdsMask& Mask, Address& Ads )
{
//	LogMsgP( '>', "Ads=%u:%u/%u.%u", Ads.zone, Ads.net, Ads.node, Ads.point );
	if( Mask.zone != ANY && Mask.zone != Ads.zone )	return FALSE;
	if( Mask.net == ANY )
	{	UWORD	region;
		region = (UWORD)(Ads.net<100 ? Ads.net : (Ads.net<1000 ? Ads.net/10 : Ads.net/100));
		if( Mask.region != ANY && Mask.region != region )	return FALSE;
	}else
		if( Mask.net != Ads.net )	return FALSE;
	if( Mask.node != ANY && Mask.node != Ads.node )	return FALSE;
	if( Mask.point!= ANY && Mask.point!= Ads.zone )	return FALSE;
	return	TRUE;
}

//-----------------------------------------------------------------------------
// pFloDir -  pp .?lo 䠩
// pFloName -    pp .?lo 䠩
// pBox -  pp - 䠩
// pTicDir -  pp  p ⨪
// outname -  ?lo-䠩  㧫   pp  ⮢
int move_lo_to_filebox( const char* pFloDir, const char* pFloName,
	const char* pBox, const char* pTicDir,
	unsigned long CRCnode, const char* address,
	Address& Ads, const char* outname, const char* quename )
{
	FILE	*tempflo, *file;
	int	hFlgBusy;
	struct stat filestat;
	int rc = 0;
	short len;
	char	c;
	char	flgname[9];
	char	BusyFlag[_MAX_PATH2];
	char PTFName[_MAX_PATH2];
	struct _find_t	file_t;
	BOOL	bPTFExists;

	bSetQueFlag = FALSE;

	if( *Flags )
	{	unsigned long CRC = CRCnode;

		if( Ads.point )
		{	*BusyFlag = '.';
			itoa( Ads.point, BusyFlag+1, 10 );
			char* ptr = BusyFlag;
			while ( *ptr )
				CRC = UpdateCrc32( *ptr++, CRC );
		}
		HexTr( flgname, CRC, 8 );
		flgname[8] = '\0';
		_makepath( BusyFlag, NULL, Flags, flgname, "`??" );
		if( !_dos_findfirst( BusyFlag, _A_NORMAL, &file_t ) )	goto Fnd_NodeIsBusy;
#if defined(__OS2__) || defined(__NT__)
		_dos_findclose( &file_t );
#endif
	}
// pp塞/ᮧ bink style busy 䫠
	memcpy( flgname, pFloName, 8 );
	flgname[8] = '\0';
	_makepath( BusyFlag, NULL, pFloDir, flgname, "BSY" );
	unsigned err;
	err = _dos_creatnew( BusyFlag, _A_NORMAL, &hFlgBusy );
//LogMsgP( '?',"errno = %i, DOS error = %xh", errno, err );
	_dos_close( hFlgBusy );
	switch( err )
	{
	case 0:
		break;
	case 0x05:
	case 0x50:
#if defined(__OS2__)
	case 110:
#endif
		goto NodeIsBusy;
	case 0x04:
		LogMsg( '?',"No handles available." );
		return 9;
	case 0x03:
		LogMsgP( '?',"Directory %s does not exist", pFloDir );
		return 9;
	default:
		LogMsgP( '?',"Undetermined error (DOS error = %i) on create flag %s",
			err, BusyFlag );
		return 9;
	}

	tempflo_opened = 0;
	_makepath( flofile, NULL, pFloDir, pFloName, NULL );

	route* rt;
	rt = RouteTbl;
	while ( rt )
	{ if( !memcmp( rt->OutName, outname, 8 )
							&& rt->point == Ads.point && rt->zone == Ads.zone )
			goto Transfer;
		rt = rt->Next;
	}

	LogMsgP( '+',"Processing outbound for %s.%i", address, Ads.point );

	ptfHead = NULL;
	ptfTail = &ptfHead;

	// ⠥ ???????.ptf 䠩.
	len = (short)strlen(flofile);
	memcpy( PTFName, flofile, len-3 );
	strcpy( PTFName+(len-3), "PTF" );
	if( bPTFExists = !access( PTFName, 0 ), bPTFExists )
	{	PTFile* ptf;
		if( file = _fsopen( PTFName, "rt", SH_DENYWR ), !file )	goto ErrCantOpen;
		while( fgets( line, 512, file ) )
		{	ptf = (PTFile*)malloc( strlen(line)+sizeof(PTFile) );
			strcpy( ptf->File, line );
			ptf->Next = NULL;
			*ptfTail = ptf;
			ptfTail = &ptf->Next;
		}
		fclose( file );
	}
	// ⠥ tobesent.$$$
	read_tobesent( pBox );

	// ⠥  p뢠 flo-䠩
	if( file = _fsopen( flofile, "rt", SH_DENYWR ), !file )	goto ErrCantOpenFLO;
	while( fgets( line, 512, file ) )
	{	len = (short)strlen( line );
		c = line[--len];
		line[len] = '\0';
//LogMsgP( '>', "line='%s'", line );
		switch( line[0] )
		{
		case '^':
			if( line[len-13] == '\\' && line[len-4]=='.'  && line[len-1]=='C'
				&& ( line[len-3]=='Z' || ( line[len-3]=='T' && line[len-2]=='I' ) ) )
			{	// p tic  z?c
				if( bMoveTic==DontMoveTics )	goto WriteToPTF;
				if( bPTExists && line[len-3]=='T' )
				{	FILE	*tic;
					char	tag[64];
					//  passthru ⢨ ⨪ - p쭮 : 㤠 p (???)
					if( access( line+1, 0 ) )	break;
					if( tic = _fsopen( line+1, "rt", SH_DENYWR ), !tic )
					{	LogMsgP( '?',"Can't open file %s", line+1 );
						goto PutToFloAndContinue;
					}
					char*	ptr;
					PassTT*	ptt;
					ptr=fgets( tag, 64, tic );	// ⠥ ⥣   ⨪
					fclose(tic);
					if( ptr )
					{	tag[strlen(tag)-1] = '\0';
						if( memcmp( tag, "Area ", 5 ) || ( ptr = skip_blanks(tag+5), !ptr ) )
						{	LogMsgP( '?', "Invalid tic file format %s", line+1 );
							goto PutToFloAndContinue;
						}
						ptt = PTThead;														
						while( ptt && strcmp( ptr, ptt->Tag ) )	ptt = ptt->Next;
						if(ptt)	//  tic ⭮  passthru area,  p  
						{	line[len] = c;
							scan_tobesent( line );	// 뢠  tobesent
							goto PutToFloAndContinue1;	// 襬 p⭮  flo-䠩
						}
					}
				}
				// pᨬ ⨪/  SaveTic pp
				if( rc = MoveFile( line+1, pTicDir, KILLSENT|TARGETDIR|RENAMENEW ), rc )
				{	if ( rc>1 )
					{	if( rc==2 )	// 䠩  ᪮p, 㦭 ⠢   ?lo-䠩
							goto PutToFloAndContinue;
						break;
					}
				}
				put_tobesent( newname, KILLSENT );
				break;
			}
			if( access( line+1, 0 ) )	goto FileNotFound;
			put_tobesent( line );
		case '~':
			break;
		case '#':
			if( stat(line+1,&filestat) )
				continue;	// 䠩  ;  ,  p쭮
			line[len] = c;
			{	MaxArcSize* pMAS = pMASTbl;
//				LogMsgP( '>', "#Ads=%u:%u/%u.%u", Ads.zone, Ads.net, Ads.node, Ads.point );
				while( pMAS && !CmpAdsWithMask( pMAS->Mask, Ads ) )	pMAS = pMAS->Next;
//				if( pMAS )	LogMsgP( '>', "limit=%u", pMAS->limit );
//				else	LogMsg( '>', "Not found in MAS table" );
				if( !pMAS || filestat.st_size < pMAS->limit )
					put_toflo( line, tempflo, pFloDir );	// 襬 p   .flo
			}
			if( !filestat.st_size )	continue;	// 䠩 㫥 
			scan_tobesent( line );
			break;
		default:
WriteToPTF:
			{	PTFile**	pptf;
				PTFile*	ptf;
				char*	pline;
				pline = ( *line=='^' ? line+1 : line );
				if( access( pline, 0 ) )	//     ?
				{	//   
					line[len] = c;
					if( pptf=ScanPTFList( line ), pptf ) // 饬  PTF
					{	// 䠩 㦥 pᨫ  tobesent,
						// ⢨ 䠩 - p쭮 : AllFix 㤠 pp祭 䠩
						line[len] = '\0';
						LogMsgP( '!', "File %s not found", pline );
						line[len] = c;
						// 塞  䠩   tobesent
						pcache* pp;
						if( pp = scan_tobesent( line, TRUE ), pp )
						{	pcache pc;
							pc = *pp;
							*pp = pc->Next;
							free( pc );
							if( !*pp )	Last = pp;
						}
						// 㤠塞  ᯨ᪠ PTF
						ptf = *pptf;
						*pptf = ptf->Next;
						free( ptf );
						if( !*pptf )	ptfTail = pptf;
						continue;
					}else	goto FileNotFound;
				}
				line[len] = c;
				if( pptf=ScanPTFList( line ), pptf )
				{	//  㦥 뢠  tobesent, pp,   p   㦥 ?
					if( scan_tobesent( line, TRUE ) )
						// 䠩   ⠬ => ⠢塞 䠩  flo-䠩
						goto PutToFloAndContinue1;
					// 䠩 p, 㤠塞  ᯨ᪠ PTF
					ptf = *pptf;
					// ᫨ 䠩 K/S,  㤠塞  ᠬ
					if( *(ptf->File)=='^' )
					{	//     : p p 맮 AllFix ᠬ  p孥
						line[len] = '\0';
						remove( pline );
//						LogMsgP( '>', "Remove file '%s'", pline );
					}
					*pptf = ptf->Next;
					free( ptf );
					if( !*pptf )	ptfTail = pptf;
//LogMsg( '>', "Delete from PTF" );
					continue;
				}
				//    ᯨ᪥ PTF =>   䠩
				// 襬  ᯨ᮪ ptf
//LogMsg( '>', "Add to PTF" );
				ptf = (PTFile*)malloc( len+1+sizeof(PTFile) );
				strcpy( ptf->File, line );
				ptf->Next = NULL;
				*ptfTail = ptf;
				ptfTail = &ptf->Next;
				// 襬  flo  tobesent
				put_toflo( line, tempflo, pFloDir );
				put_tobesent( pline );
			}
		}
		continue;
FileNotFound:
		line[len] = '\0';
		LogMsgP( '?', "File %s not found", *line=='^' ? line+1 : line );
PutToFloAndContinue:
		line[len] = c;
PutToFloAndContinue1:
		put_toflo( line, tempflo, pFloDir );
	}
	rc = 0;
	fclose( file );
	write_tobesent( pBox );	// 塞 䠩 tobesent.$$$
	remove( flofile );	// 㤠塞 c室 ?lo 䠩
	if( tempflo_opened )
	{	fclose( tempflo );
		rename( tempfile, flofile );
		tempflo_opened = 0;
	}
	remove( BusyFlag );
	
	if( ptfHead )
	{	// 襬  ptf-䠩
		if( file = _fsopen( PTFName, "wt", SH_DENYRW ), !file )
			LogMsgP( '?', "Unable to create/truncate file %s", PTFName );
		{	PTFile* ptf = ptfHead;
			while( ptf )
			{	if( file )	fputs( ptf->File, file );
				ptfHead = ptf->Next;
				free( ptf );
				ptf = ptfHead;
			}
			ptfTail = &ptfHead;
			if( file )	fclose(file);
		}
	}else
		if( bPTFExists )	remove( PTFName );

	// ⠭ QUE 䫠
	if( bSetQueFlag && *Packets )
	{	if( Ads.point )
		{ char szTmp[9];
			char pDir[_MAX_PATH];
			unsigned	atr;
			strcpy( szTmp, "000" );
			memcpy( szTmp+1, quename, 2 );
			_makepath( pDir, NULL, Packets, "POINTS", szTmp );
			if( _dos_getfileattr( pDir, &atr ) ? mkdir( pDir ) : !(atr&_A_SUBDIR) )
			{	LogMsgP( '?',"Can't create directory %s", pDir );
				return 1;
			}
			memcpy( szTmp, quename+2, 6 );
			szTmp[7] = DuoTrTbl[ Ads.point&31 ];
			szTmp[6] = DuoTrTbl[ (Ads.point>>5)&31 ];
			szTmp[8] = '\0';
			_makepath( BusyFlag, NULL, pDir, szTmp, "QUE" );
		}else
			_makepath( BusyFlag, NULL, Packets, quename, "QUE" );
		if( _dos_creat( BusyFlag, _A_NORMAL, &hFlgBusy ) )
			LogMsgP( '?', "Can't create que-flag %s", BusyFlag );
		else	_dos_close( hFlgBusy );
	}
	return rc;

Fnd_NodeIsBusy:
#if defined(__OS2__) || defined(__NT__)
	_dos_findclose( &file_t );
#endif
NodeIsBusy:
	LogMsgP( '!',"Busy flag for %s.%i is detected. Skipping...", address, Ads.point );
	return 10;

ErrCantOpenFLO:
	{	PTFile* ptf = ptfHead;	// ⨬ ᯨ᮪ ptf
		while( ptf )
		{ ptfHead = ptf->Next;
			free( ptf );
			ptf = ptfHead;
		}
		ptfTail = &ptfHead;
	}
ErrCantOpen:
	_dos_close( hFlgBusy );
	remove( BusyFlag );
	LogMsgP('?',"File %s could not be opened", flofile );
	return 1;

// 㠫쭠 ⠢
Transfer:
	BOOL	bMoved = FALSE;
	LogMsgP( '+',"Moving outbound for %s.%i to %s", address,(int)Ads.point, rt->Dir );
	if( file = _fsopen( flofile, "rt", SH_DENYWR ), !file )	goto ErrCantOpen;
	while( fgets( line, 512, file ) )	// ⠥ ?lo-䠩
	{	len = (short)strlen( line );
		line[len-1] = '\0';
		switch( line[0] )
		{
		case '^':
			rc = MoveFile( line+1, rt->Dir, KILLSENT|TARGETDIR|rt->Mode );
			break;
		case '~':
			continue;
		case '#':
			if( stat(line+1,&filestat) )
				continue;	// 䠩  ,  ,  p쭮
			if( !filestat.st_size )
				continue;	// 䠩 㫥 
			rc = MoveFile( line+1, rt->Dir, TRUNCSENT|RENAMENEW|TARGETDIR );
			break;
		default:
			rc = MoveFile( line, rt->Dir, TARGETDIR|rt->Mode );
		}
		if ( rc<2 )
			bMoved |= TRUE;
		else
			if( rc==2 )
			{	// 䠩  ᪮p, 㦭 ⠢   ?lo-䠩
				line[len-1] = '\n';
				put_toflo( line, tempflo, pFloDir );	// 襬 p   .flo
			}
	}
	if( bMoved && *(rt->Dir+rt->DirLen+1) )
	{	int htmp;	// ⠭ 䫠,  - ⠢
		_dos_creat( (rt->Dir+rt->DirLen+1), _A_NORMAL, &htmp );
		_dos_close( htmp );
	}

	fclose( file );
	remove( flofile );	// 㤠塞 c室 ?lo 䠩
	if( tempflo_opened )
	{	fclose( tempflo );
		rename( tempfile, flofile );
		tempflo_opened = 0;
	}
	remove( BusyFlag );
	return 0;

}


//-----------------------------------------------------------------------------
int move_outbound_to_filebox( const UWORD zone, const char* pOutBound,
	const char* pBoxes, const char* pSaveTic )
{
	unsigned long	CRCnode;
	struct _find_t	file, dir;
	char	Mask[_MAX_PATH2];
	char	MaskP[_MAX_PATH2];
	char	PntOut[_MAX_PATH2];
	char	address[32];
	char	Box[_MAX_PATH2];
	char	boxname[64];
	Address	Ads;

	Ads.zone = zone;
	LogMsgP( '=',"Scan Outbound directory %s", pOutBound );
	_makepath( Mask, NULL, pOutBound, "????????.?LO", NULL );
	if( !_dos_findfirst( Mask, _A_NORMAL, &file ) )
		do{
			CRCnode = bink2tmail( Ads, file.name, boxname, address );
#if defined(__OS2__)||defined(__NT__)
			if( bLongNames  )
			{	strcat( boxname, ".0" );
				_makepath( Box, NULL, pBoxes, boxname,
					file.name[9]=='H' ? ".H" : NULL );
			}else
#endif
				_makepath( Box, NULL, pBoxes, boxname,
					file.name[9]=='H' ? "00H" :"00" );
			move_lo_to_filebox( pOutBound, file.name, Box, pSaveTic,
				CRCnode, address, Ads, file.name, boxname );
		}while( !_dos_findnext( &file ) );
#if defined(__OS2__) || defined(__NT__)
	_dos_findclose( &file );
#endif

	char	ext[35];

	_makepath( MaskP, NULL, pOutBound, "????????.PNT", NULL );
	if( !_dos_findfirst( MaskP, _A_SUBDIR, &dir ) )
	{	do{
			_makepath( PntOut, NULL, pOutBound, dir.name, NULL );
			CRCnode = bink2tmail( Ads, dir.name, boxname, address );
			_makepath( Mask, NULL, PntOut, "????????.?LO", NULL );
			if( !_dos_findfirst( Mask, _A_NORMAL, &file ) )
			{
				do{
					Ads.point = (UWORD)strtol( file.name, NULL, 16 );
#if defined(__OS2__)||defined(__NT__)
					if( bLongNames )
					{	itoa( Ads.point, ext, 10 );
						if( file.name[9]=='H' )	strcat( ext, ".H" );
						_makepath( Box, NULL, pBoxes, boxname, ext );
					}else{
#endif
						DuoTr( ext, Ads.point, 2 );
						if( file.name[9]=='H' )
						{ ext[2] = 'H'; ext[3] = '\0';
						}else
							ext[2] = '\0';
						_makepath( Box, NULL, pBoxes, boxname, ext );
#if defined(__OS2__)||defined(__NT__)
					}
#endif
					move_lo_to_filebox( PntOut, file.name, Box, pSaveTic,
						CRCnode, address, Ads, dir.name, boxname );
				}while( !_dos_findnext( &file ) );
#if defined(__OS2__) || defined(__NT__)
				_dos_findclose( &file );
#endif
			}
		}while( !_dos_findnext( &dir ) );
#if defined(__OS2__) || defined(__NT__)
		_dos_findclose( &dir );
#endif
	}
	return 0;
}


//-----------------------------------------------------------------------------
void Remove_Route( const UWORD zone, const char* outname, const UWORD point )
{	route* rt;
	route** prt;

	prt = &RouteTbl;
	rt = RouteTbl;
	while ( rt )
	{	if( !memcmp( rt->OutName, outname, 8 )
							&& rt->point == point && rt->zone == zone )
			goto Found;
		prt = &(rt->Next);
		rt = rt->Next;
	}
	return;

Found:
	*prt = rt->Next;	// 㤠塞  ᯨ᪠
	if( !rt->Next )	pLastRoute = prt;
	_ffree( rt );
	return;
}

//-----------------------------------------------------------------------------
void Clear_Route_Table( void )
{	route* rt;
	while( RouteTbl )
	{	rt = RouteTbl;
		RouteTbl = rt->Next;
		_ffree( rt );
	}
	pLastRoute = &RouteTbl;
}

//-----------------------------------------------------------------------------
char*	MakeOutbound( char* NewPath, unsigned Zone, const char* Domain )
{	char* Drive;
	char* Dir;
	char*	Fname;
	char*	Ext;
	char	NewFname[13];
	char	Temp[_MAX_PATH2];
	short l;
	l = (short)strlen(Outbound);
	if( Outbound[l-1] == '\\' ) Outbound[l-1] = '\0';
	_splitpath2( Outbound, Temp, &Drive, &Dir, &Fname, &Ext );
	memcpy( NewFname, *Domain ? Domain : Fname , 8 );
	NewFname[8] = '.';
	HexTr( NewFname+9, Zone, 3 );
	NewFname[12] = '\0';
	strupr(NewFname);
	_makepath( NewPath, Drive, Dir, NewFname, NULL );
	return NewPath;
}

//-----------------------------------------------------------------------------
char	ForAllFix( char*	path )
{	ALLFIXcfg	*cfg;
	FileMgrRec	*fa;
	FILE	*filecfg;
	short	len;
	char	szFile[_MAX_PATH2];

	cfg = (ALLFIXcfg*)malloc( sizeof(ALLFIXcfg) );
	if( bMoveTic == DontMovePTTics )
	{	_makepath( szFile, NULL, path, "FAREAS.FIX", NULL );
		if( filecfg = _fsopen( szFile, "rb", SH_DENYNO ), !filecfg )	goto	ErrOnOpen;
		fa = (FileMgrRec*)(void*)cfg;
		while( fread( fa, sizeof(FileMgrRec), 1, filecfg ) )
		{	if( fa->Attrib & _passthru )
			{	fa->Name[*(fa->Name)+1] = '\0';
				AddPassThrough( (char*)fa->Name + 1 );
			}
		}
		fclose( filecfg );
	}
   _makepath( szFile, NULL, path, "SETUP.FIX", NULL );
	if( filecfg = _fsopen( szFile, "rb", SH_DENYNO ), !filecfg )	goto	ErrOnOpen;
	if( !fread( cfg, sizeof(ALLFIXcfg), 1, filecfg ) )	goto ErrOnOpen2;
	fclose( filecfg );
	len = *(cfg->OutBound);
	memcpy( Outbound, cfg->OutBound+1, len );
	Outbound[len] = '\0';
	len = *(cfg->Queue);
	memcpy( Queue, cfg->Queue+1, len );
	if( Queue[len-1] != '\\' )
		Queue[len++] = '\\';
	Queue[len] = '\0';
	{	UWORD Zone, MainZone;
		char	ZoneOutbound[_MAX_PATH];
		MainZone = cfg->Aka[0].Zone;
		move_outbound_to_filebox( MainZone, Outbound, Boxes, SaveTic );
		for( short i=0; i<20; i++ )
		{	if( Zone = cfg->Domains[i].Zone, !Zone || Zone==MainZone )	continue;
		   cfg->Domains[i].Name[*(cfg->Domains[i].Name)+1] = '\0';
			MakeOutbound( ZoneOutbound, Zone, cfg->Domains[i].Name + 1 );			
			move_outbound_to_filebox( Zone, ZoneOutbound, Boxes, SaveTic );
		}
	}
	free( cfg );

	if( bMoveTic == DontMovePTTics )		ClearPassThroughTable();
	return 0;

ErrOnOpen2:
	free( cfg );
	fclose( filecfg );
ErrOnOpen:
	LogMsgP('?',"File %s could not be opened", szFile );
	return 1;
}

//-----------------------------------------------------------------------------
unsigned	TestAndCreateDir( const char* Dir )
{	unsigned	atr,rc;
	
	if( rc = _dos_getfileattr( Dir, &atr ), rc )
	{	// LogMsgP( '>', "Function _dos_getfileattr return error code %u", rc );
		switch( rc )
		{
		case 0x15:
		case 0x0f:
			LogMsgP( '?', "Can't create directory %s - invalid drive", Dir );
			break;
		case 2:
			if( rc = mkdir( Dir ), rc )	goto CantCreate;
			break;
		case 3:
			LogMsgP( '?', "Can' create directory %s - invalid path", Dir );
			break;
		default:
			if( rc = mkdir( Dir ), !rc )	return	0;
		CantCreate:
			LogMsgP( '?', "Can't create directory %s, error code = %u", Dir, rc );
		}
		return	rc;
	}
	if( atr&_A_SUBDIR )	return 0;
	LogMsgP( '?', "Can't create directory, file %s already exists", Dir );
	return	rc;
}

//-----------------------------------------------------------------------------
char szExplain[] = "\n"
"Options:\n"
" -c<file>  - path, name and extention of control file\n"
" -l<file>  - path, name and extention of log file\n"
" -L<chars> - types of messages to be put to log file\n"
" -q        - quiet mode: suppress message \"Control file ...\"\n"
"\n(c) 1995 Alex Konshin, 2:5030/217@fidonet, SunRise St.Petersburg"
;

//-----------------------------------------------------------------------------
typedef struct {
   byte	len;
   byte	code;
   char* str;
}  KeyWord;

enum{ xLOG, xSET, xTEST, xPASSTHROUGH, xBOXES, xFLAGS, xQUEUE, xALLFIX, xSAVETIC, xPACKETS,
	xDELIVER, xDEFAULT, xADDRESS, xOUTBOUND, xMOVETICS, xMAILFIRST, xMAXARCSIZE, xLONGNAMES
};

static KeyWord Keys[] =
{{ 3, xLOG, "LOG" },
 { 4, xSET, "SET" },
 { 4, xTEST, "TEST" },
 { 4, xPASSTHROUGH, "PASS" },
 { 5, xBOXES, "BOXES" },
 { 5, xFLAGS, "FLAGS" },
 { 5, xQUEUE, "QUEUE" },
 { 6, xALLFIX, "ALLFIX" },
 { 7, xSAVETIC, "SAVETIC" },
 { 7, xPACKETS, "PACKETS" },
 { 7, xDELIVER, "DELIVER" },
 { 7, xDEFAULT, "DEFAULT" },
 { 7, xADDRESS, "ADDRESS" },
 { 8, xOUTBOUND, "OUTBOUND" },
 { 8, xMOVETICS, "MOVETICS" },
 { 9, xMAILFIRST, "MAILFIRST" },
 { 9, xLONGNAMES, "LONGNAMES" },
 { 10, xMAXARCSIZE, "MAXARCSIZE" },
 { 11, xPASSTHROUGH, "PASSTHROUGH" },
 { 255, 255, NULL }
};



//-----------------------------------------------------------------------------
int	main ( int argc, char**argv )
{
	FILE	*fileCtl;
	int	rc = 0;
	short	len;
	BOOL	bQuiet = FALSE;

	time_t DosTime;
	struct tm	CurTm;

	RouteTbl = NULL;
	pLastRoute = &RouteTbl;
	pMASTbl = NULL;
	ppLastMAS = &pMASTbl;
	*ctlfile = '\0';
	*LogPlus = '\0';
	*Flags = '\0';
	*Boxes = '\0';
	*Packets = '\0';
	*SaveTic = '\0';
	bLogOpened = FALSE;

	srand( (unsigned)time( NULL ) );

	/* 権 */
	for( short nArg = 1; nArg<argc; nArg++ )
	{	char* psArg = argv[nArg];
		if( *psArg!='/' && *psArg!='-' )	break;
		switch( psArg[1] )
		{
		case '?':
		case 'h':
		case 'H':
			cout << Title;
			cout << szExplain;
			exit(0);
		case 'q':
			bQuiet = TRUE;
			break;
		case 'c':
			if( !psArg+2 )
			{	cout << "Inalid option " << psArg;
				exit(-3);
			}
			strcpy( ctlfile, psArg+2 );
			break;
		case 'l':
			if( !psArg+2 )
			{	cout << "Inalid option " << psArg;
				exit(-3);
			}
			DosTime = time(NULL);
			_localtime( &DosTime, &CurTm );
			strcpy( szLogFName, psArg+2 );
			strftime( line, 256, "Start MoveLo2 v"VERSION" at %d %b %Y, %A", &CurTm );
			LogMsg( 0xfe, line );
			break;
		case 'L':
			if( !psArg+2 )
			{ len = (short)(strlen(psArg)-2);
				if( len > sizeof(LogTypes)+2 )
					cout << "Invalid option " << psArg;
				else
					strcpy( LogTypes+1, psArg+2 );
			}else
				*(LogTypes+1) = '\0';
			break;
		default:
			cout << "Unknown option " << psArg;
			exit(-3);
		}
	}

	if( !*ctlfile )
	{	len = (short)strlen( argv[0] );
		memcpy( ctlfile, argv[0], len-3 );
		memcpy( ctlfile+(len-3), "CTL", 4 );
	}
	fileCtl = fopen( ctlfile, "rt" );
	if ( !fileCtl )
	{	cout << "File " << ctlfile << " could not be opened\n";
		return 2;
	}
	if( !bQuiet )
	{	cout << Title;
		cout << "Control file " << ctlfile << "\n";
	}

	char	*ptr;
	char	*val;
	char	c;
	UWORD	Zone;
	char	Temp[_MAX_PATH2];

	if( rc=setjmp( JmpOnError ), rc )	goto Abend;

	while( fgets( line, sizeof(line), fileCtl ) )
	{  byte xOp;
      KeyWord* pKey;
      ptr = VarExpand(line);
		if( !ptr )	continue;
		val = ptr;
		ptr = toend( ptr );
		len = (short)(ptr-val);
		c = val[len];
		*ptr = '\0';
		strupr(val);
      for( pKey=Keys; pKey->len < len; pKey++ );
		while( pKey->len == len && memcmp(val,pKey->str,len) )	pKey++;
		if( pKey->len != len )	goto InvalidKeyword;
		xOp = pKey->code;
		*ptr = c;
		switch( xOp )
		{
		case xLOG:
			if( bLogOpened )	fclose( fpLog );
			bLogOpened = FALSE;
			if( *szLogFName )	LogMsg( 0xfe,"End\n" );
			DosTime = time(NULL);
			_localtime( &DosTime, &CurTm );
			ptr = GetValue( ptr, szLogFName, LogFNameMaxLen );
			ptr = skip_blanks( ptr );
			if( ptr )
			{	char* tmp;
				tmp = toend(ptr);
				len = (short)(tmp - ptr);
				if( len > sizeof(LogTypes)+2 )
				{ LogMsg( '?', "Invalid second parameter for Log keyword ignored" );
					break;
				}
				memcpy( LogTypes+1, ptr, len );
				LogTypes[len+1] = '\0';
			}
			strftime( line, 256, "Start at %d %b %Y, %A (v"VERSION")", &CurTm );
			LogMsg( 0xfe, line );
			break;
		case xSET:
			SetVarValue( tSet, ptr );
			break;
#if 0
		case xTEST:	// ⫠ pp  pp ⠭ p
			GetValue( ptr, Temp, 256 );
         LogMsg( '>', Temp );
			break;
#endif
		case xPASSTHROUGH:	// ᫨ ⨪ ᥣ p,   pp pp
			GetValue( ptr, Temp, TagMaxLen );	// p祭   ⥣ = 40
			if( !*Temp )
			{	ClearPassThroughTable();
				break;
			}
			AddPassThrough( Temp );
			break;
   	case xBOXES:
			GetValue( ptr, Boxes, BoxesMaxLen );
			if( !*Boxes )	goto ParameterMissing;
			strupr( Boxes );
			if( TestAndCreateDir( Boxes ) )
			{	LogMsgP( '?', "Operator \"Boxes %s\" ignoreg", Boxes );
				*Boxes = '\0';
			}
			break;
   	case xQUEUE:
			GetValue( ptr, Queue, QueueMaxLen );
			if( *Queue )
			{	strupr( Queue );
				len = (short)strlen( Queue );
				if( Queue[len-1] != '\\' )
				{	Queue[len] = '\\';
		         Queue[++len] = '\0';
				}
				if( TestAndCreateDir( Queue ) )
				{	LogMsgP( '?', "Operator \"Queue %s\" ignoreg", Queue );
					*Queue = '\0';
				}
			}
			break;
		case xFLAGS:
			GetValue( ptr, Flags, FlagsMaxLen );
			if( *Flags )
			{	strupr( Flags );
				if( TestAndCreateDir( Flags ) )
				{	ptr = Flags;
					goto InvalidParameter;
				}
			}
			break;
		case xALLFIX:
			if( !*Boxes )
			{	LogMsg( '?', "Variable Boxes does not set, operator AllFix ignored" );
				break;
			}
			GetValue( ptr, Temp, 256 );
			if( !*Temp )	goto ParameterMissing;
			strupr( Temp );
			ForAllFix( Temp );
			break;
		case xSAVETIC:
			GetValue( ptr, SaveTic, SaveTicMaxLen );
			if( !*SaveTic )	goto ParameterMissing;
			strupr( SaveTic );
			if( TestAndCreateDir( SaveTic ) )
			{	ptr = SaveTic;
				goto InvalidParameter;
			}
			break;
		case xPACKETS:
			GetValue( ptr, Packets, PacketsMaxLen );
			if( *Packets )
			{	strupr( Packets );
				if( TestAndCreateDir( Packets ) )
				{	ptr = Packets;
					goto InvalidParameter;
				}
			}
			break;
		case xDEFAULT:
			SetVarValue( tDefault, ptr );
			break;
		case xDELIVER:
			{	Address ads;
				char	szAds[9];
				char*	szDir;
				char*	szFlag;
				short	DirLen;
				short	FlagLen;
				byte	Mode = 0;
				ptr = skip_blanks( ptr );
				if( !ptr )
				{	// ⪠ ᥩ ⠡ ⠢
					Clear_Route_Table();
					break;
				}
				if( !parse_address( ptr, ads ) )
				{ rc = 2;
					goto ErrInCtl;
				}
				sprintf( szAds, "%04X%04X", ads.net, ads.node );
				ptr = skip_blanks( ptr );
				Remove_Route( ads.zone, szAds, ads.point );
				if( ptr )
				{	szDir = ptr;
					ptr = toend( ptr );
					DirLen = (short)(ptr-szDir);
					szFlag = skip_blanks( ptr );
					*ptr = '\0';
					strupr( szDir );
					if( TestAndCreateDir( szDir ) )
					{	ptr = szDir;
						goto InvalidParameter;
					}
					ptr = szFlag;
					FlagLen = 0;
					if( !ptr )	goto NoFlag;
					if( *ptr == '-' )
					{	ptr = toend( ptr );
						if( ptr-szFlag!=2 )	goto BadDeliverOption;
						switch( szFlag[1] )
						{
						case 'o':
							Mode = OVERWRITE;
							break;
						case 'r':
							Mode = RENAMENEW;
							break;
						case 'x':
							Mode = RENAMEOLD;
							break;
						default:
							goto BadDeliverOption;
						}
						szFlag = ptr = skip_blanks( ptr );
						if( !ptr )	goto NoFlag;
					}
					ptr = toend( ptr );
					FlagLen = (short)(ptr-szFlag);
					*ptr = '\0';
					strupr( szFlag );
				NoFlag:
					route* rt;
					rt = (route*)malloc( sizeof(route)+DirLen+FlagLen );
					rt->zone = ads.zone;
					rt->point = ads.point;
					memcpy( rt->OutName, szAds, 8 );
					rt->Mode = Mode;
					rt->DirLen = (byte)DirLen;
					strcpy( rt->Dir, szDir );
					if( szFlag )
						strcpy( rt->Dir+DirLen+1, szFlag );
					else
						*(rt->Dir+DirLen+1) = '\0';
					rt->Next = NULL;
					*pLastRoute = rt;
					pLastRoute = &(rt->Next);
				}
			}
			break;
		case xADDRESS:
			if( !parse_address( ptr, Main ) )
			{ rc = 2;
				goto ErrInCtl;
			}
			break;
		case xOUTBOUND:
			if( !*Boxes )
			{	LogMsg( '?', "Variable Boxes does not set, operator OutBound ignored" );
				break;
			}
			ptr = GetValue( ptr, Outbound, OutboundMaxLen );
			if( !*Outbound )	goto ParameterMissing;
			strupr( Outbound );
			if( TestAndCreateDir( Outbound ) )
			{	ptr = Outbound;
				goto InvalidParameter;
			}
			Zone = Main.zone;
			GetValue( ptr, Temp, 32 );
			if( *Temp )	Zone = (UWORD)atoi( Temp );
			if( Zone<1 )	Zone = 2;
			move_outbound_to_filebox( Zone, Outbound, Boxes, SaveTic );
			break;
		case xMOVETICS:
			GetValue( ptr, Temp, 8 );
			strupr(Temp);
			if( !strcmp(Temp,"NO"))	bMoveTic = DontMoveTics;
			else	if( !strcmp(Temp,"ANY"))	bMoveTic = MoveAnyTics;
			else	if( !strcmp(Temp,"NONPASS"))	bMoveTic = DontMovePTTics;
			else	goto InvalidParameterInTemp;
			break;
		case xMAILFIRST:
			GetValue( ptr, Temp, 4 );
			bMailFirst = TRUE;
			if( !*Temp )	break;
			strupr(Temp);
			if( !strcmp( Temp, "YES" ) )	break;
			if( !strcmp( Temp, "NO" ) )
			{	bMailFirst = FALSE;
				break;
			}
			goto InvalidParameterInTemp;
#if defined(__OS2__)||defined(__NT__)
		case xLONGNAMES:
			ptr = skip_blanks( ptr );
			if( !ptr || toupper(*ptr)=='Y' )	bLongNames = 1;
			else if( toupper(*ptr)=='N' )	bLongNames = 0;
			else	goto InvalidParameter;
			break;
#endif
		case xMAXARCSIZE:
			{	AdsMask	Mask;
				unsigned long	limit = -1;
				char* tmp;
	         tmp = ptr = skip_blanks(ptr);
				if( !ptr || (*ptr!='-' && (*ptr<'0' || *ptr>'9') ) )	goto InvalidParameter;
				limit = strtol( tmp, &tmp, 10 );
				switch( *tmp )
				{
				case 'K':	case 'k':
					limit<<=10;
					tmp++;
					break;
				case 'M':	case 'm':
					limit<<=20;
					tmp++;
					break;
				default:;
				}
				if( *tmp<' '|| *tmp==';' )	tmp = NULL;
				else
					if( *tmp!=' ' && *tmp!='\t' )	goto InvalidParameter;
				ptr = GetAdsMask( ptr = tmp, Mask );
				MaxArcSize*	pMAS;
				pMAS = (MaxArcSize*)malloc( sizeof(MaxArcSize) );
				pMAS->Mask = Mask;
				pMAS->limit = limit;
				pMAS->Next = NULL;
				*ppLastMAS = pMAS;
				ppLastMAS = &(pMAS->Next);
			}
			break;
		default:
			goto InvalidKeyword;
		}
	}
ErrInCtl:
	fclose( fileCtl );
	LogMsg( 0xfe, "End\n" );
	if( bLogOpened )	fclose( fpLog );
	Clear_Route_Table();
	return rc;

InvalidKeyword:
	*(toend(val)) = '\0';
	LogMsgP( '?',"Invalid keyword '%s'", val );
	rc = 4;
	goto ErrInCtl;

ParameterMissing:
	*(toend(val)) = '\0';
	LogMsgP( '?',"Parameter missing for keyword '%s'", val );
	rc = 3;
	goto ErrInCtl;

BadDeliverOption:
	*(toend(val)) = '\0';
	LogMsg( '?', "Invalid option for Deliver operator" );
	rc = 3;
	goto ErrInCtl;

InvalidParameterInTemp:
	ptr = Temp;
InvalidParameter:
	*(toend(val)) = '\0';
	*(toend(ptr)) = '\0';
	LogMsgP( '?', "Invalid parameter %s for keyword %s", ptr, val );
	rc = 4;
	goto ErrInCtl;

Abend:
	*(toend(val)) = '\0';
	switch( rc )
	{
	case ParameterTooLong:
		LogMsgP( '?', "Parameter for keyword '%s' is too long", val );
		rc = 3;
		break;
	case SinglePerCent:
		LogMsgP( '?', "Incorrect syntax: environment variable missing in '%s'", val );
		rc = 3;
		break;
	case ErrMissParm:
		goto	ParameterMissing;
	case ErrInvParm:
		goto	InvalidParameter;
	case ErrMissAddress:
		LogMsgP( '?', "Invalid parameter %s - your main address is not specified", ptr );
		rc = 3;
		break;
	default:
		LogMsgP( '?', "Undetermine error %i", rc );
	}
	goto ErrInCtl;
}

