/* maximum length of a line in a FILE_ID.DIZ file */
enum{ MaxFileIDlen = 45 };

/* Attribute bits for the fileecho records */
enum
{	_announce   = 0x0001,
	_replace    = 0x0002,
	_convertall = 0x0004,
	_passthru   = 0x0008,
	_dupecheck  = 0x0010,
	_fileidxxx  = 0x0020,
	_visible    = 0x0040,
	_tinysb     = 0x0080,
	_Security   = 0x0100,
	_NoTouch    = 0x0200,
	_SendOrig   = 0x0400,
	_AddGifSpecs= 0x0800,
	_VirusScan  = 0x1000,
	_UpdateMagic= 0x2000,
	_UseFDB     = 0x4000
};

/* Attribute bits for the systems in the system list */
enum{
	_SendTo      = 0x0001,
	_ReceiveFrom = 0x0002,
	_PreRelease  = 0x0004,
	_Inactive    = 0x0008,
	_NoneStat    = 0x0010,
	_HoldStat    = 0x0020,
	_CrashStat   = 0x0040,
	_Mandatory   = 0x0080
};

/* Magic filename types */
enum{
	_AdoptFile   = 1,
	_ExecCommand = 2,
	_ForwardTo   = 3,
	_MoveToArea  = 4,
	_NoForward   = 5,
	_OtherPath   = 6,
	_UpdateAlias = 7,
	_CopyFile    = 8,
	_KeepNum     = 9,
	_HatchNew    = 10,
	_PickUpFile  = 11,
	_UnpackFile  = 12,
	_PassThruFile= 13,
	_DeleteFile  = 14
};

/* Message status bits in the node manager */
enum{
	_HOLD	= 0x0200,
	_CRASH	= 0x0001
};

/* Size of the systems list */
enum{ ExportSize = 255 };

/* Maximum number of records in the TOBEREP.IDX file */
enum{ IndexSize = 8000 };

typedef char StringRecord[2000];

typedef char Str12[13];

typedef	enum{Hudson,Pkt,Msg,EzyCom,Squish,Jam,PCBoard,Null,_Netmail}
	MsgBaseType;

typedef unsigned char byte;
#if defined(__OS2__)
typedef unsigned short word;
typedef short int integer;
#else
typedef unsigned word;
typedef int integer;
#endif
typedef byte real[6];

typedef struct
{	word Zone;
	word Net;
	word Node;
	word Point;
} NetAddress;

typedef struct
{   word Zone;
	word Net;
} ZoneNet;

/* TOBEREP.IDX file */
typedef struct
{	byte	Group;
    word	Offset;
}  ToBeRepIdx;

/* TOBEREP.FIX file */
typedef struct
{	char	Fname[13];
	long	Fsize;
	long	Fdate;
	NetAddress	From, Origin;
	byte	Group;
	char	Name[41];
	char	Comment[51];
	char	Replaces[13];
	char	MagicName[21];
	unsigned long	Fcrc;
	real	Cost;
	real	UnitCost;
	byte	UnitSize;
	word	DescLen;
	StringRecord	Fdesc;
} ToBeRepFix;

typedef struct
{	NetAddress	Address;
	byte	Status;
}	ExportEntry;

/* Systems list */
typedef ExportEntry ExportArray[ExportSize];

/* Array used to store groups */
typedef byte GroupArray[32];

typedef struct
{	char	Arc[13];
	char	charArcCmd[21];
	char	UnArc[13];
	char	UnArcCmd[21];
	char	BannerCmd[21];
} ArcRec;

typedef struct
{	NetAddress	Aka;
	char	MgrProgram[9];
	char	MgrPassword[17];
	word	Attrib;
    /* bit 0 - add prefix
       bit 1 - unconditional
       bit 2 - direct
       bit 3 - filebone.ra */
	GroupArray	Groups;
	char	AreasFile[13];
	byte	UseAka;
} UplinkRec;

typedef struct
{	ZoneNet	Zn;
	byte	Aka;
}	AkaMatchRec;

typedef enum{FrontDoorMode,BinkleyMode,DBridgeMode,PortalOfPower}
	MailerModeType;

typedef enum{	European     /*dd-mm-yy*/,
				American     /*mm-dd-yy*/,
				Scandinavian /*yy-mm-dd*/
}	DateType;

/* SETUP.FIX file */
typedef struct{
	byte	VersionID;
	char	FixLog[61], inNETmail[61], MSGpath[61], Inbound[61], LOGfile[61];
	char	PktPath[61];
	char	PktOut[61];
	char	Queue[61];
	char	TicPath[61];
	char	Alias[61];
	char	Semaphore[61];
	char	RcvdPath[61];
	char	DefaultAdd[61];
	char	BadPath[61];
	char	AreaLog[61];
	char	OutBound[61];
	char	OutNetmail[61];
	char	SecInbound[61];

	char	SysOp[31];
	char	RKey[25];
	char	ListPath[61];
	char	BBSname[31];
	char	Baud[6];
	char	Flags[31];
	char	Location[31];
	char	Comment[61];
	char	Pline1[31], Pline2[31], Pline3[31];

	byte	FileAreas[8000];

	NetAddress	FakeAka;
	NetAddress	Aka[21/* 0..20 */];
	char	Origin[20][61];
	char	Days[7][21];
	char	Months[12][21];
	struct{ word	Zone; char	Name[26];} Domains[20];
	ArcRec	Arc[10];
	UplinkRec	Uplink[20];

	byte	KeepDate;
	byte	Rescan;
	byte	KeepNet, KeepRec;
	byte	Swap;
	char	Exclude[20][13];
	char	FileCnt[9];

	/* No longer used */
	struct{
		char	From[31], Too[31];
		char	Subject[73];
		char	Template[13];
		byte	Extra[44];
	} GroupsDef;

	struct{
		byte	Group;
		char	Message[13];
		byte	Keep;/*short int*/
		word	Attrib;
		byte	Convert;
		byte	Status;
		byte	UseFDB;
		byte	LongDesc;
		char	Banner[9];
		byte	Extra[34];
	} FareasDef;

	struct{
		byte	Useaka;
		byte	MailStat;
		byte	Direct;
		byte	TicFile;
		byte	Message;
		byte	Notify;
		byte	Archiver;
		byte	Forward, AutoAdd;
		byte	PackMode;
		byte	Remote;
		GroupArray	Groups;
		byte	Extra1[44];
	} NodesDef;

	byte	LogStyle;
	byte	LocalRep;
	long	LogOptions;
	AkaMatchRec	AkaMatch[20];
	byte	ReplaceExt;
	byte	KeepMgr;
	word	AreaMgrOpts;
	/* bit 0 - allow %+ALL */
	/* 1 -       %notify */
	/* 2 -       %password */
	/* 3 -       %message */
	/* 4 -       %compression */
	/* 5 -       %tick */
	/* 6 -       %pause */
	/* 7 -       %echopassword */
	byte	AutoAddNodes;
	GroupArray	PublicGroups;
	byte	UseXEMS;
	MailerModeType	MailerMode;
	byte	DaysToKeepHis;
	byte	MaxSizeOfHis;
	/* no longer used */
	byte	ResetFuture;
	char	ExtendedChar;
	byte	FilterFileID;
	byte	OneLineFileID;
	word	KeepDays;
	DateType	DateFormat;
	word	StatSize;
	byte	_4DOSmode;
	char	AreaMgrStr[21][5];
	char	VirusChecker[13];
	char	VirusOptions[51];
	char	DBqueue[61];
	char	TagPath[61];
	/* no longer used */
	struct{
		char	ReadHK, ScanHK, QuickHK, YellHK, HelpHK, EnterHK, QuitHK, LogoffHK;
		byte	YellDelay;
		byte	FixLogStyle;
		byte	Extra[22];
	} FixDor;
	byte	RedirectOutput;
	byte	VirusErrorLvl;
	byte	FilesToScan;
	byte	MaxLineFileID;
	byte	FileIDindent;
	long	InitDate;
	char	EchoToss[61];
	word	MaxTicPackSize;
	byte	OldFileFind;
	char	TmpDir[61];
	char	ExtConvExe[13];
	char	ExtConvOpt[129];
	byte	AddArea;
	char	TemplatePath[61];
	integer	UTCofs;
	byte	MtaVirusLvl, MtaErrorLvl;
	word	MinSpace;
	char	Colors[41];
	struct{
		char	name[36];
		NetAddress	address;
		char	fname[61];
		char	nname[61];
		byte	dom;
		byte	status;
		byte	direct;
		byte	oldf;
		char	area[13];
		byte	extra[73];
	} UEFTS;
	byte	DupeCheck;
	/* 0 - filename
	   1 - filename + fileecho
	   2 - filecrc
	   3 - filecrc + fileecho
	   4 - filecrc + filename
	            5 - filename + fileecho + filecrc  */
	word	MaxSizeToPack;
	byte	messagecomp;
	char	BillPath[61];
	char	DupePath[61];
	ArcRec	xArc[4/* 7..10 */];
	char	xSig[4/* 7..10 */][30];
	char	xExt[4/* 7..10 */][4];
	char	Unwanted[61];
	byte	MaxMsgSize;
	byte	Extra[1112];
} ALLFIXcfg;

/* AREAS.FIX file */
typedef struct{
	char	Comment[56];
	char	Name[41];
	char	RName[41];
	byte	Origin;
	/* Scan board number */
	word	Board;
	/* Reply board number */
	word	RBoard;
	byte	Aka;
	/* Scan path */
	char	Path[61];
	/* Reply path */
	char	Rpath[61];
	/* Scan type of message base */
	/* Reply type of message base */
	byte	Btype, Rtype;
	/* no longer used */
	char	_Sname[9];
	/* no longer used */
	char	_SRname[9];
	char	Template[9];
	byte	Extra[105];
} AreaMGRRec;

/* AREAS.IDX file */
typedef struct{
	char	Comment[56];
	word	Offset;
} AreaMgrIdx;

/* NEWFILES.FIX file */
typedef struct{
	char	Comment[56];
	byte	Group;
	word	FileBrd;
	long	PathCrc;
} NewFileMgrRec;

/* NEWFILES.IDX file */
typedef struct{
	word	FileBrd;
	word	Offset;
} NewFileMgrIdx;

/* FAREAS.FIX file */
typedef struct{
	char	Name[13];
	byte	Extra_1[28];
	char	Message[13];
	char	Comment[56];
	byte	Group;
	word	Attrib;
	byte	KeepLate;/* short int */
	byte /*0..6*/	Convert;
	byte	UplinkNum;
	char	DestDir[61];
	word	TotalFiles, TotalKb;
	byte	Byear, Bmonth;
	word	_FBoard;
	byte	UseAka; /* short int */
	byte	LongDesc;
	char	Banner[9];
	real	UnitCost;
	byte	UnitSize;
	byte	AllLinks;
	real	AddPercentage;
	byte	Extra[30];
	ExportArray	Export;
} FileMgrRec;

/* FAREAS.IDX file */
typedef struct{
	char	Name[13];
	byte	Group;
	word	Offset;
} FileMGRidx;

/* GRPFILE.FIX file */
typedef struct{
	FileMgrRec	FMrec;
	char	Name[26];
} GrpFileMgrRec;

/* GRPFILE.IDX file */
typedef struct{
	byte	Group;
	char	Spec[13];
	char	Name[26];
	word	Offset;
} GrpFileMgrIdx;

/* NODEFILE.FIX file */
typedef struct{
	NetAddress	Aka;
	char	Sysop[36];
	char	Password[21];
	GroupArray	Groups;
	byte	Reserved;
	byte	Extra[4];
	byte	MailStat;
	byte	Direct;
	byte	TicFile;
	byte	UseAka;/* short int */
	byte	Message;
	byte	Notify;
	byte	Archiver;
	byte	Forward;
	byte	AutoAdd;
	char	MgrPassword[21];
	byte	Remote;
	byte	PackMode;
	NetAddress	ViaNode;
} NodeMGRrec;

/* NODEFILE.IDX file */
typedef struct{
	NetAddress	Aka;
	word	Offset;
} NodeMGRidx;

/* REPORTS.FIX file */
typedef struct{
	GroupArray	Groups;
	byte	Reserved;
	byte	Extra1[4];
	byte	Aka;
	byte	Origin;
	char	Template[9];
	char	From[36], Too[36];
	char	Subject[73];
	/* Message base type */
	byte	MsgType;
	/* Message board number */
	word	Board;
	char	Name[41];
	char	Path[61];
	ExportArray	Export;
	byte	Extra2[44];
} ReportsMgrRec;

/* REPORTS.IDX file */
typedef struct{
	GroupArray	Group;
	word	Offset;
} ReportsMGRidx;

/* MGICFILE.FIX file */
typedef struct{
	byte	Attrib;
	char	FileMask[13], FromArea[13], ToArea[13];
	char	Directory[61];
	char	Command[61];
	byte	KeepNum;/* short int */
	byte	Days;
	byte	Extra[41];
	ExportArray	Export;
} MagicFileMgrRec;

/* MGICFILE.IDX file */
typedef struct{
	char	FileMask[13];
	word	Offset;
} MagicMGRidx;

/* HATCH.FIX file */
typedef struct{
	char	Name[13];
	char	Spec[80];
	char	Replace[13];
	char	Magic[21];
	char	Desc[81];
	byte	Days;
	/* no longer used */
	byte	UseFDB;
	byte	Extra[4];
} HatchMGRrec;

/* HATCH.IDX file */
typedef struct{
	char	Name[13];
	word	Offset;
} HatchMgrIdx;

/* FILEAREA.FIX file (file area records) */
typedef struct{
	char	Path[61];
	char	Name[61];
	char	List[61];
	char	Fnum[10];
	word	Fbrd;
	word	Pbrd;
	long	PathCRC;
} FileAreaRecord;

/* FILEAREA.FIX file (header, stored at begining of file) */
typedef struct{
	byte	BBStype;
	char	SysPath[61];
	char	BBSpath[61];
	char	FilePath[61];
	byte	UseFDB;
	byte	Extra[71];
} FileAreaHeader;

/* STATFILE.FIX file */
typedef struct{
	Str12	FileEcho;
	long	Date;
	Str12	FileName;
	long	FileSize;
	long	FileDate;
	NetAddress	Sender;
	/* Number of downlinks following this record */
	word	NumDown;
} StatisticRecord;

/* STATFILE.IDX file */
typedef struct{
	/* 32 bit CRC of fileecho name */
	long	FileEcho;
	long	Offset;
} StatisticIndex;

