;===============================================
; Program DISK by Sherman M Barney. A modification of DSIZE  by D. Whitman
;
; Syntax:  DISK [d:] [?]
;
; Examines the disk in the specified drive, prints the format size,
; and sets ERRORLEVEL as follows:
;
;  0 = unknown format
;  1 = single sided, 8 sectors (160K)
;  2 = single sided, 9 sectors (180K)
;  3 = double sided, 8 sectors (320K)
;  4 = double sided, 9 sectors (360K)
;  5 = 3 1/2" 720K
;  6 = 5 1/4" 1.2M
;  7=  3 1/2" 1.44M
;
; The ERRORLEVEL variable can be used by a BATCH file invoking DISK 
;
; DISK requires DOS 2.0 or later
;
; This source file is in MAX assembler syntax.
; It is public domain.
;===============================================

; equates
getver        equ     30H     ;get DOS version number
getdi         equ     36H     ;get disk information
prnstr        equ     09H     ;print string to console
cr = 0dh                      ;carriage return
lf = 0ah                      ;linefeed
beep = 07h                    ;bell
param_count    equ     [80H]
param_area     equ      81H
drv1   equ     [5CH]          ;drive number in 1st fcb

;start of prgm
chkver:mov     ah,getver          ;what DOS are we under?
       int     21H                ;ask DOS.
       cmp     al,00              ;earlier than 2.0?
       jne     param              ;no, jump
       mov     dx,offset baddos   ;yes, point to message
       mov     ah,prnstr          ;print message
       int     21H                ;with dos call
       jmp     exit               ;and quit

param: xor     ch, ch             ;cx = number of parameter chars
       mov     cl,param_count
       cmp     cl,0               ;any parameters?
       je      chkdsk             ;skip if none
       mov     di,param_area      ;scan parameter area for help request
       mov     al, '?'            ;marked with (?) ?
       repnz scasb                ;scan till match or end
       jnz     chkdsk             ;no match? skip
       mov     ah,prnstr          ;otherwise print help
       mov     dx,offset help 
       int     21H
       int     20H                ;and exit

chkdsk:mov     dl,drv1            ;get drive number
       mov     ah,getdi           ;ask for disk info
       int     21H                ;with dos call
       
       cmp     dx,0b1fh           ;is it 1.44M ?
       jne     c1                 ;if not, then jump
       mov     dx,offset M1_44    ;point to message
       call    print_message      ;print message 
       mov     al,07H             ;and set errorlevel
       jmp     seterr
       
c1:    cmp     dx,943H            ;is it 1.2M ?
       jne     c2                 ;if not, then jump
       mov     dx,offset M1_2     ;point to message
       call    print_message      ;print message 
       mov     al,06H             ;and set errorlevel
       jmp     seterr
       
c2:    cmp     dx,2C9H            ;is it 720K ?
       jne     c3                 ;if not, then jump
       mov     dx,offset K720     ;point to message
       call    print_message      ;print message 
       mov     al,04H             ;and set errorlevel
       jmp     seterr
       
c3:    cmp     dx,0162H           ;is it 360K ?
       jne     c4                 ;if not, then jump
       mov     dx,offset K360     ;point to message
       call    print_message      ;print message 
       mov     al,04H             ;and set errorlevel
       jmp     seterr

c4:    cmp     dx,015FH           ;is it 180K ?
       jne     c5                 ;if not, then jump
       mov     dx,offset K180     ;point to message
       call    print_message      ;print message 
       mov     al,02H             ;and set errorlevel
       jmp     seterr

c5:    cmp     dx,013BH           ;is it 320K ?
       jne     c6                 ;if not, then jump
       mov     dx,offset K320     ;point to message
       call    print_message      ;print message 
       mov     al,03H             ;and set errorlevel
       jmp     seterr

c6:    cmp     dx,0139H           ;is it 160K ?
       jne     unkwn              ;if not, then jump
       mov     dx,offset K160     ;point to message
       call    print_message      ;print message 
       mov     al,01H             ;and set errorlevel
       jmp     seterr

unkwn: mov     dx,offset K?       ;point to message
       call    print_message      ;print message 
       mov     al,0               ;and set errorlevel

seterr:mov     ah,04ch            ;set errorlevel
       int     21H                ;and exit

exit:  int     20H                ;abnormal exit for errors

print_message: mov ah,prnstr
               int 21H
               ret

M1_44   db cr,lf,'1.44M disk',cr,lf,lf,'$'
M1_2    db cr,lf,'1.2M disk',cr,lf,lf,'$'
K720    db cr,lf,'720K disk',cr,lf,lf,'$'
K360    db cr,lf,'360K disk',cr,lf,lf,'$'
K180    db cr,lf,'180K disk',cr,lf,lf,'$'
K320    db cr,lf,'320K disk',cr,lf,lf,'$'
K160    db cr,lf,'160K disk',cr,lf,lf,'$'
K?      db cr,lf,'Unrecognized disk format',cr,lf,lf,'$'
baddrv  db cr,lf,beep,'Invalid drive specifier!',cr,lf,'$'
baddos  db cr,lf,beep,'This utility requires DOS 2.0 or later!',cr,lf,'$'
help    db cr,lf
db 'DISK version 1.01 by Sherman M Barney',cr,lf
db 'A modification of DSIZE by D. Whitman',cr,lf,lf
db 'Examines the disk in the specified drive and determines its format',cr,lf,lf
db 'Syntax:  Disk [d:]  [?]',cr,lf,lf
db '   d: = drive letter (a or b)',cr,lf,lf
db '   ? = Print this help message',cr,lf,lf
db 'A printed summary is produced, and ERRORLEVEL is set as follows:'
db  cr,lf,lf
db '    0 = unknown format',cr,lf
db '    1 = single sided, 8 sector (160K)',cr,lf
db '    2 = single sided, 9 sector (180K)',cr,lf
db '    3 = double sided, 8 sector (320K)',cr,lf
db '    4 = double sided, 9 sector (360K)',cr,lf
db '    5 = 3 1/2" 720K',cr,lf
db '    6 = 5 1/4" 1.2M',cr,lf
db '    7 = 3 1/2" 1.44M',cr,lf,'$'
