;
; This file is a charset conversion module in text form.
;
; This module Converts IBM extended characters to ISO 8859-1 characters.
;
; Format: ID, version, level,
;         from charset, to charset,
;         128 entries: first & second byte
;	  "END"
; Lines beginning with a ";" or a ";" after the entries are comments
;
; Unkown characters are mapped to the "?" character.
;
; cedilla = ,   ; dieresis = ..       ; acute = '
; grave = `     ; circumflex = ^      ; ring = o
; tilde = ~     ; caron = v 
; All of these are above the character, apart from the cedilla which is below.
;
; \ is the escape character: \0 means decimal zero,
; \dnnn where nnn is a decimal number is the ordinal value of the character
; \xnn where nn is a hexadecimal number
; e.g.: \d32 is the ASCII space character
; Two \\ is the character "\" itself.
;
0		; ID number
0		; version number
;
2		; level number
;
IBMPC		; from set
LATIN-1		; to set
;
\0 \xc7         ; 128 80 C with cedilla
\0 \xfc         ; 129 81 u dieresis
\0 \xe9         ; 130 82 e acute
\0 \xe2         ; 131 83 a circumflex
\0 \xe4         ; 132 84 a dieresis
\0 \xe0         ; 133 85 a grave
\0 \xe5         ; 134 86 a ring
\0 \xe7         ; 135 87 c cedilla
\0 \xea         ; 136 88 e circumflex
\0 \xeb         ; 137 89 e dieresis
\0 \xe8         ; 138 8A e grave
\0 \xef         ; 139 8B i dieresis
\0 \xee         ; 140 8C i circumflex
\0 \xec         ; 141 8D i grave
\0 \xc4         ; 142 8E A dieresis
\0 \xc5         ; 143 8F A ring
\0 \xc9         ; 144 90 E acute
\0 \xe6         ; 145 91 ae
\0 \xc6         ; 146 92 AE
\0 \xf4         ; 147 93 o circumflex
\0 \xf6         ; 148 94 o dieresis
\0 \xf3         ; 149 95 o acute
\0 \xdb         ; 150 96 u circumflex
\0 \xd9         ; 151 97 u grave
\0 \xff         ; 152 98 y dieresis
\0 \xd6         ; 153 99 O dieresis
\0 \xdc         ; 154 9A U dieresis
\0 \xf8         ; 155 9B o slash (CP865/850 mapping)
\0 \xa3         ; 156 9C pound sterling
\0 \xd8         ; 157 9D O slash (CP865/850 mapping)
P t             ; 158 9E Pt
f l             ; 159 9F florin
\0 \xe1         ; 160 A0 a acute
\0 \xcc         ; 161 A1 i grave
\0 \xf2         ; 162 A2 o grave
\0 \xf9         ; 163 A3 u grave
\0 \xf1         ; 164 A4 n tilde
\0 \xd1         ; 165 A5 N tilde
\0 \xaa         ; 166 A6 ord feminine
\0 \xba         ; 167 A7 ord masculine
\0 \xbf         ; 168 A8 question downwards
\0 -            ; 169 A9
\0 \xac         ; 170 AA logical not
\0 \xbd         ; 171 AB half fraction
\0 \xbc         ; 172 AC quarter fraction
\0 \xa1         ; 173 AD exclam downwards
\0 \xab         ; 174 AE guillemot left
\0 \xbb         ; 175 AF guillemot right
\0 #            ; 176 B0
\0 #            ; 177 B1
\0 #            ; 178 B2
\0 |            ; 179 B3
\0 |            ; 180 B4
\0 |            ; 181 B5
\0 |            ; 182 B6
\0 +            ; 183 B7
\0 +            ; 184 B8
\0 |            ; 185 B9
\0 |            ; 186 BA
\0 +            ; 187 BB
\0 +            ; 188 BC
\0 +            ; 189 BD
\0 +            ; 190 BE
\0 +            ; 191 BF
\0 +            ; 192 C0
\0 -            ; 193 C1
\0 -            ; 194 C2
\0 |            ; 195 C3
\0 -            ; 196 C4
\0 +            ; 197 C5
\0 |            ; 198 C6
\0 |            ; 199 C7
\0 +            ; 200 C8
\0 +            ; 201 C9
\0 =            ; 202 CA
\0 =            ; 203 CB
\0 |            ; 204 CC
\0 =            ; 205 CD
\0 +            ; 206 CE
\0 =            ; 207 CF
\0 -            ; 208 D0
\0 =            ; 209 D1
\0 -            ; 210 D2
\0 +            ; 211 D3
\0 +            ; 212 D4
\0 +            ; 213 D5
\0 +            ; 214 D6
\0 |            ; 215 D7
\0 +            ; 216 D8
\0 +            ; 217 D9
\0 +            ; 218 DA
\0 #            ; 219 DB
\0 n            ; 220 DC
\0 |            ; 221 DD
\0 |            ; 222 DE
\0 ~            ; 223 DF
\0 a            ; 224 E0 alpha
\0 \xdf         ; 225 E1 german double s (misused as Beta)
\x1 ?           ; 226 E2 Gamma
p i             ; 227 E3 pi
\x1 ?           ; 228 E4 Sigma (summation)
\x1 ?           ; 229 E5 sigma
\0 \xb5         ; 230 E6 mu
\x1 ?           ; 231 E7 gamma
\x1 ?           ; 232 E8 Phi
\x1 ?           ; 233 E9 Theta
\x1 ?           ; 234 EA Omega
\0 \xf0         ; 235 EB delta
\x1 ?           ; 236 EC infinity
/ 0             ; 237 ED empty set
\x1 ?           ; 238 EE element
\x1 ?           ; 239 EF intersection
= =             ; 240 F0 equivalence
\0 \xb1         ; 241 F1 plusminus
> =             ; 242 F2 greater equals
< =             ; 243 F3 smaller equals
\x1 ?           ; 244 F4 integral top
\x1 ?           ; 245 F5 integral bottom
\0 \xf7         ; 246 F6 divide
~ =             ; 247 F7 approx.
\0 \xb0         ; 248 F8 ring / degree
\0 .            ; 249 F9 centered dot
\0 -            ; 250 FA en dash
\x1 ?           ; 251 FB radical
^ n             ; 252 FC to the n'th power
\0 \xb2         ; 253 FD to the second power
\0 \xb7         ; 254 FE bullet
\0 \xa0         ; 255 FF non-breaking space
END

