;
; This file is a charset conversion module in text form.
;
; This module Converts IBM extended characters to ISO 8859-1 q-p characters.
;
; Format: ID, version, level,
;         from charset, to charset,
;         128 entries: first & second byte
;	  "END"
; Lines beginning with a ";" or a ";" after the entries are comments
;
; Unkown characters are mapped to the "?" character.
;
; cedilla = ,   ; dieresis = ..       ; acute = '
; grave = `     ; circumflex = ^      ; ring = o
; tilde = ~     ; caron = v 
; All of these are above the character, apart from the cedilla which is below.
;
; \ is the escape character: \0 means decimal zero,
; \dnnn where nnn is a decimal number is the ordinal value of the character
; \xnn where nn is a hexadecimal number
; e.g.: \d32 is the ASCII space character
; Two \\ is the character "\" itself.
;
0		; ID number
0		; version number
;
2		; level number
;
IBMPC		; from set
LATIN1QP        ; to set
;
= C 7           ; 128 C with cedilla
= F C           ; 129 u dieresis
= E 9           ; 130 e acute
= E 2           ; 131 a circumflex
= E 4           ; 132 a dieresis
= E 0           ; 133 a grave
= E 5           ; 134 a ring
= E 7           ; 135 c cedilla
= E A           ; 136 e circumflex
= E B           ; 137 e dieresis
= E 8           ; 138 e grave
= E F           ; 139 i dieresis
= E E           ; 140 i circumflex
= E C           ; 141 i grave
= C 4           ; 142 A dieresis
= C 5           ; 143 A ring
= C 9           ; 144 E acute
= E 6           ; 145 ae
= C 6           ; 146 AE
= F 4           ; 147 o circumflex
= F 6           ; 148 o dieresis
= F 3           ; 149 o acute
= D B           ; 150 u circumflex
= D 9           ; 151 u grave
= F F           ; 152 y dieresis
= D 6           ; 153 O dieresis
= D C           ; 154 U dieresis
= F 8           ; 155 o slash (CP865/850 mapping)
= A 3           ; 156 pound sterling
= D 8           ; 157 O slash (CP865/850 mapping)
P t             ; 158 Pt
f l             ; 159 florin
= E 1           ; 160 a acute
= C C           ; 161 i grave
= F 2           ; 162 o grave
= F 9           ; 163 u grave
= F 1           ; 164 n tilde
= D 1           ; 165 N tilde
= A A           ; 166 ord feminine
= B A           ; 167 ord masculine
= B F           ; 168 question downwards
\0 -            ; 169
= A C           ; 170 logical not
= B D           ; 171 half fraction
= B C           ; 172 quarter fraction
= A 1           ; 173 exclam downwards
= A B           ; 174 guillemot left
= B B           ; 175 guillemot right
\0 #            ; 176
\0 #            ; 177
\0 #            ; 178
\0 |            ; 179
\0 |            ; 180
\0 |            ; 181
\0 |            ; 182
\0 +            ; 183
\0 +            ; 184
\0 |            ; 185
\0 |            ; 186
\0 +            ; 187
\0 +            ; 188
\0 +            ; 189
\0 +            ; 190
\0 +            ; 191
\0 +            ; 192
\0 -            ; 193
\0 -            ; 194
\0 |            ; 195
\0 -            ; 196
\0 +            ; 197
\0 |            ; 198
\0 |            ; 199
\0 +            ; 200
\0 +            ; 201
\0 =            ; 202
\0 =            ; 203
\0 |            ; 204
\0 =            ; 205
\0 +            ; 206
\0 =            ; 207
\0 -            ; 208
\0 =            ; 209
\0 -            ; 210
\0 +            ; 211
\0 +            ; 212
\0 +            ; 213
\0 +            ; 214
\0 |            ; 215
\0 +            ; 216
\0 +            ; 217
\0 +            ; 218
\0 #            ; 219
\0 n            ; 220
\0 |            ; 221
\0 |            ; 222
\0 ~            ; 223
\0 a            ; 224 alpha
= D F           ; 225 german double s (misused as Beta)
\x1 ?           ; 226 Gamma
p i             ; 227 pi
\x1 ?           ; 228 Sigma (summation)
\x1 ?           ; 229 sigma
= B 5           ; 230 mu
\x1 ?           ; 231 gamma
\x1 ?           ; 232 Phi
\x1 ?           ; 233 Theta
\x1 ?           ; 234 Omega
= F 0           ; 235 delta
\x1 ?           ; 236 infinity
= F 8           ; 237 o slash
\x1 ?           ; 238 element
\x1 ?           ; 239 intersection
= =             ; 240 equivalence
= B 1           ; 241 plusminus
> =             ; 242 greater equals
< =             ; 243 smaller equals
\x1 ?           ; 244 integral top
\x1 ?           ; 245 integral bottom
= F 7           ; 246 divide
~ =             ; 247 approx.
= B 0           ; 248 ring / degree
\0 .            ; 249 centered dot
\0 -            ; 250 en dash
\x1 ?           ; 251 radical
^ n             ; 252 to the n'th power
= B 2           ; 253 to the second power
= B 7           ; 254 bullet
= A 0           ; 255 non-breaking space
END

