/*---------------------------------------------------------------------+
( Exec to load in the current inbasket mail and return the current     )
( userid                                                               )
+----------------------------------------------------------------------+
( Written By: Ken Taylor                                               )
(             InnoVal Systems Solutions                                )
(                                                                      )
( (c) 1995, InnoVal Systems Solutions Inc.  All rights reserved.       )
+---------------------------------------------------------------------*/

 Signal On Syntax

 NUMERIC DIGITS 22

'VMPUSH SET'
'CP SET  MSG OFF'
'CP SET IMSG OFF'
'CP SET EMSG OFF'

 MaxCronNumber = 0

 Call REMOVE_FILE 'OFSMAIL OFSLOGXX'

'ESTATE OFFICE MODULE *'
 if RC = 0 then 'OFFICE INBASKET GIB ($LEAVEIB'
 else           'PROFS  INBASKET GIB ($LEAVEIB'

'SET CMSTYPE RT'
'VMFCLEAR'
 Say '** Post Road VM 1.20f'

 Do Forever
  'DESBUF'

   pull cmd

   Select
     When cmd = 'START' then do
       Call REMOVE_FILE 'OFSMAIL OFSLOGXX'

       Call SCAN_READER   /* look for paperclip files */

       Address 'COMMAND' 'COPY OFSMAIL OFSLOGfl A0 = OFSLOGXX = (REP'
       If RC <> 0 then do
         Say '** A-Disk space has been exceeded'
         Say '** Attempting to create a temporary mini-disk'
         if GET_TEMP_DISK(3) = 0 then do
           Say '** Temporary mini-disk ('tfm') was created'
           Address 'COMMAND' 'COPY OFSMAIL OFSLOGfl A0',
                             '= OFSLOGXX 'tfm' (REP'
         end
         else Say '** A temporary mini-disk could not be created'
       end

      'SET CMSTYPE RT'
      'ESTATE OFSMAIL OFSLOGXX *'
       If RC = 0 then Say '** POSTROAD STARTING'
       else do
         if PULL_DOCUMENTS() = 0 then
              Say '** POSTROAD STARTING (DOCS ONLY)'
         else Say '** POSTROAD STARTING NOMAIL'
       end /* else */
     end
     When cmd = 'STARTNEW' then do
       Call SCAN_READER   /* look for paperclip files */

       Address 'COMMAND' 'COPY OFSMAIL OFSLOGfl A0 = OFSLOGXX = (REP'
       If RC <> 0 then do
         Say '** A-Disk space has been exceeded'
         Say '** Attempting to create a temporary mini-disk'
         if GET_TEMP_DISK(3) = 0 then do
           Say '** Temporary mini-disk ('tfm') was created'
           Address 'COMMAND' 'COPY OFSMAIL OFSLOGfl A0',
                             '= OFSLOGXX 'tfm' (REP'
         end
         else Say '** A temporary mini-disk could not be created'
       end

      'SET CMSTYPE RT'
      'ESTATE OFSMAIL OFSDATA A'
       If RC = 0 then do
         ret = GET_NEW_MAIL('A')
         If ret = 5 then do
           Say '** A-Disk space has been exceeded'
           Say '** Attempting to create a temporary mini-disk'
           if GET_TEMP_DISK(3) = 0 then do
             Say '** Temporary mini-disk ('tfm') was created'
             ret = GET_NEW_MAIL(tfm)
           end
           else Say '** A temporary mini-disk could not be created'
         end

        'SET CMSTYPE RT'
         If      ret = 0 then Say '** POSTROAD STARTING NEWMAIL'
         else if ret = 1 then Say '** POSTROAD STARTING'
         else do
          'ESTATE OFSMAIL DOCMENTS *'
           if RC = 0 then Say '** POSTROAD STARTING (DOCS ONLY)'
           else           Say '** POSTROAD STARTING NOMAIL'
         end
       end
       else Say '** POSTROAD STARTING NOMAIL'
     end
     When cmd = 'NICKNAME' then do
      'SET CMSTYPE RT'
      'LISTFILE OFS OFSMCNTL A'
       If RC = 0 then Say '** NICKNAME FOUND'
       else           Say '** NICKNAME NOT FOUND'
     end
     When cmd = 'END' then do
       time = space(translate(time(),' ',':'),0)
       date = date('SORTED')''time
      'GLOBALV SELECT POSTROAD SETLP LAST_DATE 'date

       if MaxCronNumber <> 0 then
        'GLOBALV SELECT POSTROAD SETLP MAXCRONNUMBER 'MaxCronNumber

       Call REMOVE_FILE 'OFSMAIL OFSLOGXX'

      'SET CMSTYPE RT'

       if PULL_DOCUMENTS() = 0 then Say '** POSTROAD ENDED (DOCS EXIST)'
       else                         Say '** POSTROAD ENDED'
     end
     When cmd = 'ENDNEW' then do
       time = space(translate(time(),' ',':'),0)
       date = date('SORTED')''time
      'GLOBALV SELECT POSTROAD SETLP LAST_DATE 'date

       if MaxCronNumber <> 0 then
        'GLOBALV SELECT POSTROAD SETLP MAXCRONNUMBER 'MaxCronNumber

      'DESBUF'
      'LISTFILE OFSNEW OFSLOGXX * (STACK'
       if RC = 0 then pull . . fm .
       else fm = 'A'
      'DESBUF'
       fm = substr(fm,1,1)
       Address 'COMMAND' 'ERASE  OFSNEW  OFSLOGXX 'fm
       Address 'COMMAND' 'ERASE  OFSNEW  OFSDATA  'fm
       if fm <> 'A' then 'REL 'fm' (DET'

       Call REMOVE_FILE 'OFSMAIL OFSLOGXX'

      'SET CMSTYPE RT'

      'ESTATE OFSMAIL DOCMENTS *'
       if RC = 0 then Say '** POSTROAD ENDED (DOCS EXIST)'
       else           Say '** POSTROAD ENDED'
     end
     When cmd = 'UPDATE' then do
      'SET CMSTYPE RT'
      'VMFCLEAR'
       Say '** POSTROAD BEGIN UPDATE **'
      'SET CMSTYPE HT'

       RC = UPDATE_INBASKET()

      'SET CMSTYPE RT'
       Say '** POSTROAD END UPDATE **'
     end
     When cmd = 'RDRLIST' then do
      'SET CMSTYPE RT'
      'VMFCLEAR'
       Say '** POSTROAD SCANNING RDR FILES **'
      'SET CMSTYPE HT'

       ret = GET_RDRFILES()
      'SET CMSTYPE RT'
       if ret = 0 then Say '** POSTROAD RDR FILES FOUND **'
       else            Say '** POSTROAD RDR FILES NONE **'
     end
     When word(cmd,1) = 'POSTTRANS' then do
       Parse Var cmd . spool id .
      'QUERY RDR 'spool
       If RC = 0 then do
        'QUERY 'id
         If RC = 45 then RC = 0
         If RC = 0 then do
          'SET CMSTYPE RT'
          'TRANSFER RDR 'spool id
           If RC = 0 then Say '** TRANSFER DONE **'
           else do
             Say '** TRANSFER DONE ERROR **'
             Say '** ERROR('RC') TRANSFERING RDR ('spool') TO ('id')'
           end
         end
         else do
          'SET CMSTYPE RT'
           Say '** TRANSFER DONE ERROR **'
           Say '** USERID ('id') WAS NOT FOUND'
         end
       end
       else do
        'SET CMSTYPE RT'
         Say '** TRANSFER DONE ERROR **'
         Say '** RDR SPOOL ID ('spool') WAS NOT FOUND'
       end
     end
     When word(cmd,1) = 'POSTREC' then do
       Parse Var cmd . spool fn ft fm .
      'QUERY RDR 'spool
       If RC = 0 then do
        'SET CMSTYPE RT'
        'RECEIVE 'spool fn ft fm' (REPLACE'
         If RC = 0 then Say '** RECEIVE DONE **'
         else do
           Say '** RECEIVE DONE ERROR **'
           Say '** ERROR('RC') RECEIVING RDR ('spool') AS ('fn ft fm')'
         end
       end
       else do
        'SET CMSTYPE RT'
         Say '** RECEIVE DONE ERROR **'
         Say '** SPOOL ID ('spool') WAS NOT FOUND'
       end
     end
     When cmd = 'UPNOTES' then do
       fm = UPLOAD_NOTES()

      'SET CMSTYPE RT'
      'VMFCLEAR'
       Say '** POSTROAD FILEMODE --' fm
     end
     When cmd = 'SENDNOTES' then do
       Call SEND_NOTES

      'SET CMSTYPE RT'
      'VMFCLEAR'
       Say '** POSTROAD COMPLETED **'
     end
     When cmd = 'DELETE' then do
      'SET CMSTYPE RT'
      'VMFCLEAR'
       Say '** POSTROAD BEGIN DELETE **'
      'SET CMSTYPE HT'

       RC = DELETE_INBASKET()

      'SET CMSTYPE RT'
       Say '** POSTROAD END DELETE **'
     end
     When cmd = 'USERID' then do
      'SET CMSTYPE RT'
      'VMFCLEAR'
       Say '** POSTROAD -- 'userid()
     end
     When cmd = ''     then LEAVE
     When cmd = 'POSTQUIT' then LEAVE
     Otherwise do
       Address 'CMS' cmd
      'VMFCLEAR'
     end
  end /* select */
end /* do...forever */

/*---------------------------------------------------------------------+
( Exit the exec.  One way in...One way out.                            )
+---------------------------------------------------------------------*/
QUIT:

 Call REMOVE_FILE 'OFSMAIL OFSLOGXX'
 Call REMOVE_FILE 'OFSMAIL DOCMENTS'
 Call REMOVE_FILE 'OFSMAIL RDRLIST'
 Call REMOVE_FILE 'OFSNEW  OFSLOGXX'

'ESTATE OFFICE MODULE *'
 if RC = 0 then 'OFFICE INBASKET PIB'
 else           'PROFS  INBASKET PIB'

'VMPOP SET'
'VMFCLEAR'
 EXIT(0)

/*---------------------------------------------------------------------+
( Display any syntax errors on the screen                              )
+---------------------------------------------------------------------*/
SYNTAX:
  ret = RC
 'SET CMSTYPE RT'
  Say 'Error' ret 'in line' sigl ':' errortext(ret)
/*  Say sigl':'sourceline(sigl) */
  pull .
  Signal QUIT
  RETURN(0)

/*--------------------------------------------------------------------+
( Open the mail so that any notes are received                        )
+--------------------------------------------------------------------*/
OPEN_THE_MAIL:Procedure
 Parse value diag('8','QUERY FILES',80) with . 'FILES: 'tfiles' RDR,' .
 if datatype(tfiles) <> 'NUM' then tfiles = 0

'SET CMSTYPE HT'
'PROFS TERMNL TTY'
'DESBUF'
 if tfiles > 0 then Queue 'QUIT'
 Queue 'RET'
'PROFS INBASKET GIB'
'PROFS TERMNL'

 Call SCAN_READER   /* look for paperclip files */

 if symbol('RET_CODE') = 'LIT' then ret_code = 0
 RETURN(ret_code)

/*---------------------------------------------------------------------+
( Scan the reader list for paperclip files                             )
+---------------------------------------------------------------------*/
SCAN_READER:Procedure

 Parse value diag('8','QUERY FILES',80) with . 'FILES: 'files' RDR,' .
 if datatype(files) <> 'NUM' then files = 0

 files = diag(8,'QUERY READER ALL',(81+files*81))
 start = index(files,'15'x)
 cnt   = 0
 Do while length(files) > start+1
   last      = index(files,'15'x,start+1)
   this_file = substr(files,start+1,last-start-1)
   start     = last

   Parse Var this_file id spool . . . . . fdate ftime fn ft .

  'CP ORDER READER 'spool
  'MAKEBUF'
  'NETDATA QUERY (LIFO MSGALL)'
   if RC = 0 then Do
     pull line
     Parse Var line . fn ft . . . . user node .
   end
  'DROPBUF'

   Select
     When length(ft) < 6 then nop
     When substr(ft,length(ft)-4,5) = 'PCLIP' then do
      'SET CMSTYPE HT'
      'RECEIVE 'spool fn ft ' A (REP NOP OLDDATE'
      'SET CMSTYPE RT'
     end
     Otherwise nop
   end /* select */
 end /* do until */

 If symbol('RET_CODE') = 'LIT' then ret_code = 0
 RETURN

/*---------------------------------------------------------------------+
( Query the mini-disk to see where the new notes should go             )
+---------------------------------------------------------------------*/
UPLOAD_NOTES:Procedure
 tfm = 'A'

 if CHECK_DISK() > 55 then do
   RC = GET_TEMP_DISK(3) /* get temp disk space */
   if RC <> 0 then tfm = 'A'
 end

 RETURN(tfm)

/*---------------------------------------------------------------------+
( Update the inbasket deleting the specified notes                     )
+---------------------------------------------------------------------*/
UPDATE_INBASKET:Procedure

 ret_code = 0
 delete.  = 0

 /****************************************/
 /* read the list of notes to be deleted */
 /****************************************/

 delfile = 'OFSMAIL DELETE A'
'EXECIO * DISKR 'delfile' (STEM LINE. FINIS'
 If RC = 0 then do i = 1 to line.0
   line        = strip(line.i)
   delete.line = 1
 end
 else ret_code = RC


 if ret_code = 0 then do
   /***********************************/
   /* update the OFSMAIL OFSDATA file */
   /***********************************/
   file = 'OFSMAIL OFSDATA A'

  'DESBUF'
  'LISTFILE 'file' (ALL STACK'
   if RC = 0 then pull . . . . lrecl .

   ncnt = 0
   rec. = ''
   cnt  = 0
  'EXECIO * DISKR 'file' (STEM LINE. FINIS'
   If RC = 0 then do i = 1 to line.0
     line = line.i
     if substr(line,1,1) = 'FF'x & substr(line,2,1) = 'FF'x then do
       /*-----------------*/
       /* check for notes */
       /*-----------------*/
       zip     = substr(line,5,12)
       subject = strip(substr(line,66,65))
       chk     = zip' 'subject
       if delete.chk = 1 then do
         ncnt       = ncnt + 1
         delete.chk = 0
         line       = overlay('2A'x,line,192)
       end
     end
     else if substr(line,1,8) <> 'IBHEADER' then do
       /*---------------------*/
       /* check for documents */
       /*---------------------*/
       zip     = substr(line,1,12)
       subject = strip(substr(line,66,65))
       chk     = zip' 'subject
       if delete.chk = 1 then do
         ncnt       = ncnt + 1
         delete.chk = 0
         line       = overlay('2A'x,line,192)
       end
     end

     cnt     = cnt + 1
     rec.cnt = line
   end
   else ret_code = RC
 end /* if...ret_code */

 if ret_code = 0 & ncnt > 0 then do
   /*******************************/
   /* erase the file & rewrite it */
   /*******************************/
   tfile = 'OFSMAIL OFSTEMP A'
  'ESTATE 'tfile
   If RC = 0 then Address 'COMMAND' 'ERASE 'tfile

   if cnt > 0 then do
    'EXECIO 'cnt' DISKW 'tfile' 1 F 'lrecl' (STEM REC. FINIS'
     If RC = 0 then do
       Address 'COMMAND' 'ERASE 'file
      'RENAME 'tfile file

      'ESTATE OFFICE MODULE *'
       if RC = 0 then ovMod = 'OFFICE'
       else           ovMod = 'PROFS'

       ovMod' INBASKET $FILDEL'
       ovMod' INBASKET PIB'
       ovMod' INBASKET GIB ($LEAVEIB'
     end
     else do
       ret_code = RC
      'SET CMSTYPE RT'
       Say 'Error('ret_code') updating inbasket files'
      'SET CMSTYPE HT'
       Address 'COMMAND' 'ERASE 'tfile
     end
   end
 end /* if...ncnt */

 Address 'COMMAND' 'ERASE 'delfile

 RETURN(ret_code)

/*---------------------------------------------------------------------+
( Delete the inbasket                                                  )
+---------------------------------------------------------------------*/
DELETE_INBASKET:Procedure
 ret_code = 0

 /***********************************/
 /* update the OFSMAIL OFSDATA file */
 /***********************************/
 file = 'OFSMAIL OFSDATA A'

'DESBUF'
'LISTFILE 'file' (ALL STACK'
 if RC = 0 then pull . . . . lrecl .

 rec. = ''
 cnt  = 0

'EXECIO * DISKR 'file' (STEM LINE. FINIS'
 If RC = 0 then do i = 1 to line.0
   line = line.i
   if substr(line,1,8) <> 'IBHEADER' then do
     line    = overlay('2A'x,line,192)
     cnt     = cnt + 1
     rec.cnt = line
   end
   else do
     cnt     = cnt + 1
     rec.cnt = line
   end
 end
 else ret_code = RC

 if ret_code = 0 then do
   /*******************************/
   /* erase the file & rewrite it */
   /*******************************/
   tfile = 'OFSMAIL OFSTEMP A'
  'ESTATE 'tfile
   If RC = 0 then Address 'COMMAND' 'ERASE 'tfile

   if cnt > 0 then do
    'EXECIO 'cnt' DISKW 'tfile' 1 F 'lrecl' (STEM REC. FINIS'
     If RC = 0 then do
       Address 'COMMAND' 'ERASE 'file
      'RENAME 'tfile file

      'ESTATE OFFICE MODULE *'
       if RC = 0 then ovMod = 'OFFICE'
       else           ovMod = 'PROFS'

       ovMod' INBASKET $FILDEL'
       ovMod' INBASKET PIB'
       ovMod' INBASKET GIB ($LEAVEIB'
     end
     else do
       ret_code = RC
      'SET CMSTYPE RT'
       Say 'Error('ret_code') updating inbasket files'
      'SET CMSTYPE HT'
       Address 'COMMAND' 'ERASE 'tfile
     end
   end
 end /* if...ncnt */

 RETURN(ret_code)

/*---------------------------------------------------------------------+
( Check the percentage of free A-disk space                            )
+---------------------------------------------------------------------*/
CHECK_DISK:Procedure
 per = 100
'DESBUF'
'QUERY DISK A (STACK'
 If RC = 0 then do
   pull .
   pull . . . . . . . . per .
   Parse Var per .'-'per .
   if datatype(per) <> 'NUM' then per = 100
 end
'DESBUF'
 RETURN(per)

/*---------------------------------------------------------------------+
( Create a temporary mini-disk for the user                            )
+---------------------------------------------------------------------*/
GET_TEMP_DISK:Procedure Expose tfm taddr
 arg tcylinders

'SET CMSTYPE HT'
 If datatype(tcylinders) <> 'NUM' then tcylinders = 1

 lab = 'TEMP'
'MAKEBUF'
'GETFMADR'
 If RC <> 0 then ret_code = -3
 else do
   pull . tfm taddr .
  'EXECIO 0 CP(STR DEFINE T3380 'taddr tcylinders
   If RC <> 0 then 'EXECIO 0 CP(STR DEFINE T3390 'taddr tcylinders

   If RC <> 0 then ret_code = -3
   else do
     Queue 'YES'
     Queue  strip(substr(lab,1,6))
    'FORMAT 'taddr tfm
     If RC <> 0 then ret_code = -3
   end
 end
 if ret_code = -3 then do
  'EXECIO * CP(STR DETACH 'taddr
  'RELEASE 'tfm
 end
'DROPBUF'
 SET CMSTYPE RT
 If datatype(ret_code) <> 'NUM' then ret_code = 0
 RETURN(ret_code)

/*---------------------------------------------------------------------+
( Send the notes that were transfered up to the host                   )
+---------------------------------------------------------------------*/
SEND_NOTES:Procedure
 max   = 1000
 clip. = 0

 file = 'POSTBLUE SENDNOTE *'

'DESBUF'
'LISTFILE 'file' (DATE STACK'
 If RC = 0 then pull . . fm . . recs . fdate .

 If RC = 0 & right(fdate,8,'0') = date('USA') then do
   fm   = substr(fm,1,1)
   file = subword(file,1,2) fm

   times = recs % max
   if recs // max > 0 then times = times + 1

   note. = 0
   do z = 1 to times
     start = (z-1)*max + 1
     if z = times then read = recs//max
     else              read = max

    'EXECIO 'read' DISKR 'file start' (STEM LINE. FINIS'
     If RC = 0 then do i = 1 to read
       line     = line.i

       note.0   = note.0 + 1
       tot      = note.0
       note.tot = line

       tchar = substr(line,1,1)
       if c2d(tchar) = 31 then do
         RC    = SEND_CURRENT_NOTE(fm)
         note. = 0
       end /* if */
     end /* if */
     else do
       ret_code = RC
       LEAVE
     end /* else */
   end /* do...z */

   Address 'COMMAND' 'ERASE 'file
   fm = translate(fm)
   if fm <> 'A' then 'REL 'fm' (DET'
 end /* if */

 /*----------------------*/
 /* erase any clip files */
 /*----------------------*/
 if clip.0 > 0 then do i = 1 to clip.0
   Address 'CMS' 'ERASE 'clip.i
 end
 RETURN

/*--------------------------------------------------------------------+
( Send the note that was just read                                    )
+--------------------------------------------------------------------*/
SEND_CURRENT_NOTE:Procedure Expose note. clip.
 arg fm
 ret_code = 0
 to.      = 0
 cc.      = 0
 inet.    = 0
 /*-------------------------------*/
 /* find the end of the addresses */
 /*-------------------------------*/
 body = 1
 do i = 1 to note.0
   body = i
   if (c2d(substr(note.i,1,1)) <> 30) then LEAVE
   else do
     if pos('.',note.i) > 0 & pos('@',note.i) > 0 then do
       inet.0 = inet.0 + 1
       tot    = inet.0
       Parse Var note.i 1 . 3 inet.tot
       if pos('<',inet.tot) > 0 then
         Parse Var inet.tot . '<'inet.tot'>'
       inet.tot = translate(inet.tot,'  ','()')
     end
     else if c2d(substr(note.i,2,1)) = 2 then do
       cc.0   = cc.0 + 1
       tot    = cc.0
       Parse Var note.i 1 . 3 cc.tot
     end
     else do
       to.0   = to.0 + 1
       tot    = to.0
       Parse Var note.i 1 . 3 to.tot
     end
   end
 end

 distlist_file = CREATE_DIST_LIST()

 /*-------------------------*/
 /* send any internet notes */
 /*-------------------------*/
 if inet.0 > 0 then RC = SEND_INET_NOTES(body,fm)

 /*----------------------*/
 /* send any profs notes */
 /*----------------------*/
 if to.0   > 0 then RC = SEND_PROFS_NOTES(body,fm)

 if distlist_file <> '' then Address 'COMMAND' 'ERASE 'distlist_file

 RETURN(ret_code)

/*---------------------------------------------------------------------+
( Create a distribution list file                                      )
+---------------------------------------------------------------------*/
CREATE_DIST_LIST:Procedure Expose to. cc.
 if to.0 = 0 then do
   do i = 0 to cc.0
     to.i = cc.i
   end
   cc.0 = 0
 end

 if to.0 > 4 then do
   fn   = 'POS$$OAD'
   file = fn' OFSMLIST A'
  'ESTATE 'file
   If RC = 0 then Address 'COMMAND' 'ERASE 'file

  'EXECIO 'to.0' DISKW 'file' 1 F 80 (STEM TO. FINIS'
   If RC = 0 then do
     to.1 = fn
     to.0 = 1
   end
   else file = ''
 end
 else file = ''

 RETURN(file)

/*---------------------------------------------------------------------+
( Send any internet notes that were found                              )
+---------------------------------------------------------------------*/
SEND_INET_NOTES:Procedure Expose note. inet.
 arg body,fm

 ret_code = 0
 do z = 1 to inet.0
   line.    = ''
   count    = 0

   Parse Var inet.z userid'@'node

   count      = count + 1
   line.count = 'OPTIONS: NOACK  NOLOG    SHORT  NONOTEBOOK ALL'
   count      = count + 4

   Parse Value date('SORTED') With 1 yr 5 . 7 dd .
   dd = dd + 0

  'IDENTIFY ( LIFO'
   parse pull vmid . vmnode . . . time timezone .

   count      = count + 1
   line.count = 'X-Mailer: Post Road Mailer (Blue Edition)'
   count      = count + 1
   line.count = 'Date: 'dd date('MONTH') yr',' time timezone
   count      = count + 1
   line.count = 'From: 'left(vmid,8,' ')' at 'vmnode
   count      = count + 1
   line.count = 'To:   'userid' at 'node

   do i = body to note.0 - 1
     if c2d(substr(note.i,1,1))=19 & c2d(substr(note.i,2,1))=90 then do
       nop  /* ignore paperclips */
     end
     else do
       count      = count + 1
       line.count = note.i
     end
   end
   line.0 = count

   file = '$$PROFS$$ NOTE 'fm
  'ESTATE 'file
   If RC = 0 then Address 'COMMAND' 'ERASE 'file

  'EXECIO 'line.0' DISKW 'file' (STEM LINE. FINIS'
   If RC = 0 then do
    'ISEND 'file' (NOTE NOLOG NOPROMPT'
     ret_code = RC
   end
   else ret_code = 1

  'ESTATE 'file
   If RC = 0 then Address 'COMMAND' 'ERASE 'file

   if ret_code <> 0 then LEAVE
 end

 RETURN(ret_code)

/*---------------------------------------------------------------------+
( Send any profs notes that were found                                 )
+---------------------------------------------------------------------*/
SEND_PROFS_NOTES:Procedure Expose note. to. cc. clip.
 arg body,fm

 ret_code = 0

 line.    = ''
 count    = 0
 do i = body to note.0 - 1
   if c2d(substr(note.i,1,1))=19 & c2d(substr(note.i,2,1))=90 then do
     /*--------------------------*/
     /* this is a paperclip file */
     /*--------------------------*/

     spot = lastpos('\',note.i) + 1
     file = substr(note.i,spot,length(note.i) - spot + 1)
     Parse Upper Var file fn'.'ft rest
     ft   = ft'PCLIP'

    'DESBUF'
    'LISTFILE 'fn ft' * (ALL STACK'
     If RC = 0 then do
       pull . . fm .

       fm         = substr(fm,1,1)

       do j = 1 to to.0
         RC = SEND_THE_FILE(to.j,fn ft fm)
       end
       do j = 1 to cc.0
         RC = SEND_THE_FILE(cc.j,fn ft fm)
       end

       count      = count + 1
       line.count = 'Paperclip: 'fn ft rest

       clip.0     = clip.0 + 1
       tot        = clip.0
       clip.tot   = fn ft fm
     end
   end
   else do
     count      = count + 1
     line.count = note.i

     if pos('SUBJECT:',translate(line.count)) = 1 then
       Parse Var line.count 1 . 10 line.count
   end
 end
 do i = 1 to cc.0
   count      = count + 1
   line.count = '.cc 'cc.i
 end

 line.0 = count

'ESTATE OFFICE MODULE *'
 if RC = 0 then ovMod = 'OFFICE'
 else           ovMod = 'PROFS'

'SET CMSTYPE HT'
'MAKEBUF'
 buff = RC
 ovMod ' TERMNL TTY'
 do i = 1 to line.0
   if strip(line.i) = '' then line = copies(' ',30)
   else                       line = line.i

   Queue line
 end
 Queue ''
 user = ''
 do i = 1 to to.0
   user = user to.i
 end

 ovMod ' NOTE 'user

 ret_code = RC
 ovMod ' TERMNL'
'SET IMPEX ON'
'DESBUF'

 RETURN(ret_code)

/*---------------------------------------------------------------------+
( Send the file to the given id or dist list                           )
+---------------------------------------------------------------------*/
SEND_THE_FILE:Procedure
 arg id,file

 if pos('(',id) > 0 then do
   Parse Var id node'('id')'
   if strip(node) <> '' then
     Address 'CMS' 'SENDFILE 'file' TO 'id' AT 'node
   else
     Address 'CMS' 'SENDFILE 'file' TO 'id
 end
 else do
   distfile = id 'OFSMLIST *'
  'ESTATE 'distfile
   if RC = 0 then do
    'EXECIO * DISKR 'distfile' (STEM LINE. FINIS'
     If RC = 0 then do i = 1 to line.0
       if substr(line.i,1,1) <> '.' then do
         Parse Var line.i id .

         RC = SEND_THE_FILE(id,file)
       end
     end
   end
   else do
     Address 'CMS' 'SENDFILE 'file' TO 'id
   end
 end

 RETURN(0)

/*---------------------------------------------------------------------+
( Return the current VM node                                           )
+---------------------------------------------------------------------*/
NODE:Procedure
'ID (LIFO'
 pull . . node .
 RETURN(node)

/*--------------------------------------------------------------------*/
/* Check to see if there is any new mail                              */
/*--------------------------------------------------------------------*/
GET_NEW_MAIL:Procedure Expose MaxCronNumber
 arg fm .

 if fm = '' then fm = 'A'

 ret_code = 3

 file     = 'OFSMAIL OFSDATA A'
 tfile    = 'OFSNEW  OFSDATA 'fm
 savefile = 'OFSMAIL DOCMENTS 'fm

'ESTATE 'tfile
 If RC = 0 then Address 'COMMAND' 'ERASE 'tfile
'ESTATE 'savefile
 If RC = 0 then Address 'COMMAND' 'ERASE 'savefile

'GLOBALV SELECT POSTROAD GET MAXCRONNUMBER'

'GLOBALV SELECT POSTROAD GET LAST_DATE'
 last_date = strip(last_date)
 if length(last_date) = 14 & datatype(last_date) = 'NUM' then do
  /*--------------------------------*/
  /* see if there any any new notes */
  /*--------------------------------*/
  'DESBUF'
  'LISTFILE 'file' (ALL STACK'
   if RC = 0 then pull . . . . lrecl .

  'EXECIO * DISKR 'file' (STEM LINE. FINIS'
   If RC = 0 then do
     notes  = 0
     new    = 0
     maxdoc = 0
     cnt    = 0

     /*-----------------------------------*/
     /* look for the last document pulled */
     /*-----------------------------------*/
     do i = 1 to line.0
       if substr(line.i,1,12) = MaxCronNumber then do
         maxdoc = i
         LEAVE
       end
     end /* do i */

     /*----------------------------*/
     /* browse the mail index file */
     /*----------------------------*/
     do i = 1 to line.0
       line = line.i
       if substr(line,1,1) = 'FF'x & substr(line,2,1) = 'FF'x  then do
         notes = notes + 1
         stamp = substr(line,5,12)

         if substr(line,133,1) = '20'x then
              Parse Var stamp 1 dd 3 mm 5 yy 7 time
         else Parse Var stamp 1 mm 3 dd 5 yy 7 time

         if yy < 50 then yy = '20'yy
         else            yy = '19'yy
         stamp = yy''mm''dd''time
         if stamp > last_date then do
           new = new + 1
           cnt = cnt + 1
          'EXECIO 1 DISKW 'tfile cnt' F 'lrecl' (VAR LINE FINIS'
           If RC <> 0 then do
             ret_code = 5
             LEAVE
           end
         end
       end /* if */
       else if substr(line,1,8) <> 'IBHEADER' then do
         /*---------------------*/
         /* Could be a document */
         /*---------------------*/
         if i > maxdoc then do
           RC = READ_DOCUMENT(savefile,line)
           If RC = 0 then do
             cnt = cnt + 1
            'EXECIO 1 DISKW 'tfile cnt' F 'lrecl' (VAR LINE FINIS'
             If RC <> 0 then do
               ret_code = 5
               LEAVE
             end
           end
           else if RC = 5 then do
             ret_code = 5
             LEAVE
           end
         end
       end
     end /* do...i */
   end /* if */

   if ret_code = 3 & new > 0 then do
     if new < notes then do
       /*--------------------------------------*/
       /* copy the new notes if any were found */
       /*--------------------------------------*/
       if new <> 1 then Say '** ('new') New notes were found'
       else             Say '** ('new') New note was found'
       ret_code = GET_NEW_NOTES(fm,notes - new)
     end
     else ret_code = 1
   end
 end
 else ret_code = 1

 if ret_code = 5 then do
  'ESTATE 'tfile
   If RC = 0 then Address 'COMMAND' 'ERASE 'tfile
 end
 else if ret_code = 1 & fm <> 'A' then 'REL 'fm' (DET'

 RETURN(ret_code)

/*--------------------------------------------------------------------*/
/* Read the mail file and save the new notes                          */
/*--------------------------------------------------------------------*/
GET_NEW_NOTES:Procedure
 arg fm,old

 ret_code = 0
 file     = 'OFSMAIL OFSLOGXX *'
 tfile    = 'OFSNEW  OFSLOGXX 'fm
'ESTATE 'tfile
 If RC = 0 then Address 'COMMAND' 'ERASE 'tfile

'DESBUF'
'LISTFILE 'file' (ALL STACK'
 if RC = 0 then pull . . . . . nrecs .
'DESBUF'

 cnt    = 0
 max    = 1000
 tstart = 1
 times = nrecs % max
 if nrecs // max > 0 then times = times + 1
 do z = 1 to times
   start = ((z-1) * max) + 1
   if z < times then tread = max
   else              tread = nrecs // max

   rec.  = 0
  'EXECIO 'tread' DISKR 'file start' (STEM LINE. FINIS'
   If RC = 0 then do i = 1 to line.0
     line = line.i

     if cnt >= old then do
       rec.0   = rec.0 + 1
       tot     = rec.0
       rec.tot = line
     end

     if substr(line,1,1) = 'FF'x &,
        substr(line,2,1) = 'FF'x then cnt = cnt + 1
   end /* do...i */

  'EXECIO 'rec.0' DISKW 'tfile tstart' (STEM REC. FINIS'
   If RC = 0 then do
     tstart = tstart + rec.0
   end
   else do
     ret_code = 5
     LEAVE
   end
 end /* do...z */

 if ret_code = 5 then do
  'ESTATE 'tfile
   If RC = 0 then Address 'COMMAND' 'ERASE 'tfile
 end

 RETURN(ret_code)

/*--------------------------------------------------------------------*/
/* see if the user has any documents in the document database         */
/*--------------------------------------------------------------------*/
PULL_DOCUMENTS:Procedure Expose MaxCronNumber
 RC = EXTRACT_DOCUMENTS('A')
 If RC = 5 then do
  'SET CMSTYPE RT'
   Say '** A-Disk space has been exceeded'
   Say '** Attempting to create a temporary mini-disk'
   if GET_TEMP_DISK(3) = 0 then do
     Say '** Temporary mini-disk ('tfm') was created'
     RC = EXTRACT_DOCUMENTS(tfm)
   end
   else Say '** A temporary mini-disk could not be created'
 end
 ret_code = RC
'SET CMSTYPE RT'
 RETURN(ret_code)

/*-------------------------------------------------------------------*/
/* Pull all of the documents from the user's inbasket                */
/*-------------------------------------------------------------------*/
EXTRACT_DOCUMENTS:Procedure Expose MaxCronNumber
 arg fm

 savefile = 'OFSMAIL DOCMENTS 'fm
 ret_code = 1

'ESTATE 'savefile
 If RC = 0 then Address 'COMMAND' 'ERASE 'savefile

 file = 'OFSMAIL OFSDATA A'

'EXECIO * DISKR 'file' (STEM LINE. FINIS'
 If RC = 0 then do i = 2 to line.0
   line = line.i
   if substr(line,1,1) <> 'FF'x & substr(line,2,1) <> 'FF'x then do
     RC = READ_DOCUMENT(savefile,line)
     if      RC = 0 then ret_code = 0
     else if RC = 5 then do
       ret_code = 5
       LEAVE
     end
   end
 end

 RETURN(ret_code)

/*-------------------------------------------------------------------*/
/* Parse the doucment line and get the data                          */
/*-------------------------------------------------------------------*/
READ_DOCUMENT:Procedure Expose MaxCronNumber
 Parse arg savefile,line

 Parse Var line 1 tcron 13 . 20 spec 22 stat 23 . 33 tfrom 49 tto,
               65 . 66 sub 183 . 329 id 337 node 345 . 500 slip 560 .

 if stat = 'M' then stat = 'FINAL'
 else               stat = 'DRAFT'

 doc. = ''
 doc.SUBJECT = strip(sub)
 doc.FROMID  = strip(node)'('strip(id)')'
 doc.FROM    = strip(tfrom)
 doc.TO      = strip(tto)

 slip        =       translate(slip,' ',d2c( 0))
 slip        =       translate(slip,' ',d2c( 1))
 slip        =       translate(slip,' ',d2c( 3))
 slip        =       translate(slip,' ',d2c( 5))
 slip        =       translate(slip,' ',d2c(14))
 slip        =       translate(slip,' ',d2c(15))
 doc.RSLIP   = strip(translate(slip,' ',d2c(255)))

 if pos('HDC',tcron) = 0 then  /* don't include "paper" docs */
      ret_code = PULL_DOCUMENT(savefile,tcron,stat,spec)
 else ret_code = 1

 if ret_code = 5 then do
  'ESTATE 'savefile
   If RC = 0 then Address 'COMMAND' 'ERASE 'savefile
 end
 RETURN(ret_code)

/*--------------------------------------------------------------------*/
/* Read the docuement text from the file                              */
/*--------------------------------------------------------------------*/
PULL_DOCUMENT:Procedure Expose doc. MaxCronNumber
 arg savefile,cron,stat,spec

'ESTATE OFFICE MODULE *'
 If RC = 0 then ovMod = 'OFFICE'
 else           ovMod = 'PROFS'

 MaxCronNumber = cron

 file = substr(cron,3,3)''substr(cron,9,4)

'SET CMSTYPE HT'
'DESBUF'
'LISTFILE *'file' * A (STACK'
 If RC = 0 then do queued()
   pull fn ft fm .
   Address 'COMMAND' 'ERASE 'fn ft fm
 end

 ovMod 'RETRIEVE 'substr(cron,1,8) substr(cron,9,4) 'DISK TYPE FINAL'

'DESBUF'
'LISTFILE *'file' * A (STACK'
 If RC = 0 then do
   pull fn ft fm .
   If pos('RFT',ft) > 0 then do
     rft_doc = 'YES'

     Address 'COMMAND' 'ERASE 'fn ft fm
     ovMod 'RETRIEVE 'substr(cron,1,8) substr(cron,9,4) 'XFORM STRIP'
    'DESBUF'
    'LISTFILE *'file' * A (STACK'
     If RC = 0 then pull fn ft fm .
   end

   file = fn ft fm
 end
 else file = 'D'file' MEMO A'
'DESBUF'
                                    /* draft format */
 if substr(word(file,2),1,3) = 'SCR' & rft_doc <> 'YES' then do
  'ESTATE 'file
   If RC = 0 then do
     ofile = word(file,1) 'MEMO A'
    'ESTATE 'ofile
     If RC = 0 then Address 'COMMAND' 'ERASE 'ofile

    'ESTATE SCRIPT MODULE *'
     If RC = 0 then do
      'SCRIPT 'file' (PROF(OFSMPROF)  SYSVAR(L DRAFT M 'word(file,1)')',
                   'FILE('ofile') DEV(TERM)'
       If RC = 0 then do
         Address 'COMMAND' 'ERASE 'file
         file = ofile
       end /* if */
     end /* if */
   end /* if */
 end /* if */

 record. = ''

 if stat = 'FINAL' & rft_doc <> 'YES' then start = 5
 else                                      start = 1

'EXECIO * DISKR 'file start' (STEM RECORD. FINIS'
 if RC <> 0 then record.0 = 0

 if stat = 'FINAL' & rft_doc <> 'YES' then do
   cnt = 0
   do i = 1 to record.0
     num = C2D(substr(record.i,1,1))

     cnt        = cnt + 1
     record.cnt = record.i

     if num = 1 then do j = i to record.0
       num = C2D(substr(record.j,1,1))
       if num = 1 then i = i + 1
       else LEAVE
     end
   end /* do i */
   record.0 = cnt

   do i = 1 to record.0
     if substr(record.i,2,1) <> '' then
          record.i = substr(record.i,2,80)
     else record.i = substr(record.i,3,80)
   end
 end
 else do i = record.0 to 1 by -1
   if strip(record.i) <> '' & found <> 'YES' then do
     record.0 = i
     found    = 'YES'
   end
 end

'ESTATE 'file
 If RC = 0 then Address 'COMMAND' 'ERASE 'file

 if record.0 > 0 then do
   line = ''
   line = overlay('FF'x,      line, 1)
   line = overlay(cron,       line, 2)
   line = overlay(doc.FROMID, line,14)
   line = overlay(doc.FROM,   line,32)
   line = overlay(doc.TO,     line,52)
   line = overlay(doc.SUBJECT,line,72)

  'ESTATE 'savefile
   If RC <> 0 then
        'EXECIO 1 DISKW 'savefile' 1 F 150 (VAR LINE FINIS'
   else 'EXECIO 1 DISKW 'savefile' (VAR LINE FINIS'
   ret_code = RC


   if ret_code = 0 & length(doc.RSLIP) > 0 then do
     line = 'Routing Slip: 'doc.RSLIP
    'EXECIO 1 DISKW 'savefile' (VAR LINE FINIS'
     ret_code = RC

     if ret_code = 0 then do
       line = ''
      'EXECIO 1 DISKW 'savefile' (VAR LINE FINIS'
       ret_code = RC
     end
   end

   if ret_code = 0 then do
     record.0   = record.0 + 1
     tot        = record.0
     record.tot = 'FFFF'x

    'EXECIO 'record.0' DISKW 'savefile' (STEM RECORD. FINIS'
     ret_code = RC
   end

   if ret_code <> 0 then ret_code = 5
 end
 else ret_code = 1
 RETURN(ret_code)

/*--------------------------------------------------------------------*/
/* Build a list of the users RDR files                                */
/*--------------------------------------------------------------------*/
GET_RDRFILES:Procedure
 mailfile = 'OFSMAIL RDRLIST A'
'ESTATE 'mailfile
 If RC = 0 then Address 'COMMAND' 'ERASE 'mailfile

'DESBUF'
'QUERY READER ALL (STACK'
 If RC = 0 then do queued()
   pull rscs sp cl type recs cpy hld date time fn ft dist .
   if rscs <> 'ORIGINID' & rscs <> 'NO' then do
     fid   = ''
     fnode = ''
     if rscs <> 'RSCS' then do
       fid   = rscs
       fnode = NODE()
     end
     else do
      'EXEC X$RALT$X 'sp
       If      RC = 0 then pull fid fnode .
       else if RC = 4 then do
        'EXECIO 1 CP (LIFO STRING TAG QUERY FILE 'sp
         if RC <> 1016 & RC <> 1026 then do
           parse upper pull rec
           if substr(rec,1,4) <> '(TAG' then do
             fnode = strip(substr(rec,20,8))
             fid   = strip(substr(rec,29,8))
           end
         end
       end /* else */
     end

     if fid   = '' then fid   = '(none)'
     if fnode = '' then fnode = '(none)'

     recs = right(strip(recs,'L','0'),8)

     line = ''
     line = overlay(fn,   line, 1)
     line = overlay(ft,   line,10)
     line = overlay(type, line,19)
     line = overlay(cl,   line,23)
     line = overlay(fid,  line,25)
     line = overlay(fnode,line,34)
     line = overlay(hld,  line,43)
     line = overlay(recs, line,48)
     line = overlay(date, line,57)
     line = overlay(time, line,63)
     line = overlay(sp,   line,72)

    'EXECIO 1 DISKW 'mailfile' (VAR LINE'
     If RC <> 0 then do
      'SET CMSTYPE RT'
       Say '** POSTROAD ERROR A-DISK MAY BE FULL **'
       Address 'COMMAND' 'ERASE 'mailfile
       LEAVE
     end
   end
 end /* do...queued() */

'DESBUF'
'ESTATE 'mailfile
 If RC = 0 then ret_code = 0
 else           ret_code = 1
 RETURN(ret_code)

/*------------------------------------------------------------------*/
/* Remove the given file from the a disk and any temp disk          */
/*------------------------------------------------------------------*/
REMOVE_FILE:Procedure
 arg fn ft .

'DESBUF'
'LISTFILE 'fn ft' * (STACK'
 If RC = 0 then do queued()
   pull . . fm .
   fm = substr(fm,1,1)
   Address 'COMMAND' 'ERASE 'fn ft fm
   If fm <> 'A' then 'REL 'fm' (DET'
 end
 RETURN
