/*----------------------------------------------------------------------*/
/* This program will read in a OV notelog (i.e. OFSLOGfl file)          */
/* and produce a Post Road Mailer Folder                                */
/*----------------------------------------------------------------------*/
/* To prepare a notelog for downloading, type in and execute            */
/* the following EXEC against the notelog file on VM                    */
/*                                                                      */
/* |...+....1....+....2....+....3....+....4....+....5....+....6....+....*/
/* /*******/                                                            */
/* parse arg fn ft fm .                                                 */
/* if      ft = 'OFSLOGFL' then do                                      */
/*   Address 'COMMAND' 'RENAME 'fn ft fm' = OFSLOGfl A0'                */
/*   ft = 'OFSLOGfl'                                                    */
/*   fm = 'A0'                                                          */
/*   Address 'COMMAND' 'COPY   'fn ft fm' = = = (REP RECFM F LRECL 80'  */
/* end                                                                  */
/* else if ft = 'OFSLOGfl' then                                         */
/*   Address 'COMMAND' 'RENAME 'fn ft fm' = OFSLOGFL = '                */
/*----------------------------------------------------------------------*/
 Signal On Syntax

 Parse Arg pcfile folderfn parms '('title

 parms = translate(parms)

 if strip(pcfile) = '' then do
   Say 'Syntax is: log2fold <path> <folder name> <options> (<title>'
   Say
   Say 'Where:'
   Say '<path> is the VM notelog file transfered from'
   Say 'the VM host that is to be convert into a Post Road Mailer'
   Say 'folder.'
   Say '<folder name> is the file name to be used for the'
   Say 'Post Road Mailer folder files.'
   Say '<options> include APPEND or APP.'
   Say '<title> Is the tile to be assigned to the folder'

   ret_code = 0
 end
 else if Stream(pcfile, 'C', 'QUERY EXISTS') = '' then do
   Say 'File ('pcfile') was NOT found.'
   ret_code = -3
 end
 else do
   fn = filespec('name',pcfile)
   Parse Var fn fn'.'ext

   Parse Var folderfn folderfn'.' .
   folderfn = strip(folderfn);
   if folderfn = '' then folderfn = fn
   else                  folderfn = strip(substr(folderfn,1,8))

   title = strip(title)

   Say '========================================'
   Say 'Coverting file ('pcfile')'
   Say 'to Post Road Mailer folder --> 'fn
   Say '========================================'

   ret_code = CONVERT_NOTELOG(pcfile,fn,folderfn,title,parms)
 end

/*-----------------------------------------------------------------*/
/* Exit the program.  One way in.  One way out                     */
/*-----------------------------------------------------------------*/
QUIT:
  EXIT(ret_code)

/*-----------------------------------------------------------------*/
/* Display any syntax errors on the screen                         */
/*-----------------------------------------------------------------*/
SYNTAX:
  ret = RC
 'SET CMSTYPE RT'
  Say 'Error' ret 'in line' sigl ':' errortext(ret)
  Say sigl':'sourceline(sigl) 
  pull .
  Signal QUIT
  RETURN(0)

/*-----------------------------------------------------------------*/
/* Read the notelog file and convert it to Post Road folder format */
/*-----------------------------------------------------------------*/
CONVERT_NOTELOG:Procedure
 Parse arg pcfile,fn,folderfn,title,parms

 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs

 logfile   = folderfn'.NLG'
 namefile  = folderfn'.NLN'
 ret_code  = 0
 ncount    = 0
 append    = 0

 if pos('APP',parms) > 0 then append = 1

 if append = 0 & Stream(logfile, 'C', 'QUERY EXISTS') <> '' then do
   Say
   Say 'The Post Road Mailer folder ('fn') alreadys exists.'
   Say
   Say 'Do you wish to replace it? (y/n)'
   pull ans .
   ans = translate(ans)
   if substr(ans,1,1) = 'Y' then  ret_code = 0
   else                           ret_code = 1
 end  /* Do */

 if ret_code = 0 then do
   if append = 0 then do
     if Stream(logfile,   'C', 'QUERY EXISTS') <> '' then
       Call SysFileDelete logfile
     if Stream(namefile,  'C', 'QUERY EXISTS') <> '' then
       Call SysFileDelete namefile

     if title = '' then lin = d2c(1)||fn' Folder -- created: 'date() time()
     else               lin = d2c(1)||title
     Call LineOut logfile,lin
     Call LineOut namefile,lin
   end

   rec.  = ''
   count = 0
   note. = ''

   Do While Lines(pcfile) > 0
     lin = LineIn(pcfile)

     count     = count + 1
     rec.count = lin

     Select
       When substr(lin,2,9) = 'MSG FROM:' & substr(line,1,1) <> ' ' then do
         Parse Var lin . 'FROM: 'note.FID'--'note.FNODE' TO: 'note.TID,
                  '--'note.TNODE note.DATE note.TIME
       end
       When substr(lin,2,4) = 'To: ' & note.TOFOUND = '' then do
         note.TOFOUND = 1
         Parse Var lin . . . note.TO
         note.TO = strip(note.TO)
       end 
       When substr(lin,2,6) = 'From: ' & note.FROMFOUND = '' then do
         note.FROMFOUND = 1
         Parse Var lin . note.FROM
         note.FROM = strip(note.FROM)
       end 
       When c2d(substr(lin,1,1)) = 255 & c2d(substr(lin,2,1)) = 255 then do
         note.SUBJECT = strip(substr(lin, 7,65))
         note.TYPE    = substr(lin,78, 1)

         indexline = ADD_TO_INDEX(lin)
         Call LineOut logfile,'<<NEW NOTE>> 'indexline
         do i = 1 to count-1
           rec.i = overlay(' ',rec.i,1)
           Call LineOut logfile,rec.i
         end
         note.  = ''
         rec.   = ''
         count  = 0
         ncount = ncount + 1
       end
       Otherwise nop
     end /* select */
   end /* do...while */
 end /* if */
       
 lin = d2c(21);
 lin = lin||ncount ncount
 Call LineOut namefile,lin


 Say '('ncount') notes were loaded.'

 RETURN(ret_code)

/*----------------------------------------------------------------------*/
/* Create an entry in the index file for the given note                 */
/*----------------------------------------------------------------------*/
ADD_TO_INDEX:Procedure Expose note.
  Parse Arg lin

  iline = ''

  Parse Var note.DATE mm'/'dd'/'yy
  note.DATE = yy'/'mm'/'dd

  note.FNODE = strip(note.FNODE)
  note.FID   = strip(note.FID)
  note.TNODE = strip(note.TNODE)
  note.TID   = strip(note.TID)

  iline = overlay(note.TNODE note.TID,  iline, 2)
  iline = overlay(note.DATE,            iline,52)
  iline = overlay(substr(note.TIME,1,5),iline,60)
  iline = overlay(note.FROM,            iline,84)
  iline = iline||d2c(01)
  iline = iline||note.SUBJECT
  iline = iline||d2c(01)||d2c(01)
  iline = iline||note.FNODE'('note.FID')'
  iline = iline||d2c(02)
  iline = iline||note.TNODE'('note.TID')'
  iline = iline||d2c(03)

  Select
    When note.TYPE = 'F' then iline = overlay(d2c(03),iline,43)
    When note.TYPE = 'R' then iline = overlay(d2c(02),iline,43)
    When note.TYPE = 'A' then iline = overlay(d2c(04),iline,43)
    Otherwise                 iline = overlay(d2c(01),iline,43)
  end /* select */

  RETURN(iline)
