Unit MBMDefs;


INTERFACE

Uses
   WinTypes;

Const                           { Error Messages }
   db_OK                =  0;
   db_ErrExists         =  1;
   db_ErrNotExists      =  2;
   db_TooManyFields     =  3;
   db_NoMemAvail        =  4;
   db_FileNotFound      =  5;
   db_ReadError         =  6;
   db_WriteError        =  7;
   db_RecSizeError      =  8;
   db_NbRecError        =  9;
   db_DynRecError       = 10;  { Returned when Nil Pointer found in the list }
   db_OPNAError         = 11;  { Operation Not Admited}
   db_ErrNotNumber      = 12;  { STRINGxxx/BUFBYTExxx : xxx not a number}
   db_ErrUnknownTable   = 13;  
   db_ErrRecTooFar      = 18;  
   db_ErrTableClosed    = 19;  { the table is closed }

   {----------------------------------------------------------}
   { Consult Errors           Argument passed to ConsultError }
   {----------------------------------------------------------}
   db_FieldSizeError     = 48;  { GetField/SetField<>tableSize }
   db_ErrUnknownType     = 34;  { Unknown type used            }
   db_ErrFieldCount      = 30;  

   MaxFields    = 2500;  { maximum number of fields in a table record }


Type
   PList = ^TList;
   TList = record
      Elt  : Pointer;
      Next : PList
   end;

Type
   PString      = Pointer;


Type
   ErrType     = integer;

   String12    = String[12];
   String20    = String[20];
   String30    = String[30];
   String40    = String[40];
   String60    = String[60];
   String80    = Array[0..80] of char;

Type
   PathStr     = String80;

   TableString = Array[0..20] of char;
   FileString  = Array[0..80] of char;
   FieldString = String20;
   ParamString = String20;
   PredString  = String30;
   TypeString  = String20;
   TypeChar    = Array[0..20] of char;

   EPString    = String40;
   OwnerString = String20;

   pCharArray    = ^TCharArray;
   TCharArray    = array[1..MaxFields] of TypeChar;

   PStrArray    = ^TStrArray;
   TStrArray    = array[1..MaxFields] of TypeString;
   PLongArray   = ^TLongArray;
   TLongArray   = array[1..MaxFields] of LongInt;
   PIntArray   = ^TIntArray;
   TIntArray   = array[1..MaxFields] of Integer;



Const                           { Table Flags  }
   fg_Static        = 0;        { fg_Nous + fg_Memoire + fg_Static + fg_ReadWrite }
   fg_Disk          = 2;        { fg_Memoire   }

Const                           { Modes for OpenFile }
   md_Closed        = 0;
   md_Consult       = 1;
   md_Create        = 2;
   md_ReadWrite     = 4;

Const                           { Modes for AddRecord }
   md_BEGINNING      = 1;
   md_END            = 2;
   md_SORTED         = 4;

Const             { Flags for kind of sort in a table }
   NoSort         = 0;
   AscendantSort  = 1;
   DescendantSort = 2;


Type

   PTable = ^TTable;
   TTable = record
      Version  : Word;     { compiling version of the table            }
      IdTable  : PString;  { a table is known by its string identifier }
      DataFile : PString;  { a table may be stored in a data file      }
                           { rem : the full path should be given       }
      Flags    : Integer;  { defines the type of the table :           }
                           {   --------------------------------------- }
                           {   MEMORY  : fully in memory               }
                           {     the table is loaded in memory from    }
                           {     DataFile and stored in DataFile when  }
                           {     closed                                }
                           {     if Datafile is NIL, the table may be  }
                           {     used as a temporary table             }
                           {   DISK    : fully stored on disk with     }
                           {             buffered access               }
                           {     the table is never fully in memory    }
                           {     (a record one by one or buffered)     }
                           {   --------------------------------------- }
                           {   DYNAMIC :                               }
                           {     the number of records may change      }
                           {     during execution                      }
                           {   --------------------------------------- }
                           {   READONLY :                              }
                           {     a table opened in CONSULT mode can not}
                           {     modify its records                    }
                           {   READWRITE :                             }
                           {     a table opened in CONSULT mode can    }
                           {     modify its records                    }
                           {   --------------------------------------- }
      NbFields : Integer;  {  number of fields in each record          }
      Fields   : PStrArray;{  name of each field in a record           }
      Types    : PStrArray;{  type of each field in a record :         }
                           {    String       Size in memory            }
                           {    ------       --------------            }
                           {     BYTE             1                    }
                           {     SHORTINT         1                    }
                           {     CHAR             1                    }
                           {     WORD             2                    }
                           {     INTEGER          2                    }
                           {     LONGINT          4                    }
                           {     REAL             6                    }
                           {     STRINGxxx    xxx + 1                  }
                           {     BUFFBYTExxx    xxx                    }
      Offsets : PLongArray;{  Offset from the beginning of the record  }
                           {  for each field                           }
      MaxRecs  : WORD;     {  number max of record allowed for a table }
                           {    $FFFF for a DYNAMIC table              }

      RecSize  : Word;     {  size of a record                         }
      Current  : WORD;     {  current record accessed                  }
      NbRecs   : WORD;     {  number of records in the table           }

      Handle   : THandle;  {  Handle to allocated memory (static)      }
      DataPtr  : Pointer;  {  Pointer to allocated memory (dynamic)    }
      Modified : Boolean;  {  Flag to set when table contents change   }
      OpenStatus : Word;   {  Open status: (os_CLOSED, os_CREATE,      }
                           {                os_CONSULT                 }

      Limits   : LONGINT;  {  }
      Extra     : Pointer; {  Pointer to Extra Data Record             }
      XREFInc   : Word;    {  Increment for XREF Chk                   }
      SortFlag  : Byte;    {  Sort's type flag                         }
                           {  NoSort         = 0                       }
                           {  AscendantSort  = 1                       }
                           {  DescendantSort = 2                       }
      CloseFlag : Byte;    {  Not Used Reserved}
      DefaultFlag : Boolean; { if DefaultFlag then default values are  }
                             { stored in record 0                      }
      NumFldSort  : Word;   {Number of primary fields on which the     }
                            {table is sorted                           }

      ModifiedRec : Word;   {The record number which was modified      }
      Unique      : Word;   {If there is a Uniqe Field in the record   }
      TableType   : Word;   {Type of the table                         }
                            {DB    = 0                                 }
                            {DBSYS = 2   System table                  }
     Owner   : Pointer;     {the owner of the table                    }
     VarSize : PIntArray;  {  Size of Variable}


   end;


const
   NULL = '';


IMPLEMENTATION

BEGIN
END.

