// UNIT TuADs.h;    
#include "mbmdefs.h"


#ifdef __cplusplus
	extern "C" {
#endif

unsigned short far pascal TbGetCursor(unsigned short    hClient);

unsigned short far pascal CloseCursor(unsigned short 	hCursor);

unsigned short far pascal ClientDone(unsigned short     hClient);

int far pascal fOpenTable(
      		unsigned short 			hCursor,
      		LPSTR 			FileName,
      		LPSTR 			IdTable,
      		unsigned short 			Mode);

int far pascal DefineTable(
      		unsigned short 		hCursor,
      		LPSTR 		IdTable,
      		LPSTR 		DataFile,
      		int 		Flags,
      		int 		NbField,
      		PCharArray 	Fields,
      		PCharArray 	Types,
      		unsigned short 		MaxRecs,
      		BYTE 		SortFlag,
      		unsigned short 		NumFldSort);


int far pascal CreateTable(
      		unsigned short 		hCursor,
      		LPSTR 		idTable);


int far pascal OpenTable(
      		unsigned short 		hCursor,
      		LPSTR 		IdTable,
      		unsigned short 		Mode);


int far pascal CloseTable(
      		unsigned short 		hCursor,
      		LPSTR 		IdTable);

int far pascal SaveTable(
         	unsigned short 		hCursor,
         	LPSTR 		IdTable,
         	LPSTR 		FileName);

int far pascal SortTable(
            unsigned short		 hCursor,
            LPSTR 		 idTable,
            unsigned short 		 SortType,
            unsigned short 		 NbField);


PTable far pascal GetTableInfo(
      		unsigned short 		hCursor,
      		LPSTR 		IdTable);

int far pascal ResetTable(
         	unsigned short 		hCursor,
         	LPSTR 		IdTable);

int far pascal TbResetTable(PTable 		Table);

int far pascal RenameTable(
				unsigned short 		hCursor,
				LPSTR 		FromidTable,
				LPSTR 		TOidTable);


int far pascal AddRecord(
      		unsigned short 		hCursor,
      		LPSTR 		IdTable,
      		LPSTR 		Buffer,
      		unsigned short 		BufSize,
      		unsigned short 		Mode);

int far pascal GetRecord(
      		unsigned short 		hCursor,
      		LPSTR 		IdTable,
      		unsigned short 		RecNb,
      		LPSTR 		Buffer,
      		unsigned short 		BufSize);


int far pascal SetRecord(
      		unsigned short 		hCursor,
      		LPSTR 		IdTable,
      		unsigned short 		RecNb,
      		LPSTR 		Buffer,
      		unsigned short 		BufSize);


int far pascal DeleteRecord(
      		unsigned short 		hCursor,
      		LPSTR 		IdTable,
      		unsigned short 		RecNb);

int far pascal GetField(
      		unsigned short 		hCursor,
      		LPSTR 		IdTable,
		LPSTR 	        idField,
		unsigned short 		PosField,
		unsigned short 		RecNb,
		LPSTR 		FieldBuffer,
		unsigned short 		FieldSize);

int far pascal SetField(
      		unsigned short 		hCursor,
      		LPSTR 		IdTable,
      		LPSTR 		idField,
      		unsigned short 		PosField,
      		unsigned short 		RecNb,
      		LPSTR 		FieldBuffer,
      		unsigned short 		FieldSize);

int far pascal GetValue(
                unsigned short 		hCursor,
      		LPSTR 		Table_Name,
      		LPSTR 		Data_Name,
      		unsigned short 		PosField,
      		unsigned short 		RecNb,
      		LPSTR 		FieldBuffer,
      		unsigned short 		Field_Size);


int far pascal SetValue(
      		unsigned short 		hCursor,
      		LPSTR 		Table_Name,
      		LPSTR 		Data_Name,
      		unsigned short 		PosField,
      		unsigned short 		RecNb,
      		LPSTR 		FieldBuffer,
      		unsigned short 		Field_Size);

int far pascal TbGetValue(
            PTable 		Table,
            unsigned short 		PosField,
            unsigned short 		RecNb,
            LPSTR 		FieldBuffer,
            unsigned short 		Field_Size);

int far pascal TbSetValue(
            PTable 		Table,
	    LPSTR 		Data_Name,
            unsigned short 		PosField,
            unsigned short 		RecNb,
            LPSTR 		FieldBuffer,
            unsigned short 		Field_Size);

int far pascal TbGetField(
				PTable 		Table,
                                unsigned short 		RecNb,
                                unsigned short 		FR,
                                LPSTR 		Buffer,
                                unsigned short 		BufSize);

int far pascal TbSetField(
				PTable 		Table,
                                unsigned short 		RecNb,
                                unsigned short 		FR,
                                LPSTR 		Buffer,
                                unsigned short 		BufSize);

int far pascal TbGetRecord(
                    PTable 		Table,
	            unsigned short 		RecNb,
                    LPSTR 		Buffer,
                    unsigned short 		BufSize);

int far pascal TbSetRecord(
				PTable 		Table,
                                unsigned short 		RecNb,
                                LPSTR 		Buffer,
                                unsigned short 		BufSize);

int far pascal TbAddRecord(
				PTable 		Table,
                                LPSTR 		Buffer,
                                unsigned short 		BufSize,
                                unsigned short 		Mode);

int far pascal TbInsRecord(
            PTable 		Table,
            LPSTR 		Buffer,
            unsigned short 		BufSize,
            unsigned short 		RecNb);

int far pascal TbDeleteRecord(
				PTable 		Table,
                                unsigned short 		RecNb);

LPSTR far pascal TbGetFieldAddress(
            PTable 		Table,
            unsigned short 		RecNb,
            unsigned short 	        FR);

LPSTR far pascal TbGetRecordAddress(
	    PTable 		Table,
            unsigned short 		RecNb);

int far pascal SearchRecord(
       		unsigned short 		hCursor,
       		LPSTR 		IdTable,
       		LPSTR 		idField,
       		LPSTR 		FieldBuffer,
       		unsigned short 		FieldSize,
   		unsigned short 	        far *RecNb);

int far pascal SearchKey(
       		unsigned short 		hCursor,
       		LPSTR 		IdTable,
       		unsigned short 		Nflds,
       		LPSTR 		RecBuffer,
   		unsigned short 		far *RecNb);

int far pascal TbSearchKey(
       		PTable 		Table,
       		unsigned short 		Nflds,
       		LPSTR 		RecBuffer,
   		unsigned short 		far *RecNb);

unsigned short far pascal TbSearchRef(
       		PTable 		Table,
       		unsigned short 		Nflds,
       		LPSTR 		RecBuffer);

int far pascal GetVarType(
                           PTable     Table ,
                     	   LPSTR      idField ,
                    	   unsigned short       PosField ,
                    	   LPSTR      VarType);

int far pascal GetDataType(
      		unsigned short 		       hCursor,
      		LPSTR 		       idTable,
      		FieldString            idField,
      		unsigned short 		       PosField,
      		TypeString far *       VarType);

int far pascal GetFldPos(
            PTable 		Table,
            LPSTR		idField);

int far pascal GetFldName(
            PTable 		Table,
            unsigned short 		FR,
            LPSTR		idField);


unsigned short far pascal GetNbRecs(
         	unsigned short 		hCursor,
         	LPSTR 		IdTable
         	);

unsigned short far pascal TbGetNbRecs(PTable  Table);

int far pascal Register_Runtime(
                        LPSTR    USER ,
                        LPSTR    CODE ,
                        LPSTR    Distributor
                        );

int far pascal TbSetRecBuffValue(PTable Table,
								 int    nFldNumber,
								 LPSTR  lpTableRecord,
								 LPSTR  lpToken);  

int far pascal TbGetRecBuffValue(PTable Table,
								 int    nFldNumber,
								 LPSTR  lpTableRecord,
								 LPSTR  lpToken);  
 //******************* Base management *****************

ErrType far pascal OpenMBase(
 				unsigned short 	       hCursor,
 				LPSTR 	       MBaseFile,
 				unsigned short 	       Mode);

ErrType far pascal CloseMBase(
 				unsigned short      hCursor,
 				LPSTR     MBaseFile);

ErrType far pascal SortMBase(
				unsigned short 		hCursor,
				LPSTR 		MBaseFile);

ErrType far pascal SaveMBase(
            unsigned short 		hCursor,
            LPSTR 		MBaseFile);

ErrType far pascal SaveASMBase(
				unsigned short       hCursor,
                                LPSTR 	   MBase,
                                LPSTR 	   ASMBaseFile);

ErrType far pascal DeleteMBase(
				unsigned short 	       hCursor,
				LPSTR 	       MBaseFile);

BOOL far pascal IsBaseModified(
				unsigned short 	       hCursor,
                                LPSTR 	       MBaseFile);

ErrType far pascal SetBaseModified(
				unsigned short 	       hCursor,
                                LPSTR 	       MBaseFile,
                                BOOL           Modified);

ErrType far pascal OpenMBaseTable(
				unsigned short       hCursor,
                                LPSTR 	   MBaseFile,
                                LPSTR 	   TableFile);

ErrType far pascal CloseBase(
 				unsigned short      hCursor,
 				LPSTR     MBaseFile);

ErrType far pascal SortBase(
				unsigned short 		hCursor,
				LPSTR 		MBaseFile);

ErrType far pascal OpenBase(
 				unsigned short 	       hCursor,
 				LPSTR 	       MBaseFile,
 				unsigned short 	       Mode);

ErrType far pascal SaveBase2Tables(
 				unsigned short 	       hCursor,
 				LPSTR 	       lpBaseName ) ;

BOOL far pascal IsTableInBase(
 				unsigned short 	       hCursor,
 				LPSTR 	       lpBaseName,
 				LPSTR 	       lpTableName ) ;
ErrType far pascal ResetBase(
 				unsigned short 	       hCursor,
 				LPSTR 	       lpBaseName ) ;

#ifdef __cplusplus
	}
#endif



