  Program REGISTER;

  {$R REGISTER}

{-----------------------------------------------------------------------}
{ Program : DevStart                                                    }
{-----------------------------------------------------------------------}
{ Purpose :                                                             }
{    This program is an exemple, to help you starting applications with ADS    }
{-----------------------------------------------------------------------}

uses
   WinTypes,   {System Units}
   WinProcs,
   r_Incl,
   D_Regist,
   D_Acount,
   D_FstlR,
   D_DstPay,
   D_FSTPay,
   TuADS,
   BWCC,
   About;      {Private unit}

const
   AppName = 'DevStart';
const
   HELP_ABOUT = 999; { Should be in an INCLUDE file}

Var
   BWCCLIB : THandle;


{-----------------------------------------------------------------------}
{ Function : WindowProc                                                 }
{-----------------------------------------------------------------------}
{  Purpose : Callback function for the (.RES) file dialogs              }
{            Interpretes system-menu\close only                         }
{-----------------------------------------------------------------------}
{  Parameters :                                                         }
{-----------------------------------------------------------------------}

function WindowProc( Window: HWnd; Message, wParam: Word;
                     lParam: Longint): Longint; export;
var
   Return         : LongInt;
   Status         : Integer;

begin
   WindowProc := 0;
   Return     := 0;
   case Message of
      WM_CREATE  : begin

                   Register_RunTime('ITD SC- BELGIUM',
                                   '0000',
                                   'ITD0001CS01/CSE0011911/94-0000');
                   Status := OpenMBase(HInstance,'ADSDIST.mbf',4);
                   if (Status <> mb_OK) then
                   begin
                      MessageBox(Window,'Base not found','Error',0);
                      SendMessage(Window,WM_QUIT,0,0);
                   end;
                   end;



      WM_COMMAND :
      begin
         Case wParam of
            HELP_ABOUT :
               AboutInit(Window,Message,wParam,lParam);
            IDM_REGIST :
               DRegistInit(Window,Message,wParam,lParam);
            IDM_FSTLREP :
               D_FSTLAccountInit(Window,Message,wParam,lParam);
            IDM_DACOUNT :
               D_AccountInit(Window,Message,wParam,lParam);
            IDM_DISTPAY :
               D_DstPayInit(Window,Message,wParam,lParam);
            IDM_FSTLPAY :
               D_FSTPayInit(Window,Message,wParam,lParam);
         end;{Case WPARAM of }
      end;{wm_command}

      WM_DESTROY: begin
                     FreeLibrary(BWCCLIB);
                     Status := SaveMBase(HInstance,'ADSDIST.MBF');
                     ClientDone(HInstance);
                     if hClip > 0 then
                        GlobalFree(hClip);
                     PostQuitMessage(0);
                  end;
   end;{case Message of}

   if Return=0 then
      WindowProc:= DefFrameProc(Window,GetProp(Window,'MDIClient'),
                                Message, WParam, LParam)
   else
      WindowProc:=Return;
end;



{-----------------------------------------------------------------------}
{ Function : RegisterMainWindow                                         }
{-----------------------------------------------------------------------}
{ Purpose :                                                             }
{    Registers the class for the Main window                            }
{-----------------------------------------------------------------------}

function RegisterMainWindow(hClient : THandle) :Boolean;
var
   RegisterMDIFrame : boolean;
   wc : TWndClass;
begin
   RegisterMDIFrame := FALSE;
   wc.style       := cs_vredraw or cs_hredraw or cs_globalclass;
   wc.lpfnWndProc := MakeProcInstance(@WindowProc,HInstance);
   wc.cbClsExtra  := 0;
   wc.cbWndExtra  := 0;
   wc.hInstance   := hClient;
   wc.hIcon       := LoadIcon(hClient,AppName);
   wc.hCursor     := LoadCursor(0, IDC_ARROW);
   wc.hbrBackground  := COLOR_APPWORKSPACE + 1;
   wc.lpszMenuName   := AppName;
   wc.lpszClassName  := AppName;
   RegisterMDIFrame  := RegisterClass(wc);
end;



{-------------------------------------------------------------------------}
{ Procedure : WinMain                                                     }
{-----------------------------------------------------------------------}
{ Purpose :                                                               }
{    Main Function                                                        }
{-------------------------------------------------------------------------}

procedure WinMain;
var
  Window         : HWnd;
  Message        : TMsg;
  MyWndClass  : TWndClass;
begin
   if hPrevInst = 0 then { hPrevInst = System Constant}
   begin
      if not RegisterMainWindow(hInstance) then
         halt(255);{ An Error occured (not enough memory ?)}

      Window := CreateWindow(AppName,
                             'Register ADS Distributors',
                             ws_OverlappedWindow,
                             cw_UseDefault,
                             cw_UseDefault,
                             cw_UseDefault,
                             cw_UseDefault,
                             0,
                             0,
                             HInstance,
                             nil);                    { Create the main Window }
      ShowWindow(Window, CmdShow);                    { Show the main Window   }
   end
   else
   begin
      Window := FindWindow(AppName,nil);              { Get the window and     }
      ShowWindow(Window, SW_SHOWNORMAL);              {           activate it  }
      BringWindowToTop(Window);
   end;
   UpdateWindow(Window);

   while GetMessage(Message, 0, 0, 0) do              { Main messages loop    }
   begin
         TranslateMessage(Message);
         DispatchMessage(Message);
   end;

   GetClassInfo(HInstance,AppName,MyWndClass);
   FreeProcInstance(MyWndClass.lpfnWndProc);          { Free memory before   }
   Halt(Message.wParam);                              {     leaving for good }
end;


begin
   WinMain;
end.


