Unit About;

INTERFACE
Uses
   Wintypes, Winprocs;

function AboutInit(Window : hWnd; Message,wParam : Word;lParam : LongInt):Integer;

IMPLEMENTATION

{-----------------------------------------------------------------------}
{ Function : About                                                      }
{-----------------------------------------------------------------------}
{ Purpose :                                                             }
{    Callback function for the About Dialog Box                         }
{    Interpretes OK button only                                         }
{-----------------------------------------------------------------------}
{  Parameters : Standart window  parameters                             }
{-----------------------------------------------------------------------}

function AboutWndProc(Dialog: HWnd; Message, WParam: Word;
               LParam: Longint): LongInt; export;
const
   ScrollInc :Integer = 1 ;
var
   Return         : LongInt;
   DlgDc          : hDC;
   DlgPaintStruct : TPaintStruct;
   hWndChild      : hWnd;
   TM             : TTextMetric;
   X,Y,Cx,Cy,i              : Integer;
   UpdateRect,
   DlgRect        : TRect;
   hFont          : THandle;
const
   Name : Boolean = FALSE;
begin
   Return := 0;
   case Message of
      WM_INITDIALOG:
      begin
         ScrollInc := 1;
      end;
      WM_COMMAND:
         if (WParam = ID_OK) or (WParam = ID_CANCEL)
         then begin
            EndDialog(Dialog, 1);
            Exit;
         end;


      WM_LBUTTONDOWN:
      begin
         if (wParam and MK_SHIFT)<>0 then
         begin
            x := LoWord(lParam);
            y := HiWord(lParam);
            if (x>100) and (x<148)
               and (y>257) and (y<302) then
               begin
                  GetClientRect(Dialog,DlgRect);
                  UpdateRect := DlgRect;
                  ScrollInc := -ScrollInc;
                  For i := 1 to (DlgRect.Bottom - DlgRect.Top) do
                  begin
                     ScrollWindow(Dialog,0,ScrollInc,nil,nil);
                     UpdateWindow(Dialog);
                  end;
             end;
         end;
      end;
   end;
   AboutWndProc := Return;
end;


{-----------------------------------------------------------------------}
{ Function : AboutInit                                                  }
{-----------------------------------------------------------------------}
{ Purpose :                                                             }
{    Initialisation for the About Box                                   }
{-----------------------------------------------------------------------}
{  Parameters : Standart window  parameters                             }
{-----------------------------------------------------------------------}

function AboutInit(Window : hWnd; Message,wParam : Word;
                   lParam : LongInt):Integer;
var
   AboutProc     : TFarProc;
begin
   AboutProc := MakeProcInstance(@AboutWndProc, hInstance);
   DialogBox(hInstance, 'AboutBox', Window, AboutProc);  { Modal Dialog !}
   FreeProcInstance(AboutProc);
end;



begin
end.