/*  Project Main

	 Copyright  1994. ITD.

	 SUBSYSTEM	:	MAIN.EXE
	 FILE			:	mntradlg.cpp
	 AUTHOR		:	TK
	 CREATION	:	07 december 1994


	 OVERVIEW
	 ========
	 Source file for implementation of MainTradersDlg (TDialog).
*/

#include <owl\owlpch.h>
#pragma hdrstop
extern WORD hInst ;
#include "mntradlg.h"
#include "TUADS.H"

struct sTrad
				{
				char Name[30];
				char First_Name[20];
				char Address[255];
				char Phone[20];
				} *Trader;


DEFINE_RESPONSE_TABLE1(MainTradersDlg, TDialog)
	 EV_BN_CLICKED(IDC_BTNDOWN, ClickedDown),
	 EV_BN_CLICKED(IDC_BTNUP  , ClickedUp),
END_RESPONSE_TABLE;




MainTradersDlg::MainTradersDlg (TWindow* parent, TResId resId):
	 TDialog(parent, resId, 0)
{
	EDNAME		= new TEdit(this,IDC_NAME) ;
	EDNUMBER		= new TEdit(this,IDC_NUMBER) ;
	EDTOTAL		= new TEdit(this,IDC_TOTAL) ;
	EDPHONE		= new TEdit(this,IDC_PHONE) ;
	EDFIRSTNAME	= new TEdit(this,IDC_FIRST_NAME) ;
	EDADDRES		= new TEdit(this,IDC_ADDRESS) ;
	BTDOWN		= new TButton(this,IDC_BTNDOWN ) ;
	BTUP			= new TButton(this,IDC_BTNUP ) ;


}


MainTradersDlg::~MainTradersDlg ()
{
	delete EDNAME   ;
	delete EDNUMBER ;
	delete EDTOTAL  ;
	delete EDPHONE  ;
	delete EDFIRSTNAME ;
	delete EDADDRES ;
	delete BTDOWN   ;
	delete BTUP		 ;	

	Destroy();
}

void MainTradersDlg::SetupWindow ()
{
  TDialog::SetupWindow() ;
  PrintRecord(1) ;
}

void MainTradersDlg::PrintRecord (int nb)
{
  PTable TraderTable;
  char Current[5] ;
  char NbRecs[5]  ;

  Trader = new(sTrad);
  GetRecord(hInst,"TRADERS",nb ,(LPSTR)Trader,sizeof(sTrad));
  EDNAME->SetText(Trader->Name);
  EDPHONE->SetText(Trader->Phone) ;
  EDFIRSTNAME->SetText(Trader->First_Name) ;
  EDADDRES->SetText(Trader->Address) ;
  delete(Trader);

  TraderTable = GetTableInfo(hInst,"TRADERS");
  itoa(TraderTable->Current,Current,10)  ;
  itoa(TraderTable->NbRecs,NbRecs,10)  ;
  EDNUMBER->SetText(Current);
  EDTOTAL->SetText(NbRecs)  ;

}

void MainTradersDlg::ClickedUp ()
{
  PTable TraderTable;
  TraderTable = GetTableInfo(hInst,"TRADERS");
  if ( (TraderTable->Current) < (TraderTable->NbRecs) )
  {
		PrintRecord(TraderTable->Current + 1 ) ;
  }
}

void MainTradersDlg::ClickedDown()
{
  PTable TraderTable;
  TraderTable = GetTableInfo(hInst,"TRADERS");
  if ( (TraderTable->Current) > 1 )
  {
		PrintRecord(TraderTable->Current - 1 ) ;
  }
}


