@echo off
REM ***************************************
REM *** VLabel.bat - Read or set volume ***
REM *** ver.2        label for a drive  ***
REM ***************************************

CEnviD %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
GOTO CENVI_EXIT

main(argc,argv)
{
   if ( argc < 2  ||  3 < argc
     || strcmp( (drive=argv[1]) + 1, ":" )
     || !isalpha(drive[0]) ) {
      Instructions();
      return(EXIT_FAILURE);
   }

   // get current volume label
   #define _A_VOLID  0x08  // Volume label
   sprintf(SearchSpec,"%c:\\*.*",drive[0]);
   if ( CurrentName = SearchFirstMatch(_A_VOLID,SearchSpec,dummy) ) {
      // get rid of annoying period
      strcpy(CurrentName+8,CurrentName+9);
      printf("Current %c: Label is \"%s\"\n",toupper(drive[0]),CurrentName);
   } else
      printf("No current Label for %c:\n",toupper(drive[0]));

   if ( 3 == argc ) {
      // set the new label
      if ( !SetVolumeLabel(drive[0],argv[2]) ) {
         printf("\aError setting new volume label for %c:\n",toupper(drive[0]));
         return(EXIT_FAILURE);
      }
   } else {
      // set VLABEL to new name
      undefine(VLABEL);
      if ( CurrentName )
         VLABEL = CurrentName;
   }

   return(EXIT_SUCCESS);
}

Instructions()
{
   printf("\a\n")
   printf("VLabel - Get or Set a disk volume label\n")
   printf("\n")
   printf("SYNTAX: VLABEL <d>: [NewLabel]\n")
   printf("\n")
   printf("Where: <d> Drive designation (e.g. A:, B:, C:, etc...)\n")
   printf("       NewLabel - New volume name (truncated after 11 characters)\n")
   printf("\n")
   printf("Examples: VLABEL A:\n")
   printf("          VLABEL A: MYTRANSFER\n")
   printf("\n")
   printf("NOTE: If retrieving volume label then set the VLABEL environment variable\n")
   printf("      to the name of the volume.\n")
   printf("\n")
   printf("ERRORLEVEL: Sets ERRORLEVEL %d for error, %d if success\n",EXIT_FAILURE,EXIT_SUCCESS)
   printf("\n")
}

SearchFirstMatch(FileAttribute,FileName,FoundAttribute)
{  // return name found, else NULL
   reg.ah = 0x4E;
   reg.cx = FileAttribute;
   reg.ds = segment(FileName);
   reg.dx = offset(FileName);
   if ( !interrupt(0x21,reg) )
      return NULL;
   lDTA = GetDTAaddress();
   FoundAttribute = peek(lDTA+21,UWORD8);
   strcpy(lFoundName,peek(lDTA+30,13));

   return lFoundName;
}

GetDTAaddress()   // return pointer to Data Transmission Area
{
   reg.ah = 0x2F;
   interrupt(0x21,reg);
   return Address(reg.es,reg.bx);
}


SetVolumeLabel(pDriveLetter,pName)  // return True for success, else False
{
   // drive letter convert to drive number 1 - 26
   lDriveNumber = toupper(pDriveLetter) - 'A' + 1;

   // Create FCB blob for old-style FCB functions
   // Set up initial fields for FCB
   BLObSize(lFCB,8 + 37);
   memset(lFCB,0,BLObSize(lFCB));
   BLObPut(lFCB,0,255,UWORD8);
   BLObPut(lFCB,6,8,UWORD8);
   BLObPut(lFCB,7,lDriveNumber,UWORD8);

   // Delete current volume ID
   BLObPut(lFCB,8,'*       *  ',11);
   reg.ah = 0x13;
   reg.ds = segment(lFCB);
   reg.dx = offset(lFCB);
   interrupt(0x21,reg);
   undefine(reg);

   // Create new volume file; local name must be 11 characters, blank-padded
   sprintf(lName,"%s                  ",pName);
   memcpy(lFCB+8,lName,11);
   reg.ah = 0x16;
   reg.ds = segment(lFCB);
   reg.dx = offset(lFCB);
   interrupt(0x21,reg);
   if ( reg.al ) return False;
   undefine(reg);
 
   // Close the file
   reg.ah = 0x10;
   reg.ds = segment(lFCB);
   reg.dx = offset(lFCB);
   interrupt(0x21,reg);
   return( reg.al ? False : True );
}

:CENVI_EXIT
