@echo off
REM ****************************************************************
REM *** Reboot_2.bat - Reboot computer by jumping to BIOS reboot ***
REM *** ver.2          routine.  This is an example of the CEnviD ***
REM ***                asm() function.  To provide protection    ***
REM ***                from accidentaly rebooting, you must      ***
REM ***                enter PLEASE as the first parameter.      ***
REM ****************************************************************


REM **************************************************************
REM *** Check that "PLEASE" is the first parameter.  CEnviD     ***
REM *** return errorlevel if it is not please.                 ***
REM **************************************************************
CEnviD return( strcmpi("%1","Please") ? 1 : 0 )
if errorlevel 1 GOTO PLEASE

REM *************************************************
REM *** Set warm boot flag to avoid memory tests  ***
REM *** for warm boot you would set this to 0x472 ***
REM *************************************************
REM CEnviD poke(0x472,0x1234,UWORD16);  // warm boot
CEnviD poke(0,0x1234,UWORD16);  // cold boot

REM *********************************************************
REM *** Call Dos disk reset to make smartdrive 4.x flush. ***
REM *** If you're not using this smartdrive then the      ***
REM *** following lines aren't needed.                    ***
REM *********************************************************
CEnviD reg.ah = 0x0D; interrupt(0x21,reg);

REM **********************************************************
REM *** Set ctrl-alt-del scan code for EMM386 to shut down ***
REM *** If not using EMM386 then this is not needed.       ***
REM **********************************************************
CEnviD "poke(0x417,peek(0x417)|0x0C); reg.ax=0x4F53; interrupt(0x15,reg);"

REM **************************************************************
REM *** A routine for rebooting is in the BIOS at location     ***
REM *** FFFF:0000.  To reboot, will use the CEnviD asm()        ***
REM *** to execute the machine code: JMPF FFFF:0000, which in  ***
REM *** machine code is the byte sequence EA 00 00 FF FF.      ***
REM **************************************************************
CEnviD asm('\xEA\x00\x00\xFF\xFF');

:CENVI_EXIT

:PLEASE
ECHO Reboot_2.bat will reboot your computer.  To execute Reboot.bat you
ECHO must enter: REBOOT_2 PLEASE
