@echo off
REM ************************************************
REM *** KeyStuff.bat - Stuff characters into the ***
REM *** ver.1          keyboard buffer           ***
REM ************************************************

SET THISFILE=%0
SET KEYSTUFFS='
:BUILD_KEYSTUFFS
IF "%1" == "" GOTO END_BUILD
IF "%KEYSTUFFS%" == "" SET KEYSTUFFS=%1
IF NOT "%KEYSTUFFS%" == "" SET KEYSTUFFS=%KEYSTUFFS% %1
SHIFT
GOTO BUILD_KEYSTUFFS
:END_BUILD
SET KEYSTUFFS=%KEYSTUFFS%'

CEnviD %THISFILE%.bat %KEYSTUFFS%
GOTO CENVI_EXIT

#define NEXT_CHAR_PTR      0x41A
#define LAST_CHAR_PTR      0x41C
#define KYBD_BUF_START_PTR 0x480
#define KYBD_BUF_END_PTR   0x482
#define DOS_STATIC_MEMORY  0x400

main(argc,argv)
{
   if ( !strcmpi(argv[1],"\'/?\'") ||  !strcmpi(argv[1],"\'\'") )
      Instructions();
   else {

      // get start and end address of the keyboard buffer
      BufStart = peek(KYBD_BUF_START_PTR,UWORD16);
      BufEnd = peek(KYBD_BUF_END_PTR,UWORD16) - 2;

      // Poke bytes from input arguments into the keyboard buffer
      BufLen = min((BufEnd - BufStart)/2,1+GetArraySpan(KEYSTUFFS));
      for ( Addr = BufStart, c = KEYSTUFFS; BufLen--; Addr += 2, c++ )
         poke(Addr+DOS_STATIC_MEMORY,c[0]);

      // save pointers to beginning and ending of buffer
      poke(NEXT_CHAR_PTR,BufStart,UWORD16);
      poke(LAST_CHAR_PTR,Addr,UWORD16);

   }
}

Instructions()
{
   printf("\a");
   printf("KeyStuff - Push characters into the keyboard buffer\n");
   printf("\n");
   printf("USAGE: KeyStuff String\n");
   printf("  Where String is fifteen or fewer bytes for the keyboard buffer\n");
   printf("\n");
   printf("EXAMPLES:  The following batch file would start up BASIC.COM with the initial\n");
   printf("           command: Load \"Truck\"\n");
   printf("                call KeyStuff Load\\x20\\\"Truck\\\"\\r\\n\n");
   printf("                basica.com\n");
   printf("           To see DOS's TIME without entering keystrokes\n");
   printf("                keystuff TIME\\r\\r\n");
   printf("\n");
}

:CENVI_EXIT
SET THISFILE=
SET KEYSTUFFS=

