::jpg2desc 0.1, Copyright 1993 Richard Hempsey
::
:: a batch file/cenvi script that extracts the resolution and number of
:: colors in a JPEG file, and puts it into a 4DOS descript.ion.

CEnviD jpg2desc.bat %1 %2
GOTO CENVI_EXIT

main(argc,argv)
{
    if(argc>2) {
        fprintf(stderr,"Usage: jpg2desc [filespec]\n");
        exit(1);
    }

    if(argc==1)
        filespec="*.jpg";
    else
        filespec=argv[1];

    temp=SplitFileName(filespec);

    descfile=temp.dir;
    strcat(descfile,"descript.ion");

    df=fopen(descfile,"w");
    if(df==NULL) {
        fprintf(stderr,"error: unable to open %s for writing\n",descfile);
        exit(1);
    }

    files=Directory(filespec,False,~FATTR_SUBDIR);
    if(files==NULL) {
        fprintf(stderr,"error: no files matching filespec %s\n",filespec);
        exit(1);
    }
    numfiles=1+GetArraySpan(files);

    for(i=0;i<numfiles;i++)
        ProcessFile(files[i].name,df);

    fclose(df);

    exit(0);
}
ProcessFile(filename,desc)
{
    jf=fopen(filename,"rb");
    if(jf==NULL) {
        fprintf(stderr,"error: could not open %s for reading.\n",filename);
        return;
    }

    temp=SplitFileName(filename);
    name=temp.name;
    strcat(name,temp.ext);

    fread(jpg_id,UWORD16,jf);
    if(jpg_id!=0xd8ff) {
        fclose(jf);
        return
    }
    while(!feof(jf)) {
        fread(t,UWORD16,jf);
        if(t==0xc0ff) {
            fread(t,UWORD16,jf);
            fread(c,UWORD8,jf);
            bits=c;
            fread(t,UWORD16,jf);
            hh=swb(t);
            fread(t,UWORD16,jf);
            ww=swb(t);
            fread(c,UWORD8,jf);
            planes=c;
            fprintf(desc,"%s %04dx%04dx%02d\n",name,ww,hh,bits*planes);
            return;
        }
        fread(t,UWORD16,jf);
        fseek(jf,swb(t)-2,SEEK_CUR);
    }
    fclose(jf);
    return;
}

swb(x)
{
    return ((((x)&0xff00)>>8)|(((x)&0x00ff)<<8));
}

:CENVI_EXIT
iff %#==1 then ^ attrib +h %@path[%@full[%1]]descript.ion /q >&nul ^ *quit ^ endiff
iff %#==0 then ^ attrib +h descript.ion /q >&nul ^ *quit ^ endiff

