@echo off
REM *******************************************************************
REM *** DelTree - Delete a subdirectory and all files in it, and    ***
REM *** ver.2     recursively delete all subdirectories within that ***
REM ***           subdirectory.  You may look at DelTree1.bat and   ***
REM ***           DelTree2.bat for other methods of doing the       ***
REM ***           same thing by using temporary files.              ***
REM *******************************************************************
if "%1"=="" GOTO SHOW_HOW

REM *******************************************************************
REM *** The user could be very unhappy to delete lots of files they ***
REM *** didn't really want to delete, and so give them a chance to  ***
REM *** change their mind.                                          ***
REM *******************************************************************
   CEnviD return( stricmp(`NOASK`,`%2`) ? 0 : 1 )
   IF ERRORLEVEL 1 GOTO ANSWER_YES
   ECHO THIS WILL DELETE ALL FILES AND DIRECTORIES UNDER %1
   CEnviD GetUKey.cmm ARE YOU SURE YOU WANT TO DO THIS? (Y/N)    yn
   if N==%UKEY% GOTO FINI
   :ANSWER_YES

REM *********************************************************************
REM *** Check that this is a valid subdirectory.  This can be handled ***
REM *** by calling another CEnvi program: ValidDir.bat                ***
REM *********************************************************************
   CEnviD ValidDir.bat %1 COMPLAIN
   if ERRORLEVEL 1 GOTO FINI

REM ******************************************************************
REM *** It will be simpler to delete files if we make sure that no ***
REM *** attributes are set that would make them undeletable.  The  ***
REM *** easy way to change this is to let the DOS attrib function  ***
REM *** clear all of these attributes for us.                      ***
REM ******************************************************************
   attrib -H -S -R %1\*.* /s > NUL

REM **************************************************************************
REM *** Temporarily turn off DELDIR to make this deletion fast (if unsafe) ***
REM **************************************************************************
set DELTREE_SAVE_DEL_DIR=%DELDIR%
set DELDIR=

REM ******************************************************************
REM *** The rest of this task will be handled by CEnviD which will ***
REM *** create a list of all directories and then call the command ***
REM *** shell to delete the files in each directory.               ***
REM ******************************************************************
CEnviD %0.bat %1
GOTO CENVI_EXIT

   main(argc,argv)
   {
      // build a sorted list of all subdirectories under the specified directory
      DirCount = BuildSubdirList(argv[1],DirList)
      if ( DirCount != 0 ) {
         // sort the subdir list in reverse alphabetic order, which insures that
         // subdirectoies of a directory appear before its parent directory
         qsort(DirList,DirCount,"ReverseSortDirnames")
         // for each subdirectory, call command shell to delete all files in it
         // and then remove the directory
         for ( i = 0; i < DirCount; i++ ) {
            DeleteAllFilesInDir( DirList[i].name );
            RemoveDirectory( DirList[i].name );
         }
      }
      // all subdirectories have have been deleted, then delete the input subdir
      DeleteAllFilesInDir( argv[1] );
      RemoveDirectory( argv[1] );
   }

   BuildSubdirList(BaseDir,List) // build List of all subdirectories under BaseDir
   {                             // return count of elements in list
      sprintf(SearchSpec,"%s\\*.*",BaseDir)
      List = Directory(SearchSpec,TRUE,
                       FATTR_RDONLY|FATTR_HIDDEN|FATTR_SYSTEM|FATTR_SUBDIR|FATTR_ARCHIVE,
                       FATTR_SUBDIR)
      return( ( List == NULL ) ? 0 : 1+GetArraySpan(List) );
   }

   ReverseSortDirnames(Dir1,Dir2) // repeatedly called by qsort to sort Dir1 and Dir2
   {
      return( stricmp(Dir2.name,Dir1.name) );
   }

   DeleteAllFilesInDir(DirName) // call system to delete all files in this dir
   {
      printf("DEL %s\n",DirName)
      system("echo Y | del %s > NUL",DirName)
   }

   RemoveDirectory(DirName) // call system RMDIR call
   {
      printf("RMDIR %s\n",DirName)
      system("RMDIR %s > NUL",DirName)
   }

:CENVI_EXIT
REM **********************
REM *** Restore DELDIR ***
REM **********************
set DELDIR=%DELTREE_SAVE_DEL_DIR%
set DELTREE_SAVE_DEL_DIR=
GOTO FINI

:SHOW_HOW
   ECHO .
   ECHO DelTree.bat - Delete a subdirectory and all files and directories under it
   ECHO .
   ECHO USAGE: DelTree DirSpec [NOASK]
   ECHO WHERE: NOASK: (optional) to not prompt "are you sure?"
   ECHO        DirSpec: Specification for directory to delete
   ECHO .
GOTO FINI

:FINI
set UKEY=
