@ECHO OFF
REM *************************************************************
REM *** ChrCount.bat - Count the number off occurences of any ***
REM *** ver.1          character in a file.                   ***
REM *************************************************************

CEnviD %0.bat %1 %2 %3 %4
GOTO CENVI_EXIT

Instructions()
{
   puts("CHRCOUNT.BAT - Count occurences of a character in a file; save in CHRCOUNT\a")
   puts(``)
   puts(`USAGE: CHRCOUNT <filespec> <[x]character>`)
   puts(`Where: filespec  - Name of file to read`)
   puts(`       character - Character to search for, if "X" first then`)
   puts(`                   character is a hexidecimal value`)
   puts(``)
   puts(`NOTE: Character count is saved in the CHRCOUNT environment variable`)
   puts(``)
   puts(`Examples: CHRCOUNT C:\AUTOEXEC.BAT :`)
   puts(`          CHRCOUNT C:\AUTOEXEC.BAT A`)
   puts(`          CHRCOUNT C:\AUTOEXEC.BAT xA`)
   puts(``)
   exit(EXIT_FAILURE);
}

main(argc,argv)
{
   if ( argc != 3 )
      Instructions();

   // Get the character they're looking for
   if ( argv[2][1]  &&  'X' == toupper(argv[2][0]) )
      Character = strtol(argv[2]+1,end,16);
   else if ( !argv[2][1] )
      Character = argv[2][0];
   else {
      printf("\aI don't understand the character \"%s\".\n",argv[2]);
      exit(EXIT_FAILURE);
   }

   // open and read file
   fp = fopen(argv[1],"rb");
   if ( !fp ) {
      printf("\aUnable to open \"%s\" for reading.\n",argv[1]);
      exit(EXIT_FAILURE);
   }

   // finally, read in file and search for character
   CHRCOUNT = CountCharacterInFile(fp,Character);
   printf("Character found %d times.\n",CHRCOUNT);
   fclose(fp);
}

CountCharacterInFile(fp,c)
{
   Total = 0;
   while ( Read = fread(buf,4000,fp) ) {
      for ( size = 0; size < Read; size++ ) {
         if ( !(found = memchr(buf+size,c,Read-size)) )
            break;
         Total++;
         size = found - buf;
      }
   }
   return Total;
}

:CENVI_EXIT
