/*  This program and all it's includes were written and tested in QC v2.0	*
 *  (Pretty lame, huh) I was too lazy to convert it to Watcom 10.5 :)		*
 *  I have included all the source necessary to load and play a CMF file.	*
 *  The SBFMDRV.COM must be loaded first in order to use the functions		*
 *  The driver has also been included.  It's up to you to make sure that it's 	*
 *  loaded. (This means that this only works with Soundblasters (or clones).    *
 *  All files included in this ZIP are freeware.  I just wanted to contribute my*
 *  share back to the community that helped me when I knew nothing of coding.	*
 *  Use this however you see fit.  All that I ask is that you do not		*
 *  redistribute this package altered in any way. ;-)				*
 *                                                                              *
 *  I have not yet found a decent CMF composer, but I have found several	*
 *  conversion utilities to convert other formats to .CMF                       *
 *                                                                              *
 *  This was compiled using a HUGE memory model.  Look for other comments in the*
 *  'README.TXT' file.                                                          *
 *                                                                              *
 *  E-mail you comments to me: ZarrinW@aol.com                                  *
 ********************************************************************************/
#include <graph.h>
#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <dos.h>
#include <conio.h>
#include <io.h>

#include "sound.h"		//My CMF functions
				//You can print the prototypes for easier
				// use from 'PROTOTYP.TXT'

//  <<<<  This is just a simple demo to show how it works >>>>

void main(void)
{
 union REGS regs;
 struct SREGS segs;
 long           length=0,count=0;
 int            a=0,b=0,c=0;
 char     file_id[4],
		channel[16],
		*text,
		filename[30],
		huge *cmfdata;

 unsigned int
		version=0,
		inst_off=0,
		music_off=0,
		ticks_quarter=0,
		ticks_second=0,
		title_off=0,
		author_off=0,
		remarks_off=0,
		num_inst=0,
		tempo=0;

 if(!findcmfdriver())                   // This function does not work on QC2
  if (system("SBFMDRV.COM")==-1)
  {
   puts("FM Driver not found.");
   exit(-1);
  }
 printf("File and extention: ");
 scanf("%s",filename);

 _clearscreen(_GCLEARSCREEN);

 length=getlength(filename);

 if ((cmfdata=(char huge *)halloc(length,1))==NULL)
 {
  printf("Unable to allocate %lu bytes for file.\n",length);
  exit(-1);
 }

 printf("Loading CMF file '%s' - %lu bytes\n",filename,length);
 loadcmf(cmfdata,filename,length);
 strncpy(file_id,cmfdata,4);

 inst_off=      cmfdata[ 6]+cmfdata[ 7]*256;
 music_off=     cmfdata[ 8]+cmfdata[ 9]*256;
 ticks_quarter= cmfdata[10]+cmfdata[11]*256;
 ticks_second=  cmfdata[12]+cmfdata[13]*256;
 title_off=     cmfdata[14]+cmfdata[15]*256;
 author_off=    cmfdata[16]+cmfdata[17]*256;
 remarks_off=   cmfdata[18]+cmfdata[19]*256;
 num_inst=      cmfdata[36]+cmfdata[37]*256;
 tempo=         cmfdata[38]+cmfdata[39]*256;

 printf("\t\t\t\tOffsets:\n");
 printf("\t\t\t\t  Author:      0x%04x\n",author_off);
 printf("\t\t\t\t  Remarks:     0x%04x\n",remarks_off);
 printf("\t\t\t\t  Title:       0x%04x\n",title_off);
 printf("\t\t\t\t  Instrument:  0x%04x\n",inst_off);
 printf("\t\t\t\t  Music:       0x%04x\n",music_off%256);

 _settextposition(2,1);

 printf("ID:            %s\n",file_id);
 printf("Version:       %u.%u\n",cmfdata[4],cmfdata[5]);
 printf("Instruments:   %3u\n",num_inst);
 printf("Ticks/Quarter: %3u\n",ticks_quarter);
 printf("Ticks/Second:  %3u\n",ticks_second);
 printf("Tempo:         %3u\n",tempo%256);
 if(author_off)  printf("Author:  %s\n",cmfdata+author_off);
 if(remarks_off) printf("Remarks: %s\n",cmfdata+remarks_off);
 if(title_off)   printf("Title:   %s\n",cmfdata+title_off);
 printf("\n");
 printf("Channels:\n");
 for (a=0;a<16;a+=8)
 {
  printf("  %2u:%3s  %2u:%3s  %2u:%3s  %2u:%3s  %2u:%3s  %2u:%3s  %2u:%3s  %2u:%3s\n",
    a  ,cmfdata[a+20] ? "On":"---",
    a+1,cmfdata[a+21] ? "On":"---",
    a+2,cmfdata[a+22] ? "On":"---",
    a+3,cmfdata[a+23] ? "On":"---",
    a+4,cmfdata[a+24] ? "On":"---",
    a+5,cmfdata[a+25] ? "On":"---",
    a+6,cmfdata[a+26] ? "On":"---",
    a+7,cmfdata[a+27] ? "On":"---",
    a+8,cmfdata[a+28] ? "On":"---");
 }
 printf("----------------------------------------------------------------\n");
 printf("Driver Version: %u.%u  ", getcmfdriverversion()>>8, getcmfdriverversion()%256);
 setcmfstatusbyte();

 printf("Status Byte: %04x:%04x\n",FP_SEG(cmf_status),FP_OFF(cmf_status));
 puts("\n\nThe computer can count and play a song simultaneously.\nPress a key to stop playing...");
 if (cmfplay(cmfdata)==1) puts("Error playing CMF.");
 while (cmf_status[0])
 {
  _settextposition(14,50);
  printf("Status: %3u\n%u\n",cmf_status[0],count++);
  if (kbhit())
  {
   if (getch()==8) exit(8);
   else stopcmfplayback();
  }
 }
 _settextposition(14,50);
 printf("Status: %3u\n",cmf_status[0]);

 setsystemclock(25);
 initcmfdriver();
 freestatusbyte();
 hfree((char huge *)cmfdata);

 printf("\n\n\n");
 exit(0);
}
