unit Youseful;

interface

uses
  Classes,SysUtils,DsgnIntF,Install,IdWG,IdRS,IdFG,IdCF,IdGI,RptMan,Rpt2,
  UI,UiDF,YsflTool,Dialogs,WinProcs,WinTypes,Forms,IdCS;

procedure Register;

implementation

uses
  FileCtrl;

type
  TRptManDirProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

  TDLLFileNameProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

function TRptManDirProperty.GetAttributes: TPropertyAttributes;
begin
  Result := (inherited GetAttributes) + [paDialog];
end;

procedure TRptManDirProperty.Edit;
var
  Dir: String;
begin
  Dir := GetStrValue;
  if SelectDirectory(Dir,[],0) then
    SetStrValue(Dir);
end;

function TDLLFileNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := (inherited GetAttributes) + [paDialog];
end;

procedure TDLLFileNameProperty.Edit;
var
  OpenDialog: TOpenDialog;
  szSystemDir: array[0..255] of Char;
  SystemDir: String;
begin
  OpenDialog := TOpenDialog.Create(Application);
  try
    GetSystemDirectory(szSystemDir,255);
    SystemDir := StrPas(szSystemDir);
    OpenDialog.DefaultExt := 'DLL';
    OpenDialog.Filter := 'DLL Files|*.DLL';
    OpenDialog.InitialDir := SystemDir;
    if OpenDialog.Execute then SetValue(OpenDialog.FileName);
  finally
    OpenDialog.Free;
  end;
end;

procedure Register;
begin
  RegisterClasses([TInstall,TInstallAlias,TInstallFile,TInstallFileGroup,TProgramItem,TInstallRSConnection]);
  RegisterClasses([TSelectWindowGroupDlg,TInstallRSConnectionDlg,TInstallFileGroupsDlg,TInstallINIFile]);
  RegisterClasses([TInstallODBC,TCopyFileDlg]);
  RegisterClasses([TGoodInstallationDlg,TReportManager,TModifiedReport,TUnInstall,TUnInstallingFileDlg]);
  RegisterComponents('Youseful', [TInstall,TInstallAlias,TInstallFileGroup,TInstallODBC,TProgramItem,TInstallRSConnection]);
  RegisterComponents('Youseful',[TInstallINIFile,TSelectWindowGroupDlg,TInstallRSConnectionDlg,TInstallFileGroupsDlg]);
  RegisterComponents('Youseful',[TCopyFileDlg,TGoodInstallationDlg,TComponentConflictDlg,TUnInstall]);
  RegisterComponents('Youseful',[TUnInstallingFileDlg,TColorFade]);
  RegisterComponents('Ysfl(Misc)',[TReportManager,TModifiedReport]);
  RegisterNoIcon([TInstallFile]);
  RegisterComponentEditor(TInstallFileGroup, TInstallFileGroupEditor);
  RegisterComponentEditor(TInstall, TInstallEditor);
  RegisterPropertyEditor(TypeInfo(string),TReportManager,'Directory',TRptManDirProperty);
  RegisterPropertyEditor(TypeInfo(string),TReportManager,'ININame',TININameProperty);
  RegisterPropertyEditor(TypeInfo(string),TReportManager,'FileGroup',TFileGroupProperty);
  RegisterPropertyEditor(TypeInfo(TFileName),TInstallODBC,'DriverDLL',TDLLFileNameProperty);
  RegisterPropertyEditor(TypeInfo(TFileName),TInstallODBC,'SetupDLL',TDLLFileNameProperty);
end;

end.
