{$A+,B-,D-,F+,G+,I-,K+,L-,N-,P-,Q-,R-,S+,T+,V-,W-,X+,Y-}
unit MAGIC;
{
     File: MAGIC.PAS
   Author: Bob Swart [100434,2072]
  Purpose: explicit import unit for MAGIC.DLL
}
interface
Const
  NoneID = 0;
  UserID = 1;
  CompID = 2;

Type
  TPlayer = NoneID..CompID;

Const
  NilPlace   = 0; { move impossible }
  FirstPlace = 1;
  LastPlace  = 9;

Type
  TPlace = FirstPlace..LastPlace;
  TMove  = NilPlace..LastPlace;

Type
  HGame = Word; { Handle to a game }

Const
  MagicLoaded: Boolean = False; { presume nothing! }

var NewGame: function: HGame;
    EndGame: procedure(Game: HGame);
    MakeMove: procedure(Game: HGame; ID: TPlayer; Place: TPlace);
    NextMove: function(Game: HGame; ID: TPlayer): TMove;
    IsWinner: function(Game: HGame): TPlayer;
    GetValue: function(Game: HGame; Place: TPlace): TPlayer;

implementation
{$IFDEF WINDOWS}
uses WinProcs;
Const SEM_NoOpenFileErrorBox = $8000;
{$ELSE}
uses WinAPI;
{$ENDIF}

var SaveExit: pointer;
    DLLHandle: Word;

    procedure NewExit; far;
    begin
      ExitProc := SaveExit;
      FreeLibrary(DLLHandle)
    end {NewExit};

begin
  {$IFDEF WINDOWS}
  SetErrorMode(SEM_NoOpenFileErrorBox);
  {$ENDIF}
  DLLHandle := LoadLibrary('MAGIC.DLL');
  if DLLHandle >= 32 then
  begin
    MagicLoaded := True;
    SaveExit := ExitProc;
    ExitProc := @NewExit;
    @NewGame := GetProcAddress(DLLHandle,'NEWGAME');
    @EndGame := GetProcAddress(DLLHandle,'ENDGAME');
    @MakeMove := GetProcAddress(DLLHandle,'MAKEMOVE');
    @NextMove := GetProcAddress(DLLHandle,'NEXTMOVE');
    @IsWinner := GetProcAddress(DLLHandle,'ISWINNER');
    @GetValue := GetProcAddress(DLLHandle,'GETVALUE')
  end
end.
