unit Youseful;

interface

uses
  Classes,SysUtils,DsgnIntF,Install,IdWG,IdRS,IdFG,IdCF,IdGI,RptMan,Rpt2;

procedure Register;

implementation

uses
  FileCtrl;

type
  TRptManDirProperty = class(TStringProperty)
    public
      function GetAttributes: TPropertyAttributes; override;
      procedure Edit; override;
  end;

function TRptManDirProperty.GetAttributes: TPropertyAttributes;
begin
  Result := (inherited GetAttributes) + [paDialog];
end;

procedure TRptManDirProperty.Edit;
var
  Dir: String;
begin
  Dir := GetStrValue;
  if SelectDirectory(Dir,[],0) then
    SetStrValue(Dir);
end;

procedure Register;
begin
  RegisterClasses([TInstall,TInstallAlias,TInstallFile,TInstallFileGroup,TProgramItem,TInstallRSConnection]);
  RegisterClasses([TSelectWindowGroupDlg,TInstallRSConnectionDlg,TInstallFileGroupsDlg,TInstallINIFile,TCopyFileDlg]);
  RegisterClasses([TGoodInstallationDlg,TReportManager,TModifiedReport]);
  RegisterComponents('Youseful', [TInstall,TInstallAlias,TInstallFileGroup,TProgramItem,TInstallRSConnection]);
  RegisterComponents('Youseful',[TSelectWindowGroupDlg,TInstallRSConnectionDlg,TInstallFileGroupsDlg,TInstallINIFile]);
  RegisterComponents('Youseful',[TCopyFileDlg,TGoodInstallationDlg,TReportManager,TModifiedReport]);
  RegisterNoIcon([TInstallFile]);
  RegisterComponentEditor(TInstallFileGroup, TInstallFileGroupEditor);
  RegisterComponentEditor(TInstall, TInstallEditor);
  RegisterPropertyEditor(TypeInfo(string),TReportManager,'Directory',TRptManDirProperty);
  RegisterPropertyEditor(TypeInfo(string),TReportManager,'ININame',TININameProperty);
  RegisterPropertyEditor(TypeInfo(string),TReportManager,'FileGroup',TFileGroupProperty);
end;

end.
