
comment *

  XPC-Mouse:  POSITION CURSOR, COPY and PASTE in Dos Text Mode

  Copyright (c) 1994, 1995 by Jrgen G. Weber and Grant B. Gustafson.
  ALL RIGHTS RESERVED

  Free for personal use under the Gnu Public License agreement, which is
  distributed with this source. See the end of this file for a copy of
  the License Agreement.

  CREDITS
  ----------------------------------------------------------------------
  Portions of this code originated with and were extracted from
  PCMOUSE  (c) 1992,1994 by  Jrgen G. Weber
                             Wiesentalstrae 1
                             D-74523 Schwbisch Hall
                             Germany - European Union

  This ASM source written by GB Gustafson
                             113 JWB Math Dept Univ Utah
                             Salt Lake City, UT 84112
                             USA
  in collaboration with Jrgen G. Weber to create this new product.
  Portions of this ASM code also appeared in MOUSE2G, copyright (c)
  1991, 1992 by GB Gustafson. Finally, credits are due to Al Williams,
  for solid advice about TSRs, in his book "DOS 5: A Developers Guide",
  M&T Press, 1991, and to Dave Williams, for his electronic reference on
  DOS, especially the mouse information and interrupt details.
  ----------------------------------------------------------------------

  XPC-Mouse
  POSITION CURSOR, COPY and PASTE in Dos Text Mode

  Function: Highlight text while left button is pressed. Left release
            causes the selected text to be copied from the screen into
            an internal pastebuffer. The right button pastes the
            pastebuffer at the text cursor position. Left button press
            of 1/6 second positions the text cursor [defeatable]. Middle
            button press emits a carriage return (except in Xterm mode).
            Emacs/vi, matrix and Xterm style mouse action methods. See
            the HELP at the end of the file for more.

  MAKE:     tasm xpcmouse
            tlink xpcmouse

  COMMAND LINE OPTIONS: /U /T /Q /N0 /N1 /N2 /N3 /R /Xddd /Bddd
                        /M /K /P /A1 /A2 /A3 /C /H
                        See help text at the end of the file.
  STARTUP DEFAULTS:
            Auto default for video XOR highlight mask
               /X80 for color modes (xor mask == 64+16 )
               /M for mono modes (/M==/X119, xor mask == 64+32+16+4+2+1)
            /A1 for Emacs/jed/vi arrow keys
            /N3 for auto re-install of mouse handler
            /U, /Q,  /R, /T, /C, /?, /A2, /A3 defeated
            /K and /P toggles are ON
            /B128 is the default paste buffer size (16)(128)==2048 bytes

  VERSIONS:
  1.0  First public release. 1-Dec-1994
  1.1  Second release (maintenance). 17-Oct-1995

  Features of 1.0 inherited from Jrgen G. Weber's PC-Mouse versions 1.0-1.5:
          Option /T, enable stuffing the paste buffer into the
            keyboard buffer at every timer (int 1ch) tick.
          Un-install Option /U. Mouse hardware reset after de-install.
          8088 Version. Support mono, color, ega, vga text modes.
          Option /Xddd for XOR mask
          Option /Q for quiet start up
          Option /N to defeat int 21h patch (obsolete in ver 1.1)
          Option /R to reactivate TSR.
          Pastebuffer compression and interrupt logic.
          Install and de-install routines.

  Features of 1.0 originating with this ASM source written by GB Gustafson:
          Pressing the left button for 1/6 second positions the cursor.
          Default /A1 for emacs/vi/jove/jed/epsilon mouse action.
          Option /A2 is matrix mouse action, qedit/pi editors.
          Option /A3 is for Xterm X10/X11 style escapes \033[M cb cx cy.
            Works with remote jed/emacs/pi and extensible editors.
          Toggle /A state dynamically using SHIFT-ALT-buttonleft
            with ring selection /A1 --> /A2 --> /A3 --> /A1.
          Option /K defeats arrow keys and Xterm sequences.
          Option /P defeats the pastebuffer.
          ALT-buttonright duplicates buttonmiddle (for 2-button mouse).
          SHIFT-buttonleft toggles arrow keys on/off (see /K).
          SHIFT-buttonright toggles the pastebuffer on/off (see /P).
          Option /M for monochrome Video mode (/M==/X119).
          Unix file name selection on double-click using the idea
            of the X11R5 Xterm character classes.
          Hide mouse cursor after highlighting.
          Auto default for video XOR highlight mask
               /X80 for color modes (xor mask == 64+16 )
               /M for mono modes (/M==/X119, xor mask == 64+32+16+4+2+1)
          Help file dump /? gives switch information.
          Author, copying and copyright switch /C for shorter signon.
          Help file dump /H gives How-To information on mouse actions.
          Dynamic buffer size up to max size compiled into program.
          GNU license agreement.

  Features of 1.1 (by GBG 10-Oct-95):
          Fixed 40-col mode bug. Supports video modes 0-13h only.
          Add support for 3-button mouse systems PC mouse.
          Add carriage return function on button3 (==ALT-button2)
          Corrected documentation on DOS 6.2+Windows 3.1 and fixed a
           nasty Win 3.1 bug present in xpcmouse 1.0 and PCmouse
           versions to 1.6.
          Added swapping of mouse buttons, because most mouse device
           drivers don't do it.
          Option /N0 to defeat mouse handler re-install
          Options /N1, /N2, /N3 to set mouse handler re-install method.
           These work on the fly by re-running xpcmouse.

 Bug fixes:
          /T was always ON. Reset to initially OFF. 1-Dec-94

          /T ASM code caused characters to be lost on paste, traced to
          recursive call of interrupt 1ch. Fixed by setting a flag to
          bypass the second call (until the first one finished). This
          bug was also in PCMOUSE 1.5, as observed under SunPC and sun4
          OS. 1-Dec-94

          /T off worked with paste, but not with arrow keys. Traced to
          convoluted code which bypassed a call to stuff the keybuffer.
          Fixed by having a central place where the mouse handler calls
          the stuffer routines (near the exit). 1-Dec-94

          Procedure "GetMousePosition" did not test for 40-col. 1-Oct-95

          The int 21h patch caused windows to crash when DOS apps
          exited, because of "call dword ptr cs:[old_21h]", which
          corrupted the system stack. But "jmp dword ptr cs:[old_21h]"
          seems to be just fine. Now, InstallMouseHandler gets called
          before each program load and after each program exit. We will
          miss a CPM-style jump to address zero, but the /R switch will
          restart xPC-Mouse in this unlikely event. 10-Oct-95

          Documentation 1.0 claimed xpcmouse did not work in Win
          3.1. This is true for certain mouse device drivers and
          Win3.1 video drivers, especially those produced by
          hardware manufacturers before Win3.1 was released. 13-Oct-95

            For example, all DOS windows in Win3.1 get xPC-Mouse, for
            configuration DOS 6.2 + Win 3.1 + Genius mouse driver
            gmouse.com + 1994 Microsoft SVGA 256 video driver. In this
            example, xpcmouse.exe is installed in DOS 6.2 before running
            Win3.1. It fails for "gmouse.com" replaced by "mouse.com"
            obtained from the Win3.1 distribution disk!

          Buffer size was given in paragraphs in version 1.0, which is
          confusing. Changed to bytes in 1.1, with code to bump the byte
          count to full paragraphs. Default compile size changed to
          4096 maximum buffer size (BUFFERLEN variable is 4096) and
          default buffer size 2048 (no /B on command line). The choice
          of BUFFERLEN affects "loadhigh", because code+data must load
          entirely before we can shrink the pacj\kage to its runtime
          size.

  BUTTON CONVENTIONS.
          A 2-button mouse (Microsoft) has a Left button and a Right
          button. A 3-button mouse (PC Mouse Systems) has a Left button,
          Right button and Middle button. The physical layout is not
          important, because most mouse drivers allow the buttons to be
          swapped. Our discussion here assumes a right-handed mouse
          (otherwise it would be completely confusing to read) and the
          configuration below for a unix workstation using Xterm
          conventions for the mouse buttons. To understand "button1" and
          "button3", consult the ++second++ diagram, not the first!

                              Ŀ    Ŀ
           Mouse button                               
           configuration       L   R       L   M   R  
           for the PC          1   2       1   2   3  
                                  
                              Ŀ    Ŀ
           Mouse button                               
           configuration       L   R       L   R   M  
           for unix console    1   2       1   2   3  
                                  
          If you work at a unix console, then consider remapping the
          mouse keys from order 123 to 132 (3-button PC Mouse Systems
          only). Do this via the mouse device driver that comes on a
          disk with the Mouse hardware. If you are left-handed, then
          swapping buttons is not a new idea.

 CONFIGURATION FOR 3-BUTTON MOUSE.
 Most of the cheap mice with 3 buttons are just fine. I bought one for
 $9.95. It came with a diskette of software and documentation. It is
 installed in autoexec.bat with a line like

        loadhigh c:\mouse\mouse.com /c2

 which specifies COM2 for the port. Everything else is configured by the
 driver and I needed to do NOTHING. When first installed it came up as
 "Microsoft Mouse". And it worked fine as a 2-button mouse. Following
 the instructions with the mouse, I pulled the mouse connector from the
 computer, then held down the left mouse button and plugged it back in,
 then released the button. After the machine rebooted, the screen said
 "Mouse Systems Mouse" installed.

 In short, there are no mouse driver switches to set in order to get the
 3-button mouse to act like one. No changes are made to the device
 driver command line.

 But Microsoft windows 3.1 already had its mind made up that the mouse
 was a "Microsoft Mouse". So I had to run the Win 3.1 SETUP program
 (from inside Windows). The same thing can be accomplished by editing
 the SYSTEM.INI and WIN.INI sources in the windows directory, if you
 know how to do that.

 TESTING:
 The TSR was tested on about 6 different PC machines dating from 1984 to
 1995 manufacture. CPU's tested: 80286, 80386SX, 80386DX, 80486SX,
 80486DX, 80486DX2. No workable XT 8088 could be found for testing!
 However, an XT style non-extended keyboard was used and found to work.

 Not tested with XT turned off in the ASM code. It will probably not
 affect the TSR to do so, but the code as now written does not make use
 of 80286+ opcodes or special features of int 16h. Some mouse drivers
 and BIOS combinations disable the TSR unless it is compiled with the
 8088 code control symbol "XT", because the nonresident CPU and mouse
 BIOS tests cause the TSR to fail it's initial load. However, the
 failure is superficial: it may only affect de-install /U on most
 machines.

 Loads high with devices "HIMEM.SYS" and "EMM386.EXE noems" /w control
 "DOS=HIGH,UMB" under DOS 5.0 and 6.2. Loaded low with 386max, did not
 test loaded into high umb's under 386max.

 SUNPC EMULATOR. Works with DOS 4.01 under SoftPC version 3 (1992) for
  SUN4 OS (SunPC, DOS emulator from Sun Microsystems, standard
  configuration). This is the only mouse TSR known to work for DOS
  copy/paste/position in a unix environment (X-windows, DOS emulator).
  Used with COMMANDO TSR, no conflicts loaded low. Also works with WCED
  loaded high or low. In both, the arrow key feature allows positioning
  on the command line.

 DOSEMU EMULATOR. This driver can be installed as a replacement for the
  Linux programs "gpm" and "selection" under the DOS emulator called
  "dosemu", versions 0.60.4 and later (August 1995) for the Linux
  operating system (386/486 unix).

 MEMORY USAGE:
 Complaints about the TSR's resident size should take note that it will
 reside in high memory and eat about 4.6k of upper memory. By cutting
 out the pastebuffer, using option "/B0 /P", usage can be reduced to
 2.6k. A recompile, removing the arrow key code or the pastebuffer code
 will cause correspondingly significant code size reductions. Resident
 code size below 2.2k is possible, without paste buffer features.

 Vincent Penquerc'h (penquerc@merlin.enssat.fr) has a product called
 "CutPaste", which controls a paste buffer, plus a separate TSR
 called "Mousekey" which stuffs cursor keys into the keyboard buffer.
 Vincent's CutPaste product is shareware with a charge of 10
 dollars; his Mousekey is freeware, no charge. No sources are supplied.
 The claim is that "CutPaste" uses 1.9kb plus buffer space, or
 approximately 3952 bytes, while Mousekey uses 464 bytes. The total
 usage is 4416 bytes, or approximately the same as xPCmouse. Vincent's
 package has the advantage of splitting the two functions into neat
 containers. Be aware that Vincent's Mousekey operates differently than
 xPCmouse: in his, the mouse cursor and text cursor are the same.

 Jrgen G. Weber still distributes the original incarnation of PCmouse
 which does copy and paste only (no cursor positioning), hence Vincent's
 CutPaste program has a competitor (PCmouse 1.6). Be aware that these
 two programs are different: one may work for you and the other one not.

 Sources to Vincent's Mousekey may not be available; see instead
 Mouse2g.asm, mentioned above, and available from oak.oakland.edu.

 EDITORS TESTED:
 Remote over modem line: Emacs, vi, jed, jove, pi, joe, ce.
 Local PC: epsilon, pi, qedit, jed.

 Special interfaces tested: emacs, jed, pi.
   For these, we had to write extension code for the editor involved, or
   else modify the sources. The standard "mousex.sl" in the JED library
   works as written. PI needed the unix Xterm mouse code enabled for
   compilation under DOS. EMACS needed a special LISP function for the
   mouse motions.

* ; End comment

PVERSION equ '1.1: 17 Oct 1995'

TRUE equ -1
FALSE equ not TRUE
;
; Compile Time switches that change the final EXE size.
; EXE size is most affected by BUFFERLEN value. The
; actual resident code is about 2.6k total (help text not resident).
; The paste buffer is variable, size 0 to BUFFERLEN, and this adds
; up to 2k to the resident code size.
;
XT equ TRUE             ; TRUE for PC or XT 8086/8088 cpu and old bios.
                        ; FALSE for 80188+ cpu, new bios and 286 opcodes.

BUFFERLEN EQU 4096      ; Max buffer size for copying text and attributes.
                        ; Enough for a full screen. Blanks are compressed.
                        ; 1024 is enough for 1/2 of screen. Use /Bddd
                        ; option to set runtime buffer size (can be zero).
                        ; Code actually uses "BUFLEN" variable.

BUFLENDEFAULT EQU 2048  ; Default buffer size if /B not used on command line.
                        ; Must be less than of equal to BUFFERLEN
if  BUFFERLEN lt BUFLENDEFAULT
 %OUT  Inequality BUFLENDEFAULT <= BUFFERLEN violated.
 .ERR
endif
;
; Masks for mouse events
;
M_MOVED       EQU 1B       ;bit 0   mouse movement
M_LT_PRESSED  EQU 10B      ;bit 1   left button pressed (button1)
M_LT_RELEASED EQU 100B     ;bit 2   left button released
M_RT_PRESSED  EQU 1000B    ;bit 3   right button pressed (button2)
M_RT_RELEASED EQU 10000B   ;bit 4   right button released
M_MI_PRESSED  EQU 100000B  ;bit 5   middle button pressed (Mouse Systems)
M_MI_RELEASED EQU 1000000B ;bit 6   middle button released (Mouse Systems)

SPEED_LDC equ 9       ; Double click threshold 9/18.2 seconds
;

if not XT
 .286  ; the times, they're a-changing ...  memento mori 808[6|8]
endif

locals                  ; makes the local @@Label possible

; Useful macros
;
PUSHR macro regs   ;; eg: PUSHR <bx,ax,cx>
local reg
   irp reg,<regs>
     push reg
   endm
endm

POPR  macro regs   ;; eg: POPR  <cx,ax,bx>
local reg
   irp reg,<regs>
     pop  reg
   endm
endm

 XPUSHA macro
if XT
        PUSHR <AX,BX,CX,DX,BP,SI,DI>
else
        pusha
endif
 endm

 XPOPA macro
if XT
        POPR <DI,SI,BP,DX,CX,BX,AX>
else
        popa
endif
 endm

code segment
assume cs:code

begin_resident equ $    ; All resident code starts here

flag_int1c db FALSE          ; TRUE to stuff keybuffer at timer ticks.
flag_reinstall_exec db TRUE  ; TRUE to reinstall mouse handler before exec
flag_reinstall_exit db TRUE  ; TRUE to reinstall mouse handler after exit
flag_reinstall db FALSE      ; TRUE to reinstall mouse handler
counter_int10 dw 0           ; Incremented at each call of int 10h
flag_Left db FALSE           ; TRUE if left button was pressed.
flag_Right db FALSE          ; TRUE when right button pressed.
flag_Highlight db FALSE      ; TRUE if an area is highlighted on screen.
flag_MouseOn db FALSE        ; TRUE if mouse cursor is on.
flag_CtrlRight db FALSE      ; TRUE if last click was ctrl-right
flag_swapbuttons db FALSE    ; TRUE if buttons are swapped by user
button_1fix db 1             ; Shift amt button 1 in NewButtonOrder
button_2fix db 3             ; Shift amt button 2 in NewButtonOrder
button_3fix db 5             ; Shift amt button 3 in NewButtonOrder
old_mousemask dw 0           ; Mask used by last mouse handler.
old_mouseAddr dw 0           ; Last mouse handler offset.
old_mouseSegm dw 0           ; Last mouse handler segment
PositionLeft dw 0            ; Position of mouse at left click
NextPositionLeft dw 0        ; Position of mouse at a later left click
xor_mask db 01010000b        ; XOR mask for selected screen area
xor_pointer dw 0             ; Pointer to screen area to be xor'ed
lastChar db 0                ; Saved character from failed key-stuff.
lineSize dw 0                ; Characters per line on screen
videosegment  dw 0           ; Segment of screen memory
videoOffset dw 0             ; Offset into video page
lasttime dw 0,0              ; System time at last left click
counter_blanks db 0          ; Counter for blanks yet to be stuffed.
nextpair dw offset pastebuf  ; Pointer to next character pair in paste buffer.
lastpair dw offset pastebuf  ; Pointer to end of text in paste buffer.

flag_arrowkeys   db 1        ; Arrowkeys initially ON
flag_pastebuffer db 1        ; Pastebuffer initially ON
flag_editor  db 1            ; 1=emacs/vi/jove/jed, 2=matrix, 3=Xterm,
flag_double  db FALSE        ; TRUE if left button was double-clicked
flag_busy_stuffing db 0      ; TRUE if stuffing keys (see new int 1ch)
flag_doButton13 db FALSE     ; TRUE if we are to send button1 + button3
flag_doButton2  db FALSE     ; TRUE if we are to send button2
flag_doButton3  db FALSE     ; TRUE if we are to send button3
current_X        dw 0        ; Current mouse X coordinate (transient)
current_Y        dw 0        ; Current mouse Y coordinate (transient)
EndOfBuffer dw pastebuf+BUFFERLEN-1     ; Address of end of paste buffer
MAX_of_A equ 4               ; max number of /A options (1,2,3) plus 1

SPEED_LC     equ 3      ; About 3/18.2 sec left button press required.
col_present  db 0       ; col for text cursor (not mouse cursor!)
row_present  db 0       ; row for text cursor
col_target   db 0       ; col where left button was pressed
row_target   db 0       ; row where left button was pressed

; Xterm escapes for buttons 1,2,3 are in format ASCII,SCANCODE
; because they are to be stuffed directly into the keybuffer.
;
; Escape sequence for button 1
Button1_ESC db 1bh, 01h ; ESC
            db '[',1ah  ; [
            db 'M',32h  ; M
            db 20h,39h  ; SPACE
Button1_COL db 00h,00h  ; Column position
            db 00h,00h  ; Row position
Button1_LEN equ 6       ; Number of pairs in sequence
; Escape sequence for button 2
Button2_ESC db 1bh, 01h ; ESC
            db '[',1ah  ; [
            db 'M',32h  ; M
            db 21h,02h  ; SPACE+1
Button2_COL db 00h,00h  ; Column position
            db 00h,00h  ; Row position
Button2_LEN equ 6       ; Number of pairs in sequence
; Escape sequence for button 3
Button3_ESC db 1bh, 01h ; ESC
            db '[',1ah  ; [
            db 'M',32h  ; M
            db 22h,28h  ; SPACE+2
Button3_COL db 00h,00h  ; Column position
            db 00h,00h  ; Row position
Button3_LEN equ 6       ; Number of pairs in sequence
CR_ESC      db 0dh,1ch  ; Carriage return
CR_LEN      equ 1       ; Number of pairs in sequence
;
Xterm_PAD equ ' '+1     ; Offset for Xterm escapes row,col
;

; Xterm-style char classes for double-click
; Inequality a<=x<=b coded as "db a,b" below.
;
unix_pairs db 9         ; Number of active pairs below
unix_ranges db 35,35    ; # (pound)
            db 45,57    ; -./0123456789
            db 64,90    ; @ABCDEFGHIJKLMNOPQRSTUVWXYZ
            db 92,92    ; \ (backslash)
            db 95,95    ; _ (underline)
            db 97,122   ; abcdefghijklmnopqrstuvwxyz
            db 126,126  ; ~ (tilde)
            db 128,165  ; European letters
            db 224,238  ; Greek letters and infinity
            db 0,0      ; extra space for more combos
;            db 0,0      ; This table can be changed dynamically
;            db 0,0      ; on program load or restart (not implemented).
;            db 0,0      ; If you change this, also change
;            db 0,0      ; variable "unix_pairs" above!

;
; The MOUSE HANDLER is called by the mouse driver
; if an event occurs which matches the CX mask
; that was supplied at the time of installation.
; ENTRY:  The mouse device driver supplies this info:
; AX=Mouse event bits
; BX=button state: bit0=left, bit1=right, bit2=center
; CX=current X pixel coordinate, DX=current Y pixel coordinate
; SI=raw Y mickeys, DI=raw X mickeys
; DS=driver's data segment
;
MouseHandler proc far        ; Handler ends with far ret
      XPUSHA                 ; handler can't modify registers
      push ds                ; can't call DOS or BIOS
;
; Do not let mouse routines happen if interrupt 10h is active
; or is there is no text mode active (eg, graphics modes ==> no mouse)
;
      cmp counter_int10,0    ; Int 10h interrupted?
        jne short @@exit1    ; Yes, then get out of here.

@@not_in10:
      mov current_X,cx       ; Save button X and Y coordinates
      mov current_Y,dx       ; from this call.

      cmp flag_swapbuttons,TRUE ; Swapping button order?
       jnz @@swap_done
      call NewButtonOrder    ; October 1995, swap buttons
@@swap_done:
      push ax
      mov ax,40h             ; bios data area segment address
      mov ds,ax              ; Use DS to read bios variables.
      mov al,byte ptr [ds:49h] ; BIOS current video mode
      cmp al,3
        jna short @@test_events
      cmp al,7  ; BIOS current video mode
        jz  short @@test_events
      cmp al,13h ; Other video modes are graphics
        jna short @@exit0
     cmp word ptr [ds:4ch],0800h ; Assume text mode if video memory
        jbe short @@test_events  ; size is 4096k bytes or less.
@@exit0:
      pop ax
      jmp short @@exit1
@@test_events:
      pop ax
;
; TEST button event flags passed to handler in register AX
; In: AX=mouse event bits from device driver
;
@@tst_moved:
      test ax,M_MOVED           ; mouse was moved
        jz short @@tst_released
      jmp @@mouse_moved
@@tst_released:
      test ax,M_LT_RELEASED     ; a button was released
        jnz short @@left_released
@@tst_right:
      test ax,M_RT_PRESSED      ; button2 (right on 2-button mouse)
        jz short @@tst_left
      jmp @@test_shift_right
@@tst_left:
      test ax,M_LT_PRESSED      ; button1 (left button)
        jz short @@tst_button3
        jmp  @@test_shift_left
@@tst_button3:
      test ax,M_MI_PRESSED      ; button3 (middle on mouse systems)
        jz short @@tst_exit
      jmp @@button3_pressed
@@tst_exit:
@@exit1:
      jmp @@exit
;
; END of TEST button events
;

@@left_released:
      cmp flag_Left,TRUE         ; If left not pressed, then hide mouse.
        jne short @@skip_cursor
      cmp flag_double,TRUE
       je @@copy_region1
      mov ax,NextPositionLeft
      cmp ax,PositionLeft
        jz  short @@no_selection ; nothing at all marked
@@copy_region:                   ; Something to copy
      cmp flag_Left,FALSE        ; If left not pressed, then hide mouse.
        je short @@skip_cursor
@@copy_region1:
      mov flag_double,FALSE      ; Otherwise, copy screen text to
      mov flag_Highlight,TRUE    ; the pastebuffer.
      mov flag_Left,FALSE
      call Fill_pastebuffer
      cmp flag_pastebuffer,1     ; Pasting enabled?
        jne short @@copy_region2 ; No, then maybe send Xterm info
      or ax,ax                   ; Any chars copied to pastebuffer?
       jz short @@skip_cursor    ; No, then hide mouse.
@@copy_region2:
      mov flag_doButton13,TRUE   ; Send button1+button3 info
      jmp short @@skip_cursor

@@no_selection:
; Mouse was released at same location. Test if enough time has
; elapsed to call it a cursor positioning click.
      call ClickTimeCursor
        jnz short @@skip_cursor  ; Not enough time, hide mouse.
      call set_cursor        ; set text cursor position
@@skip_cursor:
      mov flag_Left,FALSE
      cmp flag_MouseOn,TRUE  ; turn off mouse cursor
        jnz short @@no_hide  ; because it confusing to have
      call HIDE_MOUSE        ; two cursors after we move the
      mov flag_MouseOn,FALSE ; text cursor or highlight an area
@@no_hide:
@@exit2:
      jmp short @@exit1

; TOGGLE: shift-button2 == pastebuffer ON/OFF
@@test_shift_right:
      test byte ptr [ds:17h],3 ; Keyboard flag, bit 0 and bit 1 = SHIFT
        jz short @@rt_pressed
      mov al,1
      sub al,flag_pastebuffer
      mov flag_pastebuffer,al
      jmp short @@exit2
;
; TOGGLE /A1-/A3 states by mouse actions
; button1+button2 == toggle to next of /A1 to /A3 in circular fashion.
;
@@rt_pressed:
      cmp flag_Left,TRUE
        jz short @@exit2     ; both buttons simultaneously pressed
@@do_insert:
;
; If ALT-button2, then simulate button 3 on 3-button mouse
;
      test byte ptr [ds:17h],8 ; Keyboard flag, bit 3 = ALT
        jnz  short @@do_insert0
      mov flag_doButton2,TRUE; Send button2 info later on
        jmp short @@do_insert1
@@button3_pressed:            ; Extra mouse button pressed (button3)
@@do_insert0:                ; or equivalent ALT-button2 was pressed
      mov flag_doButton3,TRUE; Send button3 info later on
      jmp short @@exit3      ; No paste, we are done!
@@do_insert1:

      cmp flag_pastebuffer,1 ; Are we pasting the buffer?
       jne short @@test_ctrl ; No, then go test for ctrl key
      mov flag_Right,TRUE
      mov bx,offset pastebuf
      mov nextpair,bx        ; pointer reset to start of pastebuf

; MOUSE ACTION: Add CR to end of pastebuffer output.
; If the right mouse button and CTRL were pressed, then
; set a flag to output a CR after the pastebuffer is finished.
@@test_ctrl:
      test byte ptr [ds:17h],4 ; Keyboard flag, bit 2 = CTRL
        jz short @@test_ctrl1
      mov  flag_CtrlRight,TRUE
@@test_ctrl1:
@@exit3:
      jmp  @@exit

@@mouse_moved:
      cmp flag_MouseOn,TRUE
        jz  short @@is_on
      call SHOW_MOUSE         ; switch on cursor after first movement
      mov flag_MouseOn,TRUE
@@is_on:
      cmp flag_Left,TRUE
        jnz short @@exit3     ; highlight if left button still pressed
@@do_mark:
      call highlight_text     ; In: cx,dx = mouse X,Y
      jmp short @@exit3       ; Updates NextPositionLeft.
;
; TOGGLE: shift-button1 == Arrowkeys ON/OFF
@@test_shift_left:             ; Test keyboard flag byte
      test byte ptr [ds:17h],4 ; bit 2 = CTRL
        jnz short @@exit3      ; Nothing for ALT-left or CTRL-left
      test byte ptr [ds:17h],3 ; bit 1 = LEFT SHIFT, bit 0 = RIGHT SHIFT
        jz short @@left_pressed
      test byte ptr [ds:17h],8 ; bit 3 = ALT
        jnz short @@test_left1
      mov al,1
      sub al,flag_arrowkeys    ; Toggle the flag on/off (1 or 0)
      mov flag_arrowkeys,al
      jmp  short @@exit
@@test_left1:
      mov al,flag_editor
      inc al
      cmp al,MAX_of_A        ; Toggle the cursor positioning
        jb short @@left1
      mov al,1
@@left1:                     ; Flag will be 1,2,..,(MAX_of_A-1)
      mov flag_editor,al
        jmp short @@exit     ; toggle finished

@@left_pressed:              ; get screen data after left click
      mov ax,[ds:4ah]        ; Characters per row for this video mode
      mov lineSize,ax
      mov ax,[ds:4eh]        ; Offset for current video page
      mov videoOffset,ax
      mov ax,[ds:63h]        ; Mono/Color BIOS word
      cmp ax,3B4h            ; monochrome ?
      mov videosegment,0b000h ; mono address
        jz short @@left_pressed1
      mov videosegment,0b800h ; color address
@@left_pressed1:
      call unhighlight_text     ; remove previous highlighting
      mov flag_Right,FALSE
      mov counter_blanks,0
      mov flag_Left,TRUE        ; Set left button press state
      call xy2offs              ; In: cx,dx   Out: ax
      mov PositionLeft,ax       ; Save mouse position and reset both
      mov NextPositionLeft,ax   ; because selected text was trashed.
      sub ax,2
      mov xor_pointer,ax

; SPEED_LDC is the number of ticks of the system clock, 18.2 per
; second, in which a left double-click must occur. Shorter times
; are not considered double-click candidates.

      mov flag_double,FALSE  ; Assume not a double-click.
      call ClickTimeDouble   ; Uses: AX
        jz short @@exit      ; Not enough time.
; double click
      mov flag_double,TRUE
      call highlight_word
@@exit:
      call stuff2keybuffer   ; to end a possibly active int 16h,0
      pop ds
      XPOPA
      ret
MouseHandler endp

SHOW_MOUSE proc
    push ax
    mov ax,1                ; Function show mouse
    int 33h
    pop ax
    ret
SHOW_MOUSE endp

HIDE_MOUSE proc
    push ax
    mov ax,2                ; Function hide mouse
    int 33h
    pop ax
    ret
HIDE_MOUSE endp

; calculate video offset from x and y
; The x and y are in pixel counts, not Mickeys.
;     (the Mouse unit is named after Mickey Mouse).
; In:  x=cx, y=dx ; Left upper corner of screen is x=0, y=0.
;      These values of x,y are Bios cursor locations.
;      We must convert to screen coordinates. In 40-col mode,
;      there are 16 pixels per char. In 80-col mode, 8 pixels per
;      char. In 132-col mode there are 4 pixels per char, but no mouse
;      device drivers are known to operate in 132 cols: they only know
;      about 40-col and 80-col bios modes 0 to 13h.
; Out: ax := offs = (y*lineSize)/8 + (x/8 or x/16)
; USES: ax
xy2offs proc
      PUSHR <dx,cx>
      shr cx,1
      shr cx,1
      shr cx,1
      cmp lineSize,40
      jnz short @@no_40
      shr cx,1         ; divide by 16 if there are 40 columns per line
    @@no_40:
      shr dx,1
      shr dx,1
      shr dx,1
      mov ax,dx
      mul lineSize
      add ax,cx        ; +=x
      add ax,ax        ; 2 bytes per character
      add ax,videoOffset
      inc ax           ; -> attribute
      POPR <cx,dx>
      ret
xy2offs endp

;
; Calculate from offset into screen memory the screen row, col
; Left upper corner of screen is row=0, col=0 [rows 0..59, cols 0..131]
; In: ax=offset into screen memory (includes attribute counts).
; Out: ah := col, al = row
offs2xy proc
      push bx
      shr ax,1               ; divide numerator AX by 2
      mov bx,lineSize        ; bl=denominator
      idiv bl                ; AX/bl --> al=quotient, ah=remainder
      pop bx
      ret
offs2xy endp

; show or hide mark on screen
; In: AX=characters*2 for XOR operation
; USES: AX
xor_screen proc
      PUSHR <bx,cx,dx,ds>
      call HIDE_MOUSE        ; in order not to destroy the mouse cursor
      mov bx,xor_pointer
      mov cl,xor_mask
      mov dx,videosegment
      mov ds,dx
      sar ax,1               ; Divide by 2 to get number of characters
      or  ax,ax
      jns short @@pos_loop

; mouse was moved to the left
@@neg_loop:
      xor byte ptr [ds:bx],cl   ; xor_mask applied to screen byte
      sub bx,2
      inc ax      ; inc, as counter is negative
      jnz short @@neg_loop
      jmp short @@exit
; mouse was moved to the right
@@pos_loop:
      add bx,2
      xor byte ptr [ds:bx],cl
      dec ax
      jnz short @@pos_loop
@@exit:
      call SHOW_MOUSE
      mov xor_pointer,bx
      POPR <ds,dx,cx,bx>     ;   PUSHR <bx,cx,dx,ds>
    ret
xor_screen endp

; Highlight single word chosen by double click
; USES: AX
highlight_word proc
      PUSHR <bx,ds>
      mov lasttime,0
      mov lasttime+2,0         ; prevent Triple click
      push videosegment
      pop ds
      mov bx,PositionLeft      ; point to attribute
      dec bx
      call @@tst_letter
      jc @@exit                ; clicked to void
  @@go_left:                   ; search for word begin
      call @@tst_letter
      dec bx
      dec bx
      jnc  @@go_left
      add bx,5                 ; points to attribute again
      mov  PositionLeft,bx
      dec bx
      dec bx
      mov  xor_pointer,bx
      dec  bx
  @@go_right:                  ; search for word end
      inc bx
      inc bx
      call @@tst_letter
      jnc @@go_right
      mov ax,bx
      inc bx
      mov NextPositionLeft,bx
      sbb ax,xor_pointer       ; cy is 1 from tst_let
      call xor_screen          ; Uses ax
  @@exit:
      POPR <ds,bx>
      ret

; @@tst_letter --- Test character classes.
; Do this like Xterm, with a string of data pairs:
; 35:35,45:57,64:90,95:95,97:122,128:165
; USES: AX
;
  @@tst_letter:
      push si
      mov si,offset unix_ranges
      mov ah,0
      mov al,[ds:bx]
  @@tst_loop:
      cmp ah,unix_pairs
      je @@tst_failed
      inc ah
      cmp byte ptr [cs:si],al
      jbe short @@tst_1
      inc si
      inc si
      jmp short @@tst_loop
  @@tst_1:
      inc si
      cmp al,byte ptr [cs:si]
      jbe short @@tst_worked
      inc si
      jmp short @@tst_loop
  @@tst_worked:
      clc
      jmp short @@tst_exit
  @@tst_failed:
      stc
  @@tst_exit:
      pop si
      ret
highlight_word endp
;
; Highlight screen area that was traversed during mouse motion.
; In: cx,dx = mouse X,Y
; USES: AX
highlight_text proc
      call xy2offs            ; In: cx,dx   Out: ax
      push ax                 ; New left mouse position
      sub ax,NextPositionLeft ; ax/2 == number of positions traversed
      pop NextPositionLeft    ; update new mouse position
      jz short @@exit         ; too little mouse motion
      call xor_screen         ; In: AX=number positions times 2
      mov flag_Highlight,TRUE
    @@exit:
      ret
highlight_text endp

; Remove highlight from screen area.
; Uses: AX
unhighlight_text proc
    push bx
      cmp flag_Highlight,TRUE
        jnz short @@exit     ; Highlighting was already undone.
      mov bx,PositionLeft
      mov ax,NextPositionLeft
      sub ax,bx
        je  short @@exit     ; Nothing highlighted
      mov bx,PositionLeft
      dec bx
      dec bx
      mov xor_pointer,bx     ; Set pointer into screen memory
      call xor_screen        ; Unhighlight. Uses: AX=Length of region
      mov flag_Highlight,FALSE
   @@exit:
   pop bx
   ret
unhighlight_text endp

;
; Fill_pastebuffer: Read the selected characters into pastebuffer.
; Called after double click or left selection.
;
Fill_pastebuffer proc
      PUSHR <bx,cx,dx,si,di,es>
      cmp flag_pastebuffer,1     ; Are we supposed to paste?
        jne short @@exit_nochars ; No, then quit with no chars.
      push cs                ; Yes, then fool with pastebuffer
      pop es                 ; store chars to es:di
      mov bx,PositionLeft
      mov cx,NextPositionLeft
      dec bx
      dec cx                 ; doesn't point to attribute any more now
      mov dx,2
      mov di,offset pastebuf
      cmp bx,cx
        jc  short @@no_swap  ; not marked from right to left
        jz  short @@exit_nochars     ; nothing at all marked
      xchg bx,cx             ; now from left to right
      add bx,dx
      add cx,dx
      cmp bx,cx
        jnz short @@no_swap  ; something marked
@@exit_nochars:              ; Nothing marked
      mov ax,0
      jmp @@@exit
@@no_swap:
      cld
      mov ax,videosegment
      mov ds,ax
      mov ah,0

@@rd_loop:
      cmp di,EndOfBuffer
        ja short @@no_bln_left  ; Buffer is full
      mov al,[ds:bx]
      cmp al,' '
        ja short @@normal_char
      inc ah                 ; ah == compression count for ' '
      cmp ah,32              ; ah == 32 means 32 ' ' characters.
        jnz short @@next_char
      stosb                  ; Otherwise, store coded byte
      mov ah,0               ; and continue with the next one
      jmp short @@next_char

@@normal_char:
      cmp ah,0               ; are there blanks left unstored ?
        jz short @@no_blks   ; no, it's a normal char
      xchg al,ah             ; yes, it's a coded ' '
      stosb                  ; Squirrel away coded ' ' byte
      xchg al,ah
      mov ah,0               ; Attribute byte is 0 for coded ' '
@@no_blks:
      stosb                  ; store char, coded or otherwise

@@next_char:
      add bx,dx              ; next char on screen

; Test, if at line end on screen
; condition: screen pos mod (characters per line) == 0

      PUSHR <dx,cx,ax>
      xor dx,dx              ; must be 0 before divide
      mov ax,bx              ; screen pos
      sub ax,videoOffset
      mov cx,lineSize        ; CX == 40 or CX == 80
      add cx,cx              ; *2 because of ascii,attribute
      div cx
      or dx,dx               ; Division remainder == 0 ?
        jnz short @@not_eol

@@go_back:                   ; discard blanks until end of line
      dec di
      cmp byte ptr [es:di],' '
        ja  short @@no_back
      cmp byte ptr [es:di],0 ; end of previous line ?
        ja short @@go_back
@@no_back:
      inc di
      mov al,dl              ; 0 to mark end of line
      stosb
      pop ax                 ; ax must have been pushed last
      xor ah,ah              ; Zero the ' ' counter
      push ax
@@not_eol:
      POPR <ax,cx,dx>
      cmp bx,cx              ; at the end of selected area ?
        jnz short @@rd_loop
      or ah,ah               ; blanks left to store ?
        jz short @@no_bln_left
      mov al,ah
      stosb                  ; store remaining blanks
@@no_bln_left:
      mov lastpair,di        ; pointer to end of used buffer area

@@exit:
      mov ax,1
@@@exit:
      POPR <es,di,si,dx,cx,bx>  ; PUSHR <bx,cx,dx,si,di,es>
      ret
Fill_pastebuffer endp

; ClickTimeDouble --- Return Z if time since last left click too short.
; Uses: AX
ClickTimeDouble proc
      PUSHR <cx,dx>
      mov ah,0
      int 1ah                ; read system clock counter
      mov ax,0               ; Return AX==0 in Z flag
      push cx                ; high word
      push dx                ; low word
      sub  dx,lasttime
      sbb  cx,lasttime+2     ; cx:dx = ticks since last click
      pop  cs:lasttime
      pop  cs:lasttime+2     ; save new clock time
      or cx,cx
        jnz short @@exit     ; Exceeded 65535/18.2 seconds
      cmp dx,SPEED_LDC
        ja short @@exit      ; Exceeded SPEED_LDC seconds
      mov ax,1               ; Was a double-click.
@@exit:
     or ax,ax
     POPR <dx,cx>
     ret
ClickTimeDouble endp

; ClickTimeCursor --- Return Z if time since last left-click was short.
; Uses: AX
ClickTimeCursor proc
      PUSHR <cx,dx>
      mov ah,0
      int 1ah                ; read system clock counter
      mov ax,0               ; Return AX==0 in Z flag
      sub  dx,lasttime
      sbb  cx,lasttime+2     ; cx:dx = ticks since last left press
      or cx,cx
        jnz short @@exit     ; Exceeds 65535/18.2 seconds
      cmp dx,SPEED_LC
        ja short @@exit      ; Exceeds 3/18.2 seconds
      mov ax,1
@@exit:
     or ax,ax
     POPR <dx,cx>
     ret
ClickTimeCursor endp


; Entry: AX = button bits from Mouse Device Driver
; Exit:  AX = button bits for swapped button order
;        Uses AX and flags

NewButtonOrder proc
     push cx
     push bx
     mov bl,al          ; bits to fix
     xor bh,bh          ; accumulator
     shl bl,1           ; fix up for BitBuster routine
     mov cl,button_1fix ; shift amount for button 1
     call BitBuster     ; gather the bits
     mov cl,button_2fix ; shift amount for button 2
     call BitBuster     ; gather the bits
     mov cl,button_3fix ; shift amount for button 3
     call BitBuster     ; gather the bits
     and al,10000001B   ; strip relevant bits
     or al,bh           ; insert new bits
     pop bx
     pop cx
     ret
NewButtonOrder endp

; Twiddle bits in the button word to get new order

BitBuster proc
     shr bl,1           ; move over 2 bits
     shr bl,1
     mov ch,bl
     and ch,00000011B   ; get lower two bits
     shl ch,cl          ; shift proper amount
     or bh,ch           ; add to accumulator
     ret
BitBuster endp

; Do soft reset on Mouse driver

SoftMouseReset proc
; Software Reset, to put handler into defined state
      mov ax,21h
      int 33h
      ret
SoftMouseReset endp

; install mouse handler

InstallMouseHandler proc far
      XPUSHA
      push es
      push cs
      pop es
      mov dx,offset MouseHandler
      mov cx,(M_MOVED or M_LT_PRESSED or M_LT_RELEASED or M_RT_PRESSED or M_RT_RELEASED or M_MI_PRESSED or M_MI_RELEASED)
      mov ax,14h             ; Swap Interrupt Subroutines
      int 33h
                             ; ignore old interrupt routine
      pop es
      XPOPA
      ret
InstallMouseHandler endp


; Get characters from the paste buffer
; Characters are 33 to 255
; A character nnn less than 33 represents nnn Blanks
; End of line is marked with 0
;
INCZ macro op  ; if Z op++
local not_zero
jnz short not_zero
inc op
not_zero:
endm

; In: Nothing
; Out: ZF flag == buffer empty else AL == char found
; Uses: AX, flags
;
GetPastebuffer2AL proc
      push bx
      cmp flag_pastebuffer,0
        jz short @@buf_empty
      cmp flag_Right,FALSE
        jz  short @@buf_empty
      cmp counter_blanks,0
        jz  short @@no_bln_lft
      dec counter_blanks
      INCZ nextpair
      mov al,' '
      jmp short @@char_found

@@no_bln_lft:
      mov bx,nextpair
      cmp bx,lastpair
        jnz short @@not_empty
      cmp flag_CtrlRight,TRUE     ; append CR, too ?
        jnz short @@buf_empty
      mov flag_CtrlRight,FALSE    ; Mark that we did it.
      mov al,13                   ; return CR
      jmp short @@char_found

@@not_empty:
      mov al,[cs:bx]              ; get next character
      cmp al,0                    ; end of line ?
        jnz short @@not_eol
      mov al,13
      inc nextpair
      jmp short @@char_found

@@not_eol:
      cmp al,' '
        jbe short @@blanks
      inc nextpair
      jmp short @@char_found
@@blanks:
      mov ah,al
      mov al,' '
      dec ah
      mov counter_blanks,ah
      INCZ nextpair           ; blanks exhausted
@@char_found:
      clc
      jmp short @@exit
@@buf_empty:
      stc
@@exit:
      pop bx
      ret
GetPastebuffer2AL endp


; Patch for EXEC Function
; Fixed by GBG October 1995. See notes at top of file.

old_21h dw 0,0
killed_flg db FALSE

new_21h proc far
      pushf
      cmp flag_reinstall_exit,FALSE
       je short @@test_exec     ; don't install mouse handler after exit
      cmp ah,4ch                ; Exit program
       je short @@reinstall
      cmp ah,00h                ; Exit program
       jne short @@test_exec
@@reinstall:
      mov flag_reinstall,TRUE
@@test_exec:
      cmp flag_reinstall_exec,FALSE
       je short @@do_old_21h    ; don't install mouse handler before exec

@@test_exec_x:
      cmp ax,4b00h              ; exec program
       jne short @@do_old_21h   ; nothing special
      cmp killed_flg,TRUE    ; /U in the mean time ?
       je short @@do_old_21h   ; we are in process of uninstall /U
      call InstallMouseHandler
      mov flag_reinstall,FALSE

@@do_old_21h:
      popf
      jmp dword ptr cs:[old_21h]

new_21h endp


; Patch for Interrupt 10h

old_10h dw 0,0

new_10h proc far
      pushf                     ; simulate interrupt
      cmp flag_reinstall,FALSE
       je @@test_mouse
      cmp counter_int10,0
       jne short @@test_mouse
      mov flag_reinstall,FALSE
      call InstallMouseHandler
@@test_mouse:
      cmp flag_MouseOn,TRUE
        jnz short @@no_hide
      call HIDE_MOUSE
      mov flag_MouseOn,FALSE
@@no_hide:
      cmp flag_Highlight,TRUE
        jnz short @@no_un_sel
      push ax
      call unhighlight_text     ; Uses AX
      pop ax
      mov flag_Left,FALSE
@@no_un_sel:
      inc counter_int10         ; Mark int 10h active
      popf
      pushf                     ; simulate int
      call dword ptr [old_10h]
      pushf
      dec counter_int10         ; Mark int 10h inactive
      popf
      iret
new_10h endp

; BIOD data segment equates
;
biosdata segment at 40h
org 1ah
headptr dw (?)  ; pointer to next key entry to read
tailptr dw (?)  ; pointer to last read key entry
org 80h
bufstrt dw (?)  ; pointer to start keyboard buffer
bufend  dw (?)  ; pointer to end keyboard buffer
biosdata ends

stuffkeyCX proc
; substitute for Int 16h, function 5
; in:  ch=scan code
;      cl=ascii
; out: al=0 success
;      al=1 buffer full
; USES: ax,cx
;
   push ds
   push bx
   pushf
    cli
    mov ax,biosdata
    mov ds,ax
    mov ax,ds:tailptr
    add ax,2
    mov bl,1
    cmp ax,ds:headptr ; don't want tailptr == headptr after exit
    jz  short @@full  ; because it means buffer is empty!
    cmp ax,ds:bufend  ; Ringbuffer, may need to bump pointer
    jnz short @@no_wrap
    mov ax,ds:bufstrt ; wrap around was required
@@no_wrap:            ; AX == new tailptr position
    cmp ax,ds:headptr ; don't want tailptr == headptr after exit
    jz  short @@full  ; because it means buffer is empty!
@@go_ahead:
    mov bx,ds:tailptr ; old tailpointer
    mov [ds:bx],cx    ; store scan+ascii
    mov ds:tailptr,ax
    mov bl,0
@@full:
    mov al,bl
   popf
   pop bx
   pop ds
   or  al,al              ; 0 == save was successful
   ret                    ; sti not appropriate here
stuffkeyCX endp
;
; Test keyboard buffer for room to copy scan codes
; In: AL == # scan codes
; Out: NZ flag set if no room exists
; Uses: AX, FLAGS
Check4Room proc
   PUSHR <ds,bx,ax>
    mov bl,al           ; Number of pairs required
    mov ax,biosdata
    mov ds,ax
    mov ax,ds:tailptr
@@loop:
    add ax,2
    cmp ax,ds:bufend  ; Ringbuffer, may need to bump pointer
      jnz short @@no_wrap
    mov ax,ds:bufstrt ; wrap around was required
@@no_wrap:            ; AX == new tailptr position
    cmp ax,ds:headptr ; don't want tailptr == headptr after exit
    jz  short @@full  ; because it means buffer is empty!
@@go_ahead:
    dec bl
    or bl,bl
    jnz short @@loop
@@full:
   or  bl,bl              ; 0 == it worked, NZ == failed
   POPR <ax,bx,ds>
   ret
Check4Room endp
;
; Patch for int 1ch
;
new_1ch proc far
      pushf
      cmp flag_busy_stuffing,1  ; In routine "stuff2keybuffer"?
        je @@skip            ; wait until next timer tick
      call stuff2keybuffer   ; write characters into keyboard buffer
@@skip:
      popf
      db 0eah                ; Code for jmp far
old_1ch dw 0,0
new_1ch endp

; Patch for int 16h

new_16h proc far
      cmp  ah,MOUSE_FN       ; New function for int 16h
        jnz  short @@skip1
      dec  ah                ; AH unchanged by normal bios call
      mov  cx,IDENTCODE      ; Return identity code
      push cs                ; and far address of the pastebuffer
      pop  es                ; es:bx := buffer address
      mov  bx,offset pastebuf
      iret
@@skip1:
      pushf
      cmp flag_busy_stuffing,1  ; In routine "stuff2keybuffer"?
        je @@skip2           ; wait until next timer tick
      call stuff2keybuffer   ; else, write character into keyboard buffer
@@skip2:
      popf
      db 0eah                ; Code for jmp far
old_16h dw 0,0
new_16h endp

;
; Arrow key routines, does not depend on Xterm standard.
;
LeftArrow proc
      mov cx,4b00h      ;cl=0, ch=4bh Left arrow key
      call stuffkeyCX   ; uses ax,cx
      ret
LeftArrow endp
DownArrow proc
      mov cx,5000h      ;cl=0, ch=50h Down arrow key
      call stuffkeyCX   ; uses ax,cx
      ret
DownArrow endp
UpArrow proc
      mov cx,4800h      ;cl=0, ch=48h Up arrow key
      call stuffkeyCX   ; uses ax,cx
      ret
UpArrow endp
RightArrow proc
      mov cx,4d00h      ;cl=0, ch=4dh Right arrow key
      call stuffkeyCX   ; uses ax,cx
      ret
RightArrow endp

;
; Xterm standard uses the sequence "ESC [ M cb cx cy" where
; cb=32 for press button1, cb=34 for press button3, cb=33 for
; press button2, cb=35 for release (any) button, cx=32+1+col,
; cy=32+1+row where (0,0) is upper left corner of screen
;
; Stuff a string of scan code data into the keyboard buffer
;
; In: bx=offset to string, al=number of pairs
; Uses: ax,bx
;
; The string must fit all at once for this procedure to succeed.
; We test the keyboard buffer to see if there is room to do the copy.
; If not enough room, then the call fails!
;
StuffCodes2keybuffer proc
      push cx
      cmp flag_arrowkeys,0    ; Arrow and Xterm stuffing disabled?
        je short @@exit       ; Yes, then quit fast.
; Test for room to do the copy
      call Check4Room         ; Does the keyboard buffer have room
        jnz short @@exit      ; for AL pairs? NZ flag == NO ROOM, Exit!
@@loop:
      cmp al,0
      je @@exit
      dec al
      mov cl,byte ptr [cs:bx]      ; ASCII value
      inc bx
      mov ch,byte ptr [cs:bx]      ; Scan code
      inc bx
      push ax
      call stuffkeyCX              ; uses ax,cx
      pop ax
      jmp short @@loop
@@exit:
      pop cx
      ret
StuffCodes2keybuffer endp

; Stuff cursor location into data area using Xterm codes
; In: al=Y=row, ah=Y=col, the cursor location in PC terms.
;     bx=offset to data area
; Uses: ax,bx
; Xterm codes are ROW=X+' '+1, COL=Y+' '+1.
; Xterm_PAD==' '+1. Assume fake scan codes.
;
StuffLoc2buffer proc
      add ah,Xterm_PAD          ; coded col for Xterm
      mov byte ptr [cs:bx],ah
      inc bx
      inc bx
      add al,Xterm_PAD          ; coded row for Xterm
      mov byte ptr [cs:bx],al
      ret
StuffLoc2buffer endp

; Stuff left button info into keyboard buffer
; In: al=row, ah=column
; Uses: ax
;
StuffButton1 proc
      push bx
      mov bx,offset Button1_COL ; Offset to data area
      call StuffLoc2buffer      ; Stuff cursor location into buffer
      mov bx,offset Button1_ESC ; Escape sequence for button 1
      mov al,Button1_LEN        ; Number of pairs in button 1 escape.
      call StuffCodes2keybuffer ; Stuff escape seq into key buffer
      pop bx
      ret
StuffButton1 endp

; Simulate press of button 3 on any mouse. Left release is mapped to
; the press of button three which normally follows button one. This button
; ends the marking of a region and maybe it copies it too, depending on the
; client program at the remote host end.
;
StuffButton3 proc
; In: al=row, ah=column
; Uses: ax
; We assume the keyboard buffer empty!
; Simplifies logic, but may fail.
      push bx
      mov bx,offset Button3_COL ; Data area pointer
      call StuffLoc2buffer      ; Stuff cursor location into buffer
      mov bx,offset Button3_ESC ; Escape sequence for button 3
      mov al,Button3_LEN        ; Number of pairs in button 3 escape.
      call StuffCodes2keybuffer ; Stuff escape seq into key buffer
      pop bx
      ret
StuffButton3 endp

StuffCR proc
; Uses: ax
; We assume the keyboard buffer empty!
; Simplifies logic, but may fail.
      push bx
      mov bx,offset CR_ESC ; Escape sequence for carriage return
      mov al,CR_LEN        ; Number of pairs in cr escape.
      call StuffCodes2keybuffer ; Stuff escape seq into key buffer
      pop bx
      ret
StuffCR endp
;
; Simulate button2 press on any mouse.
;
StuffButton2 proc
; In: al=row, ah=column
; Uses: ax
; We assume the keyboard buffer empty!
; Simplifies logic, but may fail.
      push bx
      mov bx,offset Button2_COL ; Data area pointer
      call StuffLoc2buffer      ; Stuff cursor location into buffer
      mov bx,offset Button2_ESC ; Escape sequence for button 2
      mov al,Button2_LEN        ; Number of pairs in button 1 escape.
      call StuffCodes2keybuffer ; Stuff escape seq into key buffer
      pop bx
      ret
StuffButton2 endp

;
; Do Xterm selection by stuffing escapes into the keyboard buffer
; Our selection here maps a button1 drag into "press left", "move"
; and "press right", which is the 3-button Xterm standard for marking
; a region.
;
DoXtermButton1Button3 proc
      cmp flag_editor,3      ; Is it Xterm mode?
        jne short @@exit
      push cx
      mov ax,PositionLeft
      mov cx,NextPositionLeft
      cmp ax,cx
        jc  short @@no_swap  ; not marked from right to left
      xchg ax,cx             ; now from left to right
@@no_swap:
; Send left button info
      push cx
      call offs2xy           ; AX/lineSize --> al=quotient, ah=remainder
      call StuffButton1      ; stuff Xterm escape for button 1
; Send right button info, to simulate button3 on a 2-button mouse.
      pop ax                 ; prep for integer division, AX=top
      call offs2xy           ; AX/lineSize --> al=quotient, ah=remainder
      call StuffButton3      ; stuff Xterm escape for button 3
      pop cx
@@exit:
      ret
DoXtermButton1Button3 endp

;
; Stuff button 2 (see unix figure) info into the keyboard buffer
; This button normally causes the remote client to insert the
; local pastebuffer (unix Xterm standard).
;
DoXtermButton2 proc
      cmp flag_editor,3      ; Is it Xterm mode?
        jne short @@exit
      call GetMousePosition  ;al=row, ah=col
      call StuffButton2
@@exit:
      ret
DoXtermButton2 endp

;
; Stuff right button (button 3) info into the keyboard buffer
; This button normally causes the remote client to define the
; region after a left button was received (Xterm standard).
; This is the extra button on a PC 3-button mouse.
;
DoXtermButton3 proc
      cmp flag_editor,3      ; Is it Xterm mode?
        jne short @@exit
      call GetMousePosition  ;al=row, ah=col
      call StuffButton3
@@exit:
      ret
DoXtermButton3 endp
;
; stuff2keybuffer --- Write characters into keyboard buffer
;
stuff2keybuffer proc               ; stuff to keyboard buffer
      mov flag_busy_stuffing,1  ; Don't let the timer interrupt
                                ; re-enter this routine!
      XPUSHA
      xor cx,cx
      xchg cl,lastChar       ; character left from last attempt
      or cl,cl               ; 0 == nothing left
        jnz short @@after_rd ; save character from last trial
@@loop:
      call GetPastebuffer2AL ; Nothing returned if flag_pastebuffer == 0
      mov cl,al              ; else AL == char found in pastebuffer
        jc short @@@exit     ; nothing to stuff into keybuffer
@@after_rd:
      push cx
      cmp cl,0
      mov ch,0               ; scancode, only relevant for ENTER
       jz @@scan_code        ; Potential trouble: wrong scan codes!
      mov ch,1ch             ; scancode for ENTER
@@scan_code:
      call stuffkeyCX        ; stuff CX to keyboard buffer, uses ax,cx
      pop cx
        jz  short @@loop     ; 0 == save was successful
      mov lastChar,cl        ; save for next time
      jmp short @@exit

@@@exit:                     ; Get here because pasting is finished.
      mov lastChar,0
      call StuffArrows       ; Stuff arrow keys and Xterm sequences
@@exit:
      XPOPA
      mov flag_busy_stuffing,0  ; Let the timer interrupt
                                ; re-enter this routine!
      ret
stuff2keybuffer endp

;
; Move cursor by stuffing keyboard buffer with escapes or arrow keys.
;
StuffArrows proc
;
@@arrows:
;
; emacs/vi: If the target row is not equal to the present row, then move
;           the cursor to column one of the same line before doing any
;           further cursor motion. Logic from emacs/vi/jed/jove.
; matrix:   Move to row first, then to column, no tricky cursor moves.
; xterm:    Use the escape sequence \033 [ M cb cx cy
;           for left button press.
;
      cmp flag_arrowkeys,1     ; Arrow keys on?
        je short @@test_emacs_vi
        jmp @@exit             ; No, then get out of here fast.
@@test_emacs_vi:
      cmp flag_editor,1        ; Using a method suitable for emacs/vi?
        jne short @@test_matrix
        jmp short @@do_emacs_vi
@@test_matrix:
      cmp flag_editor,2        ; Using a method suitable for matrix editor?
        jne short @@test_xterm ; Test Xterm escapes
        jmp @@do_matrix        ; Do matrix method
@@test_xterm:
      cmp flag_editor,3
      jne short @@do_xterm_exit
;
@@do_xterm:
      cmp flag_doButton13,TRUE
        jne short @@do_xterm1
      call DoXtermButton1Button3 ; Send button 1 + button 3.
      mov flag_doButton13,FALSE
      jmp short @@do_xterm_exit
@@do_xterm1:
      cmp flag_doButton2,TRUE
        jne short @@do_xterm2
      call DoXtermButton2    ; Send button2 info
      mov flag_doButton2,FALSE
      jmp short @@do_xterm_exit
@@do_xterm2:
      cmp flag_doButton3,TRUE
        jne short @@do_xterm3
      call DoXtermButton3    ; Send button3 info
      mov flag_doButton3,FALSE
      jmp short @@do_xterm_exit
@@do_xterm3:
      mov al,col_target
      cmp al,col_present
        jne short @@do_xterma
      mov al,row_present
      cmp al,row_target
        je short @@do_xterm_exit
@@do_xterma:                    ; We assume the keyboard buffer empty!
                                ; Simplifies logic, but may fail.
      mov ah,col_target         ; AX=Where to report cursor
      mov al,row_target
      push ax
      call StuffButton1         ; Stuff Xterm escape into keybuffer
      pop ax
      mov col_present,ah
      mov row_present,al
@@do_xterm_exit:
      jmp short @@exit
;
@@do_emacs_vi:
      mov al,row_present
      cmp row_target,al
      je short @@downarrow      ; row_target == row_present
@@arrow_loop:
      cmp col_present,0
      je short  @@downarrow     ; col_present == 0
      call LeftArrow
        jnz short @@exit        ; it failed, keybuffer full
      dec col_present           ; move one left
      jmp short @@arrow_loop
;
@@do_matrix:
@@downarrow:
      mov al,row_present
      cmp row_target,al
      je short @@rightarrow     ;row_target == row_present
      jl short @@uparrow        ;row_target < row_present
;
; row_target > row_present
;
      call DownArrow
        jnz short @@exit        ; failed, keybuffer full
      inc row_present           ; move one row down
      jmp short @@downarrow
;
; row_target < row_present
;
@@uparrow:                      ;row_target < row_present
      call UpArrow
        jnz short @@exit        ; failed, keybuffer full
      dec row_present           ; move one up
      jmp short @@downarrow

@@rightarrow:
      mov al,col_present
      cmp col_target,al
      je short @@special_exit   ; col_target == col_present
      jl short @@leftarrow      ; col_target < col_present
;
; col_target > col_present
;
      call RightArrow
        jnz short @@exit        ; failed, keybuffer full
      inc col_present           ; move one right
      jmp short @@rightarrow
;
; col_target < col_present
;
@@leftarrow:
      call LeftArrow
        jnz short @@exit        ; failed, keybuffer full
      dec col_present           ; move one left
      jmp short @@rightarrow

@@exit:
@@special_exit:
      cmp flag_doButton3,TRUE
        jne short @@@exit
      call StuffCR              ; stuff CR into keybuffer
        jnz short @@exit        ; keybuffer full, failed
      mov flag_doButton3,FALSE
@@@exit:
      ret
StuffArrows endp


;
; Get mouse position from handler's last call
; OUT: al=row, ah=col
; USES: AX
GetMousePosition proc
      PUSHR <dx,cx>
      mov cx,current_X
      shr cx,1          ; Get target column position in cl
      shr cx,1
      shr cx,1
      cmp lineSize,40
      jnz short @@not_40
      shr cx,1         ; divide by 16 if there are 40 columns per line
    @@not_40:
      mov dx,current_Y
      shr dx,1          ; Get target row position in dl
      shr dx,1
      shr dx,1
      mov al,dl
      mov ah,cl
      POPR <cx,dx>
      ret
GetMousePosition endp
;
; Set cursor position. Later, the keyboard buffer is stuffed by "stuff2keybuffer".
; Uses: AX
set_cursor proc
      PUSHR <bx,ds>
      call GetMousePosition  ;al=row, ah=col
      mov col_target,ah
      mov row_target,al
      ; Get current text cursor position from BIOS variable
      mov ax,40h        ; Segment of DOS bios
      mov ds,ax
      mov ah,0
      mov al,byte ptr [ds:62h]   ;Get current video page number
      add al,al         ; AL=2*AL
      add al,50h        ; 50h=cursor position bios data (8 16-bit words)
      mov bx,ax         ; BX=offset in segment 40h
      mov ax,[ds:bx]    ;Get cursor position for current page
      mov row_present,ah
      mov col_present,al
      mov lasttime,0
      mov lasttime+2,0  ; shut off click timing
@@exit:
      POPR <ds,bx>      ; PUSHR <bx,ds>
      ret
set_cursor endp


; NB: The next two variables should be in this order before pastebuf
; so that /U can de-install the TSR.

XPC_pspadr dw 0                         ; psp address of installed XPC-mouse
ENDPAIR dw offset lastpair              ; Pointer to actual end
BUFLEN  dw BUFLENDEFAULT                ; Buffer size in bytes
                                        ; Changed by /B command line switch
; buffer for read characters,
; can overwrite initialization code

pastebuf equ $

DE_INSTALL    equ 2     ; See option /U, procedure "get_opt" below.
REACTIVATE    equ 3     ; See option /R
NOT_INSTALLED equ 40h   ; FLAG for driver not installed.
ALL_OK        equ 41h   ; FLAG for all go.
WRO_VEC       equ 42h   ; FLAG for wrong vector detected.
MOUSE_FN      equ 80h   ; new function of int 16h that detects
                        ; previous installation of the program
INST_HND      equ 67h   ; tell int 16 to reinstall mouse handler
IDENTCODE     equ 16879 ; A 16-bit number used to test validity of /U
                        ; and /R options.

 TESTCPU macro
; Test for 80188 cpu or later. See startup code. Not used for XT.
if not XT
      mov cl,33       ; Test for 80188 or successor
      shl ax,cl
      or  cl,cl       ; 188+ maximally shift 32 positions
      mov dx,offset wro_cpu_str
      jz @@errexit
endif ; not XT
 endm

 TESTBIOS macro
if not XT
; Test for modern Bios with int 16,5. See startup code. Not used for XT.
; Equipment check for enhanced keyboard.
      mov ax,40h
      mov es,ax
      test byte ptr [es:96h],10000b ; enhanced keyboard installed ?
      jz @@errexit
endif ; not XT
 endm

; Local variables used to parse command line. These get wiped out by
; the paste buffer, which writes over this area.
;
quiet_flag db FALSE          ; TRUE to display everything, FALSE defeats
copying_flag db FALSE        ; TRUE to display copying info
counter_Xoption db 0         ; Counter for number of /M and /X options.
how_to_flag db FALSE         ; TRUE if to display only How-To string
ExecExit_flag db FALSE       ; TRUE if /N on command line

; change interrupts and install mouse handler
;
; GET OPTIONS. Returns special options in ah.
;
get_opt proc
        mov si,80h            ; si => command line parameters
        seges
        lodsb                 ; count
        mov bh,0
        mov bl,al
        mov es:[si+bx],bh        ; 0
        or  al,al
        jnz  @@findslash
@@goto_parm_done:
        jmp  @@parm_done
@@findslash:
        seges
        lodsb
        or al,al
        jz  @@goto_parm_done
        cmp al," "
        jz short @@findslash     ; +DEC CX
        cmp al,"/"
        jz  short @@good_sep
        cmp al,"-"
        jnz @@parm_err
@@good_sep:
;  Valid options to return in register ah:
;  DE_INSTALL, REACTIVATE
;
@@loop:                       ; Added some documentation of steps
        seges                 ; on 1-Nov-1994
        lodsb
@@HELP_setup:
        cmp al,'?'            ; Got ? on command line
          jz short @@parm_err

        and al,not ('a'-'A')  ; toupper

        cmp al,'H'            ; Got /H on command line
          jnz @@HELP_setup_exit
          mov how_to_flag,TRUE
          jz short @@parm_err
@@HELP_setup_exit:
@@U_setup:
        cmp al,'U'            ; Got /U for uninstall
        mov ah,DE_INSTALL
          jnz short @@U_setup_exit
        jmp @@exit
@@U_setup_exit:
@@R_setup:
        cmp al,'R'            ; Got /R for reactivate driver
        mov ah,REACTIVATE
          jnz short @@R_setup_exit
        jmp @@exit
@@R_setup_exit:
;
; Loop on the other command line options
;
@@N_setup:
        cmp al,'N'            ; Got /N for mouse handler re-install
          jnz short @@N_setup_exit
        mov ExecExit_flag,TRUE
        call parse_num        ; 0=defeat, 1=on exec, 2=on exit, 3=both
        mov flag_reinstall_exec,FALSE
        mov flag_reinstall_exit,FALSE
        test ax,1
          jz @@N_1
        mov flag_reinstall_exec,TRUE
@@N_1:
        test ax,2
          jz @@N_2
        mov flag_reinstall_exit,TRUE
@@N_2:
        jmp @@findslash
@@N_setup_exit:
@@S_setup:
        cmp al,'S'           ; Got /S for button swap order
         jnz short @@S_setup_exit
        call parse_num        ; Get number nnn after '/S'
        call setbuttonswap
        jmp @@findslash
@@S_setup_exit:
@@C_setup:
        cmp al,'C'            ; Got /C, display copying info
        jne short @@C_setup_exit
        mov copying_flag,1
        jmp @@findslash
@@C_setup_exit:
        jmp @@P_setup

@@parm_err:
        mov ah,FALSE
        jmp @@exit
@@parm_done:
        mov ah,TRUE
        jmp @@exit

@@P_setup:
        cmp al,'P'            ; Got /P, defeat pastebuffer
        jne short @@P_setup_exit
        mov flag_pastebuffer,0
        jmp @@findslash
@@P_setup_exit:
@@K_setup:
        cmp al,'K'            ; Got /K, defeat arrow keys
          jne short @@K_setup_exit
        mov flag_arrowkeys,0
        jmp @@findslash
@@K_setup_exit:
@@A_setup:
        cmp al,'A'            ; Got /A, set emacs, matrix, xterm modes
        jnz short @@A_setup_exit
        call parse_num        ; Get number nnn after '/A'
        cmp ax,MAX_of_A       ; Valid options are 1,2,...,(MAX_of_A)-1
        jae short @@A_setup1
        cmp ax,1
        jb short @@A_setup1
        mov flag_editor,al
@@A_setup1:
        jmp @@findslash
@@A_setup_exit:
@@Q_setup:
        cmp al,'Q'            ; Got /Q for quiet startup mode
        jnz short @@Q_setup_exit
        mov cs:quiet_flag,TRUE
        jmp @@findslash
@@Q_setup_exit:
@@M_setup:
        cmp al,'M'            ; Got /M for monochrome video mode
          jnz short @@M_setup_exit
        mov al,119            ; XOR byte mask for monochrome == /X119
        jmp short @@X_setup1
@@M_setup_exit:
@@X_setup:
        cmp al,'X'            ; Got /X for XOR mask ddd
        jnz short @@X_setup_exit
        call parse_num        ; Get number nnn after '/X'
        cmp ax,255            ; Value ddd==119 for monochrome
        ja @@parm_err
        cmp ax,0
        jb short @@parm_err
@@X_setup1:
        mov xor_mask,al
        inc counter_Xoption
        jmp @@findslash
@@X_setup_exit:
@@B_setup:
        cmp al,'B'            ; Got /B for new buffer size in bytes
        jnz short @@B_setup1_exit
        call parse_num        ; Get number nnn after '/B'
        cmp ax,BUFFERLEN      ; Don't let it get bigger than BUFFERLEN
        ja @@parm_err         ; But ZERO is OK!
        add ax,15             ; Round up to next paragraph
        mov cl,4
        shr ax,cl
        mov cl,4
        shl ax,cl             ; ax == byte count for buffer size
        mov cs:BUFLEN,ax
        jmp @@findslash
@@B_setup1_exit:
@@T_setup:
        cmp al,'T'            ; Got /T for for Timer interrupt option
        jne @@T_setup_exit
        mov cs:flag_int1c,TRUE ;Enable timer click code int 1ch
        jmp @@findslash
@@T_setup_exit:
        jmp @@findslash
@@exit:
        ret
get_opt endp

SwapButtonTable dw  123      ; 123 ==> 123
                db 1,3,5     ; shift factors for bit pattern
                dw 132
                db 1,5,3
                dw 213       ; Example: Button order 123 ==> 312
                db 3,1,5     ; Extra bytes are shift factors into
                dw 231       ; new position, eg, 00000110 are bits for
                db 3,5,1     ; for button 1, and we shift it to
                dw 312       ; 00000011 to normalize, then shift
                db 5,1,3     ; by 5 left to make it into button3
                dw 321       ; bits of 01100000
                db 5,3,1
                dw 0
                db 0,0,0
;
; Entry: ax == permutation of 123
;        Table determines allowed values (SwapButtonTable).
; Exit: Updated variables button_1fix, button_2fix, button_3fix
;
setbuttonswap proc
        push si
        push bx
        mov si,offset SwapButtonTable
@@S_loop:
        cmp ax,word ptr [si]
         jne @@S_loopexit
        inc si
        inc si
        mov bl,byte ptr [si]
        mov button_1fix,bl
        inc si
        mov bl,byte ptr [si]
        mov button_2fix,bl
        inc si
        mov bl,byte ptr [si]
        mov button_3fix,bl
        jmp short @@S_exit
@@S_loopexit:
        add si,5
        cmp word ptr [si],0
         jnz @@S_loop
        jmp short @@S_exit1
@@S_exit:
        mov flag_swapbuttons,TRUE
@@S_exit1:
        pop bx
        pop si
        ret
setbuttonswap endp


parse_num proc
        mov bx,10
        mov ax,0
        mov dh,0
@@addloop:
        seges
        mov dl,[si]
        or dl,dl
        jz  short @@done
        inc si
        sub dl,'0'
        jc short @@done
        cmp dl,9
        ja short @@done
        push dx
        mul bx
        pop dx
        add ax,dx
        jmp short @@addloop
@@done:
        ret
parse_num endp

; Entry: None
; Exit:  al=ALL_OK, es:bx == pointer to pastebuf
;        Else al==NOT_INSTALLED
; Uses: ax, es, bx; ah unchanged
inst_tst proc
        push cx
        push ax
        mov ah,MOUSE_FN        ; test for installed, call patched int16h
        mov al,MOUSE_FN
        int 16h
        cmp ah,MOUSE_FN-1       ; must pass two tests, ah changed
         jnz short @@failed
        cmp cx,IDENTCODE        ; and proper code in cx; see new_16h
         je @@worked
@@failed:
        mov al,NOT_INSTALLED
         jmp short @@exit
@@worked:
        mov al,ALL_OK           ; es:bx points to pastebuf
@@exit:
        pop cx
        mov ah,ch
        pop cx
        ret
inst_tst endp

cmp_fptr proc ; cmp ax:bx and cx:dx
        XPUSHA
        mov si,0
        mov di,0

; si:ax *= 16
        rept 4
          shl ax,1
          rcl si,1
        endm
        add ax,bx
        adc si,0

; di:cx *= 16
        rept 4
          shl cx,1
          rcl di,1
        endm
        add cx,dx
        adc di,0

        cmp cx,ax
        jnz short @@exit
        cmp si,di
@@exit:
        XPOPA
        ret
cmp_fptr endp

      ms_hnd_ptr dw 0,0

re_activate proc
LOCAL  hndadr:DWORD = AUTO_SIZE
       push bp
       mov  bp,sp
       sub  sp,AUTO_SIZE
      PUSHR <ds,es>
      call inst_tst             ; es:bx == far address of pastebuffer
      cmp al,NOT_INSTALLED
      je short @@exit

      push bx                   ; bx == & InstallMouseHandler
      push es
      sub bx,pastebuf-InstallMouseHandler
      mov word ptr hndadr,bx
      mov bx,es
      mov word ptr hndadr+2,bx
      call dword ptr [hndadr]           ; call InstallMouseHandler
      pop es
      pop bx
      cmp ExecExit_flag,FALSE           ; Process /N options?
       je @@exit
      push bx
      sub bx,pastebuf-flag_reinstall_exec
      mov al,flag_reinstall_exec
      mov byte ptr es:[bx],al
      pop bx
      sub bx,pastebuf-flag_reinstall_exit
      mov al,flag_reinstall_exit
      mov byte ptr es:[bx],al
      mov al,ALL_OK

@@exit:
      POPR <es,ds>
       add  sp,AUTO_SIZE
       pop bp
      ret
re_activate endp

RSTVEC macro vec,old_vec_dist
      mov bx,pcmoffs
      sub bx,old_vec_dist
      lds dx,[es:bx]
      mov ax,(25h shl 8) + vec           ; set vector
      int 21h
endm

CMPVEC macro vec,new_vec_dist
      mov ax,(35h shl 8) + vec           ; get vector
      int 21h                            ; to es:bx

      mov ax,es
      mov cx,pcmseg
      mov dx,pcmoffs
      sub dx,new_vec_dist
      call cmp_fptr      ; cmp ax:bx and cx:dx
      jnz @@wrong_vec
endm

de_inst proc
LOCAL  pcmoffs,pcmseg:WORD,tckflg:BYTE = AUTO_SIZE
       push bp
       mov  bp,sp
       sub  sp,AUTO_SIZE
       PUSHR <ds,es>
      call inst_tst
      cmp al,ALL_OK             ; Then es:bx == pastebuf address
        je short @@cont_de_inst
      jmp @@goexit
@@cont_de_inst:
; now test for all patched vectors, if they point to xpcmouse
; We have now es:bx == pastebuf of in-memory copy of xpcmouse
;
      mov pcmoffs,bx  ; Offset to pastebuf in segment es
      mov ax,es
      mov pcmseg,ax   ; Segment of installed xpc-mouse
      push bx
      sub bx,pastebuf-flag_int1c
      mov al,es:[bx]
      mov tckflg,al    ; use flag_int1c of installed copy
      pop bx

; We always patch 21h, 16h, 10h. Maybe 1ch.

      CMPVEC 21h,pastebuf-new_21h
      CMPVEC 16h,pastebuf-new_16h
      CMPVEC 10h,pastebuf-new_10h

      cmp tckflg,TRUE
        jnz short @@de_inst
      CMPVEC 1ch,pastebuf-new_1ch
        jmp short @@de_inst

@@wrong_vec:
        mov al,WRO_VEC
@@goexit:
        jmp short @@exit

@@de_inst:

        RSTVEC 21h,pastebuf-old_21h
        RSTVEC 16h,pastebuf-old_16h
        RSTVEC 10h,pastebuf-old_10h

      cmp tckflg,TRUE
        jnz short @@no_tick2
        RSTVEC 1ch,pastebuf-old_1ch
@@no_tick2:

; reset driver is done at end of last exec, too
        call SoftMouseReset        ; reset mouse driver & interrupt handler
        mov es,pcmseg              ; segment of installed xpc-mouse
        mov bx,pcmoffs             ; offset into that segment
        sub bx,pastebuf-killed_flg ; get offset to killed_flg in "new_21h"
        mov byte ptr [es:bx],TRUE  ; Prevent re-entry of "new_21h"
        mov bx,pcmoffs             ; offset to pastebuf
        sub bx,pastebuf-XPC_pspadr ; offset to storage word
        mov es,[es:bx]             ; Get psp address word
        mov ah,49h ; free memory
        int 21h

        mov al,ALL_OK
        jmp @@exit

@@exit:
       POPR <es,ds>
       add  sp,AUTO_SIZE
       pop bp
       ret
de_inst endp

init proc
      mov ax,es
      mov cs:XPC_pspadr,ax      ; Save a copy in resident code
      mov ax,cs
      mov ds,ax
      call get_opt
      push ax

; Output copying message and quit?
      cmp cs:copying_flag,FALSE
        jz short @@no_copying
      pop ax
      mov dx,offset copying
      jmp @@do_exit

@@no_copying:
      cmp cs:quiet_flag,TRUE
      jz short @@no_onsign
      mov dx,offset onsign
      mov ah,9
      int 21h

@@no_onsign:
      pop ax
      cmp cs:how_to_flag,TRUE
        jnz short @@no_onsign1
        jz @@do_howto_exit
@@no_onsign1:
      cmp ah,TRUE
        jz short @@cont_inst
      cmp ah,FALSE
        mov dx,offset help_str
        jz @@do_exit
      cmp ah,REACTIVATE
        jnz short @@tst_de_inst
@@do_reactivate:
      call re_activate
        cmp al,NOT_INSTALLED
        jz short @@not_yet1
        mov dx,offset re_inst_str
         jmp @@do_exit

@@tst_de_inst:
      cmp ah,DE_INSTALL
        jnz short @@cont_inst
      call de_inst
        cmp al,NOT_INSTALLED
@@not_yet1:
        mov dx,offset not_yet_str
         jz @@do_exit
        cmp al,ALL_OK
        mov dx,offset ok_de_inst
         jz @@do_exit
        mov dx,offset wro_de_inst
         jmp @@do_exit

@@cont_inst:

      TESTCPU         ; Test for 80188 cpu or later. See macro above.
      TESTBIOS        ; Test for modern bios. See macro above.

; use function 21h (instead of 0) to ensure that new
; mouse driver is installed

      mov ax,21h             ; Test, if mouse driver installed
      int 33h
      inc ax                 ; installed => 0
        jz short @@mouse_there

      mov dx,offset nomouse_str
@@errexit:
      mov ah,9
      int 21h
      mov  dx,offset noins_str
@@do_exit:
      mov  ah,9
      int  21h
      mov  ax,4c01h          ; errorlevel 1 == no mouse driver
      int  21h

@@mouse_there:
      call inst_tst
      jnz short @@install
      cmp ExecExit_flag,FALSE   ; Any /N requests?
       je @@do_howto_exit
       jmp @@do_reactivate      ; /N implies /R if already installed

@@do_howto_exit:
      mov dx,offset help_switches
      mov  ah,9
      int  21h

      mov dx,offset how_to
      mov ah,9
      int 21h

      cmp cs:how_to_flag,FALSE
        je @@exit02
      mov  ax,4c03h          ; errorlevel 3 == message exit
      int  21h

@@exit02:
      mov dx,offset msgstr
      mov ah,9
      int 21h
      mov  ax,4c02h          ; errorlevel 2 == re-installed
      int  21h

@@install:

; Set buffer length variable

      mov ax,cs:BUFLEN          ; Get ending address of the
      add ax,offset pastebuf-1  ; Paste Buffer
      mov cs:EndOfBuffer,ax     ; and save it

; See if the video mode is appropriate for the /Xddd mask
      cmp cs:counter_Xoption,0  ; Over-ride on command line?
        jnz short @@video_OK
      ;   Option /M for monochrome Video mode (/M==/X119).
      push ds
      mov ax,40h                ; Segment of bios
      mov ds,ax
      cmp byte ptr [ds:49h],7   ; BIOS current video mode mono?
      pop ds
        jnz short @@video_OK
      mov xor_mask,119          ; Use /X119 for mono
@@video_OK:

; free environment
; Space managed by DOS can be re-used.
;
      mov es,cs:XPC_pspadr
      mov es,[es:2ch]   ; segment address of environment
      mov ah,49h        ; free memory
      int 21h

      mov ax,3516h
      int 21h           ; get vector
      mov word ptr old_16h,bx
      mov word ptr cs:[old_16h+2],es

      mov ax,351ch
      int 21h                ; get vector
      mov word ptr old_1ch,bx
      mov word ptr cs:[old_1ch+2],es

      mov ax,3510h
      int 21h
      mov word ptr cs:[old_10h],bx
      mov word ptr cs:[old_10h+2],es

; install int 21h patch

      mov ax,3521h
      int 21h
      mov word ptr cs:[old_21h],bx
      mov word ptr cs:[old_21h+2],es
      mov dx,offset new_21h
      mov ax,2521h           ; set vect
      int 21h

@@no_21_inst:
      mov dx,offset new_10h
      mov ax,2510h           ; set vect
      int 21h
      mov dx,offset new_16h
      mov ax,2516h           ; set vect
      int 21h

      cmp cs:flag_int1c,FALSE
        jz short @@no_tick_set
      mov dx,offset new_1ch
      mov ax,251ch           ; set vect
      int 21h
@@no_tick_set:

      call SoftMouseReset
      call InstallMouseHandler

      cmp cs:quiet_flag,TRUE
        jz short @@terminate
      mov dx,offset how_to
      mov ah,9
      int 21h
      mov dx,offset worked
      mov ah,9
      int 21h

@@terminate:
      ; Compute how many paragraphs are to be resident.
      ; This count adds is code length plus paste buffer length. The
      ; paste buffer has by design a maximum length of BUFFERLEN bytes.
      ;
      mov dx,cs:BUFLEN          ; Desired buffer length
      add dx,offset pastebuf    ; resident code len + BUFLEN
      add dx,15+256             ; Roundup + EXE header size
      shr dx,1                  ; dx --> (end_mouse - begin_resident+15+256)/2
      shr dx,1                  ; dx --> (end_mouse - begin_resident+15+256)/4
      shr dx,1                  ; dx --> (end_mouse - begin_resident+15+256)/8
      shr dx,1                  ; dx --> (end_mouse - begin_resident+15+256)/16
      mov ax,3100h
      int 21h                ; terminate stay resident

init endp

copying:
       db 'Copyright (c) 1994,1995 Jrgen G. Weber and G.B. Gustafson',13,10
       db 'xPC-Mouse is free software, distributed under the terms of the',13,10
       db 'GNU General Public License. For details, see the file COPYING.',13,10
       db 10
       db 'Jrgen G. Weber',13,10
       db 'Wiesentalstrae 1',13,10
       db 'D-74523 Schwbisch Hall',13,10
       db 'Germany',13,10
       db 'email: weberj@dia.informatik.uni-stuttgart.de',13,10
       db 10
       db 'Grant B. Gustafson',13,10
       db '113 JWB Math Dept Univ Utah',13,10
       db 'Salt Lake City, UT 84112  USA',13,10
       db 'email: gustafson@math.utah.edu',13,10
       db '$'

onsign db 13,10,'xPC-Mouse, version ',PVERSION,13,10
       db 'Copyright (c) 1994,1995 Jrgen G. Weber and G.B. Gustafson',13,10
       db 'Free for personal use under the Gnu license agreement.',13,10
       db '$'

how_to:
       db 13,10
       db 'MOUSE BUTTON             FUNCTION',13,10
       db 'Mouse 1 (1/6 second) ... Position cursor',13,10
       db 'Mouse 2 ................ Paste text',13,10
       db 'Mouse 3 ................ Carriage return (except /A3)',13,10
       db 'Drag Mouse 1 ........... Copy text',13,10
       db 'Double-click Mouse 1 ... Copy word',13,10
       db 'CTRL-Mouse 2 ........... Paste text + ENTER',13,10
       db 'ALT-Mouse 2 ............ Mouse 3 duplicate',13,10
       db 'SHIFT-Mouse 1 .......... Cursor feature on/off ',13,10
       db 'SHIFT-ALT-Mouse 1 ...... Toggle methods /A1-/A3',13,10
       db 'SHIFT-Mouse 2 .......... Paste feature on/off',13,10
       db '$'

worked db 13,10
       db 'xPC-Mouse is installed. Use "xPCmouse /U" to un-install.',13,10,'$'
msgstr db 13,10
       db 'xPC-Mouse was already installed.',13,10,'$'
not_yet_str db 13,10,  'xPC-Mouse was not installed yet.',13,10,'$'
ok_de_inst  db 13,10,  'xPC-Mouse is un-installed.',13,10,'$'
re_inst_str db 13,10,  'xPC-Mouse is re-activated.',13,10,'$'
wro_de_inst db 13,10,  'Could not un-install xPC-Mouse.',13,10,'$'
nomouse_str db 13,10,7,'No mouse driver found or driver too old.',13,10,'$'
noins_str   db         'xPC-Mouse not installed.',13,10,'$'
wro_cpu_str db         'xPC-Mouse needs at least an 80286 with',13,10
            db         'extended keyboard support.',13,10,'$'
help_str db 13,10,'Options: /U    : Un-install xPC-Mouse',13,10
               db '         /Q    : Quiet, no messages',13,10
               db '         /R    : Re-activate xPC-Mouse',13,10
               db '         /Sabc : Swap buttons 123 to order abc',13,10
               db '         /M    : Monochrome video mode (equals /X119)',13,10
               db '         /Xddd : Highlight XOR mask ddd (default /X80)',13,10
               db '         /Bdddd: Buffer size dddd bytes',13,10
               db '         /T    : Enable timer int 1Ch patch',13,10
               db '         /N0   : Defeat mouse handler re-install',13,10
               db '         /N1   : Re-install mouse handler before exec',13,10
               db '         /N2   : Re-install mouse handler after exit',13,10
               db '         /N3   : Re-install before exec and after exit (default)',13,10
               db '         /P    : Defeat pastebuffer use',13,10
               db '         /K    : Defeat arrow key emulation',13,10
               db '         /A1   : Emacs/vi arrow key method (default)',13,10
               db '         /A2   : Matrix arrow key method',13,10
               db '         /A3   : Xterm escape sequence method',13,10
help_switches:
               db 'Info:    /C    : Display copyright information',13,10
               db '         /?    : Display help text',13,10
               db '         /H    : Display mouse button assignments',13,10
               db '         /U    : Uninstall',13,10
               db '$'

; Insure source file is long enough when loaded into memory
; so that the pastebuffer is the proper size.
;
if  ($-pastebuf) lt BUFFERLEN
        db  BUFFERLEN-($-pastebuf) dup (?)
endif

end_mouse equ pastebuf+BUFFERLEN
code ends

; Stack segment is only used during initialization

stck segment para stack 'stack'
  db 256 dup (?)
stck ends

end init

comment *
GNU PUBLIC LICENSE.
   This software is released as copyrighted material under the GNU PUBLIC
   LICENSE:

                           NO WARRANTY

   Because xPC-Mouse is licensed free of charge, absolutely no warranty
   is provided, to the extent permitted by applicable state law.  Except
   when otherwise stated in writing, Jrgen G. Weber and Grant B.
   Gustafson provides xPC-Mouse "as is" without warranty of any kind,
   either expressed or implied, including, but not limited to, the
   implied warranties of merchantability and fitness for a particular
   purpose. The entire risk as to the quality and performance of the
   program is with you. Should the xPC-Mouse program prove defective,
   you assume the cost of all necessary servicing, repair or correction.

   In no event unless required by applicable law will Grant B. Gustafson
   and Jrgen G. Weber and/or any other party who may modify and
   redistribute xPC-Mouse be liable to you for damages, including any
   lost profits, lost monies, or other special, incidental or
   consequential damages arising out of the use or inability to use
   (including but not limited to loss of data or data being rendered
   inaccurate or losses sustained by third parties or a failure of the
   program to operate with programs not distributed by Grant B.
   Gustafson and Jrgen G. Weber) the program, even if you have been
   advised of the possibility of such damages, or for any claim by any
   other party.

NO COST?
   This software is provided free of charge to individuals and educational
   institutions. Money is not requested.

POSTCARDS?
   Postcards and comments are welcome!

   Jrgen G. Weber               GB Gustafson
   Wiesentalstrae 1             113 JWB Math Dept Univ Utah
   D-74523 Schwbisch Hall       Salt Lake City, UT 84112
   Germany - European Union      USA

* ; End comment
