Option Explicit

' Windows data types
Type RECT
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type

Type DRAWITEMSTRUCT
    CtlType As Integer
    CtlID As Integer
    itemID As Integer
    itemAction As Integer
    itemState As Integer
    hwndItem As Integer
    hDC As Integer
    rcItem As RECT
    itemData As Long
End Type

Type MEASUREITEMSTRUCT
    CtlType As Integer
    CtlID As Integer
    itemID As Integer
    itemWidth As Integer
    itemHeight As Integer
    itemData As Long
End Type

' Windows declarations
Declare Function GetMenu Lib "User" (ByVal hwnd As Integer) As Integer
Declare Function GetSubMenu Lib "User" (ByVal hMenu As Integer, ByVal nPos As Integer) As Integer
Declare Function ModifyMenu Lib "User" (ByVal hMenu As Integer, ByVal nPosition As Integer, ByVal wFlags As Integer, ByVal wIDNewItem As Integer, ByVal lpString As Any) As Integer
Declare Function GetMenuItemID Lib "User" (ByVal hMenu As Integer, ByVal nPos As Integer) As Integer
Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Function Rectangle Lib "GDI" (ByVal hDC As Integer, ByVal X1 As Integer, ByVal Y1 As Integer, ByVal X2 As Integer, ByVal Y2 As Integer) As Integer
Declare Sub InflateRect Lib "User" (lpRect As RECT, ByVal X As Integer, ByVal Y As Integer)
Declare Function FillRect Lib "User" (ByVal hDC As Integer, lpRect As RECT, ByVal hBrush As Integer) As Integer
Declare Function GetSysColor Lib "User" (ByVal nIndex As Integer) As Long
Declare Function GetSystemMetrics Lib "User" (ByVal nIndex As Integer) As Integer
Declare Sub hmemcpy Lib "Kernel" (lpDest As Any, lpSource As Any, ByVal nCount As Long)

' Windows constants
Global Const ODS_SELECTED = &H1
Global Const COLOR_MENU = 4
Global Const COLOR_WINDOW = 5
Global Const COLOR_HIGHLIGHT = 13
Global Const MF_OWNERDRAW = &H100
Global Const MF_BYCOMMAND = &H0
Global Const SM_CYMENU = 15
Global Const WM_DRAWITEM = &H2B
Global Const WM_MEASUREITEM = &H2C

