VERSION 2.00
Begin MDIForm MDIForm1 
   Caption         =   "MDI Background Demo"
   ClientHeight    =   4980
   ClientLeft      =   1095
   ClientTop       =   1485
   ClientWidth     =   8640
   Height          =   5385
   Left            =   1035
   LinkTopic       =   "MDIForm1"
   Top             =   1140
   Width           =   8760
   Begin PictureBox Picture1 
      Align           =   1  'Align Top
      Height          =   4425
      Left            =   0
      ScaleHeight     =   4395
      ScaleWidth      =   8610
      TabIndex        =   0
      Top             =   0
      Visible         =   0   'False
      Width           =   8640
      Begin MsgHook MsgHook 
         Left            =   315
         Top             =   315
      End
      Begin PictureBox Picture2 
         AutoRedraw      =   -1  'True
         AutoSize        =   -1  'True
         Height          =   3780
         Left            =   2295
         Picture         =   MDIPAINT.FRX:0000
         ScaleHeight     =   3750
         ScaleWidth      =   3750
         TabIndex        =   1
         Top             =   315
         Width           =   3780
      End
   End
End
Option Explicit

' Windows messages watched for by MsgHook
Const WM_ERASEBKGND = &H14
Const WM_PAINT = &HF

' Routine within MsgHook which calls default window procedure
Declare Function InvokeWindowProc Lib "MsgHook.vbx" (ByVal hWnd As Integer, ByVal Msg As Integer, ByVal wParam As Integer, ByVal lParam As Long) As Long

Sub MDIForm_Load ()
   Dim F As Form
   Dim i As Integer
   '
   ' Setup MsgHook control
   '
   MsgHook.HwndHook = (GetWindow(Me.hWnd, GW_CHILD))
   MsgHook.Message(WM_PAINT) = True
   MsgHook.Message(WM_ERASEBKGND) = True
   '
   ' Position form to use most of screen
   '
   Me.Move Screen.Width * .15, Screen.Height * .15, Screen.Width * .7, Screen.Height * .7
   '
   ' Place a few children out in the client space
   '
   For i = 1 To 6
      Set F = New Form1
      F.Caption = F.Caption & i
   Next i
End Sub

Sub MDIForm_Resize ()
   Dim nRet As Long
   '
   ' Rearrange icons
   '
   Me.Arrange 3
   '
   ' Ensure a repaint -- won't happen if size is reduced.
   '
   nRet = SendMessage(GetWindow(Me.hWnd, GW_CHILD), WM_PAINT, 0, 0&)
End Sub

Sub MDIForm_Unload (Cancel As Integer)
   Dim i
   '
   ' Make sure all children are unloaded
   '
   For i = Forms.Count - 1 To 0 Step -1
      Unload Forms(i)
   Next i
End Sub

Sub MsgHook_Message (Msg As Integer, wParam As Integer, lParam As Long, Result As Long)
   Select Case Msg
      Case WM_PAINT
         '
         ' Paint a nice background, then allow default
         ' window procedure to run (which instructs
         ' icons to repaint and clears the update status).
         '
         mdiBitBltCentered Picture2, Me, GetSysColor(COLOR_APPWORKSPACE)
         Result = InvokeWindowProc(MsgHook.HwndHook, Msg, wParam, lParam)
      Case WM_ERASEBKGND
         '
         ' Return non-zero to indicate we do "erase".
         ' No need to invoke default window procedure.
         '
         Result = 1
   End Select
End Sub

