VERSION 2.00
Begin Form Form1 
   Caption         =   "Drop Files On Me"
   ClientHeight    =   2280
   ClientLeft      =   1095
   ClientTop       =   1485
   ClientWidth     =   6705
   Height          =   2685
   Left            =   1035
   LinkTopic       =   "Form1"
   ScaleHeight     =   2280
   ScaleWidth      =   6705
   Top             =   1140
   Width           =   6825
   Begin MsgHook MsgHook 
      Left            =   3735
      Top             =   225
   End
   Begin ListBox List1 
      Height          =   1590
      Left            =   90
      TabIndex        =   0
      Top             =   360
      Width           =   3300
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "No Files Dropped Yet"
      Height          =   195
      Left            =   90
      TabIndex        =   1
      Top             =   135
      Width           =   1830
   End
End
Option Explicit

Sub Form_Load ()
   '
   ' Prepare form to accept dropped files
   '
   Call AcceptDrops((Me.hWnd))
   '
   ' Setup MsgHook control
   '
   MsgHook.HwndHook = Me.hWnd
   MsgHook.Message(WM_DROPFILES) = True
End Sub

Sub Form_Resize ()
   '
   ' Resize Listbox to fit form
   '
   If Me.WindowState <> 1 Then ' not minimized
      List1.Move List1.Left, List1.Top, Me.ScaleWidth - 2 * List1.Left, Me.ScaleHeight - List1.Top - List1.Left
   End If
End Sub

Sub MsgHook_Message (Msg As Integer, wParam As Integer, lParam As Long, Result As Long)
   Dim nFiles As Integer
   Dim Buffer As String
   Dim i As Integer
   Dim nRet As Integer
   '
   ' Always test which message was recieved
   '
   If Msg = WM_DROPFILES Then
      '
      ' Set up buffer to recieve filenames, then
      ' retrieve number of files dropped by passing
      ' &hFFFF as the file number.
      '
      Buffer = Space$(128)
      nFiles = DragQueryFile(wParam, -1&, Buffer, Len(Buffer))
      '
      ' Clear list box and reset label
      '
      List1.Clear
      Label1 = nFiles & " Files Dropped:"
      '
      ' Retrieve the name of each file dropped, and
      ' place in listbox.
      '
      For i = (nFiles - 1) To 0 Step -1
         nRet = DragQueryFile(wParam, i, Buffer, Len(Buffer))
         List1.AddItem Left(Buffer, nRet), 0
      Next i
      List1.ListIndex = 0
      '
      ' Tell system we're done.
      '
      Call DragFinish(wParam)
      Result = 0
   End If
End Sub

