Option Explicit

Declare Function GetWindowLong Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer) As Long
Declare Function SetWindowLong Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer, ByVal dwNewLong As Long) As Long
Declare Sub DragAcceptFiles Lib "shell.dll" (ByVal hWnd%, ByVal fAccept%)
Declare Sub DragFinish Lib "shell.dll" (ByVal hDrop%)
Declare Function DragQueryFile Lib "shell.dll" (ByVal hDrop%, ByVal iFile%, ByVal lpszFile$, ByVal cb%) As Integer

' Constants used to alter window style
Global Const GWL_EXSTYLE = (-20)
Global Const WS_EX_ACCEPTFILES = &H10&

' Constant which notifies of drag-and-drop
Global Const WM_DROPFILES = &H233

Sub AcceptDrops (hWnd As Integer)
   Dim Style As Long
   '
   ' Set to accept dropped files from File Manager
   '
   Style = GetWindowLong(hWnd, GWL_EXSTYLE)
   Style = SetWindowLong(hWnd, GWL_EXSTYLE, Style Or WS_EX_ACCEPTFILES)
   '
   ' Notify system we want to accept dropped files
   '
   DragAcceptFiles hWnd, True
End Sub

